/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.JBEditorTabs;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewDialog;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.psi.c;
import icons.PythonIcons;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDataView
implements DumbAware {
    public static final String DATA_VIEWER_ID = "SciView";
    public static final String COLORED_BY_DEFAULT = "python.debugger.dataview.coloredbydefault";
    public static final String AUTO_RESIZE = "python.debugger.dataview.autoresize";
    public static final String EMPTY_TAB_NAME = "empty";
    private static final Logger e;
    private static final String b = "reference.toolWindows.PyDataView";
    @NotNull
    private final Project d;
    private JBEditorTabs c;
    private final Map<ProcessHandler, TabInfo> a;
    private static final long f;

    public PyDataView(@NotNull Project project) {
        if (project == null) {
            PyDataView.a(0);
        }
        this.a = new ConcurrentHashMap<ProcessHandler, TabInfo>();
        this.d = project;
    }

    public void show(@NotNull PyDebugValue value) {
        long l2 = f ^ 0x698A43EB6900L;
        if (value == null) {
            PyDataView.a(1);
        }
        if (ToolWindowManager.getInstance((Project)this.d).getToolWindow(DATA_VIEWER_ID) != null) {
            this.a(value);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                PyDataViewDialog pyDataViewDialog = new PyDataViewDialog(this.d, value);
                pyDataViewDialog.show();
            });
        }
    }

    private void a(@NotNull PyDebugValue pyDebugValue) {
        ToolWindow toolWindow;
        long l2 = f ^ 0xC4C44307F39L;
        if (pyDebugValue == null) {
            PyDataView.a(2);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)this.d).getToolWindow(DATA_VIEWER_ID)) == null) {
            e.error("Tool window 'SciView' is not found");
            return;
        }
        toolWindow.getContentManager().getReady((Object)this).doWhenDone(() -> {
            TabInfo tabInfo = this.addTab(pyDebugValue.getFrameAccessor());
            PyDataViewerPanel pyDataViewerPanel = (PyDataViewerPanel)tabInfo.getComponent();
            pyDataViewerPanel.apply(pyDebugValue);
        });
        toolWindow.show(null);
        Content content2 = toolWindow.getContentManager().getContent(0);
        if (content2 != null) {
            toolWindow.getContentManager().setSelectedContent(content2);
        }
    }

    public void closeTabs(Predicate<PyFrameAccessor> ifClose) {
        ArrayList<TabInfo> arrayList = new ArrayList<TabInfo>();
        for (TabInfo tabInfo : this.c.getTabs()) {
            if (!ifClose.test(PyDataView.a(tabInfo).getFrameAccessor())) continue;
            arrayList.add(tabInfo);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (TabInfo tabInfo : arrayList) {
                this.c.removeTab(tabInfo);
            }
        });
    }

    public void updateTabs(@NotNull ProcessHandler handler) {
        if (handler == null) {
            PyDataView.a(3);
        }
        this.a();
        PyFrameAccessor pyFrameAccessor = this.c.getTabs().iterator();
        while (pyFrameAccessor.hasNext()) {
            TabInfo tabInfo = (TabInfo)pyFrameAccessor.next();
            PyDataViewerPanel pyDataViewerPanel = PyDataView.a(tabInfo);
            PyFrameAccessor pyFrameAccessor2 = pyDataViewerPanel.getFrameAccessor();
            if (!(pyFrameAccessor2 instanceof PyDebugProcess)) continue;
            boolean bl2 = Comparing.equal((Object)handler, (Object)((PyDebugProcess)pyFrameAccessor2).getProcessHandler());
            tabInfo.setHidden(!bl2);
        }
        this.a(handler);
        if (this.c.getSelectedInfo() == null && (pyFrameAccessor = this.b(handler)) != null) {
            this.addTab(pyFrameAccessor);
        }
    }

    private void a(@NotNull ProcessHandler processHandler) {
        TabInfo tabInfo;
        if (processHandler == null) {
            PyDataView.a(4);
        }
        if ((tabInfo = this.a.get(processHandler)) != null) {
            this.c.select(tabInfo, true);
            this.a.remove(processHandler);
        }
    }

    private void a() {
        PyFrameAccessor pyFrameAccessor;
        TabInfo tabInfo = this.c.getSelectedInfo();
        if (!this.b() && tabInfo != null && (pyFrameAccessor = PyDataView.a(tabInfo).getFrameAccessor()) instanceof PyDebugProcess) {
            this.a.put(((PyDebugProcess)pyFrameAccessor).getProcessHandler(), tabInfo);
        }
    }

    @Nullable
    private PyFrameAccessor b(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            PyDataView.a(5);
        }
        for (PyDebugProcess pyDebugProcess : XDebuggerManager.getInstance((Project)this.d).getDebugProcesses(PyDebugProcess.class)) {
            if (!Comparing.equal((Object)processHandler, (Object)pyDebugProcess.getProcessHandler())) continue;
            return pyDebugProcess;
        }
        return null;
    }

    public void closeDisconnectedFromConsoleTabs() {
        this.closeTabs(pyFrameAccessor -> pyFrameAccessor instanceof PydevConsoleCommunication && !PyDataView.a((PydevConsoleCommunication)((Object)pyFrameAccessor)));
    }

    private static boolean a(PydevConsoleCommunication pydevConsoleCommunication) {
        return pydevConsoleCommunication.handshake();
    }

    public static PyDataView getInstance(@NotNull Project project) {
        if (project == null) {
            PyDataView.a(6);
        }
        return (PyDataView)ServiceManager.getService((Project)project, PyDataView.class);
    }

    public void init(final @NotNull ToolWindow toolWindow) {
        long l2 = f ^ 0x5B3CAE82FABEL;
        if (toolWindow == null) {
            PyDataView.a(7);
        }
        this.c = new JBRunnerTabs(this.d, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)this.d), (Disposable)this.d);
        this.c.setDataProvider(string -> {
            long l2 = f ^ 0x636F19D80CD5L;
            if (PlatformDataKeys.HELP_ID.is(string)) {
                return b;
            }
            return null;
        });
        this.c.getPresentation().setEmptyText("Run console or debugger to view available data");
        this.c.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new ColoredAction(this)}), "unknown", true);
        this.c.setTabDraggingEnabled(true);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.c, "Data", false);
        content2.setCloseable(true);
        toolWindow.getContentManager().addContent(content2);
        this.d.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-4350249005986635117L, 7225244928275589664L, MethodHandles.lookup().lookupClass()).a(250423204086937L);

            public void stateChanged() {
                long l2 = a ^ 0x12A0EEAFAF1FL;
                ToolWindow toolWindow2 = ToolWindowManager.getInstance((Project)PyDataView.this.d).getToolWindow(PyDataView.DATA_VIEWER_ID);
                if (toolWindow2 == null) {
                    return;
                }
                if (toolWindow.isAvailable() && toolWindow.getType().equals((Object)ToolWindowType.FLOATING) && !toolWindow.isVisible()) {
                    toolWindow.setShowStripeButton(false);
                    PyDataView.this.c.removeAllTabs();
                }
            }
        });
    }

    public TabInfo addTab(@NotNull PyFrameAccessor frameAccessor) {
        long l2 = f ^ 0xBCC05F16FA6L;
        if (frameAccessor == null) {
            PyDataView.a(8);
        }
        if (this.b()) {
            this.c.removeTab(this.c.getSelectedInfo());
        }
        PyDataViewerPanel pyDataViewerPanel = new PyDataViewerPanel(this.d, frameAccessor);
        TabInfo tabInfo = new TabInfo((JComponent)pyDataViewerPanel);
        if (frameAccessor instanceof PydevConsoleCommunication) {
            tabInfo.setIcon(PythonIcons.Python.PythonConsole);
            tabInfo.setTooltipText("Connected to Python Console");
        }
        if (frameAccessor instanceof PyDebugProcess) {
            tabInfo.setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
            String string2 = ((PyDebugProcess)frameAccessor).getSession().getSessionName();
            tabInfo.setTooltipText("Connected to debug session '" + string2 + "'");
        }
        tabInfo.setText(EMPTY_TAB_NAME);
        tabInfo.setPreferredFocusableComponent((JComponent)pyDataViewerPanel.getSliceTextField());
        tabInfo.setActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new NewViewerAction(this, frameAccessor)}), "unknown");
        tabInfo.setTabLabelActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new CloseViewerAction(this, tabInfo, frameAccessor)}), "unknown");
        pyDataViewerPanel.addListener(string -> tabInfo.setText(string));
        this.c.addTab(tabInfo);
        this.c.select(tabInfo, true);
        return tabInfo;
    }

    private boolean b() {
        if (this.getVisibleTabs().size() != 1) {
            return false;
        }
        TabInfo tabInfo = this.c.getSelectedInfo();
        if (tabInfo == null) {
            return false;
        }
        return PyDataView.a(tabInfo).getSliceTextField().getText().isEmpty();
    }

    public List<TabInfo> getVisibleTabs() {
        return ContainerUtil.filter((Collection)this.c.getTabs(), tabInfo -> !tabInfo.isHidden());
    }

    public void changeAutoResize(boolean autoResize) {
        for (TabInfo tabInfo : this.c.getTabs()) {
            PyDataView.a(tabInfo).resize(autoResize);
        }
    }

    private static PyDataViewerPanel a(TabInfo tabInfo) {
        return (PyDataViewerPanel)tabInfo.getComponent();
    }

    static {
        f = com.jetbrains.python.psi.c.a(-7949035344010695951L, -3332253249109474942L, MethodHandles.lookup().lookupClass()).a(251627650226345L);
        e = Logger.getInstance(PyDataView.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x28A4C9EDE5A9L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showInToolwindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTabs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreSelectedInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ColoredAction
    extends ToggleAction {
        final /* synthetic */ PyDataView this$0;
        private static final long a = com.jetbrains.python.psi.c.a(-5455887736220570418L, 8769890124706413852L, MethodHandles.lookup().lookupClass()).a(22295162039513L);

        ColoredAction(PyDataView pyDataView) {
            long l2 = a ^ 0x10FF3062B1D7L;
            this.this$0 = pyDataView;
            super("Colored");
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            PyDataViewerPanel pyDataViewerPanel;
            if (e10 == null) {
                ColoredAction.a(0);
            }
            if ((pyDataViewerPanel = this.a()) == null) {
                return true;
            }
            return pyDataViewerPanel.isColored();
        }

        @Nullable
        private PyDataViewerPanel a() {
            TabInfo tabInfo = this.this$0.c.getSelectedInfo();
            if (tabInfo == null) {
                return null;
            }
            return PyDataView.a(tabInfo);
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
            PyDataViewerPanel pyDataViewerPanel;
            if (e10 == null) {
                ColoredAction.a(1);
            }
            if ((pyDataViewerPanel = this.a()) != null) {
                pyDataViewerPanel.setColored(state2);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x66EBB6655A2EL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataView$ColoredAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseViewerAction
    extends AnAction {
        private final TabInfo a;
        private final PyFrameAccessor b;
        final /* synthetic */ PyDataView this$0;
        private static final long c = com.jetbrains.python.psi.c.a(-1796726539017262778L, -7219469038077130035L, MethodHandles.lookup().lookupClass()).a(73558681438176L);

        CloseViewerAction(PyDataView pyDataView, TabInfo info, PyFrameAccessor frameAccessor) {
            long l2 = c ^ 0x5E15FFEAE95DL;
            this.this$0 = pyDataView;
            super("Close Viewer", "Close selected viewer", AllIcons.Actions.Close);
            this.a = info;
            this.b = frameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                CloseViewerAction.a(0);
            }
            this.this$0.c.removeTab(this.a);
            if (this.this$0.getVisibleTabs().isEmpty()) {
                this.this$0.addTab(this.b);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x178AA14AA662L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/containerview/PyDataView$CloseViewerAction", "actionPerformed"));
        }
    }

    private class NewViewerAction
    extends AnAction {
        private final PyFrameAccessor a;
        final /* synthetic */ PyDataView this$0;
        private static final long b = com.jetbrains.python.psi.c.a(816294415716848889L, 4525055888993224494L, MethodHandles.lookup().lookupClass()).a(4194025000291L);

        NewViewerAction(PyDataView pyDataView, PyFrameAccessor frameAccessor) {
            long l2 = b ^ 0x2C8B25127B58L;
            this.this$0 = pyDataView;
            super("View New Container", "Open new container viewer", AllIcons.General.Add);
            this.a = frameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                NewViewerAction.a(0);
            }
            this.this$0.addTab(this.a);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x44DD4BF048FL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/containerview/PyDataView$NewViewerAction", "actionPerformed"));
        }
    }
}

