/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.google.common.collect.Maps;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.debugger.dataframe.DataFrameViewStrategy;
import com.jetbrains.python.debugger.dataframe.TableValueDescriptor;
import com.jetbrains.python.debugger.dataframe.a;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DataFrameTableModel
extends AsyncArrayTableModel {
    private final Map<Integer, ArrayChunk.ColHeader> k = Maps.newConcurrentMap();
    private final RowHeaderModel l = new RowHeaderModel(null);

    public DataFrameTableModel(int rows, int columns, PyDataViewerPanel dataProvider, PyDebugValue debugValue, DataFrameViewStrategy strategy) {
        super(rows, columns, dataProvider, debugValue, strategy);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object object = super.getValueAt(row, col);
        if (object == "") {
            return object;
        }
        TableValueDescriptor tableValueDescriptor = this.a(col, object);
        return tableValueDescriptor != null ? tableValueDescriptor : "";
    }

    private TableValueDescriptor a(int n2, Object object) {
        ArrayChunk.ColHeader colHeader = this.k.get(n2);
        if (colHeader == null) {
            return null;
        }
        return new TableValueDescriptor(object.toString(), colHeader);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return TableValueDescriptor.class;
    }

    @Override
    public String getColumnName(int col) {
        ArrayChunk.ColHeader colHeader = this.k.get(col);
        if (colHeader != null && colHeader.getLabel() != null) {
            return colHeader.getLabel();
        }
        return super.getColumnName(col);
    }

    @Override
    protected void handleChunkAdded(Integer rowOffset, Integer colOffset, ArrayChunk chunk) {
        this.l.handleChunkAdded(rowOffset, chunk);
        boolean bl2 = false;
        List list2 = chunk.getColHeaders();
        if (list2 != null) {
            for (int i10 = 0; i10 < list2.size(); ++i10) {
                ArrayChunk.ColHeader colHeader = (ArrayChunk.ColHeader)list2.get(i10);
                bl2 |= this.k.put(i10 + colOffset, colHeader) == null;
            }
        }
        if (bl2) {
            UIUtil.invokeLaterIfNeeded(() -> super.fireTableStructureChanged());
        }
    }

    @Override
    public TableModel getRowHeaderModel() {
        return this.l;
    }

    private class RowHeaderModel
    extends AbstractTableModel {
        private final Map<Integer, String> a = Maps.newConcurrentMap();
        private static final long b = c.a(3119537386620982244L, 6206577081329998182L, MethodHandles.lookup().lookupClass()).a(276002939368381L);

        private RowHeaderModel() {
        }

        @Override
        public int getRowCount() {
            return DataFrameTableModel.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            long l2 = b ^ 0x7915F7D52755L;
            if (column == 0) {
                return "   ";
            }
            throw new IllegalArgumentException("Table only has one column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String string = this.a.get(rowIndex);
            return string == null ? String.valueOf(rowIndex) : string;
        }

        public void handleChunkAdded(Integer rowOffset, ArrayChunk chunk) {
            List list2 = chunk.getRowLabels();
            if (list2 != null) {
                for (int i10 = 0; i10 < list2.size(); ++i10) {
                    String string = (String)list2.get(i10);
                    String string2 = this.a.put(i10 + rowOffset, string);
                    if (string2 != null) continue;
                    int n2 = i10 + rowOffset;
                    UIUtil.invokeLaterIfNeeded(() -> super.fireTableCellUpdated(n2, 0));
                }
            }
        }

        /* synthetic */ RowHeaderModel(a x1) {
            this();
        }
    }
}

