/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuredDocstringFormatter {
    private static final Logger b;
    private static final Charset a;
    private static final long c;

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        Object object;
        Module module2;
        if (element == null) {
            PyStructuredDocstringFormatter.a(0);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.a(1);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            object = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (((Module[])object).length == 0) {
                return Lists.newArrayList();
            }
            module2 = object[0];
        }
        if (module2 == null) {
            return Lists.newArrayList();
        }
        object = new ArrayList();
        String string = PyIndentUtil.removeCommonIndent(docstring, true).trim();
        DocStringFormat docStringFormat = DocStringUtil.guessDocStringFormat(string, element);
        if (docStringFormat == DocStringFormat.PLAIN) {
            return null;
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(docStringFormat, string);
        String string2 = PyStructuredDocstringFormatter.a(module2, docStringFormat, string);
        if (string2 != null) {
            object.add(string2);
        } else {
            object.add(structuredDocString.getDescription());
        }
        return object;
    }

    @Nullable
    private static String a(@NotNull Module module2, @NotNull DocStringFormat docStringFormat, @NotNull String string) {
        String string2;
        Sdk sdk;
        long l2 = c ^ 0x3BCB249322F4L;
        if (module2 == null) {
            PyStructuredDocstringFormatter.a(2);
        }
        if (docStringFormat == null) {
            PyStructuredDocstringFormatter.a(3);
        }
        if (string == null) {
            PyStructuredDocstringFormatter.a(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "Unittest placehoder";
        }
        if (docStringFormat == DocStringFormat.EPYTEXT) {
            sdk = PythonSdkType.findPython2Sdk(module2);
            string2 = PyBundle.message("QDOC.epydoc.python2.sdk.not.found", new Object[0]);
        } else {
            sdk = PythonSdkType.findLocalCPython(module2);
            string2 = PyBundle.message("QDOC.local.sdk.not.found", new Object[0]);
        }
        if (sdk == null) {
            b.warn("Python SDK for docstring formatter " + (Object)((Object)docStringFormat) + " is not found");
            return "<p color=\"red\">" + string2 + "</p>";
        }
        String string3 = sdk.getHomePath();
        if (string3 == null) {
            return null;
        }
        ByteBuffer byteBuffer = a.encode(string);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{docStringFormat.getFormatterCommand()});
        GeneralCommandLine generalCommandLine = PythonHelper.DOCSTRING_FORMATTER.newCommandLine(sdk, (List<String>)arrayList);
        generalCommandLine.setCharset(a);
        b.debug("Command for launching docstring formatter: " + generalCommandLine.getCommandLineString());
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(generalCommandLine, new File(string3).getParent(), null, 5000, byArray, false);
        if (!processOutput.checkSuccess(b)) {
            b.info("Malformed docstring:\n" + string);
            return null;
        }
        return processOutput.getStdout();
    }

    static {
        c = com.jetbrains.python.psi.c.a(2284383405405932828L, 7289124631419880468L, MethodHandles.lookup().lookupClass()).a(164854612464373L);
        b = Logger.getInstance(PyStructuredDocstringFormatter.class);
        a = StandardCharsets.UTF_8;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x561498EAB249L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyStructuredDocstringFormatter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDocstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runExternalTool";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

