/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameArgumentQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureHandler;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListInspection
extends PyInspection {
    private static final long a = c.a(4636178141212905133L, 6161671823764349085L, MethodHandles.lookup().lookupClass()).a(43877225007084L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x3BE2B5DA1B8AL;
        String string = PyBundle.message("INSP.NAME.incorrect.call.arguments", new Object[0]);
        if (string == null) {
            PyArgumentListInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyArgumentListInspection.b(1);
        }
        if (session == null) {
            PyArgumentListInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyArgumentListInspection.b(3);
        }
        return visitor2;
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull TypeEvalContext context, int implicitOffset) {
        if (node == null) {
            PyArgumentListInspection.b(4);
        }
        if (holder == null) {
            PyArgumentListInspection.b(5);
        }
        if (context == null) {
            PyArgumentListInspection.b(6);
        }
        if (node.getParent() instanceof PyClass) {
            return;
        }
        PyCallExpression pyCallExpression = node.getCallExpression();
        if (pyCallExpression == null) {
            return;
        }
        PyResolveContext pyResolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        List<PyCallExpression.PyArgumentsMapping> list2 = pyCallExpression.multiMapArguments(pyResolveContext, implicitOffset);
        for (PyCallExpression.PyArgumentsMapping pyArgumentsMapping : list2) {
            PyCallable pyCallable;
            PyCallExpression.PyMarkedCallee pyMarkedCallee = pyArgumentsMapping.getMarkedCallee();
            if (pyMarkedCallee == null || !((pyCallable = pyMarkedCallee.getElement()) instanceof PyFunction)) continue;
            PyFunction pyFunction = (PyFunction)pyCallable;
            if (PyKnownDecoratorUtil.hasUnknownOrChangingSignatureDecorator(pyFunction, context) || PyArgumentListInspection.a(pyCallExpression.getCallee(), pyFunction, context)) {
                return;
            }
            if (!PyArgumentListInspection.a(pyCallExpression, pyFunction)) continue;
            return;
        }
        PyArgumentListInspection.b(node, holder, list2, context);
        PyArgumentListInspection.a(node, holder, list2, context);
        PyArgumentListInspection.a(node, holder, context);
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.b(7);
        }
        if (holder == null) {
            PyArgumentListInspection.b(8);
        }
        if (context == null) {
            PyArgumentListInspection.b(9);
        }
        PyArgumentListInspection.inspectPyArgumentList(node, holder, context, 0);
    }

    private static boolean a(@Nullable PyExpression pyExpression, @NotNull PyFunction pyFunction, @NotNull TypeEvalContext typeEvalContext) {
        if (pyFunction == null) {
            PyArgumentListInspection.b(10);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(11);
        }
        if (pyExpression instanceof PyReferenceExpression && PyUtil.isInit(pyFunction)) {
            PsiPolyVariantReference psiPolyVariantReference = ((PyReferenceExpression)pyExpression).getReference();
            return Arrays.stream(psiPolyVariantReference.multiResolve(false)).map(ResolveResult::getElement).anyMatch(psiElement -> psiElement instanceof PyClass && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator((PyClass)psiElement, typeEvalContext));
        }
        return false;
    }

    private static boolean a(@NotNull PyCallExpression pyCallExpression, @NotNull PyFunction pyFunction) {
        PyExpression pyExpression;
        PyClass pyClass;
        if (pyCallExpression == null) {
            PyArgumentListInspection.b(12);
        }
        if (pyFunction == null) {
            PyArgumentListInspection.b(13);
        }
        return (pyClass = pyFunction.getContainingClass()) != null && PyUtil.isObjectClass(pyClass) && (pyExpression = pyCallExpression.getReceiver(null)) instanceof PyCallExpression && PyUtil.isSuperCall((PyCallExpression)pyExpression);
    }

    private static void a(PyArgumentList pyArgumentList, ProblemsHolder problemsHolder, TypeEvalContext typeEvalContext) {
        long l2 = a ^ 0x47623DA76F2EL;
        for (PyExpression pyExpression : pyArgumentList.getArguments()) {
            PyType pyType;
            PyExpression pyExpression2;
            if (!(pyExpression instanceof PyStarArgument) || (pyExpression2 = PyUtil.peelArgument((PyExpression)PsiTreeUtil.findChildOfType((PsiElement)pyExpression, PyExpression.class))) == null || (pyType = typeEvalContext.getType(pyExpression2)) == null || PyTypeChecker.isUnknown(pyType, typeEvalContext)) continue;
            if (((PyStarArgument)pyExpression).isKeyword()) {
                if (PyABCUtil.isSubtype(pyType, "Mapping", typeEvalContext)) continue;
                problemsHolder.registerProblem((PsiElement)pyExpression, PyBundle.message("INSP.expected.dict.got.$0", pyType.getName()), new LocalQuickFix[0]);
                continue;
            }
            if (PyABCUtil.isSubtype(pyType, "Iterable", typeEvalContext)) continue;
            problemsHolder.registerProblem((PsiElement)pyExpression, PyBundle.message("INSP.expected.iter.got.$0", pyType.getName()), new LocalQuickFix[0]);
        }
    }

    private static Set<String> a(@NotNull PyArgumentList pyArgumentList) {
        if (pyArgumentList == null) {
            PyArgumentListInspection.b(14);
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (PyExpression pyExpression : pyArgumentList.getArguments()) {
            if (!(pyExpression instanceof PyKeywordArgument)) continue;
            String string = ((PyKeywordArgument)pyExpression).getKeyword();
            if (hashSet.contains(string)) {
                hashSet2.add(string);
            }
            hashSet.add(string);
        }
        return hashSet2;
    }

    private static void b(@NotNull PyArgumentList pyArgumentList, @NotNull ProblemsHolder problemsHolder, @NotNull List<PyCallExpression.PyArgumentsMapping> list2, @NotNull TypeEvalContext typeEvalContext) {
        long l2 = a ^ 0x40943902D792L;
        if (pyArgumentList == null) {
            PyArgumentListInspection.b(15);
        }
        if (problemsHolder == null) {
            PyArgumentListInspection.b(16);
        }
        if (list2 == null) {
            PyArgumentListInspection.b(17);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(18);
        }
        if (list2.isEmpty() || list2.stream().anyMatch(pyArgumentsMapping -> pyArgumentsMapping.getUnmappedArguments().isEmpty())) {
            return;
        }
        if (list2.size() == 1) {
            Object object;
            Object object2;
            Set<String> set = PyArgumentListInspection.a(pyArgumentList);
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping2 = list2.get(0);
            if (problemsHolder.isOnTheFly() && !pyArgumentsMapping2.getUnmappedArguments().isEmpty() && pyArgumentsMapping2.getUnmappedParameters().isEmpty() && (object2 = pyArgumentsMapping2.getMarkedCallee()) != null) {
                PyTypedElement pyTypedElement = ((PyCallExpression.PyMarkedCallee)object2).getElement();
                object = pyArgumentList.getProject();
                if (pyTypedElement instanceof PyFunction && !PyChangeSignatureHandler.isNotUnderSourceRoot((Project)object, pyTypedElement.getContainingFile())) {
                    String string = PyBundle.message("INSP.unexpected.arg(s)", new Object[0]);
                    problemsHolder.registerProblem((PsiElement)pyArgumentList, string, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PyChangeSignatureQuickFix.forMismatchedCall(pyArgumentsMapping2)});
                }
            }
            for (PyTypedElement pyTypedElement : pyArgumentsMapping2.getUnmappedArguments()) {
                object = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
                if (pyTypedElement instanceof PyKeywordArgument) {
                    if (set.contains(((PyKeywordArgument)pyTypedElement).getKeyword())) continue;
                    object.add(new PyRenameArgumentQuickFix());
                }
                problemsHolder.registerProblem((PsiElement)pyTypedElement, PyBundle.message("INSP.unexpected.arg", new Object[0]), object.toArray(new LocalQuickFix[object.size() - 1]));
            }
        } else {
            problemsHolder.registerProblem((PsiElement)pyArgumentList, PyArgumentListInspection.a(PyBundle.message("INSP.unexpected.arg(s)", new Object[0]), list2, typeEvalContext, problemsHolder.isOnTheFly()), new LocalQuickFix[0]);
        }
    }

    private static void a(@NotNull PyArgumentList pyArgumentList, @NotNull ProblemsHolder problemsHolder, @NotNull List<PyCallExpression.PyArgumentsMapping> list2, @NotNull TypeEvalContext typeEvalContext) {
        if (pyArgumentList == null) {
            PyArgumentListInspection.b(19);
        }
        if (problemsHolder == null) {
            PyArgumentListInspection.b(20);
        }
        if (list2 == null) {
            PyArgumentListInspection.b(21);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(22);
        }
        if (list2.isEmpty() || list2.stream().anyMatch(pyArgumentsMapping -> pyArgumentsMapping.getUnmappedParameters().isEmpty())) {
            return;
        }
        Optional.ofNullable(pyArgumentList.getNode()).map(aSTNode -> aSTNode.findChildByType((IElementType)PyTokenTypes.RPAR)).map(ASTNode::getPsi).ifPresent(psiElement -> {
            long l2 = a ^ 0x3A33CCCC0A38L;
            if (list2.size() != 1 || ContainerUtil.exists(((PyCallExpression.PyArgumentsMapping)list2.get(0)).getUnmappedParameters(), pyCallableParameter -> pyCallableParameter.getName() == null)) {
                problemsHolder.registerProblem(psiElement, PyArgumentListInspection.a(PyBundle.message("INSP.parameter(s).unfilled", new Object[0]), list2, typeEvalContext, problemsHolder.isOnTheFly()), new LocalQuickFix[0]);
            } else {
                ((StreamEx)StreamEx.of(((PyCallExpression.PyArgumentsMapping)list2.get(0)).getUnmappedParameters()).map(PyCallableParameter::getName).filter(Objects::nonNull)).forEach(string -> {
                    long l2 = a ^ 0x56588C987CDEL;
                    problemsHolder.registerProblem(psiElement, PyBundle.message("INSP.parameter.$0.unfilled", string), new LocalQuickFix[0]);
                });
            }
        });
    }

    @NotNull
    private static String a(@NotNull String string, @NotNull List<PyCallExpression.PyArgumentsMapping> list2, @NotNull TypeEvalContext typeEvalContext, boolean bl2) {
        long l2 = a ^ 0x353C0BE4C8C6L;
        if (string == null) {
            PyArgumentListInspection.b(23);
        }
        if (list2 == null) {
            PyArgumentListInspection.b(24);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(25);
        }
        String string2 = bl2 ? "<br>" : " ";
        String string3 = PyArgumentListInspection.a(list2, typeEvalContext, bl2);
        if (bl2) {
            String string4 = XmlStringUtil.wrapInHtml((CharSequence)(string + string2 + PyBundle.message("INSP.possible.callees", new Object[0]) + ":" + string2 + XmlStringUtil.escapeString((String)string3)));
            if (string4 == null) {
                PyArgumentListInspection.b(26);
            }
            return string4;
        }
        String string5 = string + "." + string2 + PyBundle.message("INSP.possible.callees", new Object[0]) + ":" + string2 + string3;
        if (string5 == null) {
            PyArgumentListInspection.b(27);
        }
        return string5;
    }

    @NotNull
    private static String a(@NotNull List<PyCallExpression.PyArgumentsMapping> list2, @NotNull TypeEvalContext typeEvalContext, boolean bl2) {
        long l2 = a ^ 0x2115BB0B3EE9L;
        if (list2 == null) {
            PyArgumentListInspection.b(28);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(29);
        }
        String string = (String)StreamEx.of(list2).map(PyCallExpression.PyArgumentsMapping::getMarkedCallee).nonNull().map(pyMarkedCallee -> PyArgumentListInspection.a(pyMarkedCallee, typeEvalContext)).nonNull().collect(Collectors.joining(bl2 ? "<br>" : " "));
        if (string == null) {
            PyArgumentListInspection.b(30);
        }
        return string;
    }

    @Nullable
    private static String a(@NotNull PyCallExpression.PyMarkedCallee pyMarkedCallee, @NotNull TypeEvalContext typeEvalContext) {
        if (pyMarkedCallee == null) {
            PyArgumentListInspection.b(31);
        }
        if (typeEvalContext == null) {
            PyArgumentListInspection.b(32);
        }
        String string = pyMarkedCallee.getElement() != null ? pyMarkedCallee.getElement().getName() : "";
        List<PyCallableParameter> list2 = pyMarkedCallee.getCallableType().getParameters(typeEvalContext);
        if (list2 == null) {
            return null;
        }
        String string2 = ParamHelper.getPresentableText(list2, true, typeEvalContext);
        String string3 = string + string2;
        return Optional.ofNullable(PyUtil.as(pyMarkedCallee.getElement(), PyFunction.class)).map(PyPossibleClassMember::getContainingClass).map(NavigationItem::getName).map(string4 -> {
            long l2 = a ^ 0x7A1E3A69E6C9L;
            return "__init__".equals(string) ? string4 + string2 : string4 + "." + string3;
        }).orElse(string3);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x45FD2E3BFDBAL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 17: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markedCallee";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleCalleesRepresentation";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleCalleesRepresentation";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inspectPyArgumentList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "decoratedClassInitCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "objectMethodCallViaSuper";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateKeywordArguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnexpectedArguments";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnfilledParameters";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleCalleesRepresentation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleesRepresentation";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleeRepresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(-5187740288803976305L, 7058929567221146262L, MethodHandles.lookup().lookupClass()).a(269235172237775L);

        Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.b(0);
            }
            if (session == null) {
                Visitor.b(1);
            }
            super(holder, session);
        }

        @Override
        @NotNull
        protected ProblemsHolder getHolder() {
            ProblemsHolder problemsHolder = super.getHolder();
            if (problemsHolder == null) {
                Visitor.b(2);
            }
            return problemsHolder;
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            PyArgumentListInspection.inspectPyArgumentList(node, this.getHolder(), this.myTypeEvalContext);
        }

        @Override
        public void visitPyDecoratorList(PyDecoratorList node) {
            PyDecorator[] pyDecoratorArray;
            long l2 = c ^ 0x55FBC11554A7L;
            for (PyDecorator pyDecorator : pyDecoratorArray = node.getDecorators()) {
                PyCallExpression.PyMarkedCallee pyMarkedCallee;
                if (pyDecorator.hasArgumentList() || (pyMarkedCallee = (PyCallExpression.PyMarkedCallee)ContainerUtil.getFirstItem(pyDecorator.multiResolveCallee(this.getResolveContext()))) == null || pyMarkedCallee.isImplicitlyResolved()) continue;
                PyCallable pyCallable = pyMarkedCallee.getElement();
                if (pyCallable == null) {
                    return;
                }
                int n2 = pyMarkedCallee.getImplicitOffset();
                List<PyCallableParameter> list2 = pyMarkedCallee.getCallableType().getParameters(this.myTypeEvalContext);
                if (list2 == null) {
                    return;
                }
                PyCallableParameter pyCallableParameter = (PyCallableParameter)ContainerUtil.getOrElse(list2, (int)(n2 - 1), null);
                if (pyCallableParameter == null || pyCallableParameter.isKeywordContainer()) {
                    this.registerProblem((PsiElement)pyDecorator, PyBundle.message("INSP.func.$0.lacks.first.arg", pyCallable.getName()));
                    continue;
                }
                for (int i10 = n2; i10 < list2.size(); ++i10) {
                    PyCallableParameter pyCallableParameter2 = list2.get(i10);
                    if (pyCallableParameter2.getParameter() instanceof PySingleStarParameter || pyCallableParameter2.getParameter() instanceof PySlashParameter || pyCallableParameter2.isKeywordContainer() || pyCallableParameter2.isPositionalContainer() || pyCallableParameter2.hasDefaultValue()) continue;
                    String string = pyCallableParameter2.getName();
                    this.registerProblem((PsiElement)pyDecorator, PyBundle.message("INSP.parameter.$0.unfilled", string == null ? "(...)" : string));
                }
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x7CED52FC4509L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHolder";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

