/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.inspections.PyCompatibilityInspection;
import com.jetbrains.python.inspections.PyCompatibilityInspectionAdvertiserSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCompatibilityInspectionAdvertiser
implements Annotator {
    private static final String b = "Python Versions Compatibility";
    private static final NotificationGroup g;
    private static final Key<Boolean> a;
    private static final boolean c = true;
    @Language(value="HTML")
    private static final String f = "<a href=\"#yes\">Yes</a>&nbsp;&nbsp;<a href=\"#no\">No</a>";
    private static final String e = "Your source code contains __future__ imports";
    private static final String d = "Your source code imports the 'six' package";
    private static final long h;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        long l2 = h ^ 0x7B24A2559CEFL;
        if (element == null) {
            PyCompatibilityInspectionAdvertiser.a(0);
        }
        if (holder == null) {
            PyCompatibilityInspectionAdvertiser.a(1);
        }
        if (element instanceof PyFile) {
            PyFile pyFile = (PyFile)element;
            Project project = element.getProject();
            VirtualFile virtualFile = pyFile.getVirtualFile();
            if (virtualFile != null && FileIndexFacade.getInstance((Project)project).isInLibraryClasses(virtualFile)) {
                return;
            }
            Boolean bl2 = (Boolean)project.getUserData(a);
            if (bl2 != null && bl2.booleanValue()) {
                return;
            }
            if (!PyCompatibilityInspectionAdvertiser.a(pyFile)) {
                return;
            }
            int n2 = PyCompatibilityInspectionAdvertiser.a((Project)project).version;
            if (n2 < 3) {
                if (PyCompatibilityInspectionAdvertiser.b(element)) {
                    LanguageLevel languageLevel = PyCompatibilityInspectionAdvertiser.c(element);
                    if (languageLevel != null && languageLevel.isOlderThan(LanguageLevel.getLatest())) {
                        PyCompatibilityInspectionAdvertiser.a(pyFile, project, languageLevel);
                    }
                } else if (PyCompatibilityInspectionAdvertiser.b(pyFile)) {
                    PyCompatibilityInspectionAdvertiser.a(project, e);
                } else if (PyPsiUtils.containsImport(pyFile, "six")) {
                    PyCompatibilityInspectionAdvertiser.a(project, d);
                }
            }
        }
    }

    private static boolean a(@NotNull PyFile pyFile) {
        Module module2;
        if (pyFile == null) {
            PyCompatibilityInspectionAdvertiser.a(2);
        }
        if ((module2 = ModuleUtilCore.findModuleForFile((VirtualFile)pyFile.getVirtualFile(), (Project)pyFile.getProject())) != null) {
            return PythonSdkType.findPythonSdk(module2) != null;
        }
        return false;
    }

    @Nullable
    private static LanguageLevel c(@NotNull PsiElement psiElement) {
        LanguageLevel languageLevel;
        if (psiElement == null) {
            PyCompatibilityInspectionAdvertiser.a(3);
        }
        return (languageLevel = PyCompatibilityInspectionAdvertiser.a(psiElement)) != null && !languageLevel.isPython2() ? languageLevel : null;
    }

    private static void a(@NotNull PyFile pyFile, @NotNull Project project, @NotNull LanguageLevel languageLevel) {
        long l2 = h ^ 0x4C0B6F2F80B0L;
        if (pyFile == null) {
            PyCompatibilityInspectionAdvertiser.a(4);
        }
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(5);
        }
        if (languageLevel == null) {
            PyCompatibilityInspectionAdvertiser.a(6);
        }
        List<LanguageLevel> list2 = PyCompatibilityInspectionAdvertiser.a(languageLevel);
        String string = StringUtil.join(list2, (String)",&nbsp;");
        String string2 = String.format("Code compatibility inspection is configured for Python versions up to %s.<br/>Would you like to enable it for Python %s?<br/><a href=\"#yes\">Yes</a>&nbsp;&nbsp;<a href=\"#no\">No</a>", new Object[]{languageLevel, string});
        PyCompatibilityInspectionAdvertiser.a(project, b, string2, NotificationType.INFORMATION, (notification2, hyperlinkEvent) -> {
            long l2 = h ^ 0x29554061F10CL;
            boolean bl2 = "#yes".equals(hyperlinkEvent.getDescription());
            if (bl2) {
                PyCompatibilityInspectionAdvertiser.a(project, (PsiElement)pyFile, list2);
            }
            if (!bl2) {
                // empty if block
            }
            PyCompatibilityInspectionAdvertiser.a((Project)project).version = 3;
        });
    }

    @NotNull
    private static List<LanguageLevel> a(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PyCompatibilityInspectionAdvertiser.a(7);
        }
        ArrayList<LanguageLevel> arrayList = new ArrayList<LanguageLevel>();
        LanguageLevel languageLevel2 = LanguageLevel.getLatest();
        for (LanguageLevel languageLevel3 : PyCompatibilityInspection.SUPPORTED_LEVELS) {
            if (!languageLevel.isOlderThan(languageLevel3) || !languageLevel2.isAtLeast(languageLevel3)) continue;
            arrayList.add(languageLevel3);
        }
        ArrayList<LanguageLevel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyCompatibilityInspectionAdvertiser.a(8);
        }
        return arrayList2;
    }

    private static void a(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull List<LanguageLevel> list2) {
        String string;
        InspectionProfileImpl inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper;
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(9);
        }
        if (psiElement == null) {
            PyCompatibilityInspectionAdvertiser.a(10);
        }
        if (list2 == null) {
            PyCompatibilityInspectionAdvertiser.a(11);
        }
        if ((inspectionToolWrapper = (inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(string = PyCompatibilityInspectionAdvertiser.a(), project)) != null) {
            inspectionProfileImpl.modifyProfile(inspectionProfileModifiableModel -> {
                PyCompatibilityInspection pyCompatibilityInspection = (PyCompatibilityInspection)inspectionProfileModifiableModel.getUnwrappedTool(string, psiElement);
                pyCompatibilityInspection.ourVersions.addAll((Collection)ContainerUtil.map((Collection)list2, LanguageLevel::toString));
            });
            EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)inspectionProfileImpl, (String)string);
        }
    }

    private static void a(@NotNull Project project, @NotNull String string) {
        long l2 = h ^ 0x44EDFD15DA6L;
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(12);
        }
        if (string == null) {
            PyCompatibilityInspectionAdvertiser.a(13);
        }
        String string2 = string + ".<br/>Would you like to enable Code compatibility inspection?<br/>" + f;
        PyCompatibilityInspectionAdvertiser.a(project, b, string2, NotificationType.INFORMATION, (notification2, hyperlinkEvent) -> {
            long l2 = h ^ 0x5DD5FDE8DFF5L;
            boolean bl2 = "#yes".equals(hyperlinkEvent.getDescription());
            if (bl2) {
                PyCompatibilityInspectionAdvertiser.b(project);
            }
            if (!bl2) {
                // empty if block
            }
            PyCompatibilityInspectionAdvertiser.a((Project)project).version = 3;
        });
    }

    private static void a(@NotNull Project project, @NotNull String string, @NotNull String string2, @NotNull NotificationType notificationType, @NotNull NotificationListener notificationListener) {
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(14);
        }
        if (string == null) {
            PyCompatibilityInspectionAdvertiser.a(15);
        }
        if (string2 == null) {
            PyCompatibilityInspectionAdvertiser.a(16);
        }
        if (notificationType == null) {
            PyCompatibilityInspectionAdvertiser.a(17);
        }
        if (notificationListener == null) {
            PyCompatibilityInspectionAdvertiser.a(18);
        }
        project.putUserData(a, (Object)true);
        g.createNotification(string, string2, notificationType, (notification2, hyperlinkEvent) -> {
            try {
                notificationListener.hyperlinkUpdate(notification2, hyperlinkEvent);
            }
            finally {
                notification2.expire();
            }
        }).notify(project);
    }

    private static boolean b(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyCompatibilityInspectionAdvertiser.a(19);
        }
        for (PyFromImportStatement pyFromImportStatement : pyFile.getFromImports()) {
            if (!pyFromImportStatement.isFromFuture()) continue;
            return true;
        }
        return false;
    }

    private static boolean b(@NotNull PsiElement psiElement) {
        InspectionProfileImpl inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper;
        if (psiElement == null) {
            PyCompatibilityInspectionAdvertiser.a(20);
        }
        return (inspectionToolWrapper = (inspectionProfileImpl = InspectionProfileManager.getInstance((Project)psiElement.getProject()).getCurrentProfile()).getInspectionTool(PyCompatibilityInspectionAdvertiser.a(), psiElement.getProject())) != null && inspectionProfileImpl.isToolEnabled(HighlightDisplayKey.findById((String)inspectionToolWrapper.getID()), psiElement);
    }

    private static void b(@NotNull Project project) {
        InspectionProfileImpl inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper;
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(21);
        }
        if ((inspectionToolWrapper = (inspectionProfileImpl = InspectionProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(PyCompatibilityInspectionAdvertiser.a(), project)) != null) {
            inspectionProfileImpl.setToolEnabled(inspectionToolWrapper.getShortName(), true);
            EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)inspectionProfileImpl, (String)PyCompatibilityInspectionAdvertiser.a());
        }
    }

    @Nullable
    private static LanguageLevel a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PyCompatibilityInspectionAdvertiser.a(22);
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance((Project)psiElement.getProject()).getCurrentProfile();
        PyCompatibilityInspection pyCompatibilityInspection = (PyCompatibilityInspection)inspectionProfileImpl.getUnwrappedTool(PyCompatibilityInspectionAdvertiser.a(), psiElement);
        JDOMExternalizableStringList jDOMExternalizableStringList = pyCompatibilityInspection.ourVersions;
        if (jDOMExternalizableStringList.isEmpty()) {
            return null;
        }
        String string = (String)Collections.max(jDOMExternalizableStringList);
        return LanguageLevel.fromPythonVersion(string);
    }

    @NotNull
    private static String a() {
        String string = PyCompatibilityInspection.class.getSimpleName();
        if (string == null) {
            PyCompatibilityInspectionAdvertiser.a(23);
        }
        return string;
    }

    @NotNull
    private static PyCompatibilityInspectionAdvertiserSettings a(@NotNull Project project) {
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.a(24);
        }
        PyCompatibilityInspectionAdvertiserSettings pyCompatibilityInspectionAdvertiserSettings = (PyCompatibilityInspectionAdvertiserSettings)ServiceManager.getService((Project)project, PyCompatibilityInspectionAdvertiserSettings.class);
        if (pyCompatibilityInspectionAdvertiserSettings == null) {
            PyCompatibilityInspectionAdvertiser.a(25);
        }
        return pyCompatibilityInspectionAdvertiserSettings;
    }

    static {
        h = com.jetbrains.python.psi.c.a(7235007489452921042L, 8081413298504065004L, MethodHandles.lookup().lookupClass()).a(184740732907705L);
        long l2 = h ^ 0x136EEBAFB6F3L;
        g = new NotificationGroup("Python Compatibility Inspection Advertiser", NotificationDisplayType.STICKY_BALLOON, false);
        a = Key.create((String)"showingPyCompatibilityAdvertiserBalloon");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0xA593CF2E0C0L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestConfiguredVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyCompatibilityInspectionAdvertiser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspectionAdvertiser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionsNewerThan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibilityInspectionShortName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moduleUsesPythonSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLatestConfiguredCompatiblePython3Version";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showStalePython3VersionWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionsNewerThan";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableVersions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showInspectionAdvertisement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showSingletonNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsFutureImports";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibilityInspectionEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enableCompatibilityInspection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLatestConfiguredCompatiblePythonVersion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

