/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyBroadExceptionInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddCallSuperQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMissingConstructorInspection
extends PyInspection {
    private static final long a = c.a(2484776648672536247L, -8822098978984854374L, MethodHandles.lookup().lookupClass()).a(114556242023005L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x13E13F732BDL;
        String string = PyBundle.message("INSP.NAME.missing.super.constructor", new Object[0]);
        if (string == null) {
            PyMissingConstructorInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMissingConstructorInspection.b(1);
        }
        if (session == null) {
            PyMissingConstructorInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyMissingConstructorInspection.b(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3066FAF79FE8L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMissingConstructorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(-5872718540337600860L, -921811606927838623L, MethodHandles.lookup().lookupClass()).a(6107969742813L);

        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            PyExpression[] pyExpressionArray;
            long l2 = c ^ 0x48BB978B4CE9L;
            if (node == null) {
                Visitor.b(1);
            }
            if ((pyExpressionArray = node.getSuperClassExpressions()).length == 0 || pyExpressionArray.length == 1 && "object".equals(pyExpressionArray[0].getText()) || !Visitor.b(node, this.myTypeEvalContext)) {
                return;
            }
            PyFunction pyFunction = node.findMethodByName("__init__", false, this.myTypeEvalContext);
            if (pyFunction == null || Visitor.a(node, this.myTypeEvalContext) || Visitor.a(node, pyFunction, this.myTypeEvalContext)) {
                return;
            }
            if (pyExpressionArray.length == 1 || node.isNewStyleClass(this.myTypeEvalContext)) {
                this.registerProblem(pyFunction.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]), new AddCallSuperQuickFix());
            } else {
                this.registerProblem(pyFunction.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]));
            }
        }

        private static boolean b(@NotNull PyClass pyClass, @NotNull TypeEvalContext typeEvalContext) {
            long l2 = c ^ 0x2546BD5EC41AL;
            if (pyClass == null) {
                Visitor.b(2);
            }
            if (typeEvalContext == null) {
                Visitor.b(3);
            }
            String string = pyClass.getName();
            for (PyClass pyClass2 : pyClass.getAncestorClasses(typeEvalContext)) {
                if (PyUtil.isObjectClass(pyClass2) || Comparing.equal((String)string, (String)pyClass2.getName()) || pyClass2.findMethodByName("__init__", false, typeEvalContext) == null) continue;
                return true;
            }
            return false;
        }

        private static boolean a(@NotNull PyClass pyClass2, @NotNull TypeEvalContext typeEvalContext) {
            if (pyClass2 == null) {
                Visitor.b(4);
            }
            if (typeEvalContext == null) {
                Visitor.b(5);
            }
            if (PyBroadExceptionInspection.equalsException(pyClass2, typeEvalContext)) {
                return true;
            }
            return pyClass2.getAncestorClasses(typeEvalContext).stream().anyMatch(pyClass -> PyBroadExceptionInspection.equalsException(pyClass, typeEvalContext));
        }

        private static boolean a(@NotNull PyClass pyClass, @NotNull PyFunction pyFunction, @NotNull TypeEvalContext typeEvalContext) {
            if (pyClass == null) {
                Visitor.b(6);
            }
            if (pyFunction == null) {
                Visitor.b(7);
            }
            if (typeEvalContext == null) {
                Visitor.b(8);
            }
            CallVisitor callVisitor = new CallVisitor(pyClass, typeEvalContext);
            pyFunction.getStatementList().accept(callVisitor);
            return callVisitor.a;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x62009B7BCE4AL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initMethod";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "superHasConstructor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionClass";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasConstructorCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class CallVisitor
        extends PyRecursiveElementVisitor {
            @NotNull
            private final PyClass b;
            @NotNull
            private final TypeEvalContext c;
            private boolean a;
            private static final long d = com.jetbrains.python.psi.c.a(-9053454262401945684L, -9190603653640883444L, MethodHandles.lookup().lookupClass()).a(143053110613658L);

            CallVisitor(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
                if (cls == null) {
                    CallVisitor.a(0);
                }
                if (context == null) {
                    CallVisitor.a(1);
                }
                this.a = false;
                this.b = cls;
                this.c = context;
            }

            @Override
            public void visitPyCallExpression(@NotNull PyCallExpression node) {
                if (node == null) {
                    CallVisitor.a(2);
                }
                if (CallVisitor.a(node, this.b, this.c)) {
                    this.a = true;
                }
            }

            private static boolean a(@NotNull PyCallExpression pyCallExpression, @NotNull PyClass pyClass, @NotNull TypeEvalContext typeEvalContext) {
                PyExpression pyExpression;
                long l2 = d ^ 0x3606F75E7DC1L;
                if (pyCallExpression == null) {
                    CallVisitor.a(3);
                }
                if (pyClass == null) {
                    CallVisitor.a(4);
                }
                if (typeEvalContext == null) {
                    CallVisitor.a(5);
                }
                if ((pyExpression = pyCallExpression.getCallee()) == null || !"__init__".equals(pyExpression.getName())) {
                    return false;
                }
                PyExpression pyExpression2 = Optional.of(pyExpression).filter(PyQualifiedExpression.class::isInstance).map(PyQualifiedExpression.class::cast).map(PyQualifiedExpression::getQualifier).orElse(null);
                return pyExpression2 != null && (CallVisitor.b(pyExpression2, pyClass, typeEvalContext) || CallVisitor.a(pyExpression2, pyClass, typeEvalContext));
            }

            private static boolean b(@NotNull PyExpression pyExpression, @NotNull PyClass pyClass, @NotNull TypeEvalContext typeEvalContext) {
                long l2 = d ^ 0x638080D92B3L;
                if (pyExpression == null) {
                    CallVisitor.a(6);
                }
                if (pyClass == null) {
                    CallVisitor.a(7);
                }
                if (typeEvalContext == null) {
                    CallVisitor.a(8);
                }
                String string = Optional.of(pyExpression).filter(PyCallExpression.class::isInstance).map(PyCallExpression.class::cast).map(PyCallExpression::getCallee).map(NavigationItem::getName).orElse(null);
                if (!"super".equals(string)) {
                    return false;
                }
                PyExpression[] pyExpressionArray = ((PyCallExpression)pyExpression).getArguments();
                if (pyExpressionArray.length == 0) {
                    return true;
                }
                String string2 = pyExpressionArray[0].getText();
                String string3 = pyClass.getQualifiedName();
                if (string2.equals(pyClass.getName()) || string2.equals("self.__class__") || string3 != null && string3.endsWith(string2) || string2.equals("__class__") && !LanguageLevel.forElement((PsiElement)pyClass).isPython2()) {
                    return true;
                }
                return pyClass.getAncestorClasses(typeEvalContext).stream().map(NavigationItem::getName).anyMatch(string2::equals);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static boolean a(@NotNull PyExpression pyExpression, @NotNull PyClass pyClass, @NotNull TypeEvalContext typeEvalContext) {
                PsiElement psiElement;
                if (pyExpression == null) {
                    CallVisitor.a(9);
                }
                if (pyClass == null) {
                    CallVisitor.a(10);
                }
                if (typeEvalContext == null) {
                    CallVisitor.a(11);
                }
                if ((psiElement = CallVisitor.a(pyExpression)) == null) return false;
                if (!pyClass.getAncestorClasses(typeEvalContext).stream().anyMatch(psiElement::equals)) return false;
                return true;
            }

            @Nullable
            private static PsiElement a(@NotNull PyExpression pyExpression) {
                if (pyExpression == null) {
                    CallVisitor.a(12);
                }
                if (pyExpression instanceof PyCallExpression) {
                    return Optional.of((PyCallExpression)pyExpression).map(PyCallExpression::getCallee).map(PsiElement::getReference).map(PsiReference::resolve).orElse(null);
                }
                return Optional.ofNullable(pyExpression.getReference()).map(PsiReference::resolve).orElse(null);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = d ^ 0x47837C29E6A8L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cls";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 6: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "calleeQualifier";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor$CallVisitor";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyCallExpression";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isConstructorCall";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSuperCall";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSuperClassCall";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveCallingClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

