/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyNonAsciiCharInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;
    private static final long a = c.a(-645261752277694012L, -840488322917064938L, MethodHandles.lookup().lookupClass()).a(125400225639503L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x59EEA5C0F832L;
        String string = PyBundle.message("INSP.NAME.non.ascii", new Object[0]);
        if (string == null) {
            PyNonAsciiCharInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNonAsciiCharInspection.b(1);
        }
        if (session == null) {
            PyNonAsciiCharInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyNonAsciiCharInspection.b(3);
        }
        return visitor2;
    }

    public JComponent createOptionsPanel() {
        JComboBox<String> jComboBox = new JComboBox<String>(PyEncodingUtil.POSSIBLE_ENCODINGS);
        jComboBox.setSelectedItem(this.myDefaultEncoding);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                JComboBox jComboBox = (JComboBox)e10.getSource();
                PyNonAsciiCharInspection.this.myDefaultEncoding = (String)jComboBox.getSelectedItem();
            }
        });
        JComboBox<String> jComboBox2 = new JComboBox<String>(PyEncodingUtil.ENCODING_FORMAT);
        jComboBox2.setSelectedIndex(this.myEncodingFormatIndex);
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                JComboBox jComboBox = (JComboBox)e10.getSource();
                PyNonAsciiCharInspection.this.myEncodingFormatIndex = jComboBox.getSelectedIndex();
            }
        });
        return PyEncodingUtil.createEncodingOptionsPanel(jComboBox, jComboBox2);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x165B618ED9DEL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(275174133260494691L, 485340137236954787L, MethodHandles.lookup().lookupClass()).a(98321377101479L);

        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
        }

        public void visitComment(PsiComment node) {
            this.a((PsiElement)node, node.getText());
        }

        private void a(PsiElement psiElement, String string) {
            long l2 = c ^ 0x51FF9168C581L;
            if (LanguageLevel.forElement(psiElement).isPython2()) {
                PsiFile psiFile = psiElement.getContainingFile();
                if (psiFile == null) {
                    return;
                }
                String string2 = PythonFileType.getCharsetFromEncodingDeclaration(psiFile);
                boolean bl2 = false;
                CharsetEncoder charsetEncoder = Charset.forName("US-ASCII").newEncoder();
                int n2 = string.length();
                char c10 = '\u0000';
                for (int i10 = 0; i10 < n2; ++i10) {
                    c10 = string.charAt(i10);
                    if (charsetEncoder.canEncode(c10)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && string2 == null) {
                    this.registerProblem(psiElement, "Non-ASCII character " + c10 + " in file, but no encoding declared", new AddEncodingQuickFix(PyNonAsciiCharInspection.this.myDefaultEncoding, PyNonAsciiCharInspection.this.myEncodingFormatIndex));
                }
            }
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.a(node, node.getText());
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            this.a((PsiElement)node, node.getText());
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.a(node, node.getText());
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x149E6CE1EDE8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNonAsciiCharInspection$Visitor", "<init>"));
        }
    }
}

