/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureQuickFix
extends LocalQuickFixOnPsiElement {
    public static final Key<Boolean> CHANGE_SIGNATURE_ORIGINAL_CALL;
    private final List<Pair<Integer, PyParameterInfo>> b;
    @Nullable
    private final SmartPsiElementPointer<PyCallSiteExpression> a;
    private static final long c;

    @NotNull
    public static PyChangeSignatureQuickFix forMismatchedCall(@NotNull PyCallExpression.PyArgumentsMapping mapping) {
        if (mapping == null) {
            PyChangeSignatureQuickFix.a(0);
        }
        assert (mapping.getMarkedCallee() != null);
        PyFunction pyFunction = PyUtil.as(mapping.getMarkedCallee().getElement(), PyFunction.class);
        assert (pyFunction != null);
        PyCallSiteExpression pyCallSiteExpression = mapping.getCallSiteExpression();
        int n2 = -1;
        PyParameter[] pyParameterArray = pyFunction.getParameterList().getParameters();
        for (PyParameter pyParameter : pyParameterArray) {
            boolean bl2;
            PyNamedParameter pyExpression = pyParameter.getAsNamed();
            boolean bl3 = bl2 = pyExpression != null && (pyExpression.isPositionalContainer() || pyExpression.isKeywordContainer());
            if (pyParameter instanceof PySingleStarParameter || pyParameter.hasDefaultValue() || bl2) break;
            ++n2;
        }
        ArrayList arrayList = new ArrayList();
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(pyFunction.getProject(), pyCallSiteExpression.getContainingFile());
        HashSet<String> hashSet = new HashSet<String>();
        for (PyExpression pyExpression : mapping.getUnmappedArguments()) {
            Object object;
            if (pyExpression instanceof PyKeywordArgument) {
                object = ((PyKeywordArgument)pyExpression).getValueExpression();
                String string = object != null ? object.getText() : "";
                arrayList.add(Pair.create((Object)(pyParameterArray.length - 1), (Object)new PyParameterInfo(-1, ((PyKeywordArgument)pyExpression).getKeyword(), string, true)));
                continue;
            }
            object = PyChangeSignatureQuickFix.a(pyExpression, pyFunction, hashSet, typeEvalContext);
            arrayList.add(Pair.create((Object)n2, (Object)new PyParameterInfo(-1, (String)object, pyExpression.getText(), false)));
            hashSet.add((String)object);
        }
        PyChangeSignatureQuickFix pyChangeSignatureQuickFix = new PyChangeSignatureQuickFix(pyFunction, arrayList, mapping.getCallSiteExpression());
        if (pyChangeSignatureQuickFix == null) {
            PyChangeSignatureQuickFix.a(1);
        }
        return pyChangeSignatureQuickFix;
    }

    @NotNull
    public static PyChangeSignatureQuickFix forMismatchingMethods(@NotNull PyFunction function, @NotNull PyFunction complementary) {
        long l2 = c ^ 0x4C70F1A626D6L;
        if (function == null) {
            PyChangeSignatureQuickFix.a(2);
        }
        if (complementary == null) {
            PyChangeSignatureQuickFix.a(3);
        }
        int n2 = function.getParameterList().getParameters().length;
        int n3 = complementary.getParameterList().getParameters().length;
        List<Object> list2 = n3 > n2 ? Collections.singletonList(Pair.create((Object)(n2 - 1), (Object)new PyParameterInfo(-1, "**kwargs", "", false))) : Collections.emptyList();
        PyChangeSignatureQuickFix pyChangeSignatureQuickFix = new PyChangeSignatureQuickFix(function, list2, null);
        if (pyChangeSignatureQuickFix == null) {
            PyChangeSignatureQuickFix.a(4);
        }
        return pyChangeSignatureQuickFix;
    }

    private PyChangeSignatureQuickFix(@NotNull PyFunction function, @NotNull List<Pair<Integer, PyParameterInfo>> extraParameters, @Nullable PyCallSiteExpression expression) {
        if (function == null) {
            PyChangeSignatureQuickFix.a(5);
        }
        if (extraParameters == null) {
            PyChangeSignatureQuickFix.a(6);
        }
        super((PsiElement)function);
        this.b = ContainerUtil.sorted(extraParameters, Comparator.comparingInt(pair -> (Integer)pair.getFirst()));
        this.a = expression != null ? SmartPointerManager.getInstance((Project)function.getProject()).createSmartPsiElementPointer((PsiElement)expression) : null;
    }

    @NotNull
    public String getFamilyName() {
        long l2 = c ^ 0x83E2F775F08L;
        String string = PyBundle.message("QFIX.NAME.change.signature", new Object[0]);
        if (string == null) {
            PyChangeSignatureQuickFix.a(7);
        }
        return string;
    }

    @NotNull
    public String getText() {
        long l2 = c ^ 0x39E66C86937L;
        PyFunction pyFunction = this.a();
        if (pyFunction == null) {
            String string = this.getFamilyName();
            if (string == null) {
                PyChangeSignatureQuickFix.a(8);
            }
            return string;
        }
        String string = StringUtil.join(this.a(pyFunction).getParameters(), pyParameterInfo -> {
            long l2 = c ^ 0x48901B69C362L;
            return pyParameterInfo.getOldIndex() == -1 ? "<b>" + pyParameterInfo.getName() + "</b>" : pyParameterInfo.getName();
        }, (String)", ");
        String string2 = PyBundle.message("QFIX.change.signature.of", StringUtil.notNullize((String)pyFunction.getName()) + "(" + string + ")");
        String string3 = XmlStringUtil.wrapInHtml((CharSequence)string2);
        if (string3 == null) {
            PyChangeSignatureQuickFix.a(9);
        }
        return string3;
    }

    @Nullable
    private PyFunction a() {
        return (PyFunction)this.getStartElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        block13: {
            if (project == null) {
                PyChangeSignatureQuickFix.a(10);
            }
            if (file == null) {
                PyChangeSignatureQuickFix.a(11);
            }
            if (startElement == null) {
                PyChangeSignatureQuickFix.a(12);
            }
            if (endElement == null) {
                PyChangeSignatureQuickFix.a(13);
            }
            PyFunction pyFunction = this.a();
            PyMethodDescriptor pyMethodDescriptor = this.a(pyFunction);
            PyChangeSignatureDialog pyChangeSignatureDialog = new PyChangeSignatureDialog(project, pyMethodDescriptor){

                protected int getSelectedIdx() {
                    return (int)StreamEx.of((Collection)this.getParameters()).indexOf(pyParameterInfo -> pyParameterInfo.getOldIndex() < 0).orElse(super.getSelectedIdx());
                }
            };
            PyCallSiteExpression pyCallSiteExpression = this.a != null ? (PyCallSiteExpression)this.a.getElement() : null;
            try {
                if (pyCallSiteExpression != null) {
                    pyCallSiteExpression.putUserData(CHANGE_SIGNATURE_ORIGINAL_CALL, true);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    try {
                        pyChangeSignatureDialog.createRefactoringProcessor().run();
                        break block13;
                    }
                    finally {
                        Disposer.dispose((Disposable)pyChangeSignatureDialog.getDisposable());
                    }
                }
                pyChangeSignatureDialog.show();
            }
            finally {
                if (pyCallSiteExpression != null) {
                    pyCallSiteExpression.putUserData(CHANGE_SIGNATURE_ORIGINAL_CALL, null);
                }
            }
        }
    }

    @NotNull
    private static String a(@NotNull PyExpression pyExpression, @NotNull PyFunction pyFunction, @NotNull Set<String> set, @NotNull TypeEvalContext typeEvalContext) {
        Object object;
        Object object2;
        long l2 = c ^ 0x295CCB596D8EL;
        if (pyExpression == null) {
            PyChangeSignatureQuickFix.a(14);
        }
        if (pyFunction == null) {
            PyChangeSignatureQuickFix.a(15);
        }
        if (set == null) {
            PyChangeSignatureQuickFix.a(16);
        }
        if (typeEvalContext == null) {
            PyChangeSignatureQuickFix.a(17);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        PyCallExpression pyCallExpression = PyUtil.as(pyExpression, PyCallExpression.class);
        PyElement pyElement = PyUtil.as(pyCallExpression != null ? pyCallExpression.getCallee() : pyExpression, PyReferenceExpression.class);
        if (pyElement != null) {
            linkedHashSet.addAll(NameSuggesterUtil.generateNames(pyElement.getText()));
        }
        if (linkedHashSet.isEmpty()) {
            object2 = typeEvalContext.getType(pyExpression);
            if (object2 instanceof PyUnionType) {
                object2 = (PyType)ContainerUtil.find(((PyUnionType)object2).getMembers(), (Condition)Conditions.instanceOf(PyClassType.class));
            }
            object = object2 != null && object2.getName() != null ? object2.getName() : "object";
            linkedHashSet.addAll(NameSuggesterUtil.generateNamesByType((String)object));
        }
        object = object2 = Collections.min(linkedHashSet, Comparator.comparingInt(String::length));
        int n2 = 1;
        while (!PyRefactoringUtil.isValidNewName((String)object, (PsiElement)pyFunction.getStatementList()) || set.contains(object)) {
            object = (String)object2 + n2;
            ++n2;
        }
        Object object3 = object;
        if (object3 == null) {
            PyChangeSignatureQuickFix.a(18);
        }
        return object3;
    }

    @NotNull
    private PyMethodDescriptor a(PyFunction pyFunction) {
        PyMethodDescriptor pyMethodDescriptor = new PyMethodDescriptor(pyFunction){

            @Override
            public List<PyParameterInfo> getParameters() {
                ArrayList<PyParameterInfo> arrayList = new ArrayList<PyParameterInfo>();
                List<PyParameterInfo> list2 = super.getParameters();
                PeekingIterator peekingIterator = Iterators.peekingIterator(PyChangeSignatureQuickFix.this.b.iterator());
                while (peekingIterator.hasNext() && (Integer)((Pair)peekingIterator.peek()).getFirst() < 0) {
                    arrayList.add((PyParameterInfo)((Pair)peekingIterator.next()).getSecond());
                }
                for (int i10 = 0; i10 < list2.size(); ++i10) {
                    arrayList.add(list2.get(i10));
                    while (peekingIterator.hasNext() && (Integer)((Pair)peekingIterator.peek()).getFirst() == i10) {
                        arrayList.add((PyParameterInfo)((Pair)peekingIterator.next()).getSecond());
                    }
                }
                return arrayList;
            }
        };
        if (pyMethodDescriptor == null) {
            PyChangeSignatureQuickFix.a(19);
        }
        return pyMethodDescriptor;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            PyChangeSignatureQuickFix.a(20);
        }
        return this.a();
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        c = com.jetbrains.python.psi.c.a(3364801913456243966L, -1351368328953009441L, MethodHandles.lookup().lookupClass()).a(103858434604928L);
        long l2 = c ^ 0x4C8653373A46L;
        CHANGE_SIGNATURE_ORIGINAL_CALL = Key.create((String)"CHANGE_SIGNATURE_ORIGINAL_CALL");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x5B746ED6B5C6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix";
                break;
            }
            case 2: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "complementary";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraParameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedParameterNames";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forMismatchedCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forMismatchingMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateParameterName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forMismatchedCall";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forMismatchingMethods";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

