/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PySyncCheckCreateIfPossible;
import com.jetbrains.python.remote.PySyncCheckOnly;
import com.jetbrains.python.remote.PySyncDirection;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkUtil;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonProjectGenerator<T extends PyNewProjectSettings>
extends DirectoryProjectGeneratorBase<T> {
    public static final PyNewProjectSettings NO_SETTINGS;
    private static final Logger c;
    private final List<SettingsListener> a = ContainerUtil.createLockFreeCopyOnWriteList();
    private final boolean d;
    @Nullable
    private MouseListener b;
    protected Consumer<String> myErrorCallback;
    private static final long i;

    protected PythonProjectGenerator() {
        this(false);
    }

    protected PythonProjectGenerator(boolean allowRemoteProjectCreation) {
        this.d = allowRemoteProjectCreation;
    }

    public final void setErrorCallback(@NotNull Consumer<String> errorCallback) {
        if (errorCallback == null) {
            PythonProjectGenerator.a(0);
        }
        this.myErrorCallback = errorCallback;
    }

    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        return null;
    }

    @Nullable
    public JPanel extendBasePanel() throws ProcessCanceledException {
        return null;
    }

    public void checkProjectCanBeCreatedOnSdk(@NotNull Sdk sdk, @NotNull File projectDirectory) throws PyNoProjectAllowedOnSdkException {
        long l2 = i ^ 0x3758796E8FDCL;
        if (sdk == null) {
            PythonProjectGenerator.a(1);
        }
        if (projectDirectory == null) {
            PythonProjectGenerator.a(2);
        }
        if (!this.d && PySdkUtil.isRemote(sdk)) {
            throw new PyNoProjectAllowedOnSdkException("Can't create project of this type on remote interpreter. Choose local interpreter.");
        }
        PyProjectSynchronizer pyProjectSynchronizer = PythonRemoteInterpreterManager.getSynchronizerInstance(sdk);
        if (pyProjectSynchronizer == null) {
            return;
        }
        String string = pyProjectSynchronizer.checkSynchronizationAvailable(new PySyncCheckOnly(projectDirectory));
        if (string != null) {
            throw new PyNoProjectAllowedOnSdkException(string);
        }
    }

    public final void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module2) {
        Sdk sdk;
        long l2 = i ^ 0x3735CD38B1FBL;
        if (project == null) {
            PythonProjectGenerator.a(3);
        }
        if (baseDir == null) {
            PythonProjectGenerator.a(4);
        }
        if (settings == null) {
            PythonProjectGenerator.a(5);
        }
        if (module2 == null) {
            PythonProjectGenerator.a(6);
        }
        if (settings == NO_SETTINGS) {
            this.configureProjectNoSettings(project, baseDir, module2);
            return;
        }
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        Sdk sdk2 = ((PyNewProjectSettings)settings).getSdk();
        if (sdk2 instanceof PyLazySdk) {
            sdk = ((PyLazySdk)sdk2).create();
            ((PyNewProjectSettings)settings).setSdk(sdk);
            if (sdk != null) {
                SdkConfigurationUtil.addSdk((Sdk)sdk);
            }
        }
        PyProjectSynchronizer pyProjectSynchronizer = sdk = pythonRemoteInterpreterManager != null ? pythonRemoteInterpreterManager.getSynchronizer(sdk2) : null;
        if (sdk != null) {
            String string;
            String string2 = ((PyNewProjectSettings)settings).getRemotePath();
            while ((string = sdk.checkSynchronizationAvailable(new PySyncCheckCreateIfPossible(module2, string2))) != null) {
                string2 = null;
                String string3 = String.format("Local/Remote synchronization is not configured correctly.\n%s\nYou may need to sync local and remote project manually.\n\n Do you want to continue? \n\nSay 'Yes' to stay with misconfigured  mappings or 'No' to start manual configuration process.", string);
                if (Messages.showYesNoDialog((Project)project, (String)string3, (String)"Synchronization not Configured", (Icon)AllIcons.General.WarningDialog) != 0) continue;
                break;
            }
        }
        this.configureProject(project, baseDir, settings, module2, (PyProjectSynchronizer)sdk);
    }

    protected void configureProjectNoSettings(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Module module2) {
        long l2 = i ^ 0x24D9ED3D823BL;
        if (project == null) {
            PythonProjectGenerator.a(7);
        }
        if (baseDir == null) {
            PythonProjectGenerator.a(8);
        }
        if (module2 == null) {
            PythonProjectGenerator.a(9);
        }
        throw new IllegalStateException(String.format("%s does not support project creation with out of settings. See %s doc for detail", ((Object)((Object)this)).getClass(), PythonProjectGenerator.class));
    }

    protected void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module2, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            PythonProjectGenerator.a(10);
        }
        if (baseDir == null) {
            PythonProjectGenerator.a(11);
        }
        if (settings == null) {
            PythonProjectGenerator.a(12);
        }
        if (module2 == null) {
            PythonProjectGenerator.a(13);
        }
        if (synchronizer != null) {
            synchronizer.syncProject(module2, PySyncDirection.LOCAL_TO_REMOTE, null, new String[0]);
        }
    }

    public Object getProjectSettings() {
        return new PyNewProjectSettings();
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        return ValidationResult.OK;
    }

    public void addSettingsStateListener(@NotNull SettingsListener listener2) {
        if (listener2 == null) {
            PythonProjectGenerator.a(14);
        }
        this.a.add(listener2);
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            PythonProjectGenerator.a(15);
        }
    }

    public void fireStateChanged() {
        for (SettingsListener settingsListener : this.a) {
            settingsListener.stateChanged();
        }
    }

    @Nullable
    public BooleanFunction<PythonProjectGenerator> beforeProjectGenerated(@Nullable Sdk sdk) {
        return null;
    }

    public void afterProjectGenerated(@NotNull Project project) {
        if (project == null) {
            PythonProjectGenerator.a(16);
        }
    }

    @Deprecated
    @Contract(value=" -> false")
    public boolean hideInterpreter() {
        return false;
    }

    public void addErrorLabelMouseListener(@NotNull MouseListener mouseListener) {
        if (mouseListener == null) {
            PythonProjectGenerator.a(17);
        }
        this.b = mouseListener;
    }

    @Nullable
    public MouseListener getErrorLabelMouseListener() {
        return this.b;
    }

    public void createAndAddVirtualEnv(Project project, PyNewProjectSettings settings) {
    }

    protected static void reportPackageInstallationFailure(@NotNull String frameworkName, @Nullable Pair<Sdk, ExecutionException> sdkAndException) {
        if (frameworkName == null) {
            PythonProjectGenerator.a(18);
        }
        PackageManagementService.ErrorDescription errorDescription = PythonProjectGenerator.a(sdkAndException);
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            long l2 = i ^ 0x7E71AE4D8039L;
            PackagesNotificationPanel.showError((String)String.format("Install %s failed", frameworkName), (PackageManagementService.ErrorDescription)errorDescription);
        });
    }

    @NotNull
    private static PackageManagementService.ErrorDescription a(@Nullable Pair<Sdk, ExecutionException> pair) {
        ExecutionException executionException;
        long l2 = i ^ 0x6F0B66AD8E8CL;
        PackageManagementService.ErrorDescription errorDescription = null;
        if (pair != null && (errorDescription = PyPackageManagementService.toErrorDescription(Collections.singletonList(executionException = (ExecutionException)((Object)pair.second)), (Sdk)pair.first)) == null) {
            errorDescription = PackageManagementService.ErrorDescription.fromMessage((String)executionException.getMessage());
        }
        if (errorDescription == null) {
            errorDescription = PackageManagementService.ErrorDescription.fromMessage((String)"Choose another SDK");
        }
        PackageManagementService.ErrorDescription errorDescription2 = errorDescription;
        if (errorDescription2 == null) {
            PythonProjectGenerator.a(19);
        }
        return errorDescription2;
    }

    protected static void installFrameworkIfNeeded(@NotNull Project project, final @NotNull String frameworkName, final @NotNull String requirement, final @Nullable Sdk sdk, final boolean forceInstallFramework, final @Nullable Runnable callback) {
        long l2 = i ^ 0x1A13E967CD53L;
        if (project == null) {
            PythonProjectGenerator.a(20);
        }
        if (frameworkName == null) {
            PythonProjectGenerator.a(21);
        }
        if (requirement == null) {
            PythonProjectGenerator.a(22);
        }
        if (sdk == null) {
            PythonProjectGenerator.reportPackageInstallationFailure(frameworkName, null);
            return;
        }
        final PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
        if (forceInstallFramework || PySdkUtil.isRemote(sdk)) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, String.format("Ensuring %s is installed", frameworkName), false){
                private static final long a = com.jetbrains.python.psi.c.a(2742036755152895858L, -1584979987119083380L, MethodHandles.lookup().lookupClass()).a(157968107993732L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x48A8C45EDDCAL;
                    if (indicator == null) {
                        1.a(0);
                    }
                    boolean bl2 = false;
                    if (!forceInstallFramework) {
                        indicator.setText(String.format("Checking if %s is installed...", frameworkName));
                        List<PyPackage> list2 = PyPackageUtil.refreshAndGetPackagesModally(sdk);
                        boolean bl3 = bl2 = PyPackageUtil.findPackage(list2, requirement) != null;
                    }
                    if (!bl2) {
                        indicator.setText(String.format("Installing %s...", frameworkName));
                        try {
                            pyPackageManager.install(requirement);
                            pyPackageManager.refresh();
                        }
                        catch (ExecutionException executionException) {
                            PythonProjectGenerator.reportPackageInstallationFailure(requirement, (Pair<Sdk, ExecutionException>)Pair.create((Object)sdk, (Object)((Object)executionException)));
                        }
                    }
                }

                public void onSuccess() {
                    if (callback != null) {
                        callback.run();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x1661B6D7A2FBL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/newProject/PythonProjectGenerator$1", "run"));
                }
            });
        } else if (callback != null) {
            assert (SwingUtilities.isEventDispatchThread());
            callback.run();
        }
    }

    @Nullable
    public String getPreferredEnvironmentType() {
        return null;
    }

    static {
        i = com.jetbrains.python.psi.c.a(6372639867886123002L, -2422495831472438730L, MethodHandles.lookup().lookupClass()).a(82899689231682L);
        NO_SETTINGS = new PyNewProjectSettings();
        c = Logger.getInstance(PythonProjectGenerator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x3D9DEC3CF17BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDirectory";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseListener";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setErrorCallback";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectCanBeCreatedOnSdk";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectNoSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterProjectGenerated";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addErrorLabelMouseListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportPackageInstallationFailure";
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "installFrameworkIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyNoProjectAllowedOnSdkException
    extends Exception {
        private static final long a = com.jetbrains.python.psi.c.a(264322060333771279L, -2267268419775643181L, MethodHandles.lookup().lookupClass()).a(44762118145346L);

        PyNoProjectAllowedOnSdkException(@NotNull String reason) {
            if (reason == null) {
                PyNoProjectAllowedOnSdkException.a(0);
            }
            super(reason);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x2BCD5214E577L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/jetbrains/python/newProject/PythonProjectGenerator$PyNoProjectAllowedOnSdkException", "<init>"));
        }
    }

    public static interface SettingsListener {
        public void stateChanged();
    }
}

