/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.steps.PyAddExistingSdkPanel;
import com.jetbrains.python.newProject.steps.PyAddNewEnvironmentPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSpecificSettingsStep<T>
extends ProjectSettingsStepBase<T>
implements DumbAware {
    private boolean a;
    @Nullable
    private PyAddSdkGroupPanel b;
    private static final long c = com.jetbrains.python.psi.c.a(-2177702576365806923L, -2179970432527432831L, MethodHandles.lookup().lookupClass()).a(104364262583430L);

    public ProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> projectGenerator, @NotNull AbstractNewProjectStep.AbstractCallback<T> callback) {
        if (projectGenerator == null) {
            ProjectSpecificSettingsStep.a(0);
        }
        if (callback == null) {
            ProjectSpecificSettingsStep.a(1);
        }
        super(projectGenerator, callback);
    }

    protected JPanel createAndFillContentPanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).setErrorCallback(arg_0 -> ((ProjectSpecificSettingsStep)this).setErrorText(arg_0));
        }
        return this.createContentPanelWithAdvancedSettingsPanel();
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        long l2 = c ^ 0x241FB5B7A45L;
        JComponent jComponent = null;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            jComponent = ((PythonProjectGenerator)this.myProjectGenerator).getSettingsPanel(this.myProjectDirectory);
        } else if (this.myProjectGenerator instanceof WebProjectTemplate) {
            jComponent = this.getPeer().getComponent();
        }
        if (jComponent != null) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            HideableDecorator hideableDecorator = new HideableDecorator(jPanel, "Mor&e Settings", false);
            if (this.myProjectGenerator instanceof PythonProjectGenerator) {
                ValidationResult validationResult = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(this.c());
                hideableDecorator.setOn(!validationResult.isOk());
            }
            hideableDecorator.setContentComponent(jComponent);
            return jPanel;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        long l2 = c ^ 0x55D5596F4EB1L;
        if (!(this.myProjectGenerator instanceof PythonProjectGenerator)) {
            return null;
        }
        PyAddSdkGroupPanel pyAddSdkGroupPanel = this.b;
        if (pyAddSdkGroupPanel == null) {
            return null;
        }
        PyAddSdkPanel pyAddSdkPanel = pyAddSdkGroupPanel.getSelectedPanel();
        if (pyAddSdkPanel instanceof PyAddNewEnvironmentPanel) {
            PyAddNewEnvironmentPanel pyAddNewEnvironmentPanel = (PyAddNewEnvironmentPanel)pyAddSdkPanel;
            return new PyLazySdk("Uninitialized environment", (NullableComputable<Sdk>)((NullableComputable)pyAddNewEnvironmentPanel::getOrCreateSdk));
        }
        if (pyAddSdkPanel instanceof PyAddExistingSdkPanel) {
            return pyAddSdkPanel.getSdk();
        }
        return null;
    }

    @Nullable
    private Sdk c() {
        PyAddSdkGroupPanel pyAddSdkGroupPanel = this.b;
        if (pyAddSdkGroupPanel == null) {
            return null;
        }
        return pyAddSdkGroupPanel.getSdk();
    }

    public boolean installFramework() {
        return this.a;
    }

    protected void registerValidators() {
        super.registerValidators();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            this.a((Consumer<DocumentEvent>)((Consumer)documentEvent -> {
                String string = PathUtil.getFileName((String)this.b());
                ((PythonProjectGenerator)this.myProjectGenerator).locationChanged(string);
            }));
        }
    }

    @Nullable
    final String getRemotePath() {
        PyAddSdkGroupPanel pyAddSdkGroupPanel = this.b;
        if (pyAddSdkGroupPanel == null) {
            return null;
        }
        PyAddExistingSdkPanel pyAddExistingSdkPanel = (PyAddExistingSdkPanel)ObjectUtils.tryCast((Object)pyAddSdkGroupPanel.getSelectedPanel(), PyAddExistingSdkPanel.class);
        if (pyAddExistingSdkPanel == null) {
            return null;
        }
        return pyAddExistingSdkPanel.getRemotePath();
    }

    protected void initGeneratorListeners() {
        super.initGeneratorListeners();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).addSettingsStateListener(this::checkValid);
            this.myErrorLabel.addMouseListener(((PythonProjectGenerator)this.myProjectGenerator).getErrorLabelMouseListener());
        }
    }

    public boolean checkValid() {
        Object object;
        long l2 = c ^ 0x305805393786L;
        this.a = false;
        if (!super.checkValid()) {
            return false;
        }
        PyAddSdkGroupPanel pyAddSdkGroupPanel = this.b;
        if (pyAddSdkGroupPanel != null && !(object = pyAddSdkGroupPanel.validateAll()).isEmpty()) {
            this.setErrorText(StringUtil.join(object, validationInfo -> validationInfo.message, (String)"\n"));
            return false;
        }
        object = (PythonProjectGenerator)((Object)ObjectUtils.tryCast((Object)this.myProjectGenerator, PythonProjectGenerator.class));
        Sdk sdk = this.c();
        if (object == null || sdk == null) {
            this.a = true;
            return true;
        }
        try {
            ((PythonProjectGenerator)((Object)object)).checkProjectCanBeCreatedOnSdk(sdk, new File(this.myLocationField.getText()));
        }
        catch (PythonProjectGenerator.PyNoProjectAllowedOnSdkException pyNoProjectAllowedOnSdkException) {
            this.setErrorText(pyNoProjectAllowedOnSdkException.getMessage());
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        PyFrameworkProjectGenerator pyFrameworkProjectGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.myProjectGenerator, PyFrameworkProjectGenerator.class);
        if (pyFrameworkProjectGenerator != null) {
            String string = ProjectSpecificSettingsStep.a(pyFrameworkProjectGenerator, sdk);
            if (string != null) {
                this.setErrorText(string);
                return false;
            }
            if (!PythonSdkType.isRemote(sdk)) {
                Pair<Boolean, List<String>> pair = ProjectSpecificSettingsStep.b(pyFrameworkProjectGenerator, sdk);
                this.a = (Boolean)pair.first;
                arrayList.addAll((Collection)pair.second);
                ValidationResult validationResult = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(sdk);
                if (!validationResult.isOk()) {
                    arrayList.add(validationResult.getErrorMessage());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.setWarningText(StringUtil.join(arrayList, (String)"<br/>"));
        }
        return true;
    }

    private static String a(@NotNull PyFrameworkProjectGenerator pyFrameworkProjectGenerator, @NotNull Sdk sdk) {
        long l2 = c ^ 0x4D3D44A9EF37L;
        if (pyFrameworkProjectGenerator == null) {
            ProjectSpecificSettingsStep.a(2);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.a(3);
        }
        String string = pyFrameworkProjectGenerator.getFrameworkTitle();
        boolean bl2 = PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K();
        return bl2 && !pyFrameworkProjectGenerator.supportsPython3() ? string + " is not supported for the selected interpreter" : null;
    }

    @NotNull
    private static Pair<Boolean, List<String>> b(@NotNull PyFrameworkProjectGenerator pyFrameworkProjectGenerator, @NotNull Sdk sdk) {
        long l2 = c ^ 0x36A6926CD47CL;
        if (pyFrameworkProjectGenerator == null) {
            ProjectSpecificSettingsStep.a(4);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.a(5);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        if (!pyFrameworkProjectGenerator.isFrameworkInstalled(sdk)) {
            String string = pyFrameworkProjectGenerator.getFrameworkTitle();
            if (PyPackageUtil.packageManagementEnabled(sdk)) {
                bl2 = true;
                List<PyPackage> list2 = PyPackageUtil.refreshAndGetPackagesModally(sdk);
                if (!PyPackageUtil.hasManagement(list2)) {
                    arrayList.add("Python packaging tools and " + string + " will be installed on the selected interpreter");
                } else {
                    arrayList.add(string + " will be installed on the selected interpreter");
                }
            } else {
                arrayList.add(string + " is not installed on the selected interpreter");
            }
        }
        Pair pair = Pair.create((Object)bl2, arrayList);
        if (pair == null) {
            ProjectSpecificSettingsStep.a(6);
        }
        return pair;
    }

    protected JPanel createBasePanel() {
        long l2 = c ^ 0xD393D0F9E3DL;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            BorderLayout borderLayout = new BorderLayout();
            JPanel jPanel = new JPanel(borderLayout);
            JPanel jPanel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
            LabeledComponent labeledComponent = this.createLocationComponent();
            jPanel.add((Component)labeledComponent, "Center");
            jPanel2.add(jPanel);
            jPanel2.add(this.a(((PythonProjectGenerator)this.myProjectGenerator).getPreferredEnvironmentType()));
            JPanel jPanel3 = ((PythonProjectGenerator)this.myProjectGenerator).extendBasePanel();
            if (jPanel3 != null) {
                jPanel2.add(jPanel3);
            }
            return jPanel2;
        }
        return super.createBasePanel();
    }

    @NotNull
    private JPanel a(@Nullable String string) {
        long l2 = c ^ 0x7BC216BC1BC8L;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        List<Sdk> list2 = ProjectSpecificSettingsStep.a();
        Sdk sdk = this.a(list2);
        String string2 = this.b();
        PyAddNewEnvironmentPanel pyAddNewEnvironmentPanel = new PyAddNewEnvironmentPanel(list2, string2, string);
        PyAddExistingSdkPanel pyAddExistingSdkPanel = new PyAddExistingSdkPanel(null, null, list2, string2, sdk);
        PyAddSdkPanel pyAddSdkPanel = PySdkSettings.getInstance().getUseNewEnvironmentForNewProject() ? pyAddNewEnvironmentPanel : pyAddExistingSdkPanel;
        HideableDecorator hideableDecorator = new HideableDecorator(jPanel2, ProjectSpecificSettingsStep.a(pyAddSdkPanel), false);
        hideableDecorator.setContentComponent((JComponent)jPanel);
        List<PyAddSdkPanel> list3 = Arrays.asList(pyAddNewEnvironmentPanel, pyAddExistingSdkPanel);
        this.b = new PyAddSdkGroupPanel("New project interpreter", this.getIcon(), list3, pyAddSdkPanel);
        this.b.addChangeListener(() -> {
            hideableDecorator.setTitle(ProjectSpecificSettingsStep.a(this.b.getSelectedPanel()));
            boolean bl2 = this.b.getSelectedPanel() instanceof PyAddNewEnvironmentPanel;
            PySdkSettings.getInstance().setUseNewEnvironmentForNewProject(bl2);
            this.checkValid();
        });
        this.a((Consumer<DocumentEvent>)((Consumer)documentEvent -> this.b.setNewProjectPath(this.b())));
        jPanel.add((Component)this.b, "North");
        this.checkValid();
        JPanel jPanel3 = jPanel2;
        if (jPanel3 == null) {
            ProjectSpecificSettingsStep.a(7);
        }
        return jPanel3;
    }

    @NotNull
    private String b() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myLocationField;
        if (textFieldWithBrowseButton == null) {
            if ("" == null) {
                ProjectSpecificSettingsStep.a(8);
            }
            return "";
        }
        String string = textFieldWithBrowseButton.getText().trim();
        if (string == null) {
            ProjectSpecificSettingsStep.a(9);
        }
        return string;
    }

    private void a(final @NotNull Consumer<DocumentEvent> consumer) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        if (consumer == null) {
            ProjectSpecificSettingsStep.a(10);
        }
        if ((textFieldWithBrowseButton = this.myLocationField) == null) {
            return;
        }
        textFieldWithBrowseButton.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(-8471674299185089103L, 4666926560350131671L, MethodHandles.lookup().lookupClass()).a(119080082340135L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                consumer.consume((Object)e10);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3519BF652120L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep$1", "textChanged"));
            }
        });
    }

    @NotNull
    private static String a(@NotNull PyAddSdkPanel pyAddSdkPanel) {
        Sdk sdk;
        long l2 = c ^ 0x4DF0AACC0159L;
        if (pyAddSdkPanel == null) {
            ProjectSpecificSettingsStep.a(11);
        }
        String string = pyAddSdkPanel instanceof PyAddNewEnvironmentPanel ? "New " + ((PyAddNewEnvironmentPanel)pyAddSdkPanel).getSelectedPanel().getEnvName() + " environment" : ((sdk = pyAddSdkPanel.getSdk()) != null ? sdk.getName() : pyAddSdkPanel.getPanelName());
        String string2 = "Project Interpreter: " + string;
        if (string2 == null) {
            ProjectSpecificSettingsStep.a(12);
        }
        return string2;
    }

    @Nullable
    private Sdk a(@NotNull List<Sdk> list2) {
        PyFrameworkProjectGenerator pyFrameworkProjectGenerator;
        if (list2 == null) {
            ProjectSpecificSettingsStep.a(13);
        }
        boolean bl2 = (pyFrameworkProjectGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.getProjectGenerator(), PyFrameworkProjectGenerator.class)) != null && !pyFrameworkProjectGenerator.supportsPython3();
        Sdk sdk = (Sdk)ContainerUtil.getFirstItem(list2);
        if (sdk == null) {
            return null;
        }
        if (bl2 && !PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) {
            Sdk sdk2 = PythonSdkType.findPython2Sdk(list2);
            return sdk2 != null ? sdk2 : sdk;
        }
        return sdk;
    }

    @NotNull
    private static List<Sdk> a() {
        List list2 = ((StreamEx)((StreamEx)StreamEx.of(PyConfigurableInterpreterList.getInstance(null).getAllPythonSdks()).filter(sdk -> sdk != null && sdk.getSdkType() instanceof PythonSdkType && !PythonSdkType.isInvalid(sdk))).sorted((Comparator)new PreferredSdkComparator())).toList();
        if (list2 == null) {
            ProjectSpecificSettingsStep.a(14);
        }
        return list2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x30A7DE39B3EBL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFramework";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpretersPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInterpreterTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPythonSdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateFrameworkSupportsPython3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateFramework";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLocationChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInterpreterTitle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

