/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCondaPackageManagerImpl
extends PyPackageManagerImpl {
    @Nullable
    private volatile List<PyPackage> o;
    public static final String PYTHON = "python";
    public boolean useConda;
    private static final long p = c.a(-1863879203969792294L, 4241028048067762603L, MethodHandles.lookup().lookupClass()).a(264310135917903L);

    public boolean useConda() {
        return this.useConda;
    }

    public void useConda(boolean conda) {
        this.useConda = conda;
    }

    PyCondaPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.c(0);
        }
        super(sdk);
        this.o = null;
        this.useConda = true;
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        long l2 = p ^ 0x2752B30BD35FL;
        if (extraArgs == null) {
            PyCondaPackageManagerImpl.c(1);
        }
        if (this.useConda) {
            if (requirements == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PyRequirement pyRequirement : requirements) {
                arrayList.add(pyRequirement.getPresentableText());
            }
            arrayList.add("-y");
            if (!extraArgs.contains("-U")) {
                arrayList.addAll(extraArgs);
            }
            this.a("install", arrayList);
        } else {
            super.install(requirements, extraArgs);
        }
    }

    private ProcessOutput a(@NotNull String string, List<String> list2) throws ExecutionException {
        long l2 = p ^ 0x643B11681A47L;
        if (string == null) {
            PyCondaPackageManagerImpl.c(2);
        }
        Sdk sdk = this.getSdk();
        String string2 = this.b();
        if (string2 == null) {
            throw new PyExecutionException("Empty conda name for " + sdk.getHomePath(), string, list2);
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{string, "-p", string2});
        arrayList.addAll(list2);
        return PyCondaRunKt.runConda(sdk, (List<String>)arrayList);
    }

    @Nullable
    private String b() {
        VirtualFile virtualFile = PyCondaPackageManagerImpl.getCondaDirectory(this.getSdk());
        return virtualFile == null ? null : virtualFile.getPath();
    }

    @Nullable
    public static VirtualFile getCondaDirectory(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        if (sdk == null) {
            PyCondaPackageManagerImpl.c(3);
        }
        if ((virtualFile = sdk.getHomeDirectory()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return virtualFile.getParent();
        }
        return virtualFile.getParent().getParent();
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        long l2 = p ^ 0x71126F804ED1L;
        if (requirementString == null) {
            PyCondaPackageManagerImpl.c(4);
        }
        if (this.useConda) {
            super.install(requirementString);
        } else {
            this.a("install", Lists.newArrayList((Object[])new String[]{requirementString, "-y"}));
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        long l2 = p ^ 0x4878DE233886L;
        if (packages == null) {
            PyCondaPackageManagerImpl.c(5);
        }
        if (this.useConda) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PyPackage pyPackage : packages) {
                arrayList.add(pyPackage.getName());
            }
            arrayList.add("-y");
            this.a("remove", arrayList);
        } else {
            super.uninstall(packages);
        }
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        long l2 = p ^ 0x202E3A5F9100L;
        List<PyPackage> list2 = super.collectPackages();
        ProcessOutput processOutput = this.a("list", Lists.newArrayList((Object[])new String[]{"-e"}));
        Set set = Sets.newConcurrentHashSet(this.b(processOutput.getStdout()));
        if (this.useConda) {
            this.o = list2;
            ArrayList arrayList = Lists.newArrayList((Iterable)set);
            if (arrayList == null) {
                PyCondaPackageManagerImpl.c(6);
            }
            return arrayList;
        }
        this.o = Lists.newArrayList((Iterable)set);
        List<PyPackage> list3 = super.collectPackages();
        if (list3 == null) {
            PyCondaPackageManagerImpl.c(7);
        }
        return list3;
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.useConda || super.hasManagement();
    }

    @NotNull
    private List<PyPackage> b(@NotNull String string) throws ExecutionException {
        long l2 = p ^ 0x54A299AE0293L;
        if (string == null) {
            PyCondaPackageManagerImpl.c(8);
        }
        String[] stringArray = StringUtil.splitByLines((String)string);
        ArrayList<PyPackage> arrayList = new ArrayList<PyPackage>();
        for (String string2 : stringArray) {
            if (string2.startsWith("#")) continue;
            List list2 = StringUtil.split((String)string2, (String)"=");
            if (list2.size() < 3) {
                throw new PyExecutionException("Invalid conda output format", "conda", Collections.emptyList());
            }
            String string3 = (String)list2.get(0);
            String string4 = (String)list2.get(1);
            ArrayList<PyRequirement> arrayList2 = new ArrayList<PyRequirement>();
            if (list2.size() >= 4) {
                String string5 = (String)list2.get(3);
                String string6 = StringUtil.join((Collection)StringUtil.split((String)string5, (String)":"), (String)"\n");
                arrayList2.addAll(this.parseRequirements(string6));
            }
            if ("Python".equals(string3)) continue;
            arrayList.add(new PyPackage(string3, string4, "", arrayList2));
        }
        ArrayList<PyPackage> arrayList3 = arrayList;
        if (arrayList3 == null) {
            PyCondaPackageManagerImpl.c(9);
        }
        return arrayList3;
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.c(10);
        }
        return PyCondaPackageManagerImpl.isCondaVirtualEnv(sdk.getHomePath());
    }

    public static boolean isCondaVirtualEnv(@Nullable String sdkPath) {
        long l2 = p ^ 0x16389E8E51D6L;
        VirtualFile virtualFile = PyCondaPackageManagerImpl.a(sdkPath);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.getParent().findChild("envs");
        return virtualFile2 == null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.c(11);
        }
        return PyCondaPackageManagerImpl.isConda(sdk.getHomePath());
    }

    public static boolean isConda(@Nullable String sdkPath) {
        return PyCondaPackageManagerImpl.a(sdkPath) != null;
    }

    @Nullable
    private static VirtualFile a(@Nullable String string) {
        long l2 = p ^ 0x17557D927FC4L;
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(string);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = SystemInfo.isWindows ? virtualFile.getParent() : virtualFile.getParent().getParent();
        return virtualFile2.findChild("conda-meta");
    }

    @NotNull
    public static String createVirtualEnv(@Nullable String condaExecutable, @NotNull String destinationDir, @NotNull String version) throws ExecutionException {
        long l2 = p ^ 0x44C3BC89D57AL;
        if (destinationDir == null) {
            PyCondaPackageManagerImpl.c(12);
        }
        if (version == null) {
            PyCondaPackageManagerImpl.c(13);
        }
        if (condaExecutable == null) {
            throw new PyExecutionException("Cannot find conda", "Conda", Collections.emptyList(), new ProcessOutput());
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"create", "-p", destinationDir, "-y", "python=" + version});
        PyCondaRunKt.runConda(condaExecutable, (List<String>)arrayList);
        String string = PythonSdkType.getPythonExecutable(destinationDir);
        String string2 = destinationDir + File.separator + "bin" + File.separator + PYTHON;
        String string3 = string != null ? string : string2;
        if (string3 == null) {
            PyCondaPackageManagerImpl.c(14);
        }
        return string3;
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> list2 = this.o;
        if (list2 == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList(list2);
        List<PyPackage> list3 = super.getPackages();
        if (list3 == null) {
            return null;
        }
        arrayList.addAll(list3);
        return Collections.unmodifiableList(arrayList);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x1C75AE95A9A8L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCondaToolOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCondaOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCondaDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseCondaToolOutput";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

