/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyPackagingSettings;
import com.jetbrains.python.psi.c;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPIPackageUtil {
    private static final Logger b;
    private static final Gson e;
    private static final String a = "https://pypi.python.org";
    public static final String PYPI_URL = "https://pypi.python.org/pypi";
    public static final String PYPI_LIST_URL = "https://pypi.python.org/simple";
    public static final ImmutableMap<String, List<String>> PACKAGES_TOPLEVEL;
    public static final PyPIPackageUtil INSTANCE;
    private final LoadingCache<String, List<String>> f = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<String>>(){
        private static final long a = com.jetbrains.python.psi.c.a(-5964684472914321586L, 5115839932658561923L, MethodHandles.lookup().lookupClass()).a(4794135461887L);

        public List<String> load(@NotNull String key) throws Exception {
            long l2 = a ^ 0xA78536F2E48L;
            if (key == null) {
                1.a(0);
            }
            b.debug("Searching for versions of package '" + key + "' in additional repositories");
            List<String> list2 = PyPackageService.getInstance().additionalRepositories;
            for (String string : list2) {
                try {
                    String string2 = StringUtil.trimEnd((String)string, (String)"/") + "/" + key;
                    List list3 = PyPIPackageUtil.c(string2, key);
                    if (list3.isEmpty()) continue;
                    b.debug("Found versions " + list3 + "of " + key + " at " + string);
                    return Collections.unmodifiableList(list3);
                }
                catch (HttpRequests.HttpStatusException httpStatusException) {
                    if (httpStatusException.getStatusCode() == 404) continue;
                    b.debug("Cannot access " + httpStatusException.getUrl() + ": " + httpStatusException.getMessage());
                }
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x1614C2F56D35L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$1", "load"));
        }
    });
    protected final LoadingCache<String, List<RepoPackage>> myAdditionalPackages = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<RepoPackage>>(){
        private static final long a = com.jetbrains.python.psi.c.a(3274170203283824700L, -9016620581515104609L, MethodHandles.lookup().lookupClass()).a(78945610407595L);

        public List<RepoPackage> load(@NotNull String key) throws Exception {
            if (key == null) {
                2.a(0);
            }
            return PyPIPackageUtil.c(key);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x2F4E1395A7BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$2", "load"));
        }
    });
    private final LoadingCache<String, PackageDetails> d = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PackageDetails>(){
        private static final long a = com.jetbrains.python.psi.c.a(1464395798267818128L, 2834137222921421366L, MethodHandles.lookup().lookupClass()).a(234140264983199L);

        public PackageDetails load(@NotNull String key) throws Exception {
            long l2 = a ^ 0xE1781E0EC2CL;
            if (key == null) {
                3.a(0);
            }
            b.debug("Fetching details for the package '" + key + "' on PyPI");
            return (PackageDetails)HttpRequests.request((String)("https://pypi.python.org/pypi/" + key + "/json")).userAgent(PyPIPackageUtil.b()).connect(request -> (PackageDetails)e.fromJson((Reader)request.getReader(), PackageDetails.class));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0xD3F29F02AB8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$3", "load"));
        }
    });
    private final Object c = new Object();
    private static final long g;

    @NotNull
    private static String b() {
        String string = ApplicationNamesInfo.getInstance().getProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
        if (string == null) {
            PyPIPackageUtil.a(0);
        }
        return string;
    }

    @NotNull
    private static ImmutableMap<String, List<String>> a() {
        long l2 = g ^ 0x7B7433B7ADB0L;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Files.lines(Paths.get(PythonHelpersLocator.getHelperPath("/tools/packages"), new String[0])).forEach(string -> {
                List list2 = StringUtil.split((String)string, (String)" ");
                builder.put(list2.get(0), (Object)new SmartList((Collection)ContainerUtil.subList((List)list2, (int)1)));
            });
        }
        catch (IOException iOException) {
            b.error("Cannot find \"packages\". " + iOException.getMessage());
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            PyPIPackageUtil.a(1);
        }
        return immutableMap;
    }

    public static boolean isPyPIRepository(@Nullable String repository) {
        long l2 = g ^ 0x2E89D477DC25L;
        return repository != null && repository.startsWith(a);
    }

    @NotNull
    public List<RepoPackage> getAdditionalPackages(@NotNull List<String> repositories) {
        if (repositories == null) {
            PyPIPackageUtil.a(2);
        }
        List list2 = StreamEx.of((Collection)this.myAdditionalPackages.getAllPresent(repositories).values()).flatMap(StreamEx::of).toList();
        if (list2 == null) {
            PyPIPackageUtil.a(3);
        }
        return list2;
    }

    public void loadAdditionalPackages(@NotNull List<String> repositories, boolean alwaysRefresh) throws IOException {
        if (repositories == null) {
            PyPIPackageUtil.a(4);
        }
        if (alwaysRefresh) {
            for (String string : repositories) {
                this.myAdditionalPackages.refresh((Object)string);
            }
        } else {
            for (String string : repositories) {
                PyPIPackageUtil.a(this.myAdditionalPackages, string);
            }
        }
    }

    @NotNull
    private static List<RepoPackage> c(@NotNull String string) throws IOException {
        if (string == null) {
            PyPIPackageUtil.a(5);
        }
        List<RepoPackage> list2 = PyPIPackageUtil.b(string).stream().map(string2 -> new RepoPackage(string2, string, null)).collect(Collectors.toList());
        if (list2 == null) {
            PyPIPackageUtil.a(6);
        }
        return list2;
    }

    public void fillPackageDetails(@NotNull String packageName, @NotNull CatchingConsumer<PackageDetails.Info, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.a(7);
        }
        if (callback == null) {
            PyPIPackageUtil.a(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                PackageDetails packageDetails = this.a(packageName, false);
                callback.consume((Object)packageDetails.getInfo());
            }
            catch (IOException iOException) {
                callback.consume((Throwable)iOException);
            }
        });
    }

    @NotNull
    private PackageDetails a(@NotNull String string, boolean bl2) throws IOException {
        if (string == null) {
            PyPIPackageUtil.a(9);
        }
        if (bl2) {
            this.d.invalidate((Object)string);
        }
        PackageDetails packageDetails = PyPIPackageUtil.a(this.d, string);
        if (packageDetails == null) {
            PyPIPackageUtil.a(10);
        }
        return packageDetails;
    }

    public void usePackageReleases(@NotNull String packageName, @NotNull CatchingConsumer<List<String>, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.a(11);
        }
        if (callback == null) {
            PyPIPackageUtil.a(12);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String> list2 = this.a(packageName);
                if (list2.isEmpty()) {
                    List<String> list3 = this.b(packageName, true);
                    callback.consume(list3);
                } else {
                    callback.consume(list2);
                }
            }
            catch (Exception exception) {
                callback.consume((Throwable)exception);
            }
        });
    }

    @NotNull
    private List<String> b(@NotNull String string, boolean bl2) throws IOException {
        if (string == null) {
            PyPIPackageUtil.a(13);
        }
        PackageDetails packageDetails = this.a(string, bl2);
        List<String> list2 = packageDetails.getReleases();
        list2.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
        List<String> list3 = Collections.unmodifiableList(list2);
        if (list3 == null) {
            PyPIPackageUtil.a(14);
        }
        return list3;
    }

    @Nullable
    private String b(@NotNull Project project, @NotNull String string) throws IOException {
        long l2 = g ^ 0x578156CD044FL;
        if (project == null) {
            PyPIPackageUtil.a(15);
        }
        if (string == null) {
            PyPIPackageUtil.a(16);
        }
        b.debug("Requesting the latest PyPI version for the package " + string);
        List<String> list2 = this.b(string, true);
        return PyPackagingSettings.getInstance(project).selectLatestVersion(list2);
    }

    @NotNull
    private List<String> a(@NotNull String string) throws IOException {
        if (string == null) {
            PyPIPackageUtil.a(17);
        }
        List<String> list2 = PyPIPackageUtil.a(this.f, string);
        if (list2 == null) {
            PyPIPackageUtil.a(18);
        }
        return list2;
    }

    @NotNull
    private static <T> T a(@NotNull LoadingCache<String, ? extends T> loadingCache, @NotNull String string) throws IOException {
        Object object;
        long l2 = g ^ 0x1E335AA29DD9L;
        if (loadingCache == null) {
            PyPIPackageUtil.a(19);
        }
        if (string == null) {
            PyPIPackageUtil.a(20);
        }
        try {
            object = loadingCache.get((Object)string);
        }
        catch (UncheckedExecutionException | ExecutionException throwable) {
            Throwable throwable2 = throwable.getCause();
            throw throwable2 instanceof IOException ? (IOException)throwable2 : new IOException("Unexpected non-IO error", throwable2);
        }
        if (object == null) {
            PyPIPackageUtil.a(21);
        }
        return (T)object;
    }

    @Nullable
    private String a(@NotNull Project project, @NotNull String string) throws IOException {
        if (project == null) {
            PyPIPackageUtil.a(22);
        }
        if (string == null) {
            PyPIPackageUtil.a(23);
        }
        List<String> list2 = this.a(string);
        return PyPackagingSettings.getInstance(project).selectLatestVersion(list2);
    }

    @Nullable
    public String fetchLatestPackageVersion(@NotNull Project project, @NotNull String packageName) throws IOException {
        String string;
        if (project == null) {
            PyPIPackageUtil.a(24);
        }
        if (packageName == null) {
            PyPIPackageUtil.a(25);
        }
        String string2 = null;
        if (PyPIPackageCache.getInstance().containsPackage(packageName)) {
            string2 = this.b(project, packageName);
        }
        if (!PyPackageService.getInstance().additionalRepositories.isEmpty() && (string = this.a(project, packageName)) != null) {
            string2 = string;
        }
        return string2;
    }

    @NotNull
    private static List<String> c(final @NotNull String string, final @NotNull String string2) throws IOException {
        if (string == null) {
            PyPIPackageUtil.a(26);
        }
        if (string2 == null) {
            PyPIPackageUtil.a(27);
        }
        List list2 = (List)HttpRequests.request((String)string).userAgent(PyPIPackageUtil.b()).connect(request -> {
            final ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = request.getReader();
            new ParserDelegator().parse(bufferedReader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;
                private static final long a = com.jetbrains.python.psi.c.a(5972087047470291999L, -9133551759570946341L, MethodHandles.lookup().lookupClass()).a(106303990775677L);

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i10) {
                    this.myTag = tag;
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    long l2 = a ^ 0x72A8C8C90646L;
                    if (data == null) {
                        4.a(0);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        String string3 = String.valueOf(data);
                        String string22 = PyPIPackageUtil.a(string3, string2);
                        if (string22 != null) {
                            arrayList.add(string22);
                        } else {
                            b.debug("Could not extract version from " + string3 + " at " + string);
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x68B5921B2A8FL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/packaging/PyPIPackageUtil$4", "handleText"));
                }
            }, true);
            arrayList.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
            return arrayList;
        });
        if (list2 == null) {
            PyPIPackageUtil.a(28);
        }
        return list2;
    }

    @Nullable
    private static String a(@NotNull String string, @NotNull String string2) {
        String string3;
        long l2 = g ^ 0x3D1E61C48ACEL;
        if (string == null) {
            PyPIPackageUtil.a(29);
        }
        if (string2 == null) {
            PyPIPackageUtil.a(30);
        }
        String string4 = string.endsWith(".tar.gz") ? StringUtil.trimEnd((String)string, (String)".tar.gz") : FileUtilRt.getNameWithoutExtension((String)string);
        String string5 = string2.replace('-', '_');
        if (string4.startsWith(string2)) {
            string3 = StringUtil.trimStart((String)string4, (String)string2);
        } else if (string4.startsWith(string5)) {
            string3 = StringUtil.trimStart((String)string4, (String)string5);
        } else {
            return null;
        }
        String string6 = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)string3, (String)"-"));
        if (StringUtil.isNotEmpty((String)string6)) {
            return string6;
        }
        return null;
    }

    public void updatePyPICache() throws IOException {
        long l2 = g ^ 0x100C63C9C554L;
        PyPackageService pyPackageService = PyPackageService.getInstance();
        if (pyPackageService.PYPI_REMOVED.booleanValue()) {
            return;
        }
        PyPIPackageCache.reload(PyPIPackageUtil.b(PYPI_LIST_URL));
        pyPackageService.LAST_TIME_CHECKED = System.currentTimeMillis();
    }

    @NotNull
    private static List<String> b(@NotNull String string) throws IOException {
        long l2 = g ^ 0x75F52179F724L;
        if (string == null) {
            PyPIPackageUtil.a(31);
        }
        b.debug("Fetching index of all packages available on " + string);
        List list2 = (List)HttpRequests.request((String)string).userAgent(PyPIPackageUtil.b()).connect(request -> {
            final ArrayList arrayList = new ArrayList();
            BufferedReader bufferedReader = request.getReader();
            new ParserDelegator().parse(bufferedReader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;
                private static final long a = com.jetbrains.python.psi.c.a(2710725924326414360L, 2698985318388452542L, MethodHandles.lookup().lookupClass()).a(264979375140143L);

                @Override
                public void handleStartTag(@NotNull HTML.Tag tag, @NotNull MutableAttributeSet set, int i10) {
                    if (tag == null) {
                        5.a(0);
                    }
                    if (set == null) {
                        5.a(1);
                    }
                    this.myTag = tag;
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    if (data == null) {
                        5.a(2);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        arrayList.add(String.valueOf(data));
                    }
                }

                @Override
                public void handleEndTag(@NotNull HTML.Tag t2, int pos) {
                    if (t2 == null) {
                        5.a(3);
                    }
                    this.myTag = null;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x4216DBADB843L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tag";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "set";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "t";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil$5";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleStartTag";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleText";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEndTag";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            return arrayList;
        });
        if (list2 == null) {
            PyPIPackageUtil.a(32);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPackages() throws IOException {
        Object object = this.c;
        synchronized (object) {
            PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
            if (pyPIPackageCache.getPackageNames().isEmpty()) {
                this.updatePyPICache();
            }
        }
    }

    public boolean isInPyPI(@NotNull String packageName) {
        if (packageName == null) {
            PyPIPackageUtil.a(33);
        }
        return PyPIPackageCache.getInstance().containsPackage(packageName);
    }

    static {
        g = com.jetbrains.python.psi.c.a(-6445537994484355262L, -7630398490718900156L, MethodHandles.lookup().lookupClass()).a(48932955946891L);
        b = Logger.getInstance(PyPIPackageUtil.class);
        e = new GsonBuilder().create();
        PACKAGES_TOPLEVEL = PyPIPackageUtil.a();
        INSTANCE = new PyPIPackageUtil();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x6EF3BF4E53F3L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivesUrl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPackageAliases";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromPyPI";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValueOrRethrowIO";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageVersionsFromArchives";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePyPIListFromWeb";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPackages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalPackages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillPackageDetails";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "usePackageReleases";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromPyPI";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromPyPI";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueOrRethrowIO";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromAdditionalRepositories";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestPackageVersion";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageVersionsFromArchives";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractVersionFromArtifactName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parsePyPIListFromWeb";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInPyPI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class PackageDetails {
        @SerializedName(value="info")
        private Info a = new Info();
        @SerializedName(value="releases")
        private Map<String, Object> b = Collections.emptyMap();
        private static final long c = com.jetbrains.python.psi.c.a(-7899665142879922772L, 8810009128719194970L, MethodHandles.lookup().lookupClass()).a(77450413272938L);

        @NotNull
        public Info getInfo() {
            Info info = this.a;
            if (info == null) {
                PackageDetails.a(0);
            }
            return info;
        }

        @NotNull
        public List<String> getReleases() {
            List list2 = EntryStream.of(this.b).filterValues(PackageDetails::a).keys().toList();
            if (list2 == null) {
                PackageDetails.a(1);
            }
            return list2;
        }

        private static boolean a(Object object) {
            return !(object instanceof List) || !((List)object).isEmpty();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x7561BFB7C684L;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReleases";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        public static final class Info {
            @SerializedName(value="version")
            private String a = "";
            @SerializedName(value="author")
            private String c = "";
            @SerializedName(value="author_email")
            private String e = "";
            @SerializedName(value="home_page")
            private String d = "";
            @SerializedName(value="summary")
            private String b = "";
            private static final long f = com.jetbrains.python.psi.c.a(-5503076399372759752L, 8262560743780100455L, MethodHandles.lookup().lookupClass()).a(209795440874385L);

            @NotNull
            public String getVersion() {
                String string = StringUtil.notNullize((String)this.a);
                if (string == null) {
                    Info.a(0);
                }
                return string;
            }

            @NotNull
            public String getAuthor() {
                String string = StringUtil.notNullize((String)this.c);
                if (string == null) {
                    Info.a(1);
                }
                return string;
            }

            @NotNull
            public String getAuthorEmail() {
                String string = StringUtil.notNullize((String)this.e);
                if (string == null) {
                    Info.a(2);
                }
                return string;
            }

            @NotNull
            public String getHomePage() {
                String string = StringUtil.notNullize((String)this.d);
                if (string == null) {
                    Info.a(3);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = StringUtil.notNullize((String)this.b);
                if (string == null) {
                    Info.a(4);
                }
                return string;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = f ^ 0x6B1AC7F45C8CL;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails$Info";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthorEmail";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHomePage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

