/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.patterns;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.patterns.PyElementPattern;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPatterns
extends PlatformPatterns {
    private static final int a = 10000;
    private static final long b = c.a(7906785351120806267L, 11265063263401290L, MethodHandles.lookup().lookupClass()).a(256286093284417L);

    public static PyElementPattern.Capture<PyLiteralExpression> pyLiteralExpression() {
        return new PyElementPattern.Capture<PyLiteralExpression>(new InitialPatternCondition<PyLiteralExpression>(PyLiteralExpression.class){

            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return o2 instanceof PyLiteralExpression;
            }
        });
    }

    public static PyElementPattern.Capture<PyStringLiteralExpression> pyStringLiteralMatches(String regexp) {
        final Pattern pattern = Pattern.compile(regexp, 34);
        return new PyElementPattern.Capture<PyStringLiteralExpression>(new InitialPatternCondition<PyStringLiteralExpression>(PyStringLiteralExpression.class){

            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                PyStringLiteralExpression pyStringLiteralExpression;
                if (o2 instanceof PyStringLiteralExpression && !DocStringUtil.isDocStringExpression(pyStringLiteralExpression = (PyStringLiteralExpression)o2) && pyStringLiteralExpression.getTextLength() < 10000) {
                    String string = pyStringLiteralExpression.getStringValue();
                    return pattern.matcher(string).find();
                }
                return false;
            }
        });
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyArgument(final @Nullable String functionName, final int index) {
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return PythonPatterns.b(o2, functionName, index);
            }
        });
        if (capture == null) {
            PythonPatterns.a(0);
        }
        return capture;
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyModuleFunctionArgument(final @Nullable String functionName, final int index, final @NotNull String moduleName) {
        if (moduleName == null) {
            PythonPatterns.a(1);
        }
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return StreamEx.of((Collection)PythonPatterns.a(o2, functionName, index)).select(PyFunction.class).map(ScopeUtil::getScopeOwner).select(PyFile.class).anyMatch(pyFile -> moduleName.equals(FileUtilRt.getNameWithoutExtension((String)pyFile.getName())));
            }
        });
        if (capture == null) {
            PythonPatterns.a(2);
        }
        return capture;
    }

    @NotNull
    public static PyElementPattern.Capture<PyExpression> pyMethodArgument(final @Nullable String functionName, final int index, final @NotNull String classQualifiedName) {
        if (classQualifiedName == null) {
            PythonPatterns.a(3);
        }
        PyElementPattern.Capture<PyExpression> capture = new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return StreamEx.of((Collection)PythonPatterns.a(o2, functionName, index)).select(PyFunction.class).map(ScopeUtil::getScopeOwner).select(PyClass.class).anyMatch(pyClass -> classQualifiedName.equals(pyClass.getQualifiedName()));
            }
        });
        if (capture == null) {
            PythonPatterns.a(4);
        }
        return capture;
    }

    @NotNull
    private static List<PyCallable> a(@Nullable Object object, @Nullable String string, int n2) {
        if (!PythonPatterns.b(object, string, n2)) {
            List<PyCallable> list2 = Collections.emptyList();
            if (list2 == null) {
                PythonPatterns.a(5);
            }
            return list2;
        }
        PyCallExpression pyCallExpression = (PyCallExpression)((PyExpression)object).getParent().getParent();
        PyResolveContext pyResolveContext = PyResolveContext.noImplicits().withTypeEvalContext(TypeEvalContext.codeAnalysis(pyCallExpression.getProject(), pyCallExpression.getContainingFile()));
        List<PyCallable> list3 = pyCallExpression.multiResolveCalleeFunction(pyResolveContext);
        if (list3 == null) {
            PythonPatterns.a(6);
        }
        return list3;
    }

    private static boolean b(@Nullable Object object, @Nullable String string, int n2) {
        if (!(object instanceof PyExpression)) {
            return false;
        }
        PsiElement psiElement = ((PyExpression)object).getParent();
        if (!(psiElement instanceof PyArgumentList)) {
            return false;
        }
        PsiElement psiElement2 = psiElement.getParent();
        if (!(psiElement2 instanceof PyCallExpression)) {
            return false;
        }
        PyExpression pyExpression = ((PyCallExpression)psiElement2).getCallee();
        if (!(pyExpression instanceof PyReferenceExpression)) {
            return false;
        }
        String string2 = ((PyReferenceExpression)pyExpression).getReferencedName();
        if (string2 == null || !string2.equals(string)) {
            return false;
        }
        PsiElement[] psiElementArray = psiElement.getChildren();
        return n2 < psiElementArray.length && object == psiElementArray[n2];
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x1D77D0FAE86BL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/patterns/PythonPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pyArgument";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/patterns/PythonPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pyModuleFunctionArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pyMethodArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalledFunction";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pyModuleFunctionArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pyMethodArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

