/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.PySdkUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteLibrariesNode
extends PsiDirectoryNode {
    private final Sdk a;
    private final PyRemoteSdkAdditionalDataBase b;
    private static final long c = com.jetbrains.python.psi.c.a(8214246076511986002L, -882544988184270076L, MethodHandles.lookup().lookupClass()).a(98231639592680L);

    private PyRemoteLibrariesNode(Sdk sdk, Project project, @NotNull PsiDirectory value, ViewSettings viewSettings) {
        if (value == null) {
            PyRemoteLibrariesNode.a(0);
        }
        super(project, value, viewSettings);
        this.a = sdk;
        assert (this.a.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase);
        this.b = (PyRemoteSdkAdditionalDataBase)this.a.getSdkAdditionalData();
    }

    protected void updateImpl(@NotNull PresentationData data) {
        long l2 = c ^ 0x3252369FA7C2L;
        if (data == null) {
            PyRemoteLibrariesNode.a(1);
        }
        data.setPresentableText("Remote Libraries");
        data.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Nullable
    public static PyRemoteLibrariesNode create(@NotNull Project project, @NotNull Sdk sdk, ViewSettings settings) {
        if (project == null) {
            PyRemoteLibrariesNode.a(2);
        }
        if (sdk == null) {
            PyRemoteLibrariesNode.a(3);
        }
        if (sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            VirtualFile virtualFile = PySdkUtil.findAnyRemoteLibrary(sdk);
            if (virtualFile != null && virtualFile.getFileType() instanceof ArchiveFileType) {
                virtualFile = JarFileSystem.getInstance().getLocalByEntry(virtualFile);
            }
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile.getParent();
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFile2);
                if (psiDirectory != null) {
                    return new PyRemoteLibrariesNode(sdk, project, psiDirectory, settings);
                }
            }
        }
        return null;
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])((PsiDirectory)this.getValue()).getChildren())).transform(psiElement -> {
            if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory psiDirectory;
                String string = ((PsiFileSystemItem)psiElement).getVirtualFile().getPath();
                PsiDirectory psiDirectory2 = psiDirectory = psiElement instanceof PsiDirectory ? (PsiDirectory)psiElement : this.a((PsiFile)psiElement);
                if (this.b.getPathMappings().canReplaceLocal(string) && psiDirectory != null) {
                    return new PyRemoteRootNode(this.b.getPathMappings().convertToRemote(string), this.getProject(), psiDirectory, this.getSettings());
                }
            }
            return null;
        }).filter(Predicates.notNull()).toList();
    }

    @Nullable
    private PsiDirectory a(PsiFile psiFile) {
        VirtualFile virtualFile = PyRemoteLibrariesNode.b(psiFile);
        if (this.myProject != null && virtualFile != null) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    @Nullable
    private static VirtualFile b(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid() || !(virtualFile.getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        return JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x40A21C5B389CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/projectView/PyRemoteLibrariesNode";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PyRemoteRootNode
    extends PsiDirectoryNode {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(4181233445644737635L, -4388272837761270599L, MethodHandles.lookup().lookupClass()).a(36990501685601L);

        public PyRemoteRootNode(String remotePath, Project project, @NotNull PsiDirectory value, ViewSettings viewSettings) {
            if (value == null) {
                PyRemoteRootNode.a(0);
            }
            super(project, value, viewSettings);
            this.a = remotePath;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            if (data == null) {
                PyRemoteRootNode.a(1);
            }
            data.setPresentableText(this.a);
            data.setIcon(PlatformIcons.FOLDER_ICON);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0xBEE8B8B5D4AL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/projectView/PyRemoteLibrariesNode$PyRemoteRootNode";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

