/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Iterables;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIndentUtil {
    @NonNls
    public static final String TWO_SPACES = "  ";
    @NonNls
    public static final String FOUR_SPACES = "    ";
    private static final long a = c.a(8020282433142043843L, 5548729730616770706L, MethodHandles.lookup().lookupClass()).a(125140749715861L);

    private PyIndentUtil() {
    }

    public static int getLineIndentSize(@NotNull CharSequence line2) {
        char c10;
        int n2;
        if (line2 == null) {
            PyIndentUtil.a(0);
        }
        for (n2 = 0; n2 < line2.length() && ((c10 = line2.charAt(n2)) == ' ' || c10 == '\t'); ++n2) {
        }
        return n2;
    }

    @NotNull
    public static String getLineIndent(@NotNull String line2) {
        if (line2 == null) {
            PyIndentUtil.a(1);
        }
        String string = line2.substring(0, PyIndentUtil.getLineIndentSize(line2));
        if (string == null) {
            PyIndentUtil.a(2);
        }
        return string;
    }

    @NotNull
    public static CharSequence getLineIndent(@NotNull CharSequence line2) {
        if (line2 == null) {
            PyIndentUtil.a(3);
        }
        CharSequence charSequence = line2.subSequence(0, PyIndentUtil.getLineIndentSize(line2));
        if (charSequence == null) {
            PyIndentUtil.a(4);
        }
        return charSequence;
    }

    @NotNull
    public static String getElementIndent(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyIndentUtil.a(5);
        }
        if (anchor instanceof PsiFile) {
            if ("" == null) {
                PyIndentUtil.a(6);
            }
            return "";
        }
        PyStatementList pyStatementList = PyIndentUtil.a(anchor);
        if (pyStatementList == null) {
            if ("" == null) {
                PyIndentUtil.a(7);
            }
            return "";
        }
        PsiElement psiElement = pyStatementList.getPrevSibling();
        String string = psiElement instanceof PsiWhiteSpace ? psiElement.getText() : "";
        int n2 = string.lastIndexOf("\n");
        if (n2 >= 0 && pyStatementList.getStatements().length != 0) {
            String string2 = string.substring(n2 + 1);
            if (string2 == null) {
                PyIndentUtil.a(8);
            }
            return string2;
        }
        String string3 = PyIndentUtil.a(pyStatementList);
        if (string3 == null) {
            PyIndentUtil.a(9);
        }
        return string3;
    }

    @NotNull
    private static String a(@NotNull PyStatementList pyStatementList) {
        if (pyStatementList == null) {
            PyIndentUtil.a(10);
        }
        String string = PyIndentUtil.getIndentFromSettings(pyStatementList.getContainingFile());
        PyStatementList pyStatementList2 = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)pyStatementList, PyStatementList.class, (boolean)true);
        if (pyStatementList2 != null) {
            String string2 = PyIndentUtil.getElementIndent((PsiElement)pyStatementList2) + string;
            if (string2 == null) {
                PyIndentUtil.a(11);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            PyIndentUtil.a(12);
        }
        return string3;
    }

    @Nullable
    private static PyStatementList a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PyIndentUtil.a(13);
        }
        PyStatementList pyStatementList = null;
        if (psiElement instanceof PsiWhiteSpace) {
            pyStatementList = PyUtil.as(psiElement.getNextSibling(), PyStatementList.class);
        }
        if (pyStatementList == null) {
            pyStatementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyStatementList.class, (boolean)false);
        }
        return pyStatementList;
    }

    public static boolean areTabsUsedForIndentation(@NotNull PsiFile file) {
        if (file == null) {
            PyIndentUtil.a(14);
        }
        return CodeStyle.getIndentOptions((PsiFile)file).USE_TAB_CHARACTER;
    }

    public static int getIndentSizeFromSettings(@NotNull PsiFile file) {
        if (file == null) {
            PyIndentUtil.a(15);
        }
        return CodeStyle.getIndentSize((PsiFile)file);
    }

    @NotNull
    public static String getIndentFromSettings(@NotNull PsiFile file) {
        boolean bl2;
        if (file == null) {
            PyIndentUtil.a(16);
        }
        String string = (bl2 = PyIndentUtil.areTabsUsedForIndentation(file)) ? "\t" : StringUtil.repeatSymbol((char)' ', (int)PyIndentUtil.getIndentSizeFromSettings(file));
        if (string == null) {
            PyIndentUtil.a(17);
        }
        return string;
    }

    @NotNull
    public static List<String> removeCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.a(18);
        }
        List<String> list2 = PyIndentUtil.changeIndent(lines, ignoreFirstLine, "");
        if (list2 == null) {
            PyIndentUtil.a(19);
        }
        return list2;
    }

    @NotNull
    public static String removeCommonIndent(@NotNull String s2, boolean ignoreFirstLine) {
        if (s2 == null) {
            PyIndentUtil.a(20);
        }
        List<String> list2 = PyIndentUtil.removeCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s2, (boolean)false, (boolean)false), ignoreFirstLine);
        String string = StringUtil.join(list2, (String)"\n");
        if (string == null) {
            PyIndentUtil.a(21);
        }
        return string;
    }

    @NotNull
    public static String changeIndent(@NotNull String s2, boolean ignoreFirstLine, String newIndent) {
        if (s2 == null) {
            PyIndentUtil.a(22);
        }
        List<String> list2 = PyIndentUtil.changeIndent(LineTokenizer.tokenizeIntoList((CharSequence)s2, (boolean)false, (boolean)false), ignoreFirstLine, newIndent);
        String string = StringUtil.join(list2, (String)"\n");
        if (string == null) {
            PyIndentUtil.a(23);
        }
        return string;
    }

    @NotNull
    public static List<String> changeIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine, String newIndent) {
        if (lines == null) {
            PyIndentUtil.a(24);
        }
        String string = PyIndentUtil.findCommonIndent(lines, ignoreFirstLine);
        if (Iterables.isEmpty(lines)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PyIndentUtil.a(25);
            }
            return list2;
        }
        List list3 = ContainerUtil.map((Iterable)Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0)), string3 -> {
            if (StringUtil.isEmptyOrSpaces((String)string3)) {
                return "";
            }
            return newIndent + string3.substring(string.length());
        });
        if (ignoreFirstLine) {
            List list4 = ContainerUtil.prepend((List)list3, (Object[])new String[]{(String)Iterables.get(lines, (int)0)});
            if (list4 == null) {
                PyIndentUtil.a(26);
            }
            return list4;
        }
        List list5 = list3;
        if (list5 == null) {
            PyIndentUtil.a(27);
        }
        return list5;
    }

    @NotNull
    public static String findCommonIndent(@NotNull String s2, boolean ignoreFirstLine) {
        if (s2 == null) {
            PyIndentUtil.a(28);
        }
        String string = PyIndentUtil.findCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s2, (boolean)false, (boolean)false), ignoreFirstLine);
        if (string == null) {
            PyIndentUtil.a(29);
        }
        return string;
    }

    @NotNull
    public static String findCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.a(30);
        }
        String string = null;
        boolean bl2 = true;
        if (Iterables.isEmpty(lines)) {
            if ("" == null) {
                PyIndentUtil.a(31);
            }
            return "";
        }
        boolean bl3 = false;
        for (String string2 : Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0))) {
            boolean bl4 = StringUtil.isEmptyOrSpaces((String)string2);
            if (bl4 && !bl2) continue;
            String string3 = PyIndentUtil.getLineIndent(string2);
            if (string == null || !bl4 && bl2 || string.startsWith(string3)) {
                string = string3;
            } else if (!string3.startsWith(string)) {
                if (bl4) {
                    bl3 = true;
                } else {
                    if ("" == null) {
                        PyIndentUtil.a(32);
                    }
                    return "";
                }
            }
            bl2 &= bl4;
        }
        if (bl2 && bl3) {
            if ("" == null) {
                PyIndentUtil.a(33);
            }
            return "";
        }
        String string4 = StringUtil.notNullize(string);
        if (string4 == null) {
            PyIndentUtil.a(34);
        }
        return string4;
    }

    @NotNull
    public static String getLineIndent(@NotNull Document document, int lineNumber) {
        if (document == null) {
            PyIndentUtil.a(35);
        }
        TextRange textRange = TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber));
        String string = document.getText(textRange);
        String string2 = PyIndentUtil.getLineIndent(string);
        if (string2 == null) {
            PyIndentUtil.a(36);
        }
        return string2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1195F27A231EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 20: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 2: 
            case 4: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIndent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedBlockIndent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentFromSettings";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonIndent";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonIndent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndentSize";
                break;
            }
            case 1: 
            case 3: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedBlockIndent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorStatementList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areTabsUsedForIndentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSizeFromSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndentFromSettings";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonIndent";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findCommonIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

