/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBuiltinCache {
    public static final String BUILTIN_FILE = "__builtin__.py";
    public static final String BUILTIN_FILE_3K = "builtins.py";
    private static final String e = "exceptions.py";
    private static final PyBuiltinCache f;
    @NotNull
    private final Map<String, PyClassTypeImpl> c = new HashMap<String, PyClassTypeImpl>();
    @Nullable
    private PyFile b;
    @Nullable
    private PyFile a;
    private long d = -1L;
    private static final long g;

    public PyBuiltinCache() {
    }

    public PyBuiltinCache(@Nullable PyFile builtins, @Nullable PyFile exceptions) {
        this.b = builtins;
        this.a = exceptions;
    }

    @NotNull
    public static PyBuiltinCache getInstance(@Nullable PsiElement reference) {
        block5: {
            if (reference != null) {
                PyBuiltinCache pyBuiltinCache;
                try {
                    Sdk sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)reference.getContainingFile());
                    if (sdk == null) break block5;
                    pyBuiltinCache = PythonSdkPathCache.getInstance(reference.getProject(), sdk).getBuiltins();
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
                if (pyBuiltinCache == null) {
                    PyBuiltinCache.a(0);
                }
                return pyBuiltinCache;
            }
        }
        PyBuiltinCache pyBuiltinCache = f;
        if (pyBuiltinCache == null) {
            PyBuiltinCache.a(1);
        }
        return pyBuiltinCache;
    }

    @Nullable
    public static Sdk findSdkForFile(PsiFileSystemItem psifile) {
        if (psifile == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psifile);
        if (module2 != null) {
            return PythonSdkType.findPythonSdk(module2);
        }
        return PyBuiltinCache.findSdkForNonModuleFile(psifile);
    }

    @Nullable
    public static Sdk findSdkForNonModuleFile(@NotNull PsiFileSystemItem psiFile) {
        ProjectRootManager projectRootManager;
        PsiFile psiFile2;
        if (psiFile == null) {
            PyBuiltinCache.a(2);
        }
        VirtualFile virtualFile = psiFile instanceof PsiFile ? ((psiFile2 = FileContextUtil.getContextFile((PsiElement)psiFile)) != null ? psiFile2.getOriginalFile().getVirtualFile() : null) : psiFile.getVirtualFile();
        psiFile2 = null;
        if (virtualFile != null && (psiFile2 = (projectRootManager = ProjectRootManager.getInstance((Project)psiFile.getProject())).getProjectSdk()) == null) {
            List list2 = projectRootManager.getFileIndex().getOrderEntriesForFile(virtualFile);
            for (OrderEntry orderEntry : list2) {
                if (orderEntry instanceof JdkOrderEntry) {
                    psiFile2 = ((JdkOrderEntry)orderEntry).getJdk();
                    continue;
                }
                if (!OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                psiFile2 = PythonSdkType.findPythonSdk(orderEntry.getOwnerModule());
            }
        }
        return psiFile2;
    }

    @Nullable
    public static PyFile getBuiltinsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyBuiltinCache.a(3);
        }
        if (sdk == null) {
            PyBuiltinCache.a(4);
        }
        return PyBuiltinCache.a(project, sdk, PythonSdkType.getBuiltinsFileName(sdk));
    }

    @Nullable
    public static PyFile getExceptionsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        long l2 = g ^ 0x2D018048B651L;
        if (project == null) {
            PyBuiltinCache.a(5);
        }
        if (sdk == null) {
            PyBuiltinCache.a(6);
        }
        return PyBuiltinCache.a(project, sdk, e);
    }

    @Nullable
    private static PyFile a(@NotNull Project project, @NotNull Sdk sdk, @NotNull String string) {
        SdkTypeId sdkTypeId;
        if (project == null) {
            PyBuiltinCache.a(7);
        }
        if (sdk == null) {
            PyBuiltinCache.a(8);
        }
        if (string == null) {
            PyBuiltinCache.a(9);
        }
        if ((sdkTypeId = sdk.getSdkType()) instanceof PythonSdkType) {
            int n2 = string.indexOf(".");
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            List<PsiElement> list2 = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromComponents((String[])new String[]{string}), PyResolveImportUtil.fromSdk(project, sdk));
            return PyUtil.as(ContainerUtil.getFirstItem(list2), PyFile.class);
        }
        return null;
    }

    @Nullable
    public PyType createLiteralCollectionType(PySequenceExpression sequence, String name, @NotNull TypeEvalContext context) {
        PyClass pyClass;
        if (context == null) {
            PyBuiltinCache.a(10);
        }
        if ((pyClass = this.getClass(name)) != null) {
            return new PyCollectionTypeImpl(pyClass, false, PyCollectionTypeUtil.INSTANCE.getTypeByModifications(sequence, context));
        }
        return null;
    }

    @Nullable
    public PyFile getBuiltinsFile() {
        return this.b;
    }

    public boolean isValid() {
        return this.b != null && this.b.isValid();
    }

    @Nullable
    public PsiElement getByName(@NonNls String name) {
        PsiElement psiElement;
        if (this.b != null && (psiElement = this.b.getElementNamed(name)) != null) {
            return psiElement;
        }
        if (this.a != null) {
            return this.a.getElementNamed(name);
        }
        return null;
    }

    @Nullable
    public PyClass getClass(@NonNls String name) {
        if (this.b != null) {
            return this.b.findTopLevelClass(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PyClassTypeImpl getObjectType(@NonNls String name) {
        PyClassTypeImpl pyClassTypeImpl;
        Object object = this.c;
        synchronized (object) {
            if (this.b != null && this.b.getModificationStamp() != this.d) {
                this.c.clear();
                this.d = this.b.getModificationStamp();
            }
            pyClassTypeImpl = this.c.get(name);
        }
        if (pyClassTypeImpl == null) {
            object = this.getClass(name);
            if (object != null) {
                pyClassTypeImpl = new PyClassTypeImpl((PyClass)object, false);
                pyClassTypeImpl.assertValid(name);
                Map<String, PyClassTypeImpl> map2 = this.c;
                synchronized (map2) {
                    this.c.put(name, pyClassTypeImpl);
                }
            }
        } else {
            pyClassTypeImpl.assertValid(name);
        }
        return pyClassTypeImpl;
    }

    @Nullable
    public PyClassType getObjectType() {
        long l2 = g ^ 0x4DF201902895L;
        return this.getObjectType("object");
    }

    @Nullable
    public PyClassType getListType() {
        long l2 = g ^ 0x59D167705F7CL;
        return this.getObjectType("list");
    }

    @Nullable
    public PyClassType getDictType() {
        long l2 = g ^ 0x3D5C16956F16L;
        return this.getObjectType("dict");
    }

    @Nullable
    public PyClassType getSetType() {
        long l2 = g ^ 0x2226E3571D8CL;
        return this.getObjectType("set");
    }

    @Nullable
    public PyClassType getTupleType() {
        long l2 = g ^ 0x78A9B818A4B7L;
        return this.getObjectType("tuple");
    }

    @Nullable
    public PyClassType getIntType() {
        long l2 = g ^ 0x611913FE5C07L;
        return this.getObjectType("int");
    }

    @Nullable
    public PyClassType getFloatType() {
        long l2 = g ^ 0x7EF23F11F2ABL;
        return this.getObjectType("float");
    }

    @Nullable
    public PyClassType getComplexType() {
        long l2 = g ^ 0x6DDA511D2FD4L;
        return this.getObjectType("complex");
    }

    @Nullable
    public PyClassType getStrType() {
        long l2 = g ^ 0x377165BCC20DL;
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getBytesType(LanguageLevel level) {
        long l2 = g ^ 0x1B2F60C4676CL;
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getUnicodeType(LanguageLevel level) {
        long l2 = g ^ 0x3E03925D84FFL;
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getObjectType("unicode");
    }

    @Nullable
    public PyType getStringType(LanguageLevel level) {
        long l2 = g ^ 0x50E0C86955DAL;
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getByteStringType(@NotNull LanguageLevel level) {
        long l2 = g ^ 0x60C330276F52L;
        if (level == null) {
            PyBuiltinCache.a(11);
        }
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getStrOrUnicodeType() {
        return this.getStrOrUnicodeType(false);
    }

    @Nullable
    public PyType getStrOrUnicodeType(boolean definition) {
        long l2 = g ^ 0x2A45348D2777L;
        PyClassLikeType pyClassLikeType = this.getObjectType("str");
        PyClassLikeType pyClassLikeType2 = this.getObjectType("unicode");
        if (pyClassLikeType != null && pyClassLikeType.isDefinition() ^ definition) {
            PyClassLikeType pyClassLikeType3 = pyClassLikeType = definition ? (PyClassLikeType)pyClassLikeType.toClass() : (PyClassLikeType)pyClassLikeType.toInstance();
        }
        if (pyClassLikeType2 != null && pyClassLikeType2.isDefinition() ^ definition) {
            pyClassLikeType2 = definition ? (PyClassLikeType)pyClassLikeType2.toClass() : (PyClassLikeType)pyClassLikeType2.toInstance();
        }
        return PyUnionType.union(pyClassLikeType, pyClassLikeType2);
    }

    @Nullable
    public PyClassType getBoolType() {
        long l2 = g ^ 0x777EBEE4EB9AL;
        return this.getObjectType("bool");
    }

    @Nullable
    public PyClassType getClassMethodType() {
        long l2 = g ^ 0x3DA68BB4511CL;
        return this.getObjectType("classmethod");
    }

    @Nullable
    public PyClassType getStaticMethodType() {
        long l2 = g ^ 0x22D86C0647D4L;
        return this.getObjectType("staticmethod");
    }

    @Nullable
    public PyClassType getTypeType() {
        long l2 = g ^ 0x6BCDF37B4380L;
        return this.getObjectType("type");
    }

    public boolean isBuiltin(@Nullable PsiElement target) {
        if (target == null) {
            return false;
        }
        PyPsiUtils.assertValid(target);
        if (!target.isValid()) {
            return false;
        }
        PsiFile psiFile = target.getContainingFile();
        if (!(psiFile instanceof PyFile)) {
            return false;
        }
        return psiFile == this.b || psiFile == this.a;
    }

    public static boolean isInBuiltins(@NotNull PyExpression expression) {
        PsiElement psiElement;
        PyBuiltinCache pyBuiltinCache;
        if (expression == null) {
            PyBuiltinCache.a(12);
        }
        if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified()) {
            return false;
        }
        String string = expression.getName();
        PsiReference psiReference = expression.getReference();
        return psiReference != null && string != null && (pyBuiltinCache = PyBuiltinCache.getInstance((PsiElement)expression)).getByName(string) != null && (psiElement = psiReference.resolve()) != null && pyBuiltinCache.isBuiltin(psiElement);
    }

    static {
        g = com.jetbrains.python.psi.c.a(3526759758814895448L, -3934736656592871894L, MethodHandles.lookup().lookupClass()).a(257237547330919L);
        f = new PyBuiltinCache(null, null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x6B602CD9C232L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForNonModuleFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsForSdk";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsForSdk";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralCollectionType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getByteStringType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInBuiltins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

