/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNumericLiteralExpressionImpl
extends PyElementImpl
implements PyNumericLiteralExpression {
    private static final long a = c.a(3212356228990018807L, 586417838645492402L, MethodHandles.lookup().lookupClass()).a(126160471394727L);

    public PyNumericLiteralExpressionImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PyNumericLiteralExpressionImpl.a(0);
        }
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNumericLiteralExpression(this);
    }

    @Override
    @Nullable
    public Long getLongValue() {
        BigInteger bigInteger = this.getBigIntegerValue();
        return Optional.ofNullable(bigInteger).map(BigInteger::longValue).filter(l2 -> BigInteger.valueOf(l2).equals(bigInteger)).orElse(null);
    }

    @Override
    @Nullable
    public BigInteger getBigIntegerValue() {
        if (this.isIntegerLiteral()) {
            return PyNumericLiteralExpressionImpl.a(this.getNode().getText());
        }
        BigDecimal bigDecimal = this.getBigDecimalValue();
        return bigDecimal == null ? null : bigDecimal.toBigInteger();
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalValue() {
        String string = this.getNode().getText();
        if (this.isIntegerLiteral()) {
            return Optional.ofNullable(PyNumericLiteralExpressionImpl.a(string)).map(BigDecimal::new).orElse(null);
        }
        return new BigDecimal(PyNumericLiteralExpressionImpl.a(string, 0));
    }

    @Override
    public boolean isIntegerLiteral() {
        return this.getNode().getElementType() == PyElementTypes.INTEGER_LITERAL_EXPRESSION;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyNumericLiteralExpressionImpl.a(1);
        }
        if (key == null) {
            PyNumericLiteralExpressionImpl.a(2);
        }
        if (this.isIntegerLiteral()) {
            return PyBuiltinCache.getInstance((PsiElement)this).getIntType();
        }
        IElementType iElementType = this.getNode().getElementType();
        if (iElementType == PyElementTypes.FLOAT_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance((PsiElement)this).getFloatType();
        }
        if (iElementType == PyElementTypes.IMAGINARY_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance((PsiElement)this).getComplexType();
        }
        return null;
    }

    @Nullable
    private static BigInteger a(@NotNull String string) {
        int n2;
        int n3;
        long l2 = a ^ 0x5CA7C4A41DBCL;
        if (string == null) {
            PyNumericLiteralExpressionImpl.a(3);
        }
        if (string.equals("0") || string.equalsIgnoreCase("0l")) {
            return BigInteger.ZERO;
        }
        if (StringUtil.startsWithIgnoreCase((String)string, (String)"0x")) {
            n3 = 2;
            n2 = 16;
        } else if (StringUtil.startsWithIgnoreCase((String)string, (String)"0b")) {
            n3 = 2;
            n2 = 2;
        } else if (string.startsWith("0")) {
            if (StringUtil.isChar((CharSequence)string, (int)1, (char)'o') || StringUtil.isChar((CharSequence)string, (int)1, (char)'O')) {
                n3 = 2;
                n2 = 8;
            } else {
                n3 = 1;
                n2 = 8;
            }
        } else {
            n3 = 0;
            n2 = 10;
        }
        return new BigInteger(PyNumericLiteralExpressionImpl.a(string, n3), n2);
    }

    @NotNull
    private static String a(@NotNull String string, int n2) {
        if (string == null) {
            PyNumericLiteralExpressionImpl.a(4);
        }
        int n3 = StringUtil.endsWithIgnoreCase((String)string, (String)"l") || StringUtil.endsWithIgnoreCase((String)string, (String)"j") ? string.length() - 1 : string.length();
        String string2 = string.substring(n2, n3).replaceAll("_", "");
        if (string2 == null) {
            PyNumericLiteralExpressionImpl.a(5);
        }
        return string2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x2EC8CF0E4F5FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLiteralForJava";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBigIntegerValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareLiteralForJava";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

