/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    public static final Key<LanguageLevel> PYTHON_LANGUAGE_LEVEL;
    public static final Map<LanguageLevel, LanguageLevel> COMPATIBLE_LEVELS;
    private final Map<Module, Sdk> b = ContainerUtil.createWeakMap();
    private static final FileAttribute a;
    private static final long c;

    private static void a(Map<LanguageLevel, LanguageLevel> map2, LanguageLevel languageLevel, LanguageLevel languageLevel2) {
        map2.put(languageLevel, languageLevel2);
        map2.put(languageLevel2, languageLevel);
    }

    public static void pushLanguageLevel(Project project) {
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new PythonLanguageLevelPusher()});
    }

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus) {
        if (project == null) {
            PythonLanguageLevelPusher.a(0);
        }
        if (bus == null) {
            PythonLanguageLevelPusher.a(1);
        }
        Map<Module, Sdk> map2 = PythonLanguageLevelPusher.b(project);
        Set set = (Set)StreamEx.ofValues(map2).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        this.b.putAll(map2);
        PyUtil.invalidateLanguageLevelCache(project);
        this.a(project, set);
        project.putUserData(PYTHON_LANGUAGE_LEVEL, (Object)PyUtil.guessLanguageLevel(project));
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key<LanguageLevel> key = LanguageLevel.KEY;
        if (key == null) {
            PythonLanguageLevelPusher.a(2);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonLanguageLevelPusher.a(3);
        }
        return languageLevel;
    }

    @Nullable
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.a(4);
        }
        return PythonLanguageLevelPusher.getFileLanguageLevel(project, file);
    }

    @Nullable
    public static LanguageLevel getFileLanguageLevel(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.a(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            return LanguageLevel.FORCE_LANGUAGE_LEVEL;
        }
        if (file == null) {
            return null;
        }
        Sdk sdk = PythonLanguageLevelPusher.a(project, file);
        if (sdk != null) {
            return PythonSdkType.getLanguageLevelForSdk(sdk);
        }
        return PyUtil.guessLanguageLevelWithCaching(project);
    }

    @Nullable
    private static Sdk a(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Module module2;
        if (project == null) {
            PythonLanguageLevelPusher.a(6);
        }
        if (virtualFile == null) {
            PythonLanguageLevelPusher.a(7);
        }
        if ((module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project)) != null) {
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk != null) {
                return sdk;
            }
            return null;
        }
        return PythonLanguageLevelPusher.b(project, virtualFile);
    }

    @Nullable
    private static Sdk b(Project project, VirtualFile virtualFile) {
        if (virtualFile != null) {
            List list2 = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
            for (OrderEntry orderEntry : list2) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @NotNull
    public LanguageLevel getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            PythonLanguageLevelPusher.a(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            LanguageLevel languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.a(9);
            }
            return languageLevel;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonLanguageLevelPusher.a(10);
        }
        return languageLevel;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            PythonLanguageLevelPusher.a(11);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.a(12);
        }
        if (project == null) {
            PythonLanguageLevelPusher.a(13);
        }
        return true;
    }

    private static boolean a(LanguageLevel languageLevel, LanguageLevel languageLevel2) {
        return languageLevel != null && languageLevel2 != null && COMPATIBLE_LEVELS.get((Object)languageLevel) == languageLevel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project == null) {
            PythonLanguageLevelPusher.a(14);
        }
        if (fileOrDir == null) {
            PythonLanguageLevelPusher.a(15);
        }
        if (level == null) {
            PythonLanguageLevelPusher.a(16);
        }
        DataInputStream dataInputStream = a.readAttribute(fileOrDir);
        LanguageLevel languageLevel2 = null;
        if (dataInputStream != null) {
            try {
                int n2 = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (n2 == level.ordinal()) {
                    return;
                }
                languageLevel2 = Arrays.stream(LanguageLevel.values()).filter(languageLevel -> languageLevel.ordinal() == n2).findFirst().orElse(null);
            }
            finally {
                dataInputStream.close();
            }
        }
        try (VirtualFile[] virtualFileArray = a.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)virtualFileArray, (int)level.ordinal());
        }
        if (!PythonLanguageLevelPusher.a(languageLevel2, level) || !ProjectFileIndex.getInstance((Project)project).isInContent(fileOrDir)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, PythonLanguageLevelPusher::b);
        }
        for (VirtualFile virtualFile : fileOrDir.getChildren()) {
            if (virtualFile.isDirectory() || !PythonLanguageLevelPusher.b(virtualFile)) continue;
            PythonLanguageLevelPusher.a(virtualFile);
        }
    }

    private static boolean b(VirtualFile virtualFile) {
        return ((Object)((Object)PythonFileType.INSTANCE)).equals(FileTypeRegistry.getInstance().getFileTypeByFileName(virtualFile.getNameSequence()));
    }

    private static void a(@NotNull VirtualFile virtualFile) {
        Project[] projectArray;
        if (virtualFile == null) {
            PythonLanguageLevelPusher.a(17);
        }
        for (Project project : projectArray = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.a(project, virtualFile);
            if (sdk == null) continue;
            PythonSdkPathCache pythonSdkPathCache = PythonSdkPathCache.getInstance(project, sdk);
            pythonSdkPathCache.clearCache();
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.a(18);
        }
        Map<Module, Sdk> map2 = PythonLanguageLevelPusher.b(project);
        Set set = (Set)StreamEx.ofValues(map2).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        boolean bl2 = StreamEx.of(map2.entrySet()).anyMatch(entry -> {
            Module module2 = (Module)entry.getKey();
            Sdk sdk = (Sdk)entry.getValue();
            Sdk sdk2 = this.b.get(module2);
            return this.b.containsKey(module2) && sdk != sdk2;
        });
        this.b.putAll(map2);
        PyUtil.invalidateLanguageLevelCache(project);
        this.a(project, set);
        if (bl2) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project.isDisposed()) {
                    return;
                }
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            });
        }
    }

    @NotNull
    private static Map<Module, Sdk> b(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.a(19);
        }
        LinkedHashMap<Module, Sdk> linkedHashMap = new LinkedHashMap<Module, Sdk>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PythonLanguageLevelPusher.a(module2)) continue;
            linkedHashMap.put(module2, PythonSdkType.findPythonSdk(module2));
        }
        LinkedHashMap<Module, Sdk> linkedHashMap2 = linkedHashMap;
        if (linkedHashMap2 == null) {
            PythonLanguageLevelPusher.a(20);
        }
        return linkedHashMap2;
    }

    private static boolean a(@NotNull Module module2) {
        Facet[] facetArray;
        ModuleType moduleType;
        if (module2 == null) {
            PythonLanguageLevelPusher.a(21);
        }
        if ((moduleType = ModuleType.get((Module)module2)) instanceof PythonModuleTypeBase) {
            return true;
        }
        for (Facet facet : facetArray = FacetManager.getInstance((Module)module2).getAllFacets()) {
            if (!(facet.getConfiguration() instanceof PythonFacetSettings)) continue;
            return true;
        }
        return false;
    }

    private void a(final @NotNull Project project, final @NotNull Set<Sdk> set) {
        if (project == null) {
            PythonLanguageLevelPusher.a(22);
        }
        if (set == null) {
            PythonLanguageLevelPusher.a(23);
        }
        if (set.isEmpty()) {
            return;
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        final DumbModeTask dumbModeTask = new DumbModeTask(){
            private static final long a = com.jetbrains.python.psi.c.a(-5175928910670067092L, 2648235407466273960L, MethodHandles.lookup().lookupClass()).a(157503200262369L);

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x40C0741A48D9L;
                if (indicator == null) {
                    1.a(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                List list2 = (List)ReadAction.compute(() -> PythonLanguageLevelPusher.this.b(project, set));
                PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible((List)list2);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    snapshot.logResponsivenessSinceCreation("Pushing Python language level to " + list2.size() + " roots in " + set.size() + " SDKs");
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2A7FADA1E76CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$1", "performInDumbMode"));
            }
        };
        project.getMessageBus().connect((Disposable)dumbModeTask).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private static final long a = com.jetbrains.python.psi.c.a(8533185977326058952L, 8082154602124886297L, MethodHandles.lookup().lookupClass()).a(238635881916181L);

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.a(0);
                }
                DumbService.getInstance((Project)project).cancelTask(dumbModeTask);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x265D4147201EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$2", "rootsChanged"));
            }
        });
        dumbService.queueTask(dumbModeTask);
    }

    private List<Runnable> b(@NotNull Project project, @NotNull Set<Sdk> set) {
        long l2 = c ^ 0x254D8EF8CA48L;
        if (project == null) {
            PythonLanguageLevelPusher.a(24);
        }
        if (set == null) {
            PythonLanguageLevelPusher.a(25);
        }
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        for (Sdk sdk : set) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            for (VirtualFile virtualFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!virtualFile.isValid() || PyTypeShed.INSTANCE.isInside(virtualFile)) continue;
                VirtualFile virtualFile2 = virtualFile.getParent();
                boolean bl2 = virtualFile2 != null && virtualFile2.getName().equals("python_stubs");
                arrayList.add(new UpdateRootTask(project, virtualFile, languageLevel, bl2));
            }
        }
        return arrayList;
    }

    public static void setForcedLanguageLevel(Project project, @Nullable LanguageLevel languageLevel) {
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PythonLanguageLevelPusher.pushLanguageLevel(project);
    }

    public void flushLanguageLevelCache() {
        this.b.clear();
    }

    static {
        c = com.jetbrains.python.psi.c.a(-7061078845055801300L, -8689501443696270339L, MethodHandles.lookup().lookupClass()).a(278474908436816L);
        long l2 = c ^ 0x2BE3A44CE56EL;
        PYTHON_LANGUAGE_LEVEL = Key.create((String)"PYTHON_LANGUAGE_LEVEL");
        EnumMap enumMap = Maps.newEnumMap(LanguageLevel.class);
        PythonLanguageLevelPusher.a(enumMap, LanguageLevel.PYTHON26, LanguageLevel.PYTHON27);
        PythonLanguageLevelPusher.a(enumMap, LanguageLevel.PYTHON33, LanguageLevel.PYTHON34);
        COMPATIBLE_LEVELS = Maps.immutableEnumMap((Map)enumMap);
        a = new FileAttribute("python_language_level_persistence", 2, true);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0xE10FFFB1D3EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonModuleSdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileLanguageLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearSdkPathCache";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPythonModuleSdks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPythonModule";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkLanguageLevels";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRootUpdateTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UpdateRootTask
    implements Runnable {
        @NotNull
        private final Project b;
        @NotNull
        private final VirtualFile a;
        @NotNull
        private final LanguageLevel c;
        private final boolean d;
        private static final long e = com.jetbrains.python.psi.c.a(-2367916825240288711L, -7679286409496495212L, MethodHandles.lookup().lookupClass()).a(224229300919810L);

        UpdateRootTask(@NotNull Project project, @NotNull VirtualFile root, LanguageLevel languageLevel, boolean shouldSuppressSizeLimit) {
            if (project == null) {
                UpdateRootTask.a(0);
            }
            if (root == null) {
                UpdateRootTask.a(1);
            }
            if (languageLevel == null) {
                UpdateRootTask.a(2);
            }
            this.b = project;
            this.a = root;
            this.c = languageLevel;
            this.d = shouldSuppressSizeLimit;
        }

        @Override
        public void run() {
            if (this.b.isDisposed() || !((Boolean)ReadAction.compute(() -> this.a.isValid())).booleanValue()) {
                return;
            }
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            final PushedFilePropertiesUpdater pushedFilePropertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.b);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.a, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
                private static final long a = com.jetbrains.python.psi.c.a(5548327002291537607L, 4111731386849327693L, MethodHandles.lookup().lookupClass()).a(222339343984433L);

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.a(0);
                    }
                    return (Boolean)ReadAction.compute(() -> {
                        if (fileTypeManager.isFileIgnored(file)) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            pushedFilePropertiesUpdater.findAndUpdateValue(file, (FilePropertyPusher)PythonLanguageLevelPusher.this, (Object)UpdateRootTask.this.c);
                        }
                        if (UpdateRootTask.this.d) {
                            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
                        }
                        return true;
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x6E8E6CB17AA8L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask$1", "visitFile"));
                }
            });
        }

        public String toString() {
            long l2 = e ^ 0x3244C6FBD73FL;
            return "UpdateRootTask{myRoot=" + this.a + ", myLanguageLevel=" + (Object)((Object)this.c) + '}';
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = e ^ 0x15BE89698F2CL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

