/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.google.common.base.Predicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyExtractSuperclassHelper {
    private static final Logger b;
    private static final Predicate<PyMemberInfo<PyElement>> a;
    private static final long c;

    private PyExtractSuperclassHelper() {
    }

    static void extractSuperclass(PyClass clazz, @NotNull Collection<PyMemberInfo<PyElement>> selectedMemberInfos, String superBaseName, String targetFile) {
        Object object;
        long l2 = c ^ 0x400CC433B339L;
        if (selectedMemberInfos == null) {
            PyExtractSuperclassHelper.a(0);
        }
        Project project = clazz.getProject();
        selectedMemberInfos = new ArrayList<PyMemberInfo<PyElement>>(selectedMemberInfos);
        RefactoringEventData refactoringEventData = new RefactoringEventData();
        refactoringEventData.addElements((Collection)JBIterable.from(selectedMemberInfos).transform(pyMemberInfo -> (PyElement)pyMemberInfo.getMember()).toList());
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractSuperclassHelper.getRefactoringId(), refactoringEventData);
        PyMemberInfo<PyElement> pyMemberInfo2 = MembersManager.findMember(selectedMemberInfos, a);
        if (LanguageLevel.forElement((PsiElement)clazz).isPy3K() && !PyExtractSuperclassHelper.a(clazz)) {
            if (pyMemberInfo2 != null) {
                selectedMemberInfos.remove(pyMemberInfo2);
            }
        } else if (pyMemberInfo2 == null && (object = MembersManager.findMember(clazz, a)) != null) {
            selectedMemberInfos.add((PyMemberInfo<PyElement>)((Object)object));
        }
        object = "class " + superBaseName + ":\n  pass\n";
        PyClass pyClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, (String)object);
        pyClass = PyExtractSuperclassHelper.a(project, pyClass, clazz, targetFile);
        MembersManager.moveAllMembers(selectedMemberInfos, clazz, pyClass);
        if (!pyClass.getContainingFile().equals(clazz.getContainingFile())) {
            PyClassRefactoringUtil.optimizeImports(clazz.getContainingFile());
        }
        PyClassRefactoringUtil.addSuperclasses(project, clazz, null, pyClass);
        RefactoringEventData refactoringEventData2 = new RefactoringEventData();
        refactoringEventData2.addElement((PsiElement)pyClass);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractSuperclassHelper.getRefactoringId(), refactoringEventData2);
    }

    private static boolean a(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyExtractSuperclassHelper.a(1);
        }
        return Arrays.stream(pyClass.getSuperClassExpressions()).anyMatch(pyExpression -> {
            long l2 = c ^ 0x1DE32F149292L;
            return "object".equals(pyExpression.getName());
        });
    }

    private static PyClass a(Project project, PyClass pyClass, @NotNull PyClass pyClass2, String string) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x72780A76C77CL;
        if (pyClass2 == null) {
            PyExtractSuperclassHelper.a(2);
        }
        if (Comparing.equal((Object)(virtualFile = VirtualFileManager.getInstance().findFileByUrl(ApplicationManager.getApplication().isUnitTestMode() ? string : VfsUtilCore.pathToUrl((String)string))), (Object)pyClass2.getContainingFile().getVirtualFile())) {
            return (PyClass)pyClass2.getParent().addBefore((PsiElement)pyClass, (PsiElement)pyClass2);
        }
        PsiFile psiFile = null;
        try {
            if (virtualFile == null) {
                String string2;
                String string3;
                if (string.endsWith(PythonFileType.INSTANCE.getDefaultExtension())) {
                    string3 = PathUtil.getParentPath((String)string);
                    string2 = PathUtil.getFileName((String)string);
                } else {
                    string3 = string;
                    string2 = "__init__.py";
                }
                psiFile = PyExtractSuperclassHelper.placeFile(project, string3, string2);
            } else {
                psiFile = virtualFile.isDirectory() ? PyExtractSuperclassHelper.placeFile(project, virtualFile.getPath(), "__init__.py") : PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
        }
        catch (IOException iOException) {
            b.error((Throwable)iOException);
        }
        b.assertTrue(psiFile != null);
        if (psiFile.getLastChild() != null) {
            psiFile.add((PsiElement)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.PYTHON27, PsiWhiteSpace.class, "\n\n"));
        }
        pyClass = (PyClass)psiFile.add((PsiElement)pyClass);
        PyClassRefactoringUtil.insertImport((PsiElement)pyClass2, Collections.singleton(pyClass));
        return pyClass;
    }

    public static PsiFile placeFile(Project project, String path, String filename) throws IOException {
        return PyExtractSuperclassHelper.placeFile(project, path, filename, null);
    }

    public static PsiFile placeFile(Project project, String path, String filename, @Nullable String content2) throws IOException {
        PsiDirectory psiDirectory = PyExtractSuperclassHelper.a(project, path);
        b.assertTrue(psiDirectory != null);
        PsiFile psiFile = psiDirectory.findFile(filename);
        if (psiFile == null) {
            PsiDocumentManager psiDocumentManager;
            Document document;
            psiFile = psiDirectory.createFile(filename);
            if (content2 != null && (document = (psiDocumentManager = PsiDocumentManager.getInstance((Project)project)).getDocument(psiFile)) != null) {
                document.setText((CharSequence)content2);
                psiDocumentManager.commitDocument(document);
            }
        }
        return psiFile;
    }

    @Nullable
    private static PsiDirectory a(Project project, String string) throws IOException {
        String[] stringArray;
        VirtualFile virtualFile22;
        long l2 = c ^ 0x32898D6D3AB7L;
        String string2 = null;
        VirtualFile virtualFile3 = null;
        string = FileUtil.toSystemIndependentName((String)string);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        ContainerUtil.addAll(arrayList, (Object[])projectRootManager.getContentRoots());
        ContainerUtil.addAll(arrayList, (Object[])projectRootManager.getContentSourceRoots());
        arrayList.sort(Comparator.comparingInt(virtualFile -> virtualFile.getPath().length()).reversed());
        for (VirtualFile virtualFile22 : arrayList) {
            stringArray = virtualFile22.getPath();
            if (!string.startsWith((String)stringArray)) continue;
            string2 = string.substring(stringArray.length());
            virtualFile3 = virtualFile22;
            break;
        }
        if (virtualFile3 == null) {
            throw new IOException("Can't find '" + string + "' among roots");
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        virtualFile22 = PsiManager.getInstance((Project)project);
        stringArray = string2.split("/");
        int n2 = 0;
        if (stringArray[0].isEmpty()) {
            n2 = 1;
        }
        VirtualFile virtualFile4 = virtualFile3;
        while (n2 < stringArray.length) {
            VirtualFile virtualFile5 = virtualFile4.findChild(stringArray[n2]);
            if (virtualFile5 != null) {
                if (!virtualFile5.isDirectory()) {
                    throw new IOException("Expected resultDir, but got non-resultDir: " + virtualFile5.getPath());
                }
            } else {
                virtualFile5 = virtualFile4.createChildDirectory((Object)localFileSystem, stringArray[n2]);
            }
            if (virtualFile5.findChild("__init__.py") == null) {
                virtualFile5.createChildData((Object)localFileSystem, "__init__.py");
            }
            virtualFile4 = virtualFile5;
            ++n2;
        }
        return virtualFile22.findDirectory(virtualFile4);
    }

    public static String getRefactoringId() {
        long l2 = c ^ 0x6289FFFECA50L;
        return "refactoring.python.extract.superclass";
    }

    static {
        c = com.jetbrains.python.psi.c.a(4922650600673168822L, 6261955131370031808L, MethodHandles.lookup().lookupClass()).a(239559339157278L);
        b = Logger.getInstance((String)PyExtractSuperclassHelper.class.getName());
        a = new PyUtil.ObjectPredicate(true);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x720B657A5D44L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMemberInfos";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractSuperclass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectParentDeclaredExplicitly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "placeNewClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

