/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.InstanceFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PropertiesManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.SuperClassesManager;
import com.jetbrains.python.refactoring.classes.membersManager.TypeSafeMovingStrategy;
import com.jetbrains.python.refactoring.classes.membersManager.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MembersManager<T extends PyElement>
implements Function<T, PyMemberInfo<T>> {
    private static final Collection<? extends MembersManager<? extends PyElement>> b;
    @NotNull
    private final Class<T> a;
    private static final long i;

    protected MembersManager(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            MembersManager.a(0);
        }
        this.a = expectedClass;
    }

    @NotNull
    public static List<PyMemberInfo<PyElement>> getAllMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            MembersManager.a(1);
        }
        ArrayList<PyMemberInfo<PyElement>> arrayList = new ArrayList<PyMemberInfo<PyElement>>();
        for (MembersManager<? extends PyElement> membersManager : b) {
            arrayList.addAll(MembersManager.a(pyClass, membersManager));
        }
        ArrayList<PyMemberInfo<PyElement>> arrayList2 = arrayList;
        if (arrayList2 == null) {
            MembersManager.a(2);
        }
        return arrayList2;
    }

    @NotNull
    private static Collection<PyMemberInfo<PyElement>> a(@NotNull PyClass pyClass, @NotNull MembersManager<?> membersManager) {
        if (pyClass == null) {
            MembersManager.a(3);
        }
        if (membersManager == null) {
            MembersManager.a(4);
        }
        List<PyElement> list2 = membersManager.getMembersCouldBeMoved(pyClass);
        membersManager.checkElementTypes(list2);
        Collection collection = Collections2.transform(list2, membersManager);
        if (collection == null) {
            MembersManager.a(5);
        }
        return collection;
    }

    public static void moveAllMembers(@NotNull Collection<? extends PyMemberInfo<PyElement>> memberInfos, @NotNull PyClass from, PyClass ... to) {
        if (memberInfos == null) {
            MembersManager.a(6);
        }
        if (from == null) {
            MembersManager.a(7);
        }
        if (to == null) {
            MembersManager.a(8);
        }
        ArrayList<? extends PyMemberInfo<PyElement>> arrayList = new ArrayList<PyMemberInfo<PyElement>>(memberInfos);
        Collections.sort(arrayList, (pyMemberInfo, pyMemberInfo2) -> PyDependenciesComparator.INSTANCE.compare((PyElement)pyMemberInfo.getMember(), (PyElement)pyMemberInfo2.getMember()));
        for (PyMemberInfo pyMemberInfo3 : arrayList) {
            TypeSafeMovingStrategy.moveCheckingTypesAtRunTime(from, pyMemberInfo3.getMembersManager(), Collections.singleton(pyMemberInfo3), to);
        }
    }

    void checkElementTypes(@NotNull Iterable<T> elements) {
        long l2 = i ^ 0x3B00B44CC88DL;
        if (elements == null) {
            MembersManager.a(9);
        }
        for (PyElement pyElement : elements) {
            Preconditions.checkArgument((boolean)this.a.isAssignableFrom(pyElement.getClass()), (Object)String.format("Manager %s expected %s but got %s", this, this.a, pyElement));
        }
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull Collection<? extends PyMemberInfo<PyElement>> members, @NotNull Predicate<? super PyMemberInfo<PyElement>> predicate) {
        if (members == null) {
            MembersManager.a(10);
        }
        if (predicate == null) {
            MembersManager.a(11);
        }
        for (PyMemberInfo<PyElement> pyMemberInfo : members) {
            if (!predicate.apply(pyMemberInfo)) continue;
            return pyMemberInfo;
        }
        return null;
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull Predicate<? super PyMemberInfo<PyElement>> predicate) {
        if (pyClass == null) {
            MembersManager.a(12);
        }
        if (predicate == null) {
            MembersManager.a(13);
        }
        return MembersManager.findMember(MembersManager.getAllMembersCouldBeMoved(pyClass), predicate);
    }

    @NotNull
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull PyElement pyElement) {
        PyMemberInfo<PyElement> pyMemberInfo;
        long l2 = i ^ 0x328B3D25EC63L;
        if (pyClass == null) {
            MembersManager.a(14);
        }
        if (pyElement == null) {
            MembersManager.a(15);
        }
        if ((pyMemberInfo = MembersManager.findMember(pyClass, (Predicate<? super PyMemberInfo<PyElement>>)new FindByElement(pyElement, null))) != null) {
            PyMemberInfo<PyElement> pyMemberInfo2 = pyMemberInfo;
            if (pyMemberInfo2 == null) {
                MembersManager.a(16);
            }
            return pyMemberInfo2;
        }
        throw new IllegalArgumentException(String.format("Element %s not found in class %s or can't be moved", pyElement, pyClass));
    }

    @NotNull
    protected abstract List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass var1);

    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<T> elements) {
        if (elements == null) {
            MembersManager.a(17);
        }
        return elements;
    }

    protected abstract Collection<PyElement> moveMembers(@NotNull PyClass var1, @NotNull Collection<PyMemberInfo<T>> var2, PyClass ... var3);

    @NotNull
    public abstract PyMemberInfo<T> apply(@NotNull T var1);

    protected static void deleteElements(@NotNull Collection<? extends PsiElement> pyElementsToDelete) {
        if (pyElementsToDelete == null) {
            MembersManager.a(18);
        }
        for (PsiElement psiElement : pyElementsToDelete) {
            psiElement.delete();
        }
    }

    @NotNull
    protected static <T extends PyElement> Collection<T> fetchElements(@NotNull Collection<? extends PyMemberInfo<T>> memberInfos) {
        if (memberInfos == null) {
            MembersManager.a(19);
        }
        Collection collection = memberInfos.stream().map(pyMemberInfo -> (PyElement)pyMemberInfo.getMember()).filter(pyElement -> pyElement != null).collect(Collectors.toList());
        if (collection == null) {
            MembersManager.a(20);
        }
        return collection;
    }

    public abstract boolean hasConflict(@NotNull T var1, @NotNull PyClass var2);

    @NotNull
    public static Collection<? extends PyElement> getAllDependencies(@NotNull PyClass classWhereMemberDeclared, @NotNull PyElement member, @Nullable PyClass destinationClass) {
        if (classWhereMemberDeclared == null) {
            MembersManager.a(21);
        }
        if (member == null) {
            MembersManager.a(22);
        }
        PyMemberInfo<PyElement> pyMemberInfo = MembersManager.findMember(classWhereMemberDeclared, member);
        Collection<PyElement> collection = pyMemberInfo.getMembersManager().getElementsToStoreReferences(Collections.singleton(member));
        MultiMap multiMap = new MultiMap();
        HashSet<PyElement> hashSet = new HashSet<PyElement>();
        for (MembersManager<? extends PyElement> object : b) {
            for (PyElement pyElement : collection) {
                multiMap.putAllValues(object.getDependencies(pyElement));
            }
        }
        if (destinationClass != null) {
            Iterator<MembersManager<PyElement>> iterator = multiMap.keySet().iterator();
            while (iterator.hasNext()) {
                PyClass pyClass = (PyClass)((Object)iterator.next());
                if (!pyClass.equals(destinationClass) && !ArrayUtil.contains((Object)pyClass, (Object[])destinationClass.getSuperClasses(null))) continue;
                iterator.remove();
            }
        }
        for (MembersManager<PyElement> membersManager : b) {
            hashSet.addAll(membersManager.getDependencies((MultiMap<PyClass, PyElement>)multiMap));
        }
        hashSet.addAll(multiMap.values());
        HashSet<PyElement> hashSet2 = hashSet;
        if (hashSet2 == null) {
            MembersManager.a(23);
        }
        return hashSet2;
    }

    @NotNull
    protected abstract MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement var1);

    @NotNull
    protected abstract Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> var1);

    static {
        i = com.jetbrains.python.psi.c.a(-6619848307872919919L, -7602602217907212430L, MethodHandles.lookup().lookupClass()).a(251341744514626L);
        b = Arrays.asList(new MethodsManager(), new SuperClassesManager(), new ClassFieldsManager(), new InstanceFieldsManager(), new PropertiesManager());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0xA5E73359B4DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/MembersManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElementsToDelete";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classWhereMemberDeclared";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/MembersManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMembersCouldBeMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "transformSafely";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMember";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllMembersCouldBeMoved";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transformSafely";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveAllMembers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkElementTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToStoreReferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FindByElement
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final PyElement a;
        private static final long c = com.jetbrains.python.psi.c.a(-6785374583588394606L, 4160674698429833593L, MethodHandles.lookup().lookupClass()).a(146093211443965L);

        private FindByElement(PyElement pyElement) {
            this.a = pyElement;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                FindByElement.b(0);
            }
            return ((PyElement)input.getMember()).equals(this.a);
        }

        /* synthetic */ FindByElement(PyElement x0, c x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x5AE484CB228BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager$FindByElement", "applyNotNull"));
        }
    }
}

