/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager.vp;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.BadDataException;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenter;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedView;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class MembersBasedPresenterImpl<T extends MembersBasedView<?>, M extends MemberInfoModel<PyElement, PyMemberInfo<PyElement>>>
implements MembersBasedPresenter {
    @NotNull
    protected final T myView;
    @NotNull
    protected final PyClass myClassUnderRefactoring;
    @NotNull
    protected final PyMemberInfoStorage myStorage;
    @NotNull
    protected final M myModel;
    private static final long c = com.jetbrains.python.psi.c.a(-6683782542049300130L, -96477077451123380L, MethodHandles.lookup().lookupClass()).a(25344009474596L);

    MembersBasedPresenterImpl(@NotNull T view, @NotNull PyClass classUnderRefactoring, @NotNull PyMemberInfoStorage infoStorage, @NotNull M model) {
        if (view == null) {
            MembersBasedPresenterImpl.a(0);
        }
        if (classUnderRefactoring == null) {
            MembersBasedPresenterImpl.a(1);
        }
        if (infoStorage == null) {
            MembersBasedPresenterImpl.a(2);
        }
        if (model == null) {
            MembersBasedPresenterImpl.a(3);
        }
        this.myView = view;
        this.myClassUnderRefactoring = classUnderRefactoring;
        this.myStorage = infoStorage;
        this.myModel = model;
    }

    @Override
    public void okClicked() {
        MultiMap<PyClass, PyMemberInfo<?>> multiMap = this.getConflicts();
        ArrayList arrayList = new ArrayList();
        for (PyMemberInfo pyMemberInfo : this.myStorage.getClassMemberInfos((PsiElement)this.myClassUnderRefactoring)) {
            if (this.myModel.checkForProblems((MemberInfoBase)pyMemberInfo) == 0) continue;
            arrayList.add(pyMemberInfo);
        }
        if (multiMap.isEmpty() && arrayList.isEmpty() || this.myView.showConflictsDialog(multiMap, arrayList)) {
            try {
                this.validateView();
                this.doRefactor();
            }
            catch (BadDataException badDataException) {
                this.myView.showError(badDataException.getMessage());
            }
        }
    }

    protected void validateView() throws BadDataException {
        long l2 = c ^ 0x71D22B91A054L;
        if (this.myView.getSelectedMemberInfos().isEmpty()) {
            throw new BadDataException(RefactoringBundle.message((String)"no.members.selected"));
        }
    }

    abstract void doRefactor();

    @NotNull
    protected final MultiMap<PyClass, PyMemberInfo<?>> getConflicts() {
        MultiMap multiMap = new MultiMap();
        Collection<PyMemberInfo<PyElement>> collection = this.myView.getSelectedMemberInfos();
        for (PyClass pyClass : this.getDestClassesToCheckConflicts()) {
            for (PyMemberInfo<PyElement> pyMemberInfo : collection) {
                if (!pyMemberInfo.hasConflict(pyClass)) continue;
                multiMap.putValue((Object)pyClass, pyMemberInfo);
            }
        }
        MultiMap multiMap2 = multiMap;
        if (multiMap2 == null) {
            MembersBasedPresenterImpl.a(4);
        }
        return multiMap2;
    }

    @NotNull
    protected abstract Iterable<? extends PyClass> getDestClassesToCheckConflicts();

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0xD2BC9332519L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classUnderRefactoring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

