/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.field;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.field.IntroduceFieldValidator;
import com.jetbrains.python.refactoring.introduce.field.PyIntroduceFieldPanel;
import com.jetbrains.python.refactoring.introduce.field.a;
import com.jetbrains.python.refactoring.introduce.variable.PyIntroduceVariableHandler;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceFieldHandler
extends IntroduceHandler {
    private static final long c = com.jetbrains.python.psi.c.a(5935065637227576799L, 3968670330683591002L, MethodHandles.lookup().lookupClass()).a(43203961565884L);

    public PyIntroduceFieldHandler() {
        long l2 = c ^ 0x6D6165CBF104L;
        super(new IntroduceFieldValidator(), RefactoringBundle.message((String)"introduce.field.title"));
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PyIntroduceFieldHandler.b(0);
        }
        IntroduceOperation introduceOperation = new IntroduceOperation(project, editor2, file, null);
        introduceOperation.addAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
        if (PyIntroduceFieldHandler.a(file, editor2)) {
            introduceOperation.addAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        this.performAction(introduceOperation);
    }

    private static boolean a(PsiFile psiFile, Editor editor2) {
        Object object;
        PsiElement psiElement = null;
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (selectionModel.hasSelection()) {
            psiElement = psiFile.findElementAt(selectionModel.getSelectionStart());
        } else {
            object = editor2.getCaretModel();
            Document document = editor2.getDocument();
            int n2 = document.getLineNumber(object.getOffset());
            if (n2 >= 0 && n2 < document.getLineCount()) {
                psiElement = psiFile.findElementAt(document.getLineStartOffset(n2));
            }
        }
        return psiElement != null && (object = PyUtil.getContainingClassOrSelf(psiElement)) != null && PythonUnitTestUtil.isTestClass((PyClass)object, ThreeState.UNSURE, null);
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (operation.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
            return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
        }
        return super.replaceExpression(expression, newExpression, operation);
    }

    @Override
    protected boolean checkEnabled(IntroduceOperation operation) {
        long l2 = c ^ 0x416A1CEE7901L;
        if (PyUtil.getContainingClassOrSelf(operation.getElement()) == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)"Cannot introduce field: not in class", (String)this.myDialogTitle, (String)this.getHelpId());
            return false;
        }
        if (PyIntroduceFieldHandler.b(operation.getElement())) {
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        return true;
    }

    private static boolean b(PsiElement psiElement) {
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ScopeOwner.class);
        ResolvingVisitor resolvingVisitor = new ResolvingVisitor(scopeOwner);
        psiElement.accept((PsiElementVisitor)resolvingVisitor);
        return resolvingVisitor.a;
    }

    @Override
    @Nullable
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceFieldHandler.b(1);
        }
        if (declaration == null) {
            PyIntroduceFieldHandler.b(2);
        }
        if (operation == null) {
            PyIntroduceFieldHandler.b(3);
        }
        PsiElement psiElement = expression instanceof PyClass ? expression : expression.getParent();
        PyClass pyClass = PyUtil.getContainingClassOrSelf(psiElement);
        assert (pyClass != null);
        Project project = pyClass.getProject();
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.CONSTRUCTOR && !PyIntroduceFieldHandler.c(expression)) {
            return AddFieldQuickFix.addFieldToInit(project, pyClass, "", new AddFieldDeclaration(declaration, null));
        }
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.SET_UP) {
            return PyIntroduceFieldHandler.a(pyClass, new AddFieldDeclaration(declaration, null));
        }
        return PyIntroduceVariableHandler.doIntroduceVariable(expression, declaration, operation.getOccurrences(), operation.isReplaceAll());
    }

    private static boolean c(@NotNull PsiElement psiElement) {
        PyFunction pyFunction;
        long l2 = c ^ 0x543BF3C307F9L;
        if (psiElement == null) {
            PyIntroduceFieldHandler.b(4);
        }
        PsiElement psiElement2 = psiElement instanceof PyClass ? psiElement : psiElement.getParent();
        PyClass pyClass = PyUtil.getContainingClassOrSelf(psiElement2);
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(psiElement);
        return pyClass != null && scopeOwner instanceof PyFunction && scopeOwner == (pyFunction = pyClass.findMethodByName("__init__", false, null));
    }

    @NotNull
    private static PsiElement a(PyClass pyClass, Function<String, PyStatement> function) {
        long l2 = c ^ 0x6A10E59A040FL;
        PyFunction pyFunction = pyClass.findMethodByName("setUp", false, null);
        if (pyFunction != null) {
            PsiElement psiElement = AddFieldQuickFix.appendToMethod(pyFunction, function);
            if (psiElement == null) {
                PyIntroduceFieldHandler.b(5);
            }
            return psiElement;
        }
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder("setUp", (PsiElement)pyClass);
        pyFunctionBuilder.parameter("self");
        PyFunction pyFunction2 = pyFunctionBuilder.buildFunction();
        PyStatementList pyStatementList = pyClass.getStatementList();
        PsiElement psiElement = pyStatementList.getFirstChild();
        pyFunction2 = (PyFunction)pyStatementList.addBefore(pyFunction2, psiElement);
        PsiElement psiElement2 = AddFieldQuickFix.appendToMethod(pyFunction2, function);
        if (psiElement2 == null) {
            PyIntroduceFieldHandler.b(6);
        }
        return psiElement2;
    }

    @Override
    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            PyIntroduceFieldHandler.b(7);
        }
        if (PyIntroduceFieldHandler.d(element)) {
            PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)pyFunction)).findAll();
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            for (PsiReference psiReference : collection) {
                PsiElement psiElement = psiReference.getElement();
                if (psiElement == element) continue;
                arrayList.add(psiElement);
            }
            return arrayList;
        }
        return super.getOccurrences(element, expression);
    }

    @Override
    protected PyExpression createExpression(Project project, String name, PsiElement declaration) {
        String string = declaration.getText();
        String string2 = string.substring(0, string.indexOf(46));
        return PyElementGenerator.getInstance(project).createExpressionFromText(string2 + "." + name);
    }

    @Override
    protected PyAssignmentStatement createDeclaration(Project project, String assignmentText, PsiElement anchor) {
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyFunction.class);
        String string = PyUtil.getFirstParameterName(pyFunction);
        LanguageLevel languageLevel = LanguageLevel.forElement(anchor);
        return PyElementGenerator.getInstance(project).createFromText(languageLevel, PyAssignmentStatement.class, string + "." + assignmentText);
    }

    @Override
    protected void postRefactoring(PsiElement element) {
        if (PyIntroduceFieldHandler.d(element)) {
            element.getParent().delete();
        }
    }

    private static boolean d(PsiElement psiElement) {
        PyAssignmentStatement pyAssignmentStatement;
        return psiElement instanceof PyTargetExpression && psiElement.getParent() instanceof PyAssignmentStatement && PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class) != null && (pyAssignmentStatement = (PyAssignmentStatement)psiElement.getParent()).getTargets().length == 1;
    }

    @Override
    protected String getHelpId() {
        long l2 = c ^ 0x7DFE8B2F987EL;
        return "python.reference.introduceField";
    }

    @Override
    protected boolean checkIntroduceContext(PsiFile file, Editor editor2, PsiElement element) {
        long l2 = c ^ 0x22380710A709L;
        if (element != null && PyIntroduceFieldHandler.e(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor2, (String)"Introduce Field refactoring cannot be used in static methods", (String)RefactoringBundle.message((String)"introduce.field.title"), (String)"refactoring.extractMethod");
            return false;
        }
        return super.checkIntroduceContext(file, editor2, element);
    }

    private static boolean e(PsiElement psiElement) {
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (pyFunction != null) {
            PyFunction.Modifier modifier = pyFunction.getModifier();
            return modifier == PyFunction.Modifier.STATICMETHOD;
        }
        return false;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) && PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class}) != null && PsiTreeUtil.getParentOfType((PsiElement)element, PyDecoratorList.class) == null && !PyIntroduceFieldHandler.e(element);
    }

    @Override
    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement psiElement = this.performRefactoring(operation);
        if (psiElement instanceof PyAssignmentStatement) {
            List<PsiElement> list2 = operation.getOccurrences();
            PsiElement psiElement2 = PyIntroduceFieldHandler.findOccurrenceUnderCaret(list2, operation.getEditor());
            PyTargetExpression pyTargetExpression = (PyTargetExpression)((PyAssignmentStatement)psiElement).getTargets()[0];
            PyIntroduceFieldHandler.a(operation.getEditor(), (PsiElement)(psiElement2 != null ? psiElement2 : pyTargetExpression));
            PyInplaceFieldIntroducer pyInplaceFieldIntroducer = new PyInplaceFieldIntroducer(pyTargetExpression, operation, list2);
            pyInplaceFieldIntroducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    private static void a(Editor editor2, PsiElement psiElement) {
        ASTNode aSTNode;
        PyQualifiedExpression pyQualifiedExpression = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyQualifiedExpression.class, (boolean)false);
        if (pyQualifiedExpression != null && !pyQualifiedExpression.isQualified()) {
            pyQualifiedExpression = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)pyQualifiedExpression, PyQualifiedExpression.class);
        }
        if (pyQualifiedExpression != null && (aSTNode = pyQualifiedExpression.getNameElement()) != null) {
            int n2 = aSTNode.getTextRange().getStartOffset();
            editor2.getCaretModel().moveToOffset(n2);
        }
    }

    @Override
    protected String getRefactoringId() {
        long l2 = c ^ 0x49FB7D6CF18EL;
        return "refactoring.python.introduce.field";
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x124182C870C2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addFieldToSetUp";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inConstructor";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyInplaceFieldIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression c;
        private final IntroduceOperation b;
        private final PyIntroduceFieldPanel a;
        private static final long d = com.jetbrains.python.psi.c.a(7746636399629269117L, -3788627854497980991L, MethodHandles.lookup().lookupClass()).a(138874374606482L);

        PyInplaceFieldIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            long l2 = d ^ 0x2A3738D0362FL;
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), "Introduce Field", occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.c = target;
            this.b = operation;
            this.a = operation.getAvailableInitPlaces().size() > 1 ? new PyIntroduceFieldPanel(this.myProject, operation.getAvailableInitPlaces()) : null;
        }

        protected PsiElement checkLocalScope() {
            return this.c.getContainingFile();
        }

        protected JComponent getComponent() {
            return this.a == null ? null : this.a.getRootPanel();
        }

        protected void moveOffsetAfter(boolean success) {
            if (success && this.a != null && this.a.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD || this.b.getInplaceInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
                WriteAction.run(() -> {
                    IntroduceHandler.InitPlace initPlace;
                    PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this.c, PyAssignmentStatement.class);
                    assert (pyAssignmentStatement != null);
                    Function function = FunctionUtil.constant((Object)pyAssignmentStatement);
                    PyClass pyClass = PyUtil.getContainingClassOrSelf(pyAssignmentStatement);
                    IntroduceHandler.InitPlace initPlace2 = initPlace = this.a != null ? this.a.getInitPlace() : this.b.getInplaceInitPlace();
                    if (initPlace == IntroduceHandler.InitPlace.CONSTRUCTOR) {
                        AddFieldQuickFix.addFieldToInit(this.myProject, pyClass, "", (Function<? super String, ? extends PyStatement>)function);
                    } else if (initPlace == IntroduceHandler.InitPlace.SET_UP) {
                        PyIntroduceFieldHandler.a(pyClass, (Function<String, PyStatement>)function);
                    }
                    if (this.b.getOccurrences().size() > 0) {
                        pyAssignmentStatement.delete();
                    } else {
                        PyExpression pyExpression = PyElementGenerator.getInstance(this.myProject).createExpressionFromText(LanguageLevel.forElement(this.c), this.c.getText());
                        pyAssignmentStatement.replace((PsiElement)pyExpression);
                    }
                    pyAssignmentStatement.delete();
                });
            }
        }
    }

    private static class AddFieldDeclaration
    implements Function<String, PyStatement> {
        private final PsiElement a;
        private static final long b = com.jetbrains.python.psi.c.a(-4345556854878114399L, 268559189917276321L, MethodHandles.lookup().lookupClass()).a(143163173526821L);

        private AddFieldDeclaration(PsiElement declaration) {
            this.a = declaration;
        }

        public PyStatement fun(String self_name) {
            long l2 = b ^ 0x21C910A27862L;
            if ("self".equals(self_name)) {
                return (PyStatement)this.a;
            }
            String string = this.a.getText();
            Project project = this.a.getProject();
            return PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyStatement.class, string.replaceFirst("self\\.", self_name + "."));
        }

        /* synthetic */ AddFieldDeclaration(PsiElement x0, a x1) {
            this(x0);
        }
    }

    private static class ResolvingVisitor
    extends PyRecursiveElementVisitor {
        private boolean a = false;
        private final ScopeOwner b;

        ResolvingVisitor(ScopeOwner scope) {
            this.b = scope;
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            PsiElement psiElement = node.getReference().resolve();
            if (psiElement != null && PsiTreeUtil.getParentOfType((PsiElement)psiElement, ScopeOwner.class) == this.b) {
                PyFunction.Modifier modifier;
                PyFunction pyFunction;
                PyParameter[] pyParameterArray;
                if (psiElement instanceof PyParameter && this.b instanceof PyFunction && (pyParameterArray = (pyFunction = (PyFunction)this.b).getParameterList().getParameters()).length > 0 && psiElement == pyParameterArray[0] && (modifier = pyFunction.getModifier()) != PyFunction.Modifier.STATICMETHOD) {
                    return;
                }
                this.a = true;
            }
        }
    }
}

