/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Output;
import com.intellij.execution.OutputListener;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonTask {
    private static final long h = 2000L;
    private static final int d = 30000;
    protected final Module myModule;
    private final Sdk e;
    private String a;
    private String f;
    private HelperPackage b;
    private List<String> i;
    private final String j;
    private String c;
    private Runnable g;
    private static final long m = com.jetbrains.python.psi.c.a(-2630062036435367040L, -297863661954137717L, MethodHandles.lookup().lookupClass()).a(277808780112954L);

    public PythonTask(Module module2, String runTabTitle) throws ExecutionException {
        this(module2, runTabTitle, PythonSdkType.findPythonSdk(module2));
    }

    @NotNull
    public static PythonTask create(@NotNull Module module2, @NotNull String runTabTitle, @NotNull Sdk sdk) {
        PythonTask pythonTask;
        block5: {
            long l2 = m ^ 0x4AB84582B8BFL;
            if (module2 == null) {
                PythonTask.a(0);
            }
            if (runTabTitle == null) {
                PythonTask.a(1);
            }
            if (sdk == null) {
                PythonTask.a(2);
            }
            try {
                pythonTask = new PythonTask(module2, runTabTitle, sdk);
                if (pythonTask != null) break block5;
            }
            catch (ExecutionException executionException) {
                throw new AssertionError((Object)"Exception thrown file should not be");
            }
            PythonTask.a(3);
        }
        return pythonTask;
    }

    public PythonTask(Module module2, String runTabTitle, @Nullable Sdk sdk) throws ExecutionException {
        long l2 = m ^ 0x72CA5A5F1CA9L;
        this.b = null;
        this.i = new ArrayList<String>();
        this.myModule = module2;
        this.j = runTabTitle;
        this.e = sdk;
        if (this.e == null) {
            throw new ExecutionException("Cannot find Python interpreter for selected module");
        }
    }

    public String getWorkingDirectory() {
        return this.a;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.a = workingDirectory;
    }

    public void setRunnerScript(String script) {
        this.f = script;
    }

    public void setHelper(HelperPackage helper) {
        this.b = helper;
    }

    public void setParameters(List<String> parameters) {
        this.i = parameters;
    }

    public void setHelpId(String helpId) {
        this.c = helpId;
    }

    public void setAfterCompletion(Runnable afterCompletion) {
        this.g = afterCompletion;
    }

    public ProcessHandler createProcess(@Nullable Map<String, String> env) throws ExecutionException {
        ProcessHandler processHandler;
        GeneralCommandLine generalCommandLine = this.createCommandLine();
        if (env != null) {
            generalCommandLine.getEnvironment().putAll(env);
        }
        PydevConsoleRunner.setCorrectStdOutEncoding(generalCommandLine, this.myModule.getProject());
        if (PySdkUtil.isRemote(this.e)) {
            assert (this.e != null);
            processHandler = new PyRemoteProcessStarter().startRemoteProcess(this.e, generalCommandLine, this.myModule.getProject(), null);
        } else {
            EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)generalCommandLine);
            processHandler = PythonProcessRunner.createProcessHandlingCtrlC(generalCommandLine);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        }
        return processHandler;
    }

    public void run(@Nullable ConsoleView consoleView) throws ExecutionException {
        this.run(this.createCommandLine().getEnvironment(), consoleView);
    }

    public GeneralCommandLine createCommandLine() {
        Object object;
        Object object2;
        String string2;
        long l2 = m ^ 0x36BD4BBD5835L;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        if (this.a != null) {
            generalCommandLine.setWorkDirectory(this.a);
        }
        if ((string2 = this.e.getHomePath()) != null) {
            string2 = FileUtil.toSystemDependentName((String)string2);
        }
        PythonCommandLineState.createStandardGroups(generalCommandLine);
        ParamsGroup paramsGroup = generalCommandLine.getParametersList().getParamsGroup("Script");
        assert (paramsGroup != null);
        Map map2 = generalCommandLine.getEnvironment();
        if (!SystemInfo.isWindows && !PySdkUtil.isRemote(this.e)) {
            StringBuilder stringBuilder;
            generalCommandLine.setExePath("bash");
            object2 = generalCommandLine.getParametersList().addParamsGroupAt(0, "Bash");
            object2.addParameter("-cl");
            object = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
            if (this.b != null) {
                stringBuilder = new StringBuilder((String)object.fun((Object)string2) + " " + (String)object.fun((Object)this.b.asParamString()));
                this.b.addToPythonPath(generalCommandLine.getEnvironment());
            } else {
                stringBuilder = new StringBuilder((String)object.fun((Object)string2) + " " + (String)object.fun((Object)this.f));
            }
            for (String string3 : this.i) {
                stringBuilder.append(" ").append(string3);
            }
            object2.addParameter(stringBuilder.toString());
        } else {
            generalCommandLine.setExePath(string2);
            if (this.b != null) {
                this.b.addToGroup(paramsGroup, generalCommandLine);
            } else {
                paramsGroup.addParameter(this.f);
            }
            paramsGroup.addParameters(ContainerUtil.filter(this.i, string -> string != null));
        }
        PythonEnvUtil.setPythonUnbuffered(map2);
        if (string2 != null) {
            PythonEnvUtil.resetHomePathChanges(string2, map2);
        }
        object2 = this.setupPythonPath();
        PythonCommandLineState.initPythonPath(generalCommandLine, true, (List<String>)object2, string2);
        object = BuildoutFacet.getInstance(this.myModule);
        if (object != null) {
            ((BuildoutFacet)object).patchCommandLineForBuildout(generalCommandLine);
        }
        return generalCommandLine;
    }

    protected List<String> setupPythonPath() {
        return this.setupPythonPath(true, true);
    }

    protected List<String> setupPythonPath(boolean addContent, boolean addSource) {
        ArrayList arrayList = Lists.newArrayList(PythonCommandLineState.getAddedPaths(this.e));
        arrayList.addAll(PythonCommandLineState.collectPythonPath(this.myModule, addContent, addSource));
        return arrayList;
    }

    public void run(@Nullable Map<String, String> env, @Nullable ConsoleView consoleView) throws ExecutionException {
        ProcessHandler processHandler = this.createProcess(env);
        Project project = this.myModule.getProject();
        this.a(processHandler, project);
        new RunContentExecutor(project, processHandler).withFilter((Filter)new PythonTracebackFilter(project)).withConsole(consoleView).withTitle(this.j).withRerun(() -> {
            long l2 = m ^ 0x4B2DB3A7B8A1L;
            try {
                processHandler.destroyProcess();
                if (processHandler.waitFor(2000L)) {
                    this.run(env, consoleView);
                } else {
                    Messages.showErrorDialog((String)PyBundle.message("unable.to.stop", new Object[0]), (String)this.j);
                }
            }
            catch (ExecutionException executionException) {
                Messages.showErrorDialog((String)executionException.getMessage(), (String)this.j);
            }
        }).withStop(() -> processHandler.destroyProcess(), () -> !processHandler.isProcessTerminated()).withAfterCompletion(this.g).withHelpId(this.c).run();
    }

    private void a(final @NotNull ProcessHandler processHandler, @NotNull Project project) {
        if (processHandler == null) {
            PythonTask.a(4);
        }
        if (project == null) {
            PythonTask.a(5);
        }
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myModule, (Disposable)disposable);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(1303981540153756916L, -3551779406105539006L, MethodHandles.lookup().lookupClass()).a(81879925047020L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(0);
                }
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x945C23BB4BBL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/run/PythonTask$1", "processTerminated"));
            }
        }, (Disposable)this.myModule);
        project.getMessageBus().connect(disposable).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                processHandler.destroyProcess();
            }
        });
    }

    @NotNull
    public final String runNoConsole() throws ExecutionException {
        long l2 = m ^ 0x730754D8079DL;
        ProgressManager progressManager = ProgressManager.getInstance();
        Output output = SwingUtilities.isEventDispatchThread() ? (Output)progressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Output, ExecutionException>(){

            public Output compute() throws ExecutionException {
                return PythonTask.this.a();
            }
        }, this.j, false, this.myModule.getProject()) : this.a();
        int n2 = output.getExitCode();
        if (n2 == 0) {
            String string = output.getStdout();
            if (string == null) {
                PythonTask.a(6);
            }
            return string;
        }
        throw new ExecutionException(String.format("Error on python side. Exit code: %s, err: %s out: %s", n2, output.getStderr(), output.getStdout()));
    }

    @NotNull
    private Output a() throws ExecutionException {
        assert (!SwingUtilities.isEventDispatchThread());
        ProcessHandler processHandler = this.createProcess(new HashMap<String, String>());
        OutputListener outputListener = new OutputListener();
        processHandler.addProcessListener((ProcessListener)outputListener);
        processHandler.startNotify();
        processHandler.waitFor(30000L);
        Output output = outputListener.getOutput();
        if (output == null) {
            PythonTask.a(7);
        }
        return output;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x6A27ABCC73E3L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runTabTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runNoConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputInternal";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stopProcessWhenAppClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

