/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.DefaultEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.newImpl.TabLabel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.scientific.figures.DockableContentFigureFactory;
import com.jetbrains.python.scientific.figures.Figure;
import com.jetbrains.python.scientific.figures.WithDockableContent;
import com.jetbrains.python.scientific.figures.base.FigureUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPlotToolWindow
extends JPanel
implements DumbAware,
Disposable {
    private static final Logger h;
    private static final int g = 80;
    private final JBTabs e;
    private final Project a;
    private final Map<TabInfo, Object> c;
    private final List<DockableContentFigureFactory> f;
    private int b;
    private MyDockContainer d;
    private static final long i;

    public static PyPlotToolWindow getInstance(Project project) {
        return (PyPlotToolWindow)ServiceManager.getService((Project)project, PyPlotToolWindow.class);
    }

    public PyPlotToolWindow(Project project) {
        long l2 = i ^ 0x58DAF3F14BC0L;
        super(new BorderLayout());
        this.c = new HashMap<TabInfo, Object>();
        this.f = new ArrayList<DockableContentFigureFactory>();
        this.b = 0;
        this.a = project;
        this.e = JBTabsFactory.getUseNewTabs() ? new MyTabs(this.a) : new MyTabsOld(this.a);
        this.e.getPresentation().setTabsPosition(JBTabsPosition.right);
        this.e.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new SaveAsFileAction(this), new CloseAllPlotsAction(this)}), "unknown", true);
        this.e.getPresentation().setTabDraggingEnabled(true);
        this.e.addListener(new TabsListener(){
            private static final long a = com.jetbrains.python.psi.c.a(2771529539961406843L, 7316865433284355964L, MethodHandles.lookup().lookupClass()).a(35168261528394L);

            public void tabRemoved(@NotNull TabInfo tabInfo) {
                if (tabInfo == null) {
                    1.a(0);
                }
                PyPlotToolWindow.this.a(tabInfo);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3F0AD4F97A75L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabInfo", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$1", "tabRemoved"));
            }
        });
        this.add(this.e.getComponent());
    }

    public void init(ToolWindow toolWindow) {
        long l2 = i ^ 0x6CCA99EB8390L;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)this, "Plots", false);
        content2.setCloseable(false);
        toolWindow.getContentManager().addContent(content2);
        if (this.d == null) {
            this.d = new MyDockContainer(toolWindow);
            Disposer.register((Disposable)this.a, (Disposable)this.d);
            DockManager.getInstance((Project)this.a).register((DockContainer)this.d);
        }
    }

    public void addDockableContentFigureFactory(DockableContentFigureFactory factory) {
        this.f.add(factory);
    }

    public int getLastPlotIndex() {
        return this.b;
    }

    public void addFigure(@NotNull Figure figure) {
        long l2 = i ^ 0x204B5C1F215CL;
        if (figure == null) {
            PyPlotToolWindow.a(0);
        }
        TabInfo tabInfo = figure.getTabInfo();
        Object object = figure.hasSearchKey() ? figure.getSearchKey() : null;
        this.c.put(tabInfo, object);
        tabInfo.setTabLabelActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new ClosePlotAction(this, tabInfo)}), "unknown");
        if (figure instanceof WithDockableContent) {
            tabInfo.setDragOutDelegate((TabInfo.DragOutDelegate)new MyDragOutDelegate((WithDockableContent)((Object)figure)));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            TabInfo tabInfo2 = null;
            if (object != null) {
                tabInfo2 = this.a(object);
            }
            if (tabInfo2 == null) {
                this.e.addTab(tabInfo);
                ++this.b;
            } else {
                int n2 = this.e.getIndexOf(tabInfo2);
                this.e.removeTab(tabInfo2);
                this.e.addTab(tabInfo, n2);
            }
            this.e.select(tabInfo, true);
        });
    }

    private TabInfo a(Object object) {
        for (Map.Entry<TabInfo, Object> entry : this.c.entrySet()) {
            Object object2 = entry.getValue();
            if (object2 == null || !object2.equals(object)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void dispose() {
        HashSet<TabInfo> hashSet = new HashSet<TabInfo>(this.c.keySet());
        for (TabInfo tabInfo : hashSet) {
            this.a(tabInfo);
        }
    }

    private void a(TabInfo tabInfo) {
        this.c.remove(tabInfo);
        JComponent jComponent = tabInfo.getComponent();
        if (jComponent instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)jComponent));
        }
    }

    static {
        i = com.jetbrains.python.psi.c.a(8419761235266494383L, 6610087096167624564L, MethodHandles.lookup().lookupClass()).a(179746624549826L);
        h = Logger.getInstance(PyPlotToolWindow.class);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = i ^ 0x2B3EDA85285DL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "figure", "com/jetbrains/python/scientific/figures/PyPlotToolWindow", "addFigure"));
    }

    private class MyDockContainer
    implements DockContainer {
        private final ToolWindow a;
        private static final long b = com.jetbrains.python.psi.c.a(-518109943422285780L, 6351255908496337795L, MethodHandles.lookup().lookupClass()).a(40636211981404L);

        private MyDockContainer(ToolWindow toolWindow) {
            this.a = toolWindow;
        }

        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.a.getComponent());
        }

        public RelativeRectangle getAcceptAreaFallback() {
            return this.getAcceptArea();
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
            if (content2 == null) {
                MyDockContainer.a(0);
            }
            DockContainer.ContentResponse contentResponse = this.a(content2) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                MyDockContainer.a(1);
            }
            return contentResponse;
        }

        public JComponent getContainerComponent() {
            return this.a.getComponent();
        }

        public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
            if (content2 == null) {
                MyDockContainer.a(2);
            }
            Figure figure = this.a(content2).createFigure(content2);
            PyPlotToolWindow.this.addFigure(figure);
        }

        public void closeAll() {
        }

        public void addListener(DockContainer.Listener listener2, Disposable parent) {
        }

        public boolean isEmpty() {
            return false;
        }

        @Nullable
        public Image startDropOver(@NotNull DockableContent content2, RelativePoint point) {
            if (content2 == null) {
                MyDockContainer.a(3);
            }
            return null;
        }

        @Nullable
        public Image processDropOver(@NotNull DockableContent content2, RelativePoint point) {
            if (content2 == null) {
                MyDockContainer.a(4);
            }
            return null;
        }

        public void resetDropOver(@NotNull DockableContent content2) {
            if (content2 == null) {
                MyDockContainer.a(5);
            }
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        public void dispose() {
        }

        public void showNotify() {
        }

        public void hideNotify() {
        }

        private DockableContentFigureFactory a(DockableContent dockableContent) {
            return PyPlotToolWindow.this.f.stream().filter(dockableContentFigureFactory -> dockableContentFigureFactory.isApplicable(dockableContent)).findFirst().orElse(null);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x25288E189565L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDockContainer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startDropOver";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processDropOver";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "resetDropOver";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private final WithDockableContent a;
        private DragSession b;
        private static final long c = com.jetbrains.python.psi.c.a(-6709313225321139749L, 3441992604856217904L, MethodHandles.lookup().lookupClass()).a(129752607260241L);

        private MyDragOutDelegate(WithDockableContent contentFactory) {
            this.a = contentFactory;
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            if (mouseEvent == null) {
                MyDragOutDelegate.a(0);
            }
            if (info == null) {
                MyDragOutDelegate.a(1);
            }
            TabInfo tabInfo = info.getPreviousSelection();
            info.setHidden(true);
            if (tabInfo != null) {
                PyPlotToolWindow.this.e.select(tabInfo, true);
            }
            this.b = this.a().createDragSession(mouseEvent, this.a.createDockableContent());
        }

        private DockManager a() {
            return DockManager.getInstance((Project)PyPlotToolWindow.this.a);
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            if (event == null) {
                MyDragOutDelegate.a(2);
            }
            if (source == null) {
                MyDragOutDelegate.a(3);
            }
            this.b.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
            if (event == null) {
                MyDragOutDelegate.a(4);
            }
            PyPlotToolWindow.this.e.removeTab(source);
            this.b.process(event);
            this.b = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            if (this.b != null) {
                this.b.cancel();
            }
            this.b = null;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x73E7C9D5324BL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDragOutDelegate";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutStarted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDragOut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SaveAsFileAction
    extends AnAction {
        final /* synthetic */ PyPlotToolWindow this$0;
        private static final long a = com.jetbrains.python.psi.c.a(4259870452332819774L, 781364201705312993L, MethodHandles.lookup().lookupClass()).a(68265067284849L);

        private SaveAsFileAction(PyPlotToolWindow pyPlotToolWindow) {
            long l2 = a ^ 0x1413261C31B2L;
            this.this$0 = pyPlotToolWindow;
            super("Save as File");
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = a ^ 0x6069E65A9309L;
            if (e10 == null) {
                SaveAsFileAction.a(0);
            }
            TabInfo tabInfo = this.this$0.e.getSelectedInfo();
            Project project = e10.getProject();
            if (tabInfo != null && project != null) {
                byte[] byArray = FigureUtil.componentToByteArray(tabInfo.getComponent());
                if (byArray == null) {
                    h.error("Can't obtain image content");
                    return;
                }
                FileSaverDescriptor fileSaverDescriptor = new FileSaverDescriptor("Select File to Save Plot", "", new String[]{"png"});
                FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(fileSaverDescriptor, project);
                VirtualFileWrapper virtualFileWrapper = fileSaverDialog.save(project.getBaseDir(), "myplot");
                try {
                    if (virtualFileWrapper != null) {
                        File file = virtualFileWrapper.getFile();
                        Files.write(Paths.get(file.getPath(), new String[0]), byArray, new OpenOption[0]);
                    }
                }
                catch (IOException iOException) {
                    h.warn("Failed to save image " + iOException.getMessage());
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x7E8D2F790F33L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$SaveAsFileAction", "actionPerformed"));
        }
    }

    private class CloseAllPlotsAction
    extends AnAction {
        final /* synthetic */ PyPlotToolWindow this$0;
        private static final long a = com.jetbrains.python.psi.c.a(2526224045942765280L, 5877071909185171656L, MethodHandles.lookup().lookupClass()).a(147055401946515L);

        private CloseAllPlotsAction(PyPlotToolWindow pyPlotToolWindow) {
            long l2 = a ^ 0x371AE7F944F0L;
            this.this$0 = pyPlotToolWindow;
            super("Close All Plots", "Close all plot", null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                CloseAllPlotsAction.a(0);
            }
            this.this$0.e.removeAllTabs();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x375120C064A8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$CloseAllPlotsAction", "actionPerformed"));
        }
    }

    private class ClosePlotAction
    extends AnAction {
        private final TabInfo a;
        final /* synthetic */ PyPlotToolWindow this$0;
        private static final long b = com.jetbrains.python.psi.c.a(-7848165175636610053L, -9094167072412311753L, MethodHandles.lookup().lookupClass()).a(254911845689787L);

        private ClosePlotAction(PyPlotToolWindow pyPlotToolWindow, TabInfo info) {
            long l2 = b ^ 0xF1A77BEC3A3L;
            this.this$0 = pyPlotToolWindow;
            super("Close Plot", "Close selected plot", AllIcons.Actions.Close);
            this.a = info;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ClosePlotAction.a(0);
            }
            this.this$0.e.removeTab(this.a);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x7E2B733310C9L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$ClosePlotAction", "actionPerformed"));
        }
    }

    private static class MyTabsOld
    extends JBEditorTabs {
        private MyTabsOld(Project project) {
            super(project, ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)project);
            this.myDefaultPainter = new DefaultEditorTabsPainter(this){

                public Color getBackgroundColor() {
                    return JBColor.LIGHT_GRAY;
                }
            };
        }

        protected com.intellij.ui.tabs.impl.TabLabel createTabLabel(TabInfo info) {
            return new MyTabLabel((JBTabsImpl)this, info);
        }

        private static class MyTabLabel
        extends com.intellij.ui.tabs.impl.TabLabel {
            private MyTabLabel(JBTabsImpl tabs, TabInfo info) {
                super(tabs, info);
                JComponent jComponent = this.getLabelComponent();
                if (jComponent instanceof SimpleColoredComponent) {
                    ((SimpleColoredComponent)jComponent).setIconOnTheRight(true);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(JBUIScale.scale((int)100), JBUIScale.scale((int)80));
            }
        }
    }

    private static class MyTabLabel
    extends TabLabel {
        private MyTabLabel(com.intellij.ui.tabs.newImpl.JBTabsImpl tabs, TabInfo info) {
            super(tabs, info);
            JComponent jComponent = this.getLabelComponent();
            if (jComponent instanceof SimpleColoredComponent) {
                ((SimpleColoredComponent)jComponent).setIconOnTheRight(true);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(JBUIScale.scale((int)100), JBUIScale.scale((int)80));
        }
    }

    private static class MyTabs
    extends com.intellij.ui.tabs.newImpl.JBEditorTabs {
        private MyTabs(Project project) {
            super(project, ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)project);
        }

        protected TabLabel createTabLabel(TabInfo info) {
            return new MyTabLabel((com.intellij.ui.tabs.newImpl.JBTabsImpl)this, info);
        }
    }
}

