/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySdkUtil {
    protected static final Logger LOG;
    public static final int SUBSTITUTE = 26;
    public static final String PATH_ENV_VARIABLE = "PATH";
    private static final long a;

    private PySdkUtil() {
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, -1);
        if (processOutput == null) {
            PySdkUtil.a(0);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, null, timeout);
        if (processOutput == null) {
            PySdkUtil.a(1);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, extraEnv, timeout, null, true);
        if (processOutput == null) {
            PySdkUtil.a(2);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout, @Nullable byte[] stdin, boolean needEOFMarker) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(new GeneralCommandLine(command), homePath, extraEnv, timeout, stdin, needEOFMarker);
        if (processOutput == null) {
            PySdkUtil.a(3);
        }
        return processOutput;
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        if (cmd == null) {
            PySdkUtil.a(4);
        }
        return PySdkUtil.getProcessOutput(cmd, homePath, extraEnv, timeout, null, true);
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath, @Nullable @NonNls Map<String, String> extraEnv, int timeout, @Nullable byte[] stdin, boolean needEOFMarker) {
        long l2 = a ^ 0x3B9CC52CBCE4L;
        if (cmd == null) {
            PySdkUtil.a(5);
        }
        if (homePath == null || !new File(homePath).exists()) {
            return new ProcessOutput();
        }
        Map<String, String> map2 = System.getenv();
        Map<String, String> map3 = PySdkUtil.mergeEnvVariables(map2, cmd.getEnvironment());
        Map<String, String> map4 = extraEnv != null ? PySdkUtil.mergeEnvVariables(map3, extraEnv) : map3;
        PythonEnvUtil.resetHomePathChanges(homePath, map4);
        try {
            OutputStream outputStream2;
            CommandLinePatcher commandLinePatcher;
            GeneralCommandLine generalCommandLine = cmd.withWorkDirectory(homePath).withEnvironment(map4);
            PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(generalCommandLine.getExePath());
            CommandLinePatcher commandLinePatcher2 = commandLinePatcher = pythonSdkFlavor != null ? pythonSdkFlavor.commandLinePatcher() : null;
            if (commandLinePatcher != null) {
                commandLinePatcher.patchCommandLine(cmd);
            }
            CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(generalCommandLine);
            if (stdin != null) {
                outputStream2 = capturingProcessHandler.getProcessInput();
                assert (outputStream2 != null);
                outputStream2.write(stdin);
                if (SystemInfo.isWindows && needEOFMarker) {
                    outputStream2.write(26);
                    outputStream2.flush();
                } else {
                    outputStream2.close();
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                outputStream2 = ProgressManager.getInstance();
                assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "Background task can't be run under write action";
                return (ProcessOutput)outputStream2.runProcessWithProgressSynchronously(() -> capturingProcessHandler.runProcess(timeout), "Wait...", false, null);
            }
            return capturingProcessHandler.runProcess();
        }
        catch (ExecutionException | IOException throwable) {
            return PySdkUtil.a((Exception)throwable);
        }
    }

    private static ProcessOutput a(final Exception exception) {
        LOG.warn((Throwable)exception);
        return new ProcessOutput(){
            private static final long a = c.a(-7959723228707097464L, 1273177842881896829L, MethodHandles.lookup().lookupClass()).a(213815318619193L);

            @NotNull
            public String getStderr() {
                String string = super.getStderr();
                string = !StringUtil.isEmpty((String)string) ? string + "\n" + exception.getMessage() : exception.getMessage();
                String string2 = string;
                if (string2 == null) {
                    1.a(0);
                }
                return string2;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xB976C1C315BL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil$1", "getStderr"));
            }
        };
    }

    @NotNull
    public static Map<String, String> mergeEnvVariables(@NotNull Map<String, String> environment, @NotNull Map<String, String> extraEnvironment) {
        long l2 = a ^ 0x7A15C45F89BCL;
        if (environment == null) {
            PySdkUtil.a(6);
        }
        if (extraEnvironment == null) {
            PySdkUtil.a(7);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(environment);
        for (Map.Entry<String, String> entry : extraEnvironment.entrySet()) {
            String string = entry.getKey();
            if (PATH_ENV_VARIABLE.equals(string) || "PYTHONPATH".equals(string)) {
                PythonEnvUtil.addPathToEnv(hashMap, string, entry.getValue());
                continue;
            }
            hashMap.put(string, entry.getValue());
        }
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            PySdkUtil.a(8);
        }
        return hashMap2;
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData;
    }

    public static String getUserSite() {
        long l2 = a ^ 0x781015C98319L;
        if (SystemInfo.isWindows) {
            String string = System.getenv("APPDATA");
            return string + File.separator + "Python";
        }
        String string = SystemProperties.getUserHome();
        return string + File.separator + ".local";
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        Sdk sdk;
        VirtualFile virtualFile2;
        PsiFile psiFile;
        if (element == null) {
            PySdkUtil.a(9);
        }
        return (psiFile = element.getContainingFile()) != null && (virtualFile2 = psiFile.getVirtualFile()) != null && (sdk = PythonSdkType.findPythonSdk(element)) != null && (virtualFile = PySdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false);
    }

    public static String getRemoteSourcesLocalPath(String sdkHome) {
        long l2 = a ^ 0x504F0884DC39L;
        String string = File.separator;
        String string2 = PathManager.getSystemPath();
        return string2 + File.separator + "remote_sources" + string + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + string;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        long l2 = a ^ 0x728A40CB8FCCL;
        if (sdk == null) {
            PySdkUtil.a(10);
        }
        return PySdkUtil.a(sdk, "python_stubs", PythonSdkType.BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        long l2 = a ^ 0x2F03F58BECE0L;
        if (sdk == null) {
            PySdkUtil.a(11);
        }
        return PySdkUtil.a(sdk, "remote_sources", OrderRootType.CLASSES);
    }

    private static VirtualFile a(Sdk sdk, String string, OrderRootType orderRootType) {
        VirtualFile[] virtualFileArray;
        for (VirtualFile virtualFile : virtualFileArray = sdk.getRootProvider().getFiles(orderRootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(string)) continue;
            return virtualFile;
        }
        return null;
    }

    static {
        a = c.a(6179933584792478624L, -4632674008164096653L, MethodHandles.lookup().lookupClass()).a(246764285470316L);
        long l2 = a ^ 0x50275124B847L;
        LOG = Logger.getInstance((String)"#com.jetbrains.python.sdk.SdkVersionUtil");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6AD2301372D9L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvironment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeEnvVariables";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeEnvVariables";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isElementInSkeletons";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnyRemoteLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

