/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnvUtil {
    public static final String PYTHONPATH = "PYTHONPATH";
    public static final String PYTHONUNBUFFERED = "PYTHONUNBUFFERED";
    public static final String PYTHONIOENCODING = "PYTHONIOENCODING";
    public static final String IPYTHONENABLE = "IPYTHONENABLE";
    public static final String PYTHONDONTWRITEBYTECODE = "PYTHONDONTWRITEBYTECODE";
    public static final String PYVENV_LAUNCHER = "__PYVENV_LAUNCHER__";
    private static final long a = c.a(4784619378245383589L, 1870330102050241667L, MethodHandles.lookup().lookupClass()).a(210298933392371L);

    private PythonEnvUtil() {
    }

    public static Map<String, String> setPythonUnbuffered(@NotNull Map<String, String> env) {
        long l2 = a ^ 0x5392A26D2D24L;
        if (env == null) {
            PythonEnvUtil.a(0);
        }
        env.put(PYTHONUNBUFFERED, "1");
        return env;
    }

    public static Map<String, String> setPythonIOEncoding(@NotNull Map<String, String> env, @NotNull String encoding) {
        long l2 = a ^ 0x2676C6AD5FB1L;
        if (env == null) {
            PythonEnvUtil.a(1);
        }
        if (encoding == null) {
            PythonEnvUtil.a(2);
        }
        env.put(PYTHONIOENCODING, encoding);
        return env;
    }

    public static Map<String, String> resetHomePathChanges(@NotNull String homePath, @NotNull Map<String, String> env) {
        long l2 = a ^ 0x5142FCA215F4L;
        if (homePath == null) {
            PythonEnvUtil.a(3);
        }
        if (env == null) {
            PythonEnvUtil.a(4);
        }
        if (System.getenv(PYVENV_LAUNCHER) != null || EnvironmentUtil.getEnvironmentMap().containsKey(PYVENV_LAUNCHER)) {
            env.put(PYVENV_LAUNCHER, homePath);
        }
        return env;
    }

    @NotNull
    public static String addToPathEnvVar(@Nullable String source, @NotNull String value, boolean asPrefix) {
        if (value == null) {
            PythonEnvUtil.a(5);
        }
        if (StringUtil.isEmpty((String)source)) {
            String string = value;
            if (string == null) {
                PythonEnvUtil.a(6);
            }
            return string;
        }
        HashSet hashSet = Sets.newHashSet((Object[])source.split(File.pathSeparator));
        if (!hashSet.contains(value)) {
            if (asPrefix) {
                String string = value + File.pathSeparator + source;
                if (string == null) {
                    PythonEnvUtil.a(7);
                }
                return string;
            }
            String string = source + File.pathSeparator + value;
            if (string == null) {
                PythonEnvUtil.a(8);
            }
            return string;
        }
        String string = source;
        if (string == null) {
            PythonEnvUtil.a(9);
        }
        return string;
    }

    public static void addPathsToEnv(@NotNull Map<String, String> env, String key, @NotNull Collection<String> values) {
        if (env == null) {
            PythonEnvUtil.a(10);
        }
        if (values == null) {
            PythonEnvUtil.a(11);
        }
        for (String string : values) {
            PythonEnvUtil.addPathToEnv(env, key, string);
        }
    }

    public static void addPathToEnv(@NotNull Map<String, String> env, String key, String value) {
        if (env == null) {
            PythonEnvUtil.a(12);
        }
        if (!StringUtil.isEmpty((String)value)) {
            if (env.containsKey(key)) {
                env.put(key, PythonEnvUtil.addToPathEnvVar(env.get(key), value, false));
            } else {
                env.put(key, value);
            }
        }
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, @NotNull Collection<String> values) {
        long l2 = a ^ 0x13E719939C29L;
        if (env == null) {
            PythonEnvUtil.a(13);
        }
        if (values == null) {
            PythonEnvUtil.a(14);
        }
        PythonEnvUtil.addPathsToEnv(env, PYTHONPATH, values);
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, String value) {
        long l2 = a ^ 0x6C83EC40C76DL;
        if (env == null) {
            PythonEnvUtil.a(15);
        }
        PythonEnvUtil.addPathToEnv(env, PYTHONPATH, value);
    }

    public static void mergePythonPath(@NotNull Map<String, String> from, @NotNull Map<String, String> to) {
        String string;
        long l2 = a ^ 0x6A6913F8B867L;
        if (from == null) {
            PythonEnvUtil.a(16);
        }
        if (to == null) {
            PythonEnvUtil.a(17);
        }
        if ((string = from.get(PYTHONPATH)) != null) {
            HashSet hashSet = Sets.newHashSet((Object[])string.split(File.pathSeparator));
            PythonEnvUtil.addToPythonPath(to, hashSet);
        }
    }

    @NotNull
    public static Map<String, String> setPythonDontWriteBytecode(@NotNull Map<String, String> env) {
        long l2 = a ^ 0xF32C26F8C9DL;
        if (env == null) {
            PythonEnvUtil.a(18);
        }
        env.put(PYTHONDONTWRITEBYTECODE, "1");
        Map<String, String> map2 = env;
        if (map2 == null) {
            PythonEnvUtil.a(19);
        }
        return map2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6098184C49CEL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addToPathEnvVar";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setPythonDontWriteBytecode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPythonUnbuffered";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPythonIOEncoding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetHomePathChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addToPathEnvVar";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPathsToEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPathToEnv";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mergePythonPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setPythonDontWriteBytecode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

