/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyRemoteSdkValidator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import icons.PythonIcons;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    private static final Logger j;
    private static final String[] b;
    private static final int a = 60000;
    @NonNls
    private static final String e = "Skeletons";
    private static final String[] i;
    private static final String[] g;
    private static final String[] c;
    private static final Key<WeakReference<Component>> d;
    private static final Predicate<Sdk> f;
    private static final Key<Map<String, String>> h;
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE;
    private static final long k;

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        long l2 = k ^ 0x359334F948B0L;
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        long l2 = k ^ 0x663E3BE2C0B4L;
        if ("reference.project.structure.sdk.python" == null) {
            PythonSdkType.a(0);
        }
        return "reference.project.structure.sdk.python";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = PythonFileType.INSTANCE.getIcon();
        if (icon == null) {
            PythonSdkType.a(1);
        }
        return icon;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        LanguageLevel languageLevel;
        long l2 = k ^ 0x547BE5241214L;
        if (sdk == null) {
            PythonSdkType.a(2);
        }
        String string = (languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk)).isPython2() ? "__builtin__.py" : "builtins.py";
        if (string == null) {
            PythonSdkType.a(3);
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        List<PyDetectedSdk> list2 = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(sdkArray));
        PyDetectedSdk pyDetectedSdk = StreamEx.of(list2).findFirst().orElse(null);
        if (pyDetectedSdk != null) {
            return pyDetectedSdk.getHomePath();
        }
        return null;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return PythonSdkFlavor.getFlavor(path) != null;
    }

    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(4);
        }
        if (PythonSdkType.isRemote(sdk)) {
            return PyRemoteSdkValidator.Companion.isInvalid(sdk);
        }
        VirtualFile virtualFile = sdk.getHomeDirectory();
        return virtualFile == null || !virtualFile.exists();
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return PySdkUtil.isRemote(sdk);
    }

    public static boolean isVagrant(@Nullable Sdk sdk) {
        if (sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return pyRemoteSdkAdditionalDataBase.connectionCredentials().getRemoteConnectionType() == CredentialsType.VAGRANT;
        }
        return false;
    }

    public static boolean isRemote(@Nullable String sdkPath) {
        return PythonSdkType.isRemote(PythonSdkType.findSdkByPath(sdkPath));
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        long l2 = k ^ 0x2FDB5763DC7BL;
        final boolean bl2 = SystemInfo.isWindows;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){
            private static final long a = com.jetbrains.python.psi.c.a(-4023292312527090992L, -96514771929893451L, MethodHandles.lookup().lookupClass()).a(137424774530782L);

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) throws Exception {
                long l2 = a ^ 0x2632D9801530L;
                if (files2 == null) {
                    1.a(0);
                }
                if (files2.length != 0 && !PythonSdkType.this.isValidSdkHome(files2[0].getPath())) {
                    throw new Exception(PyBundle.message("sdk.error.invalid.interpreter.name.$0", files2[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && bl2) {
                    String string = file.getPath();
                    boolean bl22 = false;
                    for (String string2 : b) {
                        if (!string.endsWith(string2)) continue;
                        bl22 = true;
                        break;
                    }
                    return bl22 && super.isFileVisible(file, showHiddenFiles);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x370C983C0B59L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor == null) {
            PythonSdkType.a(5);
        }
        return fileChooserDescriptor;
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.a(6);
        }
        if (parentComponent == null) {
            PythonSdkType.a(7);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.a(8);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, Arrays.asList(sdkModel.getSdks()), sdk -> {
            if (sdk != null) {
                sdk.putUserData(d, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk);
            }
        });
    }

    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(9);
        }
        String string = sdk.getHomePath();
        return PythonSdkType.isVirtualEnv(string);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path) {
        return path != null && PythonSdkType.getVirtualEnvRoot(path) != null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(10);
        }
        return PyCondaPackageManagerImpl.isConda(sdk);
    }

    public static boolean isConda(@Nullable String sdkPath) {
        return PyCondaPackageManagerImpl.isConda(sdkPath);
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(11);
        }
        return PyCondaPackageManagerImpl.isCondaVirtualEnv(sdk);
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkType.isVirtualEnv(sdk)) {
            PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk);
            String string = this.getVersionString(sdk);
            if (pythonSdkFlavor != null && string != null) {
                for (Sdk sdk2 : PythonSdkType.getAllSdks()) {
                    if (PythonSdkType.isRemote(sdk2)) continue;
                    PythonSdkFlavor pythonSdkFlavor2 = PythonSdkFlavor.getFlavor(sdk2);
                    if (PythonSdkType.isVirtualEnv(sdk2) || !pythonSdkFlavor.equals(pythonSdkFlavor2) || !string.equals(this.getVersionString(sdk2))) continue;
                    return sdk2;
                }
            }
        }
        return null;
    }

    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String string;
        File file;
        long l2 = k ^ 0x23B3C91CE80L;
        if (binaryPath == null) {
            PythonSdkType.a(12);
        }
        if ((file = new File(binaryPath).getParentFile()) != null && (string = file.getParent()) != null) {
            File file2;
            File file3 = new File(string);
            File file4 = new File(file, "activate_this.py");
            if (file4.exists() && (file2 = PythonSdkType.findExecutableFile(file, "activate")) != null) {
                return file3;
            }
            if (new File(file3, "pyvenv.cfg").exists()) {
                return file3;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file;
        if (SystemInfo.isWindows) {
            for (String string : b) {
                File file2 = new File(parent, name + "." + string);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name)).exists()) {
            return file;
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome, boolean passParentEnvironment) {
        long l2 = k ^ 0x4A26AF142B9AL;
        Map<String, String> map2 = PythonSdkType.activateVirtualEnv(sdkHome);
        if (!map2.isEmpty()) {
            Map map3 = commandLine.getEnvironment();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (map3.containsKey(string)) {
                    if (!string.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar((String)map3.get(string), string2, false);
                    continue;
                }
                map3.put(string, string2);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        long l2 = k ^ 0x278ECB79C4E5L;
        String string = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File file = PythonSdkType.getVirtualEnvRoot(sdkHome);
        if (file != null) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)file.getAbsolutePath());
            String string3 = string + " virtualenv at " + string2;
            if (string3 == null) {
                PythonSdkType.a(13);
            }
            return string3;
        }
        String string4 = string;
        if (string4 == null) {
            PythonSdkType.a(14);
        }
        return string4;
    }

    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor pythonSdkFlavor;
        if (sdkHome == null) {
            PythonSdkType.a(15);
        }
        if ((pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return pythonSdkFlavor.getName() + " " + (Object)((Object)pythonSdkFlavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.a(16);
        }
        if (sdkModificator == null) {
            PythonSdkType.a(17);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.a(18);
        }
        if (additional == null) {
            PythonSdkType.a(19);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        Object object;
        if (currentSdk == null) {
            PythonSdkType.a(20);
        }
        if (additional == null) {
            PythonSdkType.a(21);
        }
        if (RemoteSdkCredentialsHolder.isRemoteSdk((String)currentSdk.getHomePath()) && (object = PythonRemoteInterpreterManager.getInstance()) != null) {
            return ((PythonRemoteInterpreterManager)object).loadRemoteSdkData(currentSdk, additional);
        }
        object = PyPipEnvSdkAdditionalData.load(additional);
        if (object != null) {
            return object;
        }
        return PythonSdkAdditionalData.load(currentSdk, additional);
    }

    public static boolean isSkeletonsPath(String path) {
        long l2 = k ^ 0x4DD6E1C3D202L;
        return path.contains(SKELETON_DIR_NAME);
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        long l2 = k ^ 0x136F7A1920C7L;
        if ("Python SDK" == null) {
            PythonSdkType.a(22);
        }
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile virtualFile;
        String string;
        PythonSdkFlavor pythonSdkFlavor;
        if (homePath == null) {
            PythonSdkType.a(23);
        }
        if ((pythonSdkFlavor = PythonSdkFlavor.getFlavor(string = super.sdkPath(homePath))) != null && (virtualFile = pythonSdkFlavor.getSdkPath(homePath)) != null) {
            String string2 = FileUtil.toSystemDependentName((String)virtualFile.getPath());
            if (string2 == null) {
                PythonSdkType.a(24);
            }
            return string2;
        }
        String string3 = FileUtil.toSystemDependentName((String)string);
        if (string3 == null) {
            PythonSdkType.a(25);
        }
        return string3;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        WeakReference weakReference;
        Component component;
        if (sdk == null) {
            PythonSdkType.a(26);
        }
        Project project = (component = (Component)SoftReference.dereference((Reference)(weakReference = (WeakReference)sdk.getUserData(d)))) != null ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component)) : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        PythonSdkUpdater.updateOrShowError(sdk, null, project, component);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            PythonSdkType.a(27);
        }
        if (sdkModel == null) {
            PythonSdkType.a(28);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e10, @Nullable Runnable restartAction) {
        String string;
        NotificationListener notificationListener;
        long l2 = k ^ 0x6854469196A1L;
        if (e10.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, hyperlinkEvent) -> {
                PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
                if (pythonRemoteInterpreterManager != null) {
                    try {
                        VagrantNotStartedException vagrantNotStartedException = (VagrantNotStartedException)e10.getCause();
                        pythonRemoteInterpreterManager.runVagrant(vagrantNotStartedException.getVagrantFolder(), vagrantNotStartedException.getMachineName());
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            string = e10.getMessage() + "\n<a href=\"#\">Launch vagrant and refresh skeletons</a>";
        } else if (ExceptionUtil.causedBy((Throwable)e10, ExceptionFix.class)) {
            ExceptionFix exceptionFix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e10, ExceptionFix.class);
            notificationListener = (notification2, hyperlinkEvent) -> {
                exceptionFix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            string = exceptionFix.getNotificationMessage(e10.getMessage());
        } else {
            notificationListener = null;
            string = e10.getMessage();
        }
        Notifications.Bus.notify((Notification)new Notification(e, "Couldn't refresh skeletons for remote interpreter", string, NotificationType.WARNING, notificationListener));
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path) {
        VirtualFile virtualFile;
        String string;
        long l2 = k ^ 0x3C39AF108C86L;
        if (path == null) {
            PythonSdkType.a(29);
        }
        if ((string = path.getExtension()) != null) {
            string = StringUtil.toLowerCase((String)string);
        }
        if (!path.isDirectory() && ("zip".equals(string) || "egg".equals(string)) && (virtualFile = JarFileSystem.getInstance().getJarRootForLocalFile(path)) != null) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                PythonSdkType.a(30);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = path;
        if (virtualFile3 == null) {
            PythonSdkType.a(31);
        }
        return virtualFile3;
    }

    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String string = File.separator;
        return PythonSdkType.getSkeletonsRootPath(basePath) + string + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + string;
    }

    public static String getSkeletonsRootPath(String basePath) {
        long l2 = k ^ 0x16FD3BF26F7BL;
        return basePath + File.separator + SKELETON_DIR_NAME;
    }

    @NotNull
    public static List<String> getSysPath(String bin_path) throws InvalidSdkException {
        String string = new File(bin_path).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && (!application.isUnitTestMode() || ApplicationInfoImpl.isInStressTest())) {
            List<String> list2 = PythonSdkType.getSysPathsFromScript(bin_path);
            if (list2 == null) {
                PythonSdkType.a(32);
            }
            return list2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PythonSdkType.a(33);
        }
        return arrayList2;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull String binaryPath) throws InvalidSdkException {
        GeneralCommandLine generalCommandLine;
        ProcessOutput processOutput;
        long l2 = k ^ 0x29C4E1C5FDD1L;
        if (binaryPath == null) {
            PythonSdkType.a(34);
        }
        if (!(processOutput = PySdkUtil.getProcessOutput(generalCommandLine = PythonHelper.SYSPATH.newCommandLine(binaryPath, (List<String>)Lists.newArrayList()), new File(binaryPath).getParent(), PythonSdkType.activateVirtualEnv(binaryPath), 60000)).checkSuccess(j)) {
            throw new InvalidSdkException(String.format("Failed to determine Python's sys.path value:\nSTDOUT: %s\nSTDERR: %s", processOutput.getStdout(), processOutput.getStderr()));
        }
        List list2 = processOutput.getStdoutLines();
        if (list2 == null) {
            PythonSdkType.a(35);
        }
        return list2;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        long l2 = k ^ 0x6F28EBF591CCL;
        if (sdk == null) {
            PythonSdkType.a(36);
        }
        if (PythonSdkType.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            assert (pyRemoteSdkAdditionalDataBase != null);
            String string = pyRemoteSdkAdditionalDataBase.getVersionString();
            if (StringUtil.isEmpty((String)string)) {
                PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
                if (pythonRemoteInterpreterManager != null) {
                    try {
                        string = pythonRemoteInterpreterManager.getInterpreterVersion(null, pyRemoteSdkAdditionalDataBase);
                    }
                    catch (Exception exception) {
                        j.warn("Couldn't get interpreter version:" + exception.getMessage(), (Throwable)exception);
                        string = "undefined";
                    }
                }
                pyRemoteSdkAdditionalDataBase.setVersionString(string);
            }
            return string;
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdkHome);
        return pythonSdkFlavor != null ? pythonSdkFlavor.getVersionString(sdkHome) : null;
    }

    public static List<Sdk> getAllSdks() {
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module2) {
        Facet[] facetArray;
        if (module2 == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            return sdk;
        }
        for (Facet facet : facetArray = FacetManager.getInstance((Module)module2).getAllFacets()) {
            FacetConfiguration facetConfiguration = facet.getConfiguration();
            if (!(facetConfiguration instanceof PythonFacetSettings)) continue;
            return ((PythonFacetSettings)facetConfiguration).getSdk();
        }
        return null;
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.a(37);
        }
        return PythonSdkType.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkType.findSdkByPath(PythonSdkType.getAllSdks(), path);
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor pythonSdkFlavor;
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType && (pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            LanguageLevel languageLevel = pythonSdkFlavor.getLanguageLevel(sdk);
            if (languageLevel == null) {
                PythonSdkType.a(38);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkType.a(39);
        }
        return languageLevel;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            PythonSdkType.a(40);
        }
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(41);
        }
        if (PySdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile virtualFile = sdk.getHomeDirectory();
        return virtualFile != null && virtualFile.isValid();
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk2) {
        long l2 = k ^ 0x308C2C700081L;
        if (vFile == null) {
            PythonSdkType.a(42);
        }
        if (pythonSdk2 != null) {
            Object object;
            VirtualFile virtualFile = vFile;
            Object object2 = vFile.getPath();
            boolean bl2 = false;
            PySkeletonRefresher.SkeletonHeader skeletonHeader = PythonSdkType.a(virtualFile, pythonSdk2);
            if (skeletonHeader != null) {
                if (ApplicationManager.getApplication().isUnitTestMode() && Objects.equals(vFile.getParent(), PySdkUtil.findSkeletonsDir(pythonSdk2))) {
                    return true;
                }
                object = skeletonHeader.getBinaryFile();
                if (((String)object).equals("(built-in)") || ((String)object).equals("(pre-generated)")) {
                    return true;
                }
                if (PythonSdkType.isRemote(pythonSdk2)) {
                    bl2 = true;
                    virtualFile = null;
                } else {
                    virtualFile = VfsUtil.findFileByIoFile((File)new File((String)object), (boolean)true);
                }
                object2 = object;
            }
            if (virtualFile != null) {
                virtualFile = (VirtualFile)ObjectUtils.notNull((Object)virtualFile.getCanonicalFile(), (Object)virtualFile);
                object2 = virtualFile.getPath();
            }
            if ((object = PyProjectScopeBuilder.findLibDir(pythonSdk2)) != null && PythonSdkType.a(virtualFile, (String)object2, (VirtualFile)object, pythonSdk2, bl2)) {
                return true;
            }
            VirtualFile virtualFile2 = PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2);
            if (virtualFile2 != null && PythonSdkType.a(virtualFile, (String)object2, virtualFile2, pythonSdk2, bl2)) {
                return true;
            }
            if (PyUserSkeletonsUtil.isStandardLibrarySkeleton(vFile)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile) && PyTypeShed.INSTANCE.isInside(vFile)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PySkeletonRefresher.SkeletonHeader a(@NotNull VirtualFile virtualFile, @NotNull Sdk sdk) {
        VirtualFile virtualFile2;
        if (virtualFile == null) {
            PythonSdkType.a(43);
        }
        if (sdk == null) {
            PythonSdkType.a(44);
        }
        if ((virtualFile2 = PySdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) {
            return PySkeletonRefresher.readSkeletonHeader(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        }
        return null;
    }

    @NotNull
    private static String a(@NotNull String string, @NotNull Sdk sdk) {
        RemoteSdkAdditionalData remoteSdkAdditionalData;
        if (string == null) {
            PythonSdkType.a(45);
        }
        if (sdk == null) {
            PythonSdkType.a(46);
        }
        if ((remoteSdkAdditionalData = PyUtil.as(sdk.getSdkAdditionalData(), RemoteSdkAdditionalData.class)) != null) {
            String string2 = remoteSdkAdditionalData.getPathMappings().convertToRemote(string);
            if (string2 == null) {
                PythonSdkType.a(47);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            PythonSdkType.a(48);
        }
        return string3;
    }

    private static boolean a(@Nullable VirtualFile virtualFile, @NotNull String string, @NotNull VirtualFile virtualFile2, @NotNull Sdk sdk, boolean bl2) {
        String string2;
        VirtualFile virtualFile3;
        long l2 = k ^ 0x1FF352F847FAL;
        if (string == null) {
            PythonSdkType.a(49);
        }
        if (virtualFile2 == null) {
            PythonSdkType.a(50);
        }
        if (sdk == null) {
            PythonSdkType.a(51);
        }
        if (bl2) {
            virtualFile3 = virtualFile2;
            string2 = PythonSdkType.a(virtualFile3.getPath(), sdk);
        } else {
            virtualFile3 = (VirtualFile)ObjectUtils.notNull((Object)virtualFile2.getCanonicalFile(), (Object)virtualFile2);
            string2 = virtualFile3.getPath();
        }
        if (bl2 || virtualFile == null) {
            String string3 = FileUtil.toSystemIndependentName((String)string2);
            String string4 = string3 + "/" + "site-packages";
            String string5 = FileUtil.toSystemIndependentName((String)string);
            return FileUtil.startsWith((String)string5, (String)string3) && !FileUtil.startsWith((String)string5, (String)string4);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile, (boolean)false)) {
            VirtualFile virtualFile4 = virtualFile3.findChild("site-packages");
            return virtualFile4 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile4, (VirtualFile)virtualFile, (boolean)false);
        }
        return false;
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk2) {
        long l2 = k ^ 0x3370829A4259L;
        if (pythonSdk2 == null) {
            PythonSdkType.a(52);
        }
        VirtualFile virtualFile = PythonSdkType.isVirtualEnv(pythonSdk2) ? PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2) : PyProjectScopeBuilder.findLibDir(pythonSdk2);
        return virtualFile != null ? virtualFile.findChild("site-packages") : null;
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module2) {
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        if (sdk != null && PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) {
            return sdk;
        }
        return PythonSdkType.findPython2Sdk(PythonSdkType.getAllSdks());
    }

    @Nullable
    public static Sdk findPython2Sdk(@NotNull List<? extends Sdk> sdks) {
        if (sdks == null) {
            PythonSdkType.a(53);
        }
        for (Sdk sdk : ContainerUtil.sorted(sdks, (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (!PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module2) {
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        if (sdk != null && !PythonSdkType.isRemote(sdk) && PythonSdkFlavor.getFlavor(sdk) instanceof CPythonSdkFlavor) {
            return sdk;
        }
        for (Sdk sdk2 : ContainerUtil.sorted(PythonSdkType.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkType.isRemote(sdk2)) continue;
            return sdk2;
        }
        return null;
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkType.getAllSdks().stream().filter(f.negate()).collect(Collectors.toList());
    }

    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        File file;
        if (rootPath == null) {
            PythonSdkType.a(54);
        }
        if ((file = new File(rootPath)).isFile()) {
            return file.getAbsolutePath();
        }
        for (String string : i) {
            File file2 = StringUtil.isEmpty((String)string) ? file : new File(file, string);
            if (!file2.isDirectory()) continue;
            for (String string2 : PythonSdkType.a()) {
                File file3 = new File(file2, string2);
                if (!file3.isFile()) continue;
                return file3.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        String string;
        File file;
        File file2;
        long l2 = k ^ 0x5246333AB702L;
        if (homeDirectory == null) {
            PythonSdkType.a(55);
        }
        if (name == null) {
            PythonSdkType.a(56);
        }
        if ((file2 = (file = new File(homeDirectory)).getParentFile()) == null) {
            return null;
        }
        File file3 = new File(file2, name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        file3 = new File(new File(file2, "Scripts"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        file3 = new File(new File(file2.getParentFile(), "Scripts"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        file3 = new File(new File(file2.getParentFile(), "local"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        file3 = new File(new File(new File(file2.getParentFile(), "local"), "bin"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        if (FileSystemUtil.isSymLink((String)homeDirectory) && (string = FileSystemUtil.resolveSymLink((String)homeDirectory)) != null) {
            return PythonSdkType.getExecutablePath(string, name);
        }
        file3 = new File(new File("/usr", "bin"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        file3 = new File(new File(new File("/usr", "local"), "bin"), name);
        if (file3.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(file3.getPath());
        }
        return null;
    }

    private static String[] a() {
        if (SystemInfo.isUnix) {
            return g;
        }
        return c;
    }

    public static boolean isIncompleteRemote(Sdk sdk) {
        return PySdkUtil.isRemote(sdk) && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            PythonSdkType.a(57);
        }
        return (sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase && ((PyRemoteSdkAdditionalDataBase)sdkAdditionalData).isRunAsRootViaSudo();
    }

    public static boolean hasInvalidRemoteCredentials(Sdk sdk) {
        if (PySdkUtil.isRemote(sdk)) {
            final Ref ref = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    ref.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase[]{new CredentialsCase.Vagrant(){

                public void process(VagrantBasedCredentialsHolder cred) {
                    ref.set((Object)StringUtil.isEmpty((String)cred.getVagrantFolder()));
                }
            }}));
            return (Boolean)ref.get();
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static Sdk getSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.a(58);
        }
        return PythonSdkType.findPythonSdk(element);
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(59);
        }
        String string = sdk.getName();
        if (string == null) {
            PythonSdkType.a(60);
        }
        return string;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkType.a(61);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.a(62);
        }
        return !PythonSdkType.isRemote(sdk);
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull Sdk sdk) {
        Map map2;
        if (sdk == null) {
            PythonSdkType.a(63);
        }
        if ((map2 = (Map)sdk.getUserData(h)) != null) {
            Map map3 = map2;
            if (map3 == null) {
                PythonSdkType.a(64);
            }
            return map3;
        }
        String string = sdk.getHomePath();
        if (string == null) {
            Map<String, String> map4 = Collections.emptyMap();
            if (map4 == null) {
                PythonSdkType.a(65);
            }
            return map4;
        }
        Map<String, String> map5 = PythonSdkType.activateVirtualEnv(string);
        sdk.putUserData(h, map5);
        Map<String, String> map6 = map5;
        if (map6 == null) {
            PythonSdkType.a(66);
        }
        return map6;
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        PyVirtualEnvReader pyVirtualEnvReader;
        long l2 = k ^ 0x29BA07BE008BL;
        if (sdkHome == null) {
            PythonSdkType.a(67);
        }
        if ((pyVirtualEnvReader = new PyVirtualEnvReader(sdkHome)).getActivate() != null) {
            Map<String, String> map2;
            try {
                map2 = Collections.unmodifiableMap(PyVirtualEnvReader.Companion.filterVirtualEnvVars(pyVirtualEnvReader.readPythonEnv()));
            }
            catch (Exception exception) {
                j.error("Couldn't read virtualenv variables", (Throwable)exception);
            }
            if (map2 == null) {
                PythonSdkType.a(68);
            }
            return map2;
        }
        Map<String, String> map3 = Collections.emptyMap();
        if (map3 == null) {
            PythonSdkType.a(69);
        }
        return map3;
    }

    static {
        k = com.jetbrains.python.psi.c.a(-3781065213232576486L, 2986134472402344003L, MethodHandles.lookup().lookupClass()).a(138408617267122L);
        long l2 = k ^ 0x6E8B109286C3L;
        j = Logger.getInstance(PythonSdkType.class);
        b = new String[]{"cmd", "exe", "bat", "com"};
        i = new String[]{"", "bin", "Scripts", "net45"};
        g = new String[]{"jython", "pypy", "python", "python3"};
        c = new String[]{"jython.bat", "ipy.exe", "pypy.exe", "python.exe", "python3.exe"};
        d = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
        f = PythonSdkType::isRemote;
        h = Key.create((String)"ENVIRONMENT_KEY");
        BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x224C633803F3L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 36: 
            case 41: 
            case 46: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 15: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 29: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPathsFromScript";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToRemote";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSysPathsFromScript";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isUnderLibDirButNotSitePackages";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findPython2Sdk";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSdk";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 63: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

