/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.MacPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyPySdkFlavor;
import com.jetbrains.python.sdk.flavors.PyRemoteSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonFlavorProvider;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor {
    private static final Pattern a;
    private static final Logger b;
    private static final long h;

    public static Collection<String> appendSystemPythonPath(@NotNull Collection<String> pythonPath) {
        long l2 = h ^ 0x473F2832EA5DL;
        if (pythonPath == null) {
            PythonSdkFlavor.a(0);
        }
        return PythonSdkFlavor.appendSystemEnvPaths(pythonPath, "PYTHONPATH");
    }

    protected static Collection<String> appendSystemEnvPaths(@NotNull Collection<String> pythonPath, String envname) {
        String string;
        if (pythonPath == null) {
            PythonSdkFlavor.a(1);
        }
        if ((string = System.getenv(envname)) != null) {
            pythonPath.addAll(Lists.newArrayList((Object[])string.split(File.pathSeparator)));
        }
        return pythonPath;
    }

    public static void initPythonPath(@NotNull Map<String, String> envs, boolean passParentEnvs, @NotNull Collection<String> pythonPathList) {
        long l2 = h ^ 0x359D3C31ABD4L;
        if (envs == null) {
            PythonSdkFlavor.a(2);
        }
        if (pythonPathList == null) {
            PythonSdkFlavor.a(3);
        }
        if (passParentEnvs && !envs.containsKey("PYTHONPATH")) {
            pythonPathList = PythonSdkFlavor.appendSystemPythonPath(pythonPathList);
        }
        PythonEnvUtil.addToPythonPath(envs, pythonPathList);
    }

    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        return Collections.emptyList();
    }

    public static List<PythonSdkFlavor> getApplicableFlavors() {
        return PythonSdkFlavor.getApplicableFlavors(true);
    }

    public static List<PythonSdkFlavor> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList<PythonSdkFlavor> arrayList = new ArrayList<PythonSdkFlavor>();
        if (SystemInfo.isWindows) {
            arrayList.add((PythonSdkFlavor)ServiceManager.getService(WinPythonSdkFlavor.class));
        } else if (SystemInfo.isMac) {
            arrayList.add(MacPythonSdkFlavor.INSTANCE);
        } else if (SystemInfo.isUnix) {
            arrayList.add(UnixPythonSdkFlavor.INSTANCE);
        }
        if (addPlatformIndependent) {
            arrayList.addAll(PythonSdkFlavor.getPlatformIndependentFlavors());
        }
        arrayList.addAll(PythonSdkFlavor.getPlatformFlavorsFromExtensions(addPlatformIndependent));
        return arrayList;
    }

    public static List<PythonSdkFlavor> getPlatformFlavorsFromExtensions(boolean isInpedendent) {
        ArrayList<PythonSdkFlavor> arrayList = new ArrayList<PythonSdkFlavor>();
        for (PythonFlavorProvider pythonFlavorProvider : PythonFlavorProvider.EP_NAME.getExtensionList()) {
            PythonSdkFlavor pythonSdkFlavor = pythonFlavorProvider.getFlavor(isInpedendent);
            if (pythonSdkFlavor == null) continue;
            arrayList.add(pythonSdkFlavor);
        }
        return arrayList;
    }

    public static List<PythonSdkFlavor> getPlatformIndependentFlavors() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(JythonSdkFlavor.INSTANCE);
        arrayList.add(IronPythonSdkFlavor.INSTANCE);
        arrayList.add(PyPySdkFlavor.INSTANCE);
        arrayList.add(VirtualEnvSdkFlavor.INSTANCE);
        arrayList.add(CondaEnvSdkFlavor.INSTANCE);
        arrayList.add(PyRemoteSdkFlavor.INSTANCE);
        return arrayList;
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@NotNull Sdk sdk) {
        PythonSdkFlavor pythonSdkFlavor;
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            PythonSdkFlavor.a(4);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof PythonSdkAdditionalData && (pythonSdkFlavor = ((PythonSdkAdditionalData)sdkAdditionalData).getFlavor()) != null) {
            return pythonSdkFlavor;
        }
        return PythonSdkFlavor.getFlavor(sdk.getHomePath());
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor pythonSdkFlavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (!pythonSdkFlavor.isValidSdkHome(sdkPath)) continue;
            return pythonSdkFlavor;
        }
        return null;
    }

    @Nullable
    public static PythonSdkFlavor getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor pythonSdkFlavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!pythonSdkFlavor.isValidSdkHome(sdkPath)) continue;
            return pythonSdkFlavor;
        }
        for (PythonSdkFlavor pythonSdkFlavor : PythonSdkFlavor.getPlatformFlavorsFromExtensions(true)) {
            if (!pythonSdkFlavor.isValidSdkHome(sdkPath)) continue;
            return pythonSdkFlavor;
        }
        return null;
    }

    public boolean isValidSdkHome(String path) {
        File file = new File(path);
        return file.isFile() && this.isValidSdkPath(file);
    }

    public boolean isValidSdkPath(@NotNull File file) {
        long l2 = h ^ 0x2FD926AC48DL;
        if (file == null) {
            PythonSdkFlavor.a(5);
        }
        return StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)file.getName())).startsWith("python");
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String string = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(string, new String[]{sdkHome, this.getVersionOption()}, 10000);
        return this.getVersionStringFromOutput(processOutput);
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        long l2 = h ^ 0x6122A8304CDEL;
        if (processOutput == null) {
            PythonSdkFlavor.a(6);
        }
        if (processOutput.getExitCode() != 0) {
            String string = processOutput.getStderr();
            if (StringUtil.isEmpty((String)string)) {
                string = processOutput.getStdout();
            }
            b.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + string);
            return null;
        }
        String string = this.getVersionStringFromOutput(processOutput.getStderr());
        if (string != null) {
            return string;
        }
        return this.getVersionStringFromOutput(processOutput.getStdout());
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            PythonSdkFlavor.a(7);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)a);
    }

    public String getVersionOption() {
        long l2 = h ^ 0x1B7B298E4104L;
        return "-V";
    }

    public Collection<String> getExtraDebugOptions() {
        return Collections.emptyList();
    }

    public void initPythonPath(GeneralCommandLine cmd, boolean passParentEnvs, Collection<String> path) {
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    public static void addToEnv(String key, String value, Map<String, String> envs) {
        PythonEnvUtil.addPathToEnv(envs, key, value);
    }

    public static void setupEncodingEnvs(Map<String, String> envs, @NotNull Charset charset) {
        if (charset == null) {
            PythonSdkFlavor.a(8);
        }
        String string = charset.name();
        PythonEnvUtil.setPythonIOEncoding(envs, string);
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkFlavor.a(9);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(sdk.getVersionString());
        if (languageLevel == null) {
            PythonSdkFlavor.a(10);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkFlavor.a(11);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(this.getVersionString(sdkHome));
        if (languageLevel == null) {
            PythonSdkFlavor.a(12);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevelFromVersionString(@Nullable String version) {
        String string = this.getName() + " ";
        if (version != null && version.startsWith(string)) {
            LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(version.substring(string.length()));
            if (languageLevel == null) {
                PythonSdkFlavor.a(13);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkFlavor.a(14);
        }
        return languageLevel;
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    public void initPythonPath(Collection<String> path, boolean passParentEnvs, Map<String, String> env) {
        PythonSdkFlavor.initPythonPath(env, passParentEnvs, path);
    }

    public VirtualFile getSdkPath(VirtualFile path) {
        return path;
    }

    @Nullable
    public CommandLinePatcher commandLinePatcher() {
        return null;
    }

    static {
        h = c.a(-1210820095022749139L, -7447815054156183154L, MethodHandles.lookup().lookupClass()).a(97035724710055L);
        long l2 = h ^ 0x38E18A0EC128L;
        a = Pattern.compile("(Python \\S+).*");
        b = Logger.getInstance(PythonSdkFlavor.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x33D8930F6D71L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPathList";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelFromVersionString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemPythonPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemEnvPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupEncodingEnvs";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

