/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import com.jetbrains.python.sdk.skeletons.SkeletonVersionChecker;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonGenerator {
    private static final Map<Class<? extends PythonSdkFlavor>, String> b;
    protected static final Logger LOG;
    protected static final int MINUTE = 60000;
    protected static final String GENERATOR3 = "generator3.py";
    private final String c;
    @NotNull
    protected final Map<String, String> myEnv;
    private boolean a;
    private static final long d;

    public void finishSkeletonsGeneration() {
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            PySkeletonGenerator.a(0);
        }
        return new File(name).exists();
    }

    public void setPrebuilt(boolean prebuilt) {
        this.a = prebuilt;
    }

    public PySkeletonGenerator(String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (pySdk == null) {
            PySkeletonGenerator.a(1);
        }
        this.a = false;
        this.c = skeletonPath;
        PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor(pySdk);
        this.myEnv = currentFolder != null && pythonSdkFlavor != null && b.containsKey(pythonSdkFlavor.getClass()) ? ImmutableMap.of((Object)b.get(pythonSdkFlavor.getClass()), (Object)currentFolder) : Collections.emptyMap();
    }

    public String getSkeletonsPath() {
        return this.c;
    }

    public void prepare() {
    }

    protected void generateSkeleton(String modname, String modfilename, List<String> assemblyRefs, String syspath, String sdkHomePath, Consumer<Boolean> resultConsumer) throws InvalidSdkException {
        CharSequence charSequence;
        long l2 = d ^ 0x3350AC090D21L;
        ProcessOutput processOutput = this.runSkeletonGeneration(modname, modfilename, assemblyRefs, sdkHomePath, syspath);
        Application application = ApplicationManager.getApplication();
        if ((application.isInternal() || application.isEAP()) && StringUtil.isNotEmpty((String)(charSequence = processOutput.getStdout()))) {
            LOG.info((String)charSequence);
        }
        if (!processOutput.getStderrLines().isEmpty()) {
            charSequence = new StringBuilder("Skeleton for ");
            ((StringBuilder)charSequence).append(modname);
            if (processOutput.getExitCode() != 0) {
                ((StringBuilder)charSequence).append(" failed on ");
            } else {
                ((StringBuilder)charSequence).append(" had some minor errors on ");
            }
            ((StringBuilder)charSequence).append(sdkHomePath).append(". stderr: --\n");
            for (String string : processOutput.getStderrLines()) {
                ((StringBuilder)charSequence).append(string).append("\n");
            }
            ((StringBuilder)charSequence).append("--");
            if (application.isInternal()) {
                LOG.warn(((StringBuilder)charSequence).toString());
            } else {
                LOG.info(((StringBuilder)charSequence).toString());
            }
        }
        resultConsumer.consume((Object)(processOutput.getExitCode() == 0 ? 1 : 0));
    }

    public ProcessOutput runSkeletonGeneration(String modname, String modfilename, List<String> assemblyRefs, String binaryPath, String extraSyspath) throws InvalidSdkException {
        String string = new File(binaryPath).getParent();
        List<String> list2 = this.buildSkeletonGeneratorCommandLine(modname, modfilename, assemblyRefs, binaryPath, extraSyspath);
        Map<String, String> map2 = PythonSdkType.activateVirtualEnv(binaryPath);
        HashMap<String, String> hashMap = new HashMap<String, String>(!map2.isEmpty() ? PySdkUtil.mergeEnvVariables(this.myEnv, map2) : this.myEnv);
        return this.getProcessOutput(string, ArrayUtilRt.toStringArray(list2), hashMap, 600000);
    }

    @NotNull
    protected final List<String> buildSkeletonGeneratorCommandLine(@NotNull String modname, @Nullable String modfilename, @Nullable List<String> assemblyRefs, @NotNull String binaryPath, @Nullable String extraSyspath) {
        long l2 = d ^ 0x5A5FD5185896L;
        if (modname == null) {
            PySkeletonGenerator.a(2);
        }
        if (binaryPath == null) {
            PySkeletonGenerator.a(3);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(binaryPath);
        arrayList.add(PythonHelpersLocator.getHelperPath(GENERATOR3));
        arrayList.add("-d");
        arrayList.add(this.getSkeletonsPath());
        if (assemblyRefs != null && !assemblyRefs.isEmpty()) {
            arrayList.add("-c");
            arrayList.add(StringUtil.join(assemblyRefs, (String)";"));
        }
        if (ApplicationManager.getApplication().isInternal()) {
            arrayList.add("-x");
        }
        if (!StringUtil.isEmpty((String)extraSyspath)) {
            arrayList.add("-s");
            arrayList.add(extraSyspath);
        }
        arrayList.add(modname);
        if (modfilename != null) {
            arrayList.add(modfilename);
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PySkeletonGenerator.a(4);
        }
        return arrayList2;
    }

    protected ProcessOutput getProcessOutput(String homePath, @NotNull String[] commandLine, Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        long l2 = d ^ 0x55F171F58580L;
        if (commandLine == null) {
            PySkeletonGenerator.a(5);
        }
        HashMap<String, String> hashMap = extraEnv != null ? new HashMap<String, String>(extraEnv) : new HashMap();
        PythonEnvUtil.setPythonDontWriteBytecode(hashMap);
        if (this.a) {
            hashMap.put("IS_PREGENERATED_SKELETONS", "1");
        }
        return PySdkUtil.getProcessOutput(homePath, commandLine, hashMap, timeout);
    }

    public void generateBuiltinSkeletons(@NotNull Sdk sdk) throws InvalidSdkException {
        long l2 = d ^ 0x5DB0EB75473DL;
        if (sdk == null) {
            PySkeletonGenerator.a(6);
        }
        new File(this.c).mkdirs();
        String string = sdk.getHomePath();
        if (string == null) {
            throw new InvalidSdkException("Broken home path for " + sdk.getName());
        }
        long l3 = System.currentTimeMillis();
        ProcessOutput processOutput = this.getProcessOutput(new File(string).getParent(), new String[]{string, PythonHelpersLocator.getHelperPath(GENERATOR3), "-d", this.c, "-b"}, PythonSdkType.activateVirtualEnv(sdk), 300000);
        processOutput.checkSuccess(LOG);
        LOG.info("Rebuilding builtin skeletons took " + (System.currentTimeMillis() - l3) + " ms");
    }

    @NotNull
    public ListBinariesResult listBinaries(@NotNull Sdk sdk, @NotNull String extraSysPath) throws InvalidSdkException {
        long l2 = d ^ 0x49ED6E07C2E6L;
        if (sdk == null) {
            PySkeletonGenerator.a(7);
        }
        if (extraSysPath == null) {
            PySkeletonGenerator.a(8);
        }
        String string = sdk.getHomePath();
        long l3 = System.currentTimeMillis();
        if (string == null) {
            throw new InvalidSdkException("Broken home path for " + sdk.getName());
        }
        String string2 = new File(string).getParent();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string, PythonHelpersLocator.getHelperPath(GENERATOR3), "-L"));
        if (!StringUtil.isEmpty((String)extraSysPath)) {
            arrayList.add("-s");
            arrayList.add(extraSysPath);
        }
        ProcessOutput processOutput = this.getProcessOutput(string2, ArrayUtilRt.toStringArray(arrayList), PythonSdkType.activateVirtualEnv(sdk), 240000);
        LOG.info("Retrieving binary module list took " + (System.currentTimeMillis() - l3) + " ms");
        if (processOutput.getExitCode() != 0) {
            StringBuilder stringBuilder = new StringBuilder("failed to run ").append(GENERATOR3).append(" for ").append(string);
            if (processOutput.isTimeout()) {
                stringBuilder.append(": timed out.");
            } else {
                stringBuilder.append(", exit code ").append(processOutput.getExitCode()).append(", stderr: \n-----\n");
                for (String string3 : processOutput.getStderrLines()) {
                    stringBuilder.append(string3).append("\n");
                }
                stringBuilder.append("-----");
            }
            throw new InvalidSdkException(stringBuilder.toString());
        }
        List list2 = processOutput.getStdoutLines();
        if (list2.size() < 1) {
            throw new InvalidSdkException("Empty output from generator3.py for " + string);
        }
        Iterator iterator = list2.iterator();
        int n2 = SkeletonVersionChecker.fromVersionString(((String)iterator.next()).trim());
        HashMap hashMap = Maps.newHashMap();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            int n3 = string4.indexOf(9);
            if (n3 >= 0) {
                String[] stringArray = string4.split("\t");
                String string5 = stringArray[0];
                String string6 = stringArray[1];
                int n4 = Integer.parseInt(stringArray[2]);
                int n5 = Integer.parseInt(stringArray[3]);
                hashMap.put(string5, new PySkeletonRefresher.PyBinaryItem(string5, string6, n4, n5));
                continue;
            }
            LOG.error("Bad binaries line: '" + string4 + "', SDK " + string);
        }
        ListBinariesResult listBinariesResult = new ListBinariesResult(n2, hashMap);
        if (listBinariesResult == null) {
            PySkeletonGenerator.a(9);
        }
        return listBinariesResult;
    }

    public boolean deleteOrLog(@NotNull File item) {
        boolean bl2;
        long l2 = d ^ 0xA7386E64F95L;
        if (item == null) {
            PySkeletonGenerator.a(10);
        }
        if (!(bl2 = item.delete())) {
            LOG.warn("Failed to delete skeleton file " + item.getAbsolutePath());
        }
        return bl2;
    }

    public void refreshGeneratedSkeletons() {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSkeletonsPath());
        assert (virtualFile != null);
        virtualFile.refresh(false, true);
    }

    static {
        d = com.jetbrains.python.psi.c.a(2950009883626014423L, 7836107098791077120L, MethodHandles.lookup().lookupClass()).a(166342133305776L);
        long l2 = d ^ 0x5CB21584F3F7L;
        b = new HashMap<Class<? extends PythonSdkFlavor>, String>();
        b.put(IronPythonSdkFlavor.class, "IRONPYTHONPATH");
        LOG = Logger.getInstance(PySkeletonGenerator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x7417C055FF36L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modname";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSysPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSkeletonGeneratorCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "listBinaries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildSkeletonGeneratorCommandLine";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateBuiltinSkeletons";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listBinaries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteOrLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ListBinariesResult {
        public final int generatorVersion;
        public final Map<String, PySkeletonRefresher.PyBinaryItem> modules;

        public ListBinariesResult(int generatorVersion, Map<String, PySkeletonRefresher.PyBinaryItem> modules) {
            this.generatorVersion = generatorVersion;
            this.modules = modules;
        }
    }
}

