/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletons;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletonsProvider;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.SkeletonVersionChecker;
import com.jetbrains.python.sdk.skeletons.a;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonRefresher {
    private static final Logger h;
    @Nullable
    private final Project l;
    @Nullable
    private final ProgressIndicator n;
    @NotNull
    private final Sdk c;
    private String f;
    @NonNls
    public static final String BLACKLIST_FILE_NAME = ".blacklist";
    private static final Pattern d;
    private static final Pattern k;
    private static final Pattern g;
    private static final Pattern b;
    private static int p;
    private String j;
    private PyPregeneratedSkeletons e;
    private int m;
    private Map<String, Pair<Integer, Long>> i;
    private SkeletonVersionChecker o;
    private final PySkeletonGenerator a;
    private static final long q;

    public static synchronized boolean isGeneratingSkeletons() {
        return p > 0;
    }

    private static synchronized void a(int n2) {
        p += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSkeletonsOfSdk(@Nullable Project project, @Nullable Component ownerComponent, @Nullable String skeletonsPath, @NotNull Sdk sdk) throws InvalidSdkException {
        Object object;
        long l2 = q ^ 0x3B0279905608L;
        if (sdk == null) {
            PySkeletonRefresher.b(0);
        }
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        SmartList smartList = new SmartList();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        String string = sdk.getHomePath();
        if (skeletonsPath == null) {
            h.info("Could not find skeletons path for SDK path " + string);
        } else {
            h.info("Refreshing skeletons for " + string);
            SkeletonVersionChecker skeletonVersionChecker = new SkeletonVersionChecker(0);
            object = new PySkeletonRefresher(project, ownerComponent, sdk, skeletonsPath, progressIndicator, null);
            PySkeletonRefresher.a(1);
            try {
                Object object2 = ((PySkeletonRefresher)object).regenerateSkeletons(skeletonVersionChecker);
                if (object2.size() > 0) {
                    String string2 = sdk.getName();
                    List list2 = (List)treeMap.get(string2);
                    if (list2 == null) {
                        treeMap.put(string2, (List<String>)object2);
                    } else {
                        list2.addAll(object2);
                    }
                }
            }
            finally {
                PySkeletonRefresher.a(-1);
            }
        }
        if (smartList.size() > 0 || treeMap.size() > 0) {
            int n2 = 0;
            for (Object object2 : treeMap.keySet()) {
                n2 += ((List)treeMap.get(object2)).size();
            }
            object = smartList.size() > 0 ? PyBundle.message("sdk.errorlog.$0.mods.fail.in.$1.sdks.$2.completely", n2, treeMap.size(), smartList.size()) : PyBundle.message("sdk.errorlog.$0.mods.fail.in.$1.sdks", n2, treeMap.size());
            PySkeletonRefresher.a(treeMap, (List<String>)smartList, (String)object);
        }
    }

    private static void a(@NotNull Map<String, List<String>> map2, @NotNull List<String> list2, @NotNull String string) {
        long l2 = q ^ 0x2E4656714C27L;
        if (map2 == null) {
            PySkeletonRefresher.b(1);
        }
        if (list2 == null) {
            PySkeletonRefresher.b(2);
        }
        if (string == null) {
            PySkeletonRefresher.b(3);
        }
        h.warn(PyBundle.message("sdk.some.skeletons.failed", new Object[0]));
        h.warn(string);
        if (list2.size() > 0) {
            h.warn(PyBundle.message("sdk.error.dialog.failed.sdks", new Object[0]));
            h.warn(StringUtil.join(list2, (String)", "));
        }
        if (map2.size() > 0) {
            h.warn(PyBundle.message("sdk.error.dialog.failed.modules", new Object[0]));
            for (String string2 : map2.keySet()) {
                for (String string3 : map2.get(string2)) {
                    h.warn(string3);
                }
            }
        }
    }

    public PySkeletonRefresher(@Nullable Project project, @Nullable Component ownerComponent, @NotNull Sdk sdk, @Nullable String skeletonsPath, @Nullable ProgressIndicator indicator, @Nullable String folder) throws InvalidSdkException {
        if (sdk == null) {
            PySkeletonRefresher.b(4);
        }
        this.l = project;
        this.n = indicator;
        this.c = sdk;
        this.f = skeletonsPath;
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (PySdkUtil.isRemote(sdk) && pythonRemoteInterpreterManager != null) {
            try {
                this.a = pythonRemoteInterpreterManager.createRemoteSkeletonGenerator(this.l, ownerComponent, sdk, this.getSkeletonsPath());
            }
            catch (ExecutionException executionException) {
                throw new InvalidSdkException(executionException.getMessage(), executionException.getCause());
            }
        } else {
            this.a = new PySkeletonGenerator(this.getSkeletonsPath(), this.c, folder);
        }
    }

    private void a(String string) {
        long l2 = q ^ 0x791E6CEA24D0L;
        h.debug("Progress message: " + string);
        if (this.n != null) {
            this.n.checkCanceled();
            this.n.setText(string);
            this.n.setText2("");
        }
    }

    private void b(String string) {
        long l2 = q ^ 0x16F89396A778L;
        h.debug("Progress message (minor): " + string);
        if (this.n != null) {
            this.n.setText2(string);
        }
    }

    private void c() {
        if (this.n != null) {
            this.n.checkCanceled();
        }
    }

    private static String a(@NotNull Sdk sdk, @Nullable String string) {
        if (sdk == null) {
            PySkeletonRefresher.b(5);
        }
        File file = string != null ? new File(string) : null;
        VirtualFile virtualFile2 = PyUserSkeletonsUtil.getUserSkeletonsDirectory();
        File file2 = virtualFile2 != null ? new File(virtualFile2.getPath()) : null;
        VirtualFile virtualFile3 = PySdkUtil.findAnyRemoteLibrary(sdk);
        File file3 = virtualFile3 != null ? new File(virtualFile3.getPath()) : null;
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        arrayList.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        arrayList.addAll(BuildoutFacet.getExtraPathForAllOpenModules());
        return Joiner.on((String)File.pathSeparator).join((Iterable)ContainerUtil.mapNotNull(arrayList, virtualFile -> {
            File file4;
            if (virtualFile.isInLocalFileSystem() && (file4 = new File(virtualFile.getPath())).exists() && !FileUtil.filesEqual((File)file4, (File)file) && !FileUtil.filesEqual((File)file4, (File)file2) && !FileUtil.filesEqual((File)file4, (File)file3)) {
                return virtualFile.getPath();
            }
            return null;
        }));
    }

    @NotNull
    public String getSkeletonsPath() throws InvalidSdkException {
        long l2 = q ^ 0x432D2BA9CD20L;
        if (this.f == null) {
            this.f = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), this.c.getHomePath());
            File file = new File(this.f);
            if (!file.exists() && !file.mkdirs()) {
                throw new InvalidSdkException("Can't create skeleton dir " + this.f);
            }
        }
        String string = this.f;
        if (string == null) {
            PySkeletonRefresher.b(6);
        }
        return string;
    }

    public List<String> regenerateSkeletons(@Nullable SkeletonVersionChecker checker) throws InvalidSdkException {
        boolean bl2;
        Object object2;
        long l2 = q ^ 0x4E4E6B48F791L;
        SmartList smartList = new SmartList();
        String string = this.c.getHomePath();
        String string2 = this.getSkeletonsPath();
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string3 = FileUtil.getLocationRelativeToUserHome((String)string);
        if (checker != null && checker.isPregenerated()) {
            this.a.setPrebuilt(true);
        }
        this.a.prepare();
        this.i = this.b();
        this.a(PyBundle.message("sdk.gen.querying.$0", string3));
        String string4 = PySkeletonRefresher.a(this.c, this.getSkeletonsPath());
        String[] stringArray = string4.split(";");
        PySkeletonGenerator.ListBinariesResult listBinariesResult = null;
        for (Object object2 : Lists.partition(Arrays.asList(stringArray), (int)50)) {
            if (listBinariesResult == null) {
                listBinariesResult = this.a.listBinaries(this.c, Joiner.on((String)";").join((Iterable)object2));
                continue;
            }
            listBinariesResult.modules.putAll(this.a.listBinaries((Sdk)this.c, (String)Joiner.on((String)";").join((Iterable)object2)).modules);
        }
        this.m = listBinariesResult != null ? listBinariesResult.generatorVersion : 0;
        this.e = PyPregeneratedSkeletonsProvider.findPregeneratedSkeletonsForSdk(this.c, this.m);
        this.a(PyBundle.message("sdk.gen.reading.versions.file", new Object[0]));
        this.o = checker != null ? checker.withDefaultVersionIfUnknown(this.m) : new SkeletonVersionChecker(this.m);
        String string5 = PythonSdkType.getBuiltinsFileName(this.c);
        object2 = new File(string2, string5);
        SkeletonHeader skeletonHeader = PySkeletonRefresher.readSkeletonHeader((File)object2);
        boolean bl3 = bl2 = skeletonHeader == null || skeletonHeader.getVersion() == 0;
        if (this.e != null && bl2) {
            this.e.unpackPreGeneratedSkeletons(this.getSkeletonsPath());
        }
        if (bl2) {
            this.a(string2, listBinariesResult);
        }
        boolean bl4 = this.a(string3, (File)object2);
        if (listBinariesResult != null && !listBinariesResult.modules.isEmpty()) {
            this.a(PyBundle.message("sdk.gen.updating.$0", string3));
            List<UpdateResult> list2 = this.a(listBinariesResult.modules);
            if (list2.size() > 0) {
                this.b(BLACKLIST_FILE_NAME);
                for (UpdateResult updateResult : list2) {
                    if (updateResult.isFresh()) {
                        smartList.add(updateResult.getName());
                    }
                    this.i.put(updateResult.getPath(), (Pair<Integer, Long>)new Pair((Object)this.m, (Object)updateResult.getTimestamp()));
                }
                PySkeletonRefresher.a(file, this.i);
            } else {
                PySkeletonRefresher.b(file);
            }
        }
        this.a(PyBundle.message("sdk.gen.reloading", new Object[0]));
        this.a.refreshGeneratedSkeletons();
        if (!bl2) {
            this.a(PyBundle.message("sdk.gen.cleaning.$0", string3));
            this.a(file);
        }
        if ((bl4 || PySdkUtil.isRemote(this.c)) && this.l != null) {
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.l).restart(), this.l.getDisposed());
        }
        return smartList;
    }

    private boolean a(String string, File file) throws InvalidSdkException {
        boolean bl2;
        long l2 = q ^ 0x63B2675B8D44L;
        SkeletonHeader skeletonHeader = PySkeletonRefresher.readSkeletonHeader(file);
        boolean bl3 = bl2 = this.e == null && (skeletonHeader == null || skeletonHeader.getVersion() < this.o.getBuiltinVersion());
        if (bl2) {
            this.a(PyBundle.message("sdk.gen.updating.builtins.$0", string));
            this.a.generateBuiltinSkeletons(this.c);
            if (this.l != null) {
                PythonSdkPathCache.getInstance(this.l, this.c).clearBuiltins();
            }
        }
        return bl2;
    }

    private void a(String string, PySkeletonGenerator.ListBinariesResult listBinariesResult) throws InvalidSdkException {
        long l2 = q ^ 0x1BACEEF98643L;
        Sdk sdk = PythonSdkType.getInstance().getVirtualEnvBaseSdk(this.c);
        if (sdk != null) {
            this.a("Copying base SDK skeletons for virtualenv...");
            String string2 = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), sdk.getHomePath());
            PySkeletonGenerator.ListBinariesResult listBinariesResult2 = this.a.listBinaries(sdk, PySkeletonRefresher.a(sdk, string2));
            for (Map.Entry<String, PyBinaryItem> entry : listBinariesResult.modules.entrySet()) {
                String string3 = entry.getKey();
                PyBinaryItem pyBinaryItem = entry.getValue();
                PyBinaryItem pyBinaryItem2 = listBinariesResult2.modules.get(string3);
                File file = PySkeletonRefresher.a(string3, string2);
                if (!listBinariesResult2.modules.containsKey(string3) || !file.exists() || pyBinaryItem.length() != pyBinaryItem2.length()) continue;
                File file2 = file.isDirectory() ? PySkeletonRefresher.c(string3, string) : PySkeletonRefresher.b(string3, string);
                try {
                    FileUtil.copy((File)file, (File)file2);
                }
                catch (IOException iOException) {
                    h.info("Error copying base virtualenv SDK skeleton for " + string3, (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SkeletonHeader readSkeletonHeader(@NotNull File file) {
        if (file == null) {
            PySkeletonRefresher.b(7);
        }
        try (LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));){
            String string = null;
            for (int i10 = 0; i10 < 3; ++i10) {
                string = lineNumberReader.readLine();
                if (string != null) continue;
                SkeletonHeader skeletonHeader = null;
                return skeletonHeader;
            }
            Matcher matcher = k.matcher(string);
            if (matcher.matches()) {
                SkeletonHeader skeletonHeader = new SkeletonHeader(matcher.group(1), SkeletonVersionChecker.fromVersionString(matcher.group(2)));
                return skeletonHeader;
            }
            Matcher matcher2 = g.matcher(string);
            if (!matcher2.matches()) return null;
            String string2 = matcher2.group(1);
            string = lineNumberReader.readLine();
            if (string == null) return null;
            Matcher matcher3 = b.matcher(string);
            if (!matcher3.matches()) return null;
            int n2 = SkeletonVersionChecker.fromVersionString(matcher3.group(1));
            SkeletonHeader skeletonHeader = new SkeletonHeader(string2, n2);
            return skeletonHeader;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pair<Integer, Long>> b() {
        long l2 = q ^ 0x45CC0D342BDBL;
        HashMap<String, Pair<Integer, Long>> hashMap = new HashMap<String, Pair<Integer, Long>>();
        File file = new File(this.f, BLACKLIST_FILE_NAME);
        if (file.exists() && file.canRead()) {
            try {
                FileReader fileReader = new FileReader(file);
                try (LineNumberReader lineNumberReader = new LineNumberReader(fileReader);){
                    String string;
                    do {
                        int n2;
                        if ((string = lineNumberReader.readLine()) == null || string.length() <= 0 || string.charAt(0) == '#') continue;
                        Matcher matcher = d.matcher(string);
                        boolean bl2 = true;
                        if (matcher.matches() && (n2 = SkeletonVersionChecker.fromVersionString(matcher.group(2))) > 0) {
                            try {
                                long l3 = Long.parseLong(matcher.group(3));
                                String string2 = matcher.group(1);
                                hashMap.put(string2, (Pair<Integer, Long>)new Pair((Object)n2, (Object)l3));
                                bl2 = false;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!bl2) continue;
                        h.warn("In blacklist at " + this.f + " strange line '" + string + "'");
                    } while (string != null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file, Map<String, Pair<Integer, Long>> map2) {
        long l2 = q ^ 0x781D6FAC7AE0L;
        File file2 = new File(file, BLACKLIST_FILE_NAME);
        try (PrintWriter printWriter = new PrintWriter(file2);){
            printWriter.println("# PyCharm failed to generate skeletons for these modules.");
            printWriter.println("# These skeletons will be re-generated automatically");
            printWriter.println("# when a newer module version or an updated generator becomes available.");
            for (String string : map2.keySet()) {
                Pair<Integer, Long> pair = map2.get(string);
                printWriter.print(string);
                printWriter.print(" = ");
                printWriter.print(SkeletonVersionChecker.toVersionString((Integer)pair.getFirst()));
                printWriter.print(" ");
                printWriter.print(pair.getSecond());
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            h.warn("Failed to store blacklist in " + file.getPath(), (Throwable)iOException);
        }
    }

    private static void b(File file) {
        boolean bl2;
        long l2 = q ^ 0x1BF05BAFC95FL;
        File file2 = new File(file, BLACKLIST_FILE_NAME);
        if (file2.exists() && !(bl2 = file2.delete())) {
            h.warn("Could not delete blacklist file in " + file.getPath());
        }
    }

    private void a(File file) {
        long l2 = q ^ 0x6915666D53EFL;
        this.b(file.getPath());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            boolean bl2;
            Object object;
            Object object2;
            if (file2.isDirectory()) {
                boolean bl3;
                this.a(file2);
                object2 = file2.listFiles();
                if (object2 != null && ((File[])object2).length == 0) {
                    this.a.deleteOrLog(file2);
                    continue;
                }
                if (object2 == null || ((File[])object2).length != 1 || !"__init__.py".equals(((File)(object = object2[0])).getName()) || ((File)object).length() != 0L || !(bl3 = this.a.deleteOrLog((File)object))) continue;
                this.a.deleteOrLog(file2);
                continue;
            }
            if (!file2.isFile() || "__init__.py".equals(object2 = file2.getName()) && file2.length() == 0L || BLACKLIST_FILE_NAME.equals(object2) || PythonSdkType.getBuiltinsFileName(this.c).equals(object2)) continue;
            object = PySkeletonRefresher.readSkeletonHeader(file2);
            String string = null;
            boolean bl4 = bl2 = object != null;
            if (bl2) {
                string = ((SkeletonHeader)object).getBinaryFile();
                boolean bl5 = bl2 = "(pre-generated)".equals(string) || "(built-in)".equals(string) || this.a.exists(string);
            }
            if (bl2) continue;
            h.debug("Cleaning up skeleton " + file2 + (string != null ? " for non existing binary " + string : ""));
            this.a.deleteOrLog(file2);
        }
    }

    private List<UpdateResult> a(Map<String, PyBinaryItem> map2) throws InvalidSdkException {
        long l2 = q ^ 0x3BB6FD08C0D8L;
        long l3 = System.currentTimeMillis();
        ArrayList arrayList = Lists.newArrayList(map2.keySet());
        Collections.sort(arrayList);
        ArrayList<UpdateResult> arrayList2 = new ArrayList<UpdateResult>();
        int n2 = arrayList.size();
        if (this.n != null) {
            this.n.setIndeterminate(false);
        }
        for (int i10 = 0; i10 < n2; ++i10) {
            String string;
            PyBinaryItem pyBinaryItem;
            this.c();
            if (this.n != null) {
                this.n.setFraction((double)i10 / (double)n2);
            }
            if ((pyBinaryItem = map2.get(string = (String)arrayList.get(i10))) == null) continue;
            this.a(pyBinaryItem, arrayList2);
        }
        this.d();
        long l4 = System.currentTimeMillis() - l3;
        h.info("Rebuilding skeletons for binaries took " + l4 + " ms");
        return arrayList2;
    }

    private void d() {
        this.a.finishSkeletonsGeneration();
    }

    private static File a(String string, String string2) {
        File file = PySkeletonRefresher.b(string, string2);
        return file.exists() ? file : PySkeletonRefresher.c(string, string2);
    }

    private static File b(String string, String string2) {
        long l2 = q ^ 0x22C077275F24L;
        String string3 = string.replace('.', '/');
        return new File(string2, string3 + ".py");
    }

    private static File c(String string, String string2) {
        long l2 = q ^ 0x3933F81E9A8BL;
        String string3 = string.replace('.', '/');
        return new File(new File(string2, string3), "__init__.py");
    }

    private void a(PyBinaryItem pyBinaryItem, List<UpdateResult> list2) throws InvalidSdkException {
        Pair<Integer, Long> pair;
        long l2 = q ^ 0x72034043AB86L;
        String string = pyBinaryItem.getModule();
        File file = PySkeletonRefresher.a(string, this.getSkeletonsPath());
        SkeletonHeader skeletonHeader = PySkeletonRefresher.readSkeletonHeader(file);
        boolean bl3 = true;
        if (skeletonHeader != null) {
            int n2 = this.o.getRequiredVersion(string);
            boolean bl4 = bl3 = skeletonHeader.getVersion() < n2;
        }
        if (!bl3) {
            boolean bl5 = bl3 = file.exists() && pyBinaryItem.lastModified() > file.lastModified();
        }
        if (this.i != null && (pair = this.i.get(pyBinaryItem.getPath())) != null) {
            int n3 = (Integer)pair.getFirst();
            long l3 = (Long)pair.getSecond();
            if (!(bl3 &= n3 < this.m || l3 < pyBinaryItem.lastModified())) {
                list2.add(new UpdateResult(string, pyBinaryItem.getPath(), pyBinaryItem.lastModified(), false, null));
            }
        }
        if (bl3) {
            this.b(string);
            if (this.e != null && this.e.copyPregeneratedSkeleton(string, this.getSkeletonsPath())) {
                return;
            }
            h.info("Skeleton for " + string);
            this.generateSkeleton(string, pyBinaryItem.getPath(), null, (Consumer<Boolean>)((Consumer)bl2 -> {
                if (!bl2.booleanValue()) {
                    list2.add(new UpdateResult(string, pyBinaryItem.getPath(), pyBinaryItem.lastModified(), true, null));
                }
            }));
        }
    }

    public void generateSkeleton(@NotNull String modname, @Nullable String modfilename, @Nullable List<String> assemblyRefs, Consumer<Boolean> resultConsumer) throws InvalidSdkException {
        if (modname == null) {
            PySkeletonRefresher.b(8);
        }
        this.a.generateSkeleton(modname, modfilename, assemblyRefs, this.e(), this.c.getHomePath(), resultConsumer);
    }

    private String e() {
        if (this.j == null) {
            this.j = PySkeletonRefresher.a(this.c, this.f);
        }
        return this.j;
    }

    public int getGeneratorVersion() {
        return this.m;
    }

    static {
        q = com.jetbrains.python.psi.c.a(6602527124621869903L, -1522493596373894053L, MethodHandles.lookup().lookupClass()).a(239448399984406L);
        long l2 = q ^ 0x84C765A5DC2L;
        h = Logger.getInstance(PySkeletonRefresher.class);
        d = Pattern.compile("^([^=]+) = (\\d+\\.\\d+) (\\d+)\\s*$");
        k = Pattern.compile("# from (\\S+) by generator (\\S+)\\s*");
        g = Pattern.compile("# from (.*)$");
        b = Pattern.compile("# by generator (.*)$");
        p = 0;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x4749D87DD275L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedSdks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modname";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshSkeletonsOfSdk";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logErrors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateExtraSysPath";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateSkeleton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyBinaryItem {
        private final String b;
        private final String c;
        private final long d;
        private final long a;

        PyBinaryItem(String module2, String path, long length, long lastModified) {
            this.b = path;
            this.c = module2;
            this.d = length;
            this.a = lastModified * 1000L;
        }

        public String getPath() {
            return this.b;
        }

        public String getModule() {
            return this.c;
        }

        public long length() {
            return this.d;
        }

        public long lastModified() {
            return this.a;
        }
    }

    private static class UpdateResult {
        private final String a;
        private final String d;
        private final long c;
        private final boolean b;

        public boolean isFresh() {
            return this.b;
        }

        private UpdateResult(String name, String path, long timestamp, boolean fresh) {
            this.d = name;
            this.a = path;
            this.c = timestamp;
            this.b = fresh;
        }

        public String getName() {
            return this.d;
        }

        public String getPath() {
            return this.a;
        }

        public Long getTimestamp() {
            return this.c;
        }

        /* synthetic */ UpdateResult(String x0, String x1, long x2, boolean x3, a x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static class SkeletonHeader {
        @NotNull
        private final String b;
        private final int a;
        private static final long c = com.jetbrains.python.psi.c.a(6282329247451124192L, -2598573706715940589L, MethodHandles.lookup().lookupClass()).a(36681200056681L);

        public SkeletonHeader(@NotNull String binaryFile, int version) {
            if (binaryFile == null) {
                SkeletonHeader.a(0);
            }
            this.b = binaryFile;
            this.a = version;
        }

        @NotNull
        public String getBinaryFile() {
            String string = this.b;
            if (string == null) {
                SkeletonHeader.a(1);
            }
            return string;
        }

        public int getVersion() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x3B5BEDA2075EL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher$SkeletonHeader";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher$SkeletonHeader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryFile";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

