/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import com.jetbrains.python.spellchecker.a;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final StringLiteralTokenizer b = new StringLiteralTokenizer(null);
    private final FormatStringTokenizer a = new FormatStringTokenizer(null);
    private static final long c = com.jetbrains.python.psi.c.a(1257739201230134398L, 5443800074231295282L, MethodHandles.lookup().lookupClass()).a(119823285061374L);

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            PyBinaryExpression pyBinaryExpression;
            PsiElement psiElement = element.getParent();
            if (psiElement instanceof PyBinaryExpression && element == (pyBinaryExpression = (PyBinaryExpression)psiElement).getLeftExpression() && pyBinaryExpression.getOperator() == PyTokenTypes.PERC) {
                FormatStringTokenizer formatStringTokenizer = this.a;
                if (formatStringTokenizer == null) {
                    PythonSpellcheckerStrategy.a(0);
                }
                return formatStringTokenizer;
            }
            StringLiteralTokenizer stringLiteralTokenizer = this.b;
            if (stringLiteralTokenizer == null) {
                PythonSpellcheckerStrategy.a(1);
            }
            return stringLiteralTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            PythonSpellcheckerStrategy.a(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = c ^ 0x3423F1075275L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
    }

    private static class FormatStringTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private static final long a = com.jetbrains.python.psi.c.a(900147814079233460L, 3838312497842166939L, MethodHandles.lookup().lookupClass()).a(85137213135646L);

        private FormatStringTokenizer() {
        }

        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                FormatStringTokenizer.a(0);
            }
            String string = element.getStringValue();
            List<PyStringFormatParser.FormatStringChunk> list2 = PyStringFormatParser.parsePercentFormat(string);
            PlainTextSplitter plainTextSplitter = PlainTextSplitter.getInstance();
            for (PyStringFormatParser.FormatStringChunk formatStringChunk : list2) {
                if (!(formatStringChunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                int n2 = element.valueOffsetToTextOffset(formatStringChunk.getStartIndex());
                int n3 = element.valueOffsetToTextOffset(formatStringChunk.getEndIndex());
                String string2 = element.getText().substring(n2, n3);
                consumer.consumeToken((PsiElement)element, string2, false, n2, TextRange.allOf((String)string2), (Splitter)plainTextSplitter);
            }
        }

        /* synthetic */ FormatStringTokenizer(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x7D345E894E9EL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$FormatStringTokenizer", "tokenize"));
        }
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private static final long a = com.jetbrains.python.psi.c.a(5282618920750746791L, 4615336482117697380L, MethodHandles.lookup().lookupClass()).a(177625190069164L);

        private StringLiteralTokenizer() {
        }

        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                StringLiteralTokenizer.a(0);
            }
            PlainTextSplitter plainTextSplitter = PlainTextSplitter.getInstance();
            for (PyStringElement pyStringElement : element.getStringElements()) {
                List<TextRange> list2 = pyStringElement.isFormatted() ? ((PyFormattedStringElement)pyStringElement).getLiteralPartRanges() : Collections.singletonList(pyStringElement.getContentRange());
                PyStringLiteralDecoder pyStringLiteralDecoder = new PyStringLiteralDecoder(pyStringElement);
                boolean bl2 = pyStringElement.textContains('\\');
                for (TextRange textRange : list2) {
                    List list3 = pyStringElement.isRaw() || !bl2 ? Collections.singletonList(textRange) : ContainerUtil.map(pyStringLiteralDecoder.decodeRange(textRange), pair -> (TextRange)pair.getFirst());
                    for (TextRange textRange2 : list3) {
                        String string = textRange2.substring(pyStringElement.getText());
                        consumer.consumeToken((PsiElement)pyStringElement, string, false, textRange2.getStartOffset(), TextRange.allOf((String)string), (Splitter)plainTextSplitter);
                    }
                }
            }
        }

        /* synthetic */ StringLiteralTokenizer(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x60519D48FF33L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$StringLiteralTokenizer", "tokenize"));
        }
    }
}

