/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.AbstractPythonTestRunConfigurationParams;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonLegacyTestRunConfiguration<T extends AbstractPythonTestRunConfiguration<T>>
extends AbstractPythonTestRunConfiguration<T>
implements AbstractPythonRunConfigurationParams,
AbstractPythonTestRunConfigurationParams,
RefactoringListenerProvider {
    protected String myClassName = "";
    protected String myScriptName = "";
    protected String myMethodName = "";
    protected String myFolderName = "";
    protected TestType myTestType = TestType.TEST_SCRIPT;
    private String g = "";
    private boolean h = false;
    private static final long q = c.a(-5430401229002596981L, 3685999043106831143L, MethodHandles.lookup().lookupClass()).a(218095645643476L);

    protected AbstractPythonLegacyTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    @Override
    @NotNull
    public String getWorkingDirectorySafe() {
        VirtualFile virtualFile;
        String string = this.getWorkingDirectory();
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            if (string2 == null) {
                AbstractPythonLegacyTestRunConfiguration.c(0);
            }
            return string2;
        }
        String string3 = this.myFolderName;
        if (!StringUtil.isEmptyOrSpaces((String)string3)) {
            String string4 = string3;
            if (string4 == null) {
                AbstractPythonLegacyTestRunConfiguration.c(1);
            }
            return string4;
        }
        String string5 = this.myScriptName;
        if (!StringUtil.isEmptyOrSpaces((String)string5) && (virtualFile = LocalFileSystem.getInstance().findFileByPath(string5)) != null) {
            String string6 = virtualFile.getParent().getPath();
            if (string6 == null) {
                AbstractPythonLegacyTestRunConfiguration.c(2);
            }
            return string6;
        }
        String string7 = super.getWorkingDirectorySafe();
        if (string7 == null) {
            AbstractPythonLegacyTestRunConfiguration.c(3);
        }
        return string7;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        long l2 = q ^ 0x4329734B2257L;
        if (element == null) {
            AbstractPythonLegacyTestRunConfiguration.c(4);
        }
        super.readExternal(element);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element, (String)"SCRIPT_NAME");
        this.myClassName = JDOMExternalizerUtil.readField((Element)element, (String)"CLASS_NAME");
        this.myMethodName = JDOMExternalizerUtil.readField((Element)element, (String)"METHOD_NAME");
        this.myFolderName = JDOMExternalizerUtil.readField((Element)element, (String)"FOLDER_NAME");
        this.g = JDOMExternalizerUtil.readField((Element)element, (String)"PATTERN");
        this.h = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PATTERN"));
        try {
            String string = JDOMExternalizerUtil.readField((Element)element, (String)"TEST_TYPE");
            this.myTestType = string != null ? TestType.valueOf(string) : TestType.TEST_SCRIPT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.myTestType = TestType.TEST_SCRIPT;
        }
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        long l2 = q ^ 0x4A0F00CE1964L;
        if (element == null) {
            AbstractPythonLegacyTestRunConfiguration.c(5);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SCRIPT_NAME", (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"CLASS_NAME", (String)this.myClassName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"METHOD_NAME", (String)this.myMethodName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"FOLDER_NAME", (String)this.myFolderName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"TEST_TYPE", (String)this.myTestType.toString());
        JDOMExternalizerUtil.writeField((Element)element, (String)"PATTERN", (String)this.g);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PATTERN", (String)String.valueOf(this.h));
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public void setClassName(String className) {
        this.myClassName = className;
    }

    @Override
    public String getFolderName() {
        return this.myFolderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.myFolderName = folderName;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(@NotNull String scriptName) {
        if (scriptName == null) {
            AbstractPythonLegacyTestRunConfiguration.c(6);
        }
        this.myScriptName = scriptName;
    }

    @Override
    public String getMethodName() {
        return this.myMethodName;
    }

    @Override
    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    public TestType getTestType() {
        return this.myTestType;
    }

    @Override
    public void setTestType(TestType testType) {
        this.myTestType = testType;
    }

    @Override
    public String getPattern() {
        return this.g;
    }

    @Override
    public void setPattern(String pattern) {
        this.g = pattern;
    }

    @Override
    public boolean usePattern() {
        return this.h;
    }

    @Override
    public void usePattern(boolean usePattern) {
        this.h = usePattern;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        long l2 = q ^ 0x27686FAB88EEL;
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myFolderName) && this.myTestType == TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_folder_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getScriptName()) && this.myTestType != TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_script_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myClassName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_CLASS)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_class_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myMethodName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_FUNCTION)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_method_name", new Object[0]));
        }
    }

    public boolean compareSettings(AbstractPythonLegacyTestRunConfiguration cfg) {
        long l2 = q ^ 0xE1EDBDE7840L;
        if (cfg == null) {
            return false;
        }
        if (this.getTestType() != cfg.getTestType()) {
            return false;
        }
        switch (this.getTestType()) {
            case TEST_FOLDER: {
                return this.getFolderName().equals(cfg.getFolderName());
            }
            case TEST_SCRIPT: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory());
            }
            case TEST_CLASS: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName());
            }
            case TEST_METHOD: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName()) && this.getMethodName().equals(cfg.getMethodName());
            }
            case TEST_FUNCTION: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getMethodName().equals(cfg.getMethodName());
            }
        }
        throw new IllegalStateException("Unknown test type: " + (Object)((Object)this.getTestType()));
    }

    public static void copyParams(AbstractPythonTestRunConfigurationParams source, AbstractPythonTestRunConfigurationParams target) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target.getBaseParams());
        target.setScriptName(source.getScriptName());
        target.setClassName(source.getClassName());
        target.setFolderName(source.getFolderName());
        target.setMethodName(source.getMethodName());
        target.setTestType(source.getTestType());
        target.setPattern(source.getPattern());
        target.usePattern(source.usePattern());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    public AbstractPythonTestRunConfigurationParams getTestRunConfigurationParams() {
        return this;
    }

    public String suggestedName() {
        long l2 = q ^ 0xA246C8CFCA2L;
        switch (this.myTestType) {
            case TEST_CLASS: {
                return this.getPluralTitle() + " in " + this.myClassName;
            }
            case TEST_METHOD: {
                return this.getTitle() + " " + this.myClassName + "." + this.myMethodName;
            }
            case TEST_SCRIPT: {
                String string = new File(this.getScriptName()).getName();
                string = StringUtil.trimEnd((String)string, (String)".py");
                return this.getPluralTitle() + " in " + string;
            }
            case TEST_FOLDER: {
                String string = new File(this.myFolderName).getName();
                return this.getPluralTitle() + " in " + string;
            }
            case TEST_FUNCTION: {
                return this.getTitle() + " " + this.myMethodName;
            }
        }
        throw new IllegalStateException("Unknown test type: " + (Object)((Object)this.myTestType));
    }

    @Nullable
    public String getActionName() {
        if (TestType.TEST_METHOD.equals((Object)this.myTestType)) {
            return this.getTitle() + " " + this.myMethodName;
        }
        return this.suggestedName();
    }

    protected abstract String getTitle();

    protected abstract String getPluralTitle();

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element).getVirtualFile();
            if (this.myTestType == TestType.TEST_FOLDER && AbstractPythonLegacyTestRunConfiguration.a(virtualFile2, this.myFolderName) || AbstractPythonLegacyTestRunConfiguration.a(virtualFile2, this.getWorkingDirectory())) {
                return new RefactoringElementAdapter(){
                    private static final long a = c.a(-2074487702718223207L, 9145285345339569248L, MethodHandles.lookup().lookupClass()).a(207633920430955L);

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            1.a(0);
                        }
                        String string = FileUtil.toSystemDependentName((String)((PsiDirectory)newElement).getVirtualFile().getPath());
                        AbstractPythonLegacyTestRunConfiguration.this.setWorkingDirectory(string);
                        if (AbstractPythonLegacyTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonLegacyTestRunConfiguration.this.myFolderName = string;
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.a(1);
                        }
                        if (oldQualifiedName == null) {
                            1.a(2);
                        }
                        String string = FileUtil.toSystemDependentName((String)oldQualifiedName);
                        AbstractPythonLegacyTestRunConfiguration.this.setWorkingDirectory(string);
                        if (AbstractPythonLegacyTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonLegacyTestRunConfiguration.this.myFolderName = string;
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x7A9A8FE8919FL;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            return null;
        }
        if (this.myTestType == TestType.TEST_FOLDER) {
            return null;
        }
        File file = new File(this.myScriptName);
        if (!file.isAbsolute()) {
            file = new File(this.getWorkingDirectory(), this.myScriptName);
        }
        VirtualFile virtualFile3 = virtualFile = (psiFile = element.getContainingFile()) == null ? null : psiFile.getVirtualFile();
        if (virtualFile != null && Comparing.equal((String)new File(virtualFile.getPath()).getAbsolutePath(), (String)file.getAbsolutePath())) {
            if (element instanceof PsiFile) {
                return new RefactoringElementAdapter(){
                    private static final long a = c.a(-1375557367452900223L, 872204992906974653L, MethodHandles.lookup().lookupClass()).a(177053693812432L);

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile virtualFile;
                        if (newElement == null) {
                            2.a(0);
                        }
                        if ((virtualFile = ((PsiFile)newElement).getVirtualFile()) != null) {
                            AbstractPythonLegacyTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            2.a(1);
                        }
                        if (oldQualifiedName == null) {
                            2.a(2);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)oldQualifiedName);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x458FF9CF6A50L;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$2";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            if (element instanceof PyClass && (this.myTestType == TestType.TEST_CLASS || this.myTestType == TestType.TEST_METHOD) && Comparing.equal((String)((PyClass)element).getName(), (String)this.myClassName)) {
                return new RefactoringElementAdapter(){
                    private static final long a = c.a(-8036370774144115864L, 7332411717766653092L, MethodHandles.lookup().lookupClass()).a(215085462079495L);

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            3.a(0);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myClassName = ((PyClass)newElement).getName();
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            3.a(1);
                        }
                        if (oldQualifiedName == null) {
                            3.a(2);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myClassName = oldQualifiedName;
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x7E1C3B2DB9EDL;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$3";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            if (element instanceof PyFunction && Comparing.equal((String)((PyFunction)element).getName(), (String)this.myMethodName)) {
                ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
                if (this.myTestType == TestType.TEST_FUNCTION && scopeOwner instanceof PyFile || this.myTestType == TestType.TEST_METHOD && scopeOwner instanceof PyClass && Comparing.equal((String)scopeOwner.getName(), (String)this.myClassName)) {
                    return new RefactoringElementAdapter(){
                        private static final long a = c.a(-8956887769027605881L, 8437497373407389321L, MethodHandles.lookup().lookupClass()).a(75013908298709L);

                        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                            if (newElement == null) {
                                4.a(0);
                            }
                            AbstractPythonLegacyTestRunConfiguration.this.myMethodName = ((PyFunction)newElement).getName();
                        }

                        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                            int n2;
                            if (newElement == null) {
                                4.a(1);
                            }
                            if (oldQualifiedName == null) {
                                4.a(2);
                            }
                            if ((n2 = oldQualifiedName.indexOf("#") + 1) > 0 && n2 < oldQualifiedName.length()) {
                                AbstractPythonLegacyTestRunConfiguration.this.myMethodName = oldQualifiedName.substring(n2);
                            }
                        }

                        private static /* synthetic */ void a(int n2) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            long l2 = a ^ 0x846E8861399L;
                            Object[] objectArray3 = new Object[3];
                            switch (n2) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "newElement";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "oldQualifiedName";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$4";
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "elementRenamedOrMoved";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undoElementMovedOrRenamed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }
            }
        }
        return null;
    }

    private static boolean a(VirtualFile virtualFile, String string) {
        return Comparing.equal((String)new File(virtualFile.getPath()).getAbsolutePath(), (String)new File(string).getAbsolutePath());
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x44C131D467FDL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setScriptName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TestType
    extends Enum<TestType> {
        public static final /* enum */ TestType TEST_FOLDER;
        public static final /* enum */ TestType TEST_SCRIPT;
        public static final /* enum */ TestType TEST_CLASS;
        public static final /* enum */ TestType TEST_METHOD;
        public static final /* enum */ TestType TEST_FUNCTION;
        private static final /* synthetic */ TestType[] a;

        public static TestType[] values() {
            return (TestType[])a.clone();
        }

        public static TestType valueOf(String name) {
            return Enum.valueOf(TestType.class, name);
        }

        static {
            long l2 = c.a(3848799233372937978L, -9086260660872974679L, MethodHandles.lookup().lookupClass()).a(2272984930296L) ^ 0x138D53B6D5ACL;
            TEST_FOLDER = new TestType();
            TEST_SCRIPT = new TestType();
            TEST_CLASS = new TestType();
            TEST_METHOD = new TestType();
            TEST_FUNCTION = new TestType();
            a = new TestType[]{TEST_FOLDER, TEST_SCRIPT, TEST_CLASS, TEST_METHOD, TEST_FUNCTION};
        }
    }
}

