/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Sets;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.TestRunnerService;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonUnitTestUtil {
    public static final String TESTCASE_SETUP_NAME = "setUp";
    public static final Set<String> PYTHON_TEST_QUALIFIED_CLASSES;
    private static final long a;

    private PythonUnitTestUtil() {
    }

    public static boolean isTestFile(@NotNull PyFile file, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        long l2 = a ^ 0x3EBB23B3316AL;
        if (file == null) {
            PythonUnitTestUtil.a(0);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.a(1);
        }
        if (file.getTopLevelClasses().stream().anyMatch(pyClass -> PythonUnitTestUtil.isTestClass(pyClass, testCaseClassRequired, context))) {
            return true;
        }
        if (PythonUnitTestUtil.a((PsiElement)file, testCaseClassRequired)) {
            return false;
        }
        return file.getName().startsWith("test_") || file.getTopLevelFunctions().stream().anyMatch(pyFunction -> PythonUnitTestUtil.isTestFunction(pyFunction, testCaseClassRequired, context));
    }

    @Deprecated
    public static boolean isTestCaseClass(@NotNull PyClass cls, @Nullable TypeEvalContext context) {
        if (cls == null) {
            PythonUnitTestUtil.a(2);
        }
        return PythonUnitTestUtil.isTestClass(cls, ThreeState.YES, context);
    }

    public static boolean isTestClass(@NotNull PyClass cls, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        boolean bl2;
        long l2 = a ^ 0x49C13C1C1B91L;
        if (cls == null) {
            PythonUnitTestUtil.a(3);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.a(4);
        }
        boolean bl3 = PythonUnitTestUtil.a((PsiElement)cls, testCaseClassRequired);
        if (context == null) {
            context = TypeEvalContext.codeInsightFallback(cls.getProject());
        }
        if (bl2 = PyClassExtKt.inherits(cls, context, PYTHON_TEST_QUALIFIED_CLASSES)) {
            return true;
        }
        if (bl3) {
            return false;
        }
        String string = cls.getName();
        if (string == null) {
            return false;
        }
        if (!string.startsWith("Test") && !string.endsWith("Test")) {
            return false;
        }
        Ref ref = new Ref((Object)false);
        cls.visitMethods((Processor<PyFunction>)((Processor)pyFunction -> {
            long l2 = a ^ 0x40102C47D20DL;
            String string = pyFunction.getName();
            if (string != null && string.startsWith("test")) {
                ref.set((Object)true);
                return false;
            }
            return true;
        }), true, context);
        return (Boolean)ref.get();
    }

    public static boolean isTestFunction(@NotNull PyFunction function, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        String string;
        long l2 = a ^ 0x34DD64348AEEL;
        if (function == null) {
            PythonUnitTestUtil.a(5);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.a(6);
        }
        if ((string = function.getName()) == null || !string.startsWith("test")) {
            return false;
        }
        PyClass pyClass = function.getContainingClass();
        if (!PythonUnitTestUtil.a(function, testCaseClassRequired) && pyClass == null) {
            return true;
        }
        return pyClass != null && PythonUnitTestUtil.isTestClass(pyClass, testCaseClassRequired, context);
    }

    @Deprecated
    public static boolean isUnitTestCaseClass(PyClass cls) {
        return PythonUnitTestUtil.isTestClass(cls, ThreeState.YES, null);
    }

    private static boolean a(@NotNull PsiElement psiElement, @NotNull ThreeState threeState) {
        if (psiElement == null) {
            PythonUnitTestUtil.a(7);
        }
        if (threeState == null) {
            PythonUnitTestUtil.a(8);
        }
        if (threeState != ThreeState.UNSURE) {
            return threeState.toBoolean();
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module2 == null) {
            return true;
        }
        return PyTestsSharedKt.getRunnersThatRequireTestCaseClass().contains(TestRunnerService.getInstance(module2).getProjectConfiguration());
    }

    public static List<Location> findLocations(@NotNull Project project, @NotNull String fileName, @Nullable String className, @Nullable String methodName) {
        ArrayList<Location> arrayList;
        block10: {
            block9: {
                if (project == null) {
                    PythonUnitTestUtil.a(9);
                }
                if (fileName == null) {
                    PythonUnitTestUtil.a(10);
                }
                if (fileName.contains("%")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("%"));
                }
                arrayList = new ArrayList<Location>();
                if (methodName == null && className == null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
                    if (virtualFile == null) {
                        return arrayList;
                    }
                    PsiFile object = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (object != null) {
                        arrayList.add((Location)new PsiLocation(project, (PsiElement)object));
                    }
                }
                if (className == null) break block9;
                for (PyClass pyClass : PyClassNameIndex.find(className, project, false)) {
                    ProgressManager.checkCanceled();
                    PsiFile psiFile = pyClass.getContainingFile();
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    String string = virtualFile == null ? psiFile.getName() : virtualFile.getPath();
                    String string2 = FileUtilRt.getNameWithoutExtension((String)string);
                    if (!string2.endsWith(fileName) && !fileName.equals(string)) continue;
                    if (methodName == null) {
                        arrayList.add((Location)new PsiLocation(project, (PsiElement)pyClass));
                        continue;
                    }
                    PyFunction pyFunction = pyClass.findMethodByName(methodName, true, null);
                    if (pyFunction == null) continue;
                    arrayList.add((Location)new PyPsiLocationWithFixedClass(project, pyFunction, pyClass));
                }
                break block10;
            }
            if (methodName == null) break block10;
            for (PyFunction pyFunction : PyFunctionNameIndex.find(methodName, project)) {
                PsiFile psiFile;
                VirtualFile virtualFile;
                String string;
                String string3;
                ProgressManager.checkCanceled();
                if (pyFunction.getContainingClass() != null || !(string3 = FileUtilRt.getNameWithoutExtension((String)(string = (virtualFile = (psiFile = pyFunction.getContainingFile()).getVirtualFile()) == null ? psiFile.getName() : virtualFile.getPath()))).endsWith(fileName)) continue;
                arrayList.add((Location)new PsiLocation(project, (PsiElement)pyFunction));
            }
        }
        return arrayList;
    }

    static {
        a = c.a(6411044640156654340L, 4588928580603309737L, MethodHandles.lookup().lookupClass()).a(168847379192450L);
        long l2 = a ^ 0x606E71B50F90L;
        PYTHON_TEST_QUALIFIED_CLASSES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"}));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x413788C61CB3L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClassRequired";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProvidedValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/PythonUnitTestUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFunction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseClassRequired";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

