/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PyTestFrameworkService;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFSTestFrameworkListener {
    private static final Logger c;
    private final AtomicBoolean d;
    private final PyTestFrameworkService b;
    private final MergingUpdateQueue a;
    private static final long e;

    public static VFSTestFrameworkListener getInstance() {
        return (VFSTestFrameworkListener)ApplicationManager.getApplication().getComponent(VFSTestFrameworkListener.class);
    }

    public VFSTestFrameworkListener() {
        long l2 = e ^ 0x766BABBBEBA7L;
        this.d = new AtomicBoolean(false);
        this.b = PyTestFrameworkService.getInstance();
        Application application = ApplicationManager.getApplication();
        MessageBus messageBus = application.getMessageBus();
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-8333994272883965084L, 7477748557670396347L, MethodHandles.lookup().lookupClass()).a(254500881191969L);

            public void after(@NotNull List<? extends VFileEvent> events) {
                long l2 = a ^ 0x7C5DEE8B8578L;
                if (events == null) {
                    1.a(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileContentChangeEvent) continue;
                    String string = vFileEvent.getPath();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (String string2 : PyTestFrameworkService.getFrameworkNamesSet()) {
                        if (string.contains(string2)) {
                            hashSet.add(string2);
                        }
                        if (!string.contains("py-1")) continue;
                        hashSet.add("pytest");
                    }
                    if (hashSet.isEmpty()) continue;
                    for (Sdk sdk : PythonSdkType.getAllSdks()) {
                        if (PySdkUtil.isRemote(sdk)) continue;
                        for (VirtualFile virtualFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                            String string3 = virtualFile.getCanonicalPath();
                            if (string3 == null || !string.contains(string3)) continue;
                            String string4 = (String)hashSet.iterator().next();
                            VFSTestFrameworkListener.this.a(sdk, string4);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3B4FE4DD7887L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/testing/VFSTestFrameworkListener$1", "after"));
            }
        });
        this.a = new MergingUpdateQueue("TestFrameworkChecker", 5000, true, null, (Disposable)application, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void updateAllTestFrameworks(@NotNull Sdk sdk) {
        if (sdk == null) {
            VFSTestFrameworkListener.a(0);
        }
        Map<String, Boolean> map2 = this.a(sdk, PyTestFrameworkService.getFrameworkNamesArray());
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Map.Entry entry : map2.entrySet()) {
                Boolean bl2 = (Boolean)entry.getValue();
                if (bl2 == null) continue;
                this.setTestFrameworkInstalled(bl2, sdk.getHomePath(), (String)entry.getKey());
            }
        });
    }

    private void a(final @NotNull Sdk sdk, final @NotNull String string) {
        if (sdk == null) {
            VFSTestFrameworkListener.a(1);
        }
        if (string == null) {
            VFSTestFrameworkListener.a(2);
        }
        this.a.queue(new Update(Pair.create((Object)sdk, (Object)string)){

            public void run() {
                VFSTestFrameworkListener.this.b(sdk, string);
            }
        });
    }

    private void b(@Nullable Sdk sdk, @NotNull String string) {
        Boolean bl2;
        if (string == null) {
            VFSTestFrameworkListener.a(3);
        }
        if ((bl2 = this.c(sdk, string)) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.setTestFrameworkInstalled(bl2, sdk.getHomePath(), string));
        }
    }

    @Contract(value="null, _ -> null")
    private Boolean c(@Nullable Sdk sdk, @NotNull String string) {
        if (string == null) {
            VFSTestFrameworkListener.a(4);
        }
        return this.a(sdk, new String[]{string}).get(string);
    }

    @NotNull
    private Map<String, Boolean> a(@Nullable Sdk sdk, String ... stringArray) {
        List<PyPackage> list2;
        long l2 = e ^ 0x4AC34552A24BL;
        if (stringArray == null) {
            VFSTestFrameworkListener.a(5);
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (sdk == null || StringUtil.isEmptyOrSpaces((String)sdk.getHomePath())) {
            c.info("Searching test runner in empty sdk");
            HashMap<String, Boolean> hashMap2 = hashMap;
            if (hashMap2 == null) {
                VFSTestFrameworkListener.a(6);
            }
            return hashMap2;
        }
        PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk);
        boolean bl2 = PyPackageUtil.updatePackagesSynchronouslyWithGuard(pyPackageManager, this.d);
        if (bl2 && (list2 = pyPackageManager.getPackages()) != null) {
            for (String string : stringArray) {
                hashMap.put(string, PyPackageUtil.findPackage(list2, string) != null);
            }
        }
        HashMap<String, Boolean> hashMap3 = hashMap;
        if (hashMap3 == null) {
            VFSTestFrameworkListener.a(7);
        }
        return hashMap3;
    }

    public boolean isTestFrameworkInstalled(@Nullable Sdk sdk, @NotNull String name) {
        if (name == null) {
            VFSTestFrameworkListener.a(8);
        }
        if (sdk == null) {
            return false;
        }
        Boolean bl2 = this.b.getSdkToTestRunnerByName(name).get(sdk.getHomePath());
        if (bl2 == null) {
            this.a(sdk, name);
            return true;
        }
        return bl2;
    }

    public final void setTestFrameworkInstalled(boolean installed, @NotNull String sdkHome, @NotNull String name) {
        if (sdkHome == null) {
            VFSTestFrameworkListener.a(9);
        }
        if (name == null) {
            VFSTestFrameworkListener.a(10);
        }
        this.b.getSdkToTestRunnerByName(name).put(sdkHome, installed);
    }

    static {
        e = com.jetbrains.python.psi.c.a(5407599536165702525L, -7007633386359887100L, MethodHandles.lookup().lookupClass()).a(220954502945738L);
        c = Logger.getInstance(VFSTestFrameworkListener.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x10C3CD094A0CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPackageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/VFSTestFrameworkListener";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/VFSTestFrameworkListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTestFrameworksInstalled";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAllTestFrameworks";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleTestFrameworkCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFrameworkInstalledAndUpdateSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTestFrameworkInstalled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkTestFrameworksInstalled";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkInstalled";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTestFrameworkInstalled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

