/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.doctest;

import com.google.common.collect.Lists;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.stubs.PyClassStub;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PythonDocTestUtil {
    private static final long a = c.a(4314869950428711206L, -7677289181698679507L, MethodHandles.lookup().lookupClass()).a(92056545554404L);

    private PythonDocTestUtil() {
    }

    public static List<PyElement> getDocTestCasesFromFile(PyFile file) {
        ArrayList arrayList = Lists.newArrayList();
        for (StubBasedPsiElement<PyClassStub> stubBasedPsiElement : file.getTopLevelClasses()) {
            if (!PythonDocTestUtil.isDocTestClass(stubBasedPsiElement)) continue;
            arrayList.add(stubBasedPsiElement);
        }
        Object object = file.getTopLevelFunctions().iterator();
        while (object.hasNext()) {
            StubBasedPsiElement<PyClassStub> stubBasedPsiElement;
            stubBasedPsiElement = (PyFunction)object.next();
            if (!PythonDocTestUtil.isDocTestFunction((PyFunction)stubBasedPsiElement)) continue;
            arrayList.add(stubBasedPsiElement);
        }
        if (file.getDocStringExpression() != null && (object = file.getDocStringExpression()) != null && PythonDocTestUtil.hasExample(object.getStringValue())) {
            arrayList.add(file);
        }
        return arrayList;
    }

    public static boolean isDocTestFunction(PyFunction pyFunction) {
        if (pyFunction.getDocStringExpression() == null) {
            return false;
        }
        PyStringLiteralExpression pyStringLiteralExpression = pyFunction.getDocStringExpression();
        return pyStringLiteralExpression == null || PythonDocTestUtil.hasExample(pyStringLiteralExpression.getStringValue());
    }

    public static boolean isDocTestClass(PyClass pyClass) {
        Object object = pyClass.getMethods();
        int n2 = ((PyFunction[])object).length;
        for (int i10 = 0; i10 < n2; ++i10) {
            PyFunction pyFunction = object[i10];
            if (!PythonDocTestUtil.isDocTestFunction(pyFunction)) continue;
            return true;
        }
        return pyClass.getDocStringExpression() != null && (object = pyClass.getDocStringExpression()) != null && PythonDocTestUtil.hasExample(object.getStringValue());
    }

    public static boolean hasExample(String docString) {
        long l2 = a ^ 0x95F3DE6BE60L;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(docString, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (!string.startsWith(">>>")) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }
}

