/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.quickfix.CompatibilityPrintCallQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertDictCompQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertSetLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveUnderscoresInNumericLiteralsQuickFix;
import com.jetbrains.python.inspections.quickfix.RemovePrefixQuickFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingLQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBackquoteExpressionQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBuiltinsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceExceptPartQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceListComprehensionsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceNotEqOperatorQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceOctalNumericLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceRaiseStatementQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReprExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import com.jetbrains.python.validation.a;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompatibilityVisitor
extends PyAnnotator {
    @NotNull
    private static final Set<String> c;
    @NotNull
    private static final Set<String> d;
    @NotNull
    private static final Set<String> e;
    @NotNull
    protected static final String COMMON_MESSAGE = "Python version ";
    @NotNull
    protected List<LanguageLevel> myVersionsToProcess;
    private static final long j;

    public CompatibilityVisitor(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.b(0);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    @Override
    public void visitPyAnnotation(PyAnnotation node) {
        long l2 = j ^ 0x56AE2FF623CBL;
        PsiElement psiElement = node.getParent();
        if (!(psiElement instanceof PyFunction) && !(psiElement instanceof PyNamedParameter)) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support variable annotations", (PsiElement)node);
        }
    }

    @Override
    public void visitPyDictCompExpression(PyDictCompExpression node) {
        long l2 = j ^ 0x64F58251A1E9L;
        super.visitPyDictCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> !languageLevel.supportsSetLiterals() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support dictionary comprehensions", node, (LocalQuickFix)new ConvertDictCompQuickFix(), false);
    }

    @Override
    public void visitPySetLiteralExpression(PySetLiteralExpression node) {
        long l2 = j ^ 0x5350949D414DL;
        super.visitPySetLiteralExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> !languageLevel.supportsSetLiterals() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support set literal expressions", (PsiElement)node, (LocalQuickFix)new ConvertSetLiteralQuickFix(), false);
    }

    @Override
    public void visitPySetCompExpression(PySetCompExpression node) {
        long l2 = j ^ 0x369B20A76778L;
        super.visitPySetCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> !languageLevel.supportsSetLiterals() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support set comprehensions", node, null, false);
    }

    @Override
    public void visitPyExceptBlock(PyExceptPart node) {
        long l2 = j ^ 0x116DFD08080CL;
        super.visitPyExceptBlock(node);
        PyExpression pyExpression = node.getExceptClass();
        if (pyExpression != null) {
            PsiElement psiElement = pyExpression.getNextSibling();
            while (psiElement instanceof PsiWhiteSpace) {
                psiElement = psiElement.getNextSibling();
            }
            if (psiElement != null && ",".equals(psiElement.getText())) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax.", node, (LocalQuickFix)new ReplaceExceptPartQuickFix());
            }
        }
    }

    @Override
    public void visitPyImportStatement(PyImportStatement node) {
        long l2 = j ^ 0x6C6FC9DD6A8AL;
        super.visitPyImportStatement(node);
        PyIfStatement pyIfStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyIfStatement.class);
        if (pyIfStatement != null) {
            return;
        }
        for (PyImportElement pyImportElement : node.getImportElements()) {
            QualifiedName qualifiedName = pyImportElement.getImportedQName();
            if (qualifiedName == null) continue;
            if (qualifiedName.matches(new String[]{"builtins"})) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not have module builtins", (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
                continue;
            }
            if (!qualifiedName.matches(new String[]{"__builtin__"})) continue;
            this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not have module __builtin__", (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
        }
    }

    @Override
    public void visitPyStarExpression(PyStarExpression node) {
        long l2 = j ^ 0x400892B4F1FFL;
        super.visitPyStarExpression(node);
        if (node.isAssignmentTarget()) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support starred expressions as assignment targets", (PsiElement)node);
        }
        if (node.isUnpacking()) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support starred expressions in tuples, lists, and sets", (PsiElement)node);
        }
    }

    @Override
    public void visitPyDoubleStarExpression(PyDoubleStarExpression node) {
        long l2 = j ^ 0x5434A4A7CE8FL;
        super.visitPyDoubleStarExpression(node);
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support starred expressions in dicts", (PsiElement)node);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        long l2 = j ^ 0x6A44EF798F6AL;
        super.visitPyBinaryExpression(node);
        if (node.isOperator("<>")) {
            this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support <>, use != instead.", (PsiElement)node, (LocalQuickFix)new ReplaceNotEqOperatorQuickFix());
        } else if (node.isOperator("@")) {
            this.b(node.getPsiOperator());
        }
    }

    private void b(PsiElement psiElement) {
        long l2 = j ^ 0x2C12EF14692AL;
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support matrix multiplication operators", psiElement);
    }

    @Override
    public void visitPyNumericLiteralExpression(PyNumericLiteralExpression node) {
        long l2 = j ^ 0x6F0777CD6624L;
        super.visitPyNumericLiteralExpression(node);
        String string = node.getText();
        if (node.isIntegerLiteral()) {
            char c10;
            if (string.endsWith("l") || string.endsWith("L")) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support a trailing 'l' or 'L'.", (PsiElement)node, (LocalQuickFix)new RemoveTrailingLQuickFix());
            }
            if (string.length() > 1 && string.charAt(0) == '0' && (c10 = Character.toLowerCase(string.charAt(1))) != 'o' && c10 != 'b' && c10 != 'x' && string.chars().anyMatch(n2 -> n2 != 48)) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax. It requires '0o' prefix for octal literals", (PsiElement)node, (LocalQuickFix)new ReplaceOctalNumericLiteralQuickFix());
            }
        }
        if (string.contains("_")) {
            this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support underscores in numeric literals", (PsiElement)node, (LocalQuickFix)new PyRemoveUnderscoresInNumericLiteralsQuickFix());
        }
    }

    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
        long l2 = j ^ 0x410B3C2B45ACL;
        super.visitPyStringLiteralExpression(node);
        boolean bl2 = false;
        boolean bl3 = false;
        for (PyStringElement pyStringElement : node.getStringElements()) {
            String string = StringUtil.toUpperCase((String)pyStringElement.getPrefix());
            if (string.isEmpty()) continue;
            boolean bl4 = pyStringElement.isBytes();
            bl2 |= bl4;
            bl3 |= !bl4;
            int n2 = pyStringElement.getTextOffset();
            this.registerForAllMatchingVersions(languageLevel -> !CompatibilityVisitor.H(languageLevel).contains(string) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support a '" + string + "' prefix", node, TextRange.create((int)n2, (int)(n2 + pyStringElement.getPrefixLength())), new RemovePrefixQuickFix(string), true);
        }
        if (bl2 && bl3) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not allow to mix bytes and non-bytes literals", node);
        }
    }

    @NotNull
    private static Set<String> H(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            CompatibilityVisitor.b(1);
        }
        if (languageLevel.isPython2()) {
            Set<String> set = c;
            if (set == null) {
                CompatibilityVisitor.b(2);
            }
            return set;
        }
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON36)) {
            Set<String> set = d;
            if (set == null) {
                CompatibilityVisitor.b(3);
            }
            return set;
        }
        Set<String> set = e;
        if (set == null) {
            CompatibilityVisitor.b(4);
        }
        return set;
    }

    @Override
    public void visitPyListCompExpression(PyListCompExpression node) {
        long l2 = j ^ 0x2BAFFE3FB10AL;
        super.visitPyListCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)) && UnsupportedFeaturesUtil.visitPyListCompExpression(node, languageLevel), " not support this syntax in list comprehensions.", ContainerUtil.map(node.getForComponents(), PyComprehensionForComponent::getIteratedList), (LocalQuickFix)new ReplaceListComprehensionsQuickFix());
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        long l2 = j ^ 0x69D46C3ABC4CL;
        super.visitPyRaiseStatement(node);
        this.registerForAllMatchingVersions(languageLevel -> this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)) && UnsupportedFeaturesUtil.raiseHasNoArgsUnderFinally(node, languageLevel), " not support this syntax. Raise with no arguments can only be used in an except block", (PsiElement)node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)) && UnsupportedFeaturesUtil.raiseHasMoreThenOneArg(node, languageLevel), " not support this syntax.", (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)) && UnsupportedFeaturesUtil.raiseHasFromKeyword(node, languageLevel), " not support this syntax.", (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
    }

    @Override
    public void visitPyReprExpression(PyReprExpression node) {
        long l2 = j ^ 0x7F1C790FE47DL;
        super.visitPyReprExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support backquotes, use repr() instead", (PsiElement)node, (LocalQuickFix)new ReplaceBackquoteExpressionQuickFix());
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        long l2 = j ^ 0x4AE27A16BFD6L;
        super.visitPyWithStatement(node);
        PyWithItem[] pyWithItemArray = node.getWithItems();
        if (pyWithItemArray.length > 1) {
            this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> !languageLevel.supportsSetLiterals() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support multiple context managers", Arrays.asList(pyWithItemArray).subList(1, pyWithItemArray.length), null);
        }
        this.a(node);
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        super.visitPyForStatement(node);
        this.a(node);
    }

    @Override
    public void visitPyPrintStatement(PyPrintStatement node) {
        long l2 = j ^ 0x3FA12E728570L;
        super.visitPyPrintStatement(node);
        PsiElement[] psiElementArray = node.getChildren();
        Predicate<PsiElement> predicate = psiElement -> !(psiElement instanceof PyParenthesizedExpression) && !(psiElement instanceof PyTupleExpression);
        if (psiElementArray.length == 0 || Arrays.stream(psiElementArray).anyMatch(predicate)) {
            this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax. The print statement has been replaced with a print() function", (PsiElement)node, (LocalQuickFix)new CompatibilityPrintCallQuickFix());
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        long l2 = j ^ 0x1795A0781135L;
        super.visitPyCallExpression(node);
        PsiElement psiElement = node.getFirstChild();
        if (psiElement != null && "super".equals(psiElement.getText()) && ArrayUtil.isEmpty((Object[])node.getArguments())) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax. super() should have arguments in Python 2", (PsiElement)node);
        }
        this.a(node);
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        super.visitPyFunction(node);
        this.a(node);
    }

    @Override
    public void visitPyPrefixExpression(PyPrefixExpression node) {
        long l2 = j ^ 0x224D82CBE56L;
        super.visitPyPrefixExpression(node);
        if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax", (PsiElement)node);
        }
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        long l2 = j ^ 0x42AC5A10EB05L;
        super.visitPyYieldExpression(node);
        Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)node)).map(scopeOwner -> PyUtil.as(scopeOwner, PyFunction.class)).filter(pyFunction -> pyFunction.isAsync() && pyFunction.isAsyncAllowed()).ifPresent(pyFunction -> {
            long l2 = j ^ 0x46B2F21CEC1FL;
            if (!node.isDelegating() && this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
                this.registerProblem((PsiElement)node, "Python version 3.5 does not support 'yield' inside async functions");
            }
        });
        if (!node.isDelegating()) {
            return;
        }
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax. Delegating to a subgenerator is available since Python 3.3; use explicit iteration over subgenerator instead.", (PsiElement)node);
    }

    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        PyFunction pyFunction;
        long l2 = j ^ 0x1AC4751C88DEL;
        if (ContainerUtil.exists(this.myVersionsToProcess, languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel))) && (pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class})) != null && node.getExpression() != null) {
            YieldVisitor yieldVisitor = new YieldVisitor(null);
            pyFunction.acceptChildren(yieldVisitor);
            if (yieldVisitor.haveYield()) {
                this.registerProblem((PsiElement)node, "Python versions < 3.3 do not allow 'return' with argument inside generator.");
            }
        }
    }

    @Override
    public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
        long l2 = j ^ 0x14A9FA7B6ACCL;
        if (node.isEllipsis()) {
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PySubscriptionExpression.class);
            if (pySubscriptionExpression != null && PsiTreeUtil.isAncestor((PsiElement)pySubscriptionExpression.getIndexExpression(), (PsiElement)node, (boolean)false)) {
                return;
            }
            PySliceItem pySliceItem = (PySliceItem)PsiTreeUtil.getParentOfType((PsiElement)node, PySliceItem.class);
            if (pySliceItem != null) {
                return;
            }
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support '...' outside of sequence slicings.", (PsiElement)node);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        IElementType iElementType;
        super.visitPyAugAssignmentStatement(node);
        PsiElement psiElement = node.getOperation();
        if (psiElement != null && ((Object)((Object)PyTokenTypes.ATEQ)).equals(iElementType = psiElement.getNode().getElementType())) {
            this.b(psiElement);
        }
    }

    private void a(@NotNull PsiElement psiElement) {
        ASTNode aSTNode;
        long l2 = j ^ 0x6DC19C6E740FL;
        if (psiElement == null) {
            CompatibilityVisitor.b(5);
        }
        if ((aSTNode = psiElement.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)) != null) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support this syntax", psiElement, aSTNode.getTextRange(), null, true);
        }
    }

    protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            CompatibilityVisitor.b(6);
        }
        return true;
    }

    protected abstract void registerProblem(@NotNull PsiElement var1, @NotNull TextRange var2, @NotNull String var3, @Nullable LocalQuickFix var4, boolean var5);

    protected void registerProblem(@NotNull PsiElement node, @NotNull String message, @Nullable LocalQuickFix localQuickFix) {
        if (node == null) {
            CompatibilityVisitor.b(7);
        }
        if (message == null) {
            CompatibilityVisitor.b(8);
        }
        this.registerProblem(node, node.getTextRange(), message, localQuickFix, true);
    }

    protected void registerProblem(@NotNull PsiElement node, @NotNull String message) {
        if (node == null) {
            CompatibilityVisitor.b(9);
        }
        if (message == null) {
            CompatibilityVisitor.b(10);
        }
        this.registerProblem(node, message, null);
    }

    protected void setVersionsToProcess(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.b(11);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull Iterable<Pair<? extends PsiElement, TextRange>> nodesWithRanges, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        List list2;
        long l2 = j ^ 0x51FB71A4420L;
        if (levelPredicate == null) {
            CompatibilityVisitor.b(12);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(13);
        }
        if (nodesWithRanges == null) {
            CompatibilityVisitor.b(14);
        }
        if (!(list2 = this.myVersionsToProcess.stream().filter(levelPredicate).map(LanguageLevel::toString).collect(Collectors.toList())).isEmpty()) {
            String string = COMMON_MESSAGE + StringUtil.join(list2, (String)", ") + (list2.size() == 1 ? " does" : " do") + suffix;
            for (Pair<? extends PsiElement, TextRange> pair : nodesWithRanges) {
                this.registerProblem((PsiElement)pair.first, (TextRange)pair.second, string, localQuickFix, asError);
            }
        }
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull Iterable<? extends PsiElement> nodes, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.b(15);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(16);
        }
        if (nodes == null) {
            CompatibilityVisitor.b(17);
        }
        List list2 = ContainerUtil.map(nodes, psiElement -> Pair.createNonNull((Object)psiElement, (Object)psiElement.getTextRange()));
        this.registerForAllMatchingVersions(levelPredicate, suffix, list2, localQuickFix, true);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @NotNull TextRange range, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.b(18);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(19);
        }
        if (node == null) {
            CompatibilityVisitor.b(20);
        }
        if (range == null) {
            CompatibilityVisitor.b(21);
        }
        List<Pair.NonNull> list2 = Collections.singletonList(Pair.createNonNull((Object)node, (Object)range));
        this.registerForAllMatchingVersions(levelPredicate, suffix, list2, localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.b(22);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(23);
        }
        if (node == null) {
            CompatibilityVisitor.b(24);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, node.getTextRange(), localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.b(25);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(26);
        }
        if (node == null) {
            CompatibilityVisitor.b(27);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, localQuickFix, true);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull String suffix, @NotNull PsiElement node) {
        if (levelPredicate == null) {
            CompatibilityVisitor.b(28);
        }
        if (suffix == null) {
            CompatibilityVisitor.b(29);
        }
        if (node == null) {
            CompatibilityVisitor.b(30);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, null, true);
    }

    @Override
    public void visitPyNonlocalStatement(PyNonlocalStatement node) {
        long l2 = j ^ 0x78004CB5C622L;
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not have nonlocal keyword", (PsiElement)node);
    }

    private void a(@NotNull PyCallExpression pyCallExpression) {
        PsiElement psiElement;
        long l2 = j ^ 0x312CE747151BL;
        if (pyCallExpression == null) {
            CompatibilityVisitor.b(31);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (PyExpression pyExpression : pyCallExpression.getArguments()) {
            Object object;
            if (pyExpression instanceof PyKeywordArgument) {
                object = ((PyKeywordArgument)pyExpression).getKeyword();
                if (hashSet.contains(object)) {
                    this.registerProblem((PsiElement)pyExpression, "Keyword argument repeated", new PyRemoveArgumentQuickFix());
                } else if (bl3) {
                    this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)((Object)languageLevel))), " not allow keyword arguments after **expression", (PsiElement)pyExpression, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                }
                bl2 = true;
                hashSet.add(object);
                continue;
            }
            if (pyExpression instanceof PyStarArgument) {
                object = (PyStarArgument)pyExpression;
                if (object.isKeyword()) {
                    if (bl3) {
                        this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)((Object)languageLevel))), " not allow duplicate **expressions", (PsiElement)pyExpression, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                    }
                    bl3 = true;
                    continue;
                }
                if (bl4) {
                    this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)((Object)languageLevel))), " not allow duplicate *expressions", (PsiElement)pyExpression, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                }
                bl4 = true;
                continue;
            }
            if (bl2) {
                this.registerProblem((PsiElement)pyExpression, "Positional argument after keyword argument", new PyRemoveArgumentQuickFix());
                continue;
            }
            if (bl4) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)((Object)languageLevel))), " not allow positional arguments after *expression", (PsiElement)pyExpression, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                continue;
            }
            if (!bl3) continue;
            this.registerProblem((PsiElement)pyExpression, "Positional argument after **expression", new PyRemoveArgumentQuickFix());
        }
        PyExpression pyExpression = (PyExpression)ContainerUtil.getLastItem(Arrays.asList(pyCallExpression.getArguments()));
        if (pyExpression instanceof PyStarArgument && (psiElement = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)pyExpression)) != null && psiElement.getNode().getElementType() == PyTokenTypes.COMMA) {
            int n2 = ((PyStarArgument)pyExpression).isKeyword() ? 1 : 0;
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)((Object)languageLevel))), " not allow a trailing comma after " + (n2 != 0 ? "**" : "*") + "expression", psiElement);
        }
    }

    @Override
    public void visitPyComprehensionElement(PyComprehensionElement node) {
        super.visitPyComprehensionElement(node);
        if (this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
            Arrays.stream(node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.ASYNC_KEYWORD}))).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(psiElement -> {
                long l2 = j ^ 0x63ECF2F7CD8BL;
                this.registerProblem((PsiElement)psiElement, "Python version 3.5 does not support 'async' inside comprehensions and generator expressions");
            });
            Stream stream2 = PsiTreeUtil.collectElementsOfType((PsiElement)node.getResultExpression(), (Class[])new Class[]{PyPrefixExpression.class}).stream();
            Stream stream3 = node.getIfComponents().stream().map(pyComprehensionIfComponent -> PsiTreeUtil.collectElementsOfType((PsiElement)pyComprehensionIfComponent.getTest(), (Class[])new Class[]{PyPrefixExpression.class})).flatMap(Collection::stream);
            Stream.concat(stream2, stream3).filter(pyPrefixExpression -> pyPrefixExpression.getOperator() == PyTokenTypes.AWAIT_KEYWORD && pyPrefixExpression.getOperand() != null).map(pyPrefixExpression -> pyPrefixExpression.getNode().findChildByType((IElementType)PyTokenTypes.AWAIT_KEYWORD)).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(psiElement -> {
                long l2 = j ^ 0x40A26042880BL;
                this.registerProblem((PsiElement)psiElement, "Python version 3.5 does not support 'await' inside comprehensions");
            });
        }
    }

    @Override
    public void visitPySlashParameter(PySlashParameter node) {
        long l2 = j ^ 0x464EE65732D8L;
        super.visitPySlashParameter(node);
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support positional-only parameters", (PsiElement)node);
    }

    @Override
    public void visitPyFStringFragment(PyFStringFragment node) {
        long l2 = j ^ 0x38563E07F38FL;
        super.visitPyFStringFragment(node);
        ASTNode aSTNode = node.getNode().findChildByType((IElementType)PyTokenTypes.EQ);
        if (aSTNode != null) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support equality signs in f-strings", aSTNode.getPsi());
        }
    }

    @Override
    public void visitPyAssignmentExpression(PyAssignmentExpression node) {
        long l2 = j ^ 0x534F9811D71AL;
        super.visitPyAssignmentExpression(node);
        this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support assignment expressions", (PsiElement)node);
    }

    @Override
    public void visitPyContinueStatement(PyContinueStatement node) {
        long l2 = j ^ 0x5F513DB5CCDAL;
        super.visitPyContinueStatement(node);
        if (PsiTreeUtil.getParentOfType((PsiElement)node, PyFinallyPart.class, (boolean)false, (Class[])new Class[]{PyLoopStatement.class}) != null) {
            this.registerForAllMatchingVersions(languageLevel -> languageLevel.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)languageLevel)), " not support 'continue' inside 'finally' clause", (PsiElement)node);
        }
    }

    static {
        j = com.jetbrains.python.psi.c.a(3718299893104310915L, 2665506013494329434L, MethodHandles.lookup().lookupClass()).a(153434583936765L);
        long l2 = j ^ 0x2C261FDF5063L;
        c = Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"});
        d = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"});
        e = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB", "F", "FR", "RF"});
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0xA5D9AA6F0CEL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsToProcess";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 20: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "levelPredicate";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesWithRanges";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedStringPrefixes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedStringPrefixes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAsyncKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerForLanguageLevel";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setVersionsToProcess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerForAllMatchingVersions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "highlightIncorrectArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class YieldVisitor
    extends PyElementVisitor {
        private boolean a = false;

        private YieldVisitor() {
        }

        public boolean haveYield() {
            return this.a;
        }

        @Override
        public void visitPyYieldExpression(PyYieldExpression node) {
            this.a = true;
        }

        @Override
        public void visitPyElement(PyElement node) {
            if (!this.a) {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyFunction(PyFunction node) {
        }

        /* synthetic */ YieldVisitor(a x0) {
            this();
        }
    }
}

