/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFStringFragmentFormatPart;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.validation.PyAnnotator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FStringsAnnotator
extends PyAnnotator {
    private static final long c = com.jetbrains.python.psi.c.a(-4058647158765602520L, 7916069418372605179L, MethodHandles.lookup().lookupClass()).a(148631127172126L);

    @Override
    public void visitPyFStringFragment(PyFStringFragment node) {
        boolean bl2;
        PsiElement psiElement;
        long l2 = c ^ 0x54979FE8C1CAL;
        List list2 = PsiTreeUtil.collectParents((PsiElement)node, PyFStringFragment.class, (boolean)false, PyStringLiteralExpression.class::isInstance);
        if (list2.size() > 1) {
            this.report((PsiElement)node, "Expression fragment inside f-string is nested too deeply");
        }
        if ((psiElement = node.getTypeConversion()) != null) {
            String string = psiElement.getText().substring(1);
            if (string.isEmpty()) {
                this.report(psiElement, "Conversion character is expected: should be one of 's', 'r', 'a'");
            } else if (string.length() > 1 || "sra".indexOf(string.charAt(0)) < 0) {
                this.report(psiElement, "Illegal conversion character '" + string + "': should be one of 's', 'r', 'a'");
            }
        }
        boolean bl3 = bl2 = PsiTreeUtil.getParentOfType((PsiElement)node, PyFStringFragment.class, (boolean)true) == null;
        if (bl2) {
            ArrayList arrayList = Lists.newArrayList((Object[])new PyFStringFragment[]{node});
            PyFStringFragmentFormatPart pyFStringFragmentFormatPart = node.getFormatPart();
            if (pyFStringFragmentFormatPart != null) {
                arrayList.addAll(pyFStringFragmentFormatPart.getFragments());
            }
            for (PyFStringFragment pyFStringFragment : arrayList) {
                String string = pyFStringFragment.getText();
                TextRange textRange = pyFStringFragment.getExpressionContentRange();
                for (int i10 = textRange.getStartOffset(); i10 < textRange.getEndOffset(); ++i10) {
                    if (string.charAt(i10) != '\\') continue;
                    this.reportCharacter((PsiElement)pyFStringFragment, i10, "Expression fragments inside f-strings cannot include backslashes");
                }
            }
        }
    }

    @Override
    public void visitPyFormattedStringElement(PyFormattedStringElement node) {
        long l2 = c ^ 0x632990888B3BL;
        String string = node.getText();
        for (TextRange textRange : node.getLiteralPartRanges()) {
            int n2 = textRange.getStartOffset();
            while (n2 < textRange.getEndOffset()) {
                int n3 = FStringsAnnotator.a(string, n2, textRange.getEndOffset());
                if (n2 != n3) {
                    n2 = n3;
                    continue;
                }
                char c10 = string.charAt(n2);
                if (c10 == '}') {
                    if (n2 + 1 < textRange.getEndOffset() && string.charAt(n2 + 1) == '}') {
                        n2 += 2;
                        continue;
                    }
                    this.reportCharacter(node, n2, "Single '}' is not allowed inside f-strings");
                }
                ++n2;
            }
        }
    }

    private static int a(@NotNull String string, int n2, int n3) {
        long l2 = c ^ 0x25F9B82C4FE4L;
        if (string == null) {
            FStringsAnnotator.b(0);
        }
        if (StringUtil.startsWith((CharSequence)string, (int)n2, (CharSequence)"\\N{")) {
            int n4 = string.indexOf(125, n2 + 3);
            return n4 < 0 ? n3 : n4 + 1;
        }
        return n2;
    }

    public void visitComment(PsiComment comment) {
        boolean bl2;
        long l2 = c ^ 0x770864BCADBDL;
        boolean bl3 = bl2 = PsiTreeUtil.getParentOfType((PsiElement)comment, PyFStringFragment.class) != null;
        if (bl2) {
            this.report((PsiElement)comment, "Expression fragments inside f-strings cannot include line comments");
        }
    }

    public void reportCharacter(PsiElement element, int offset, String message) {
        int n2 = element.getTextRange().getStartOffset();
        this.getHolder().createErrorAnnotation(TextRange.from((int)offset, (int)1).shiftRight(n2), message);
    }

    public void report(PsiElement element, String error) {
        this.getHolder().createErrorAnnotation(element, error);
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = c ^ 0xD67BAD0DFC2L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeText", "com/jetbrains/python/validation/FStringsAnnotator", "skipNamedUnicodeEscape"));
    }
}

