/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyUtils {
    private static final Key<Boolean> a;
    private static final Key<Boolean> b;
    private static final long c;

    private Web2PyUtils() {
    }

    public static boolean isWeb2PyProject(Project project) {
        long l2 = c ^ 0x40593E682305L;
        Boolean bl2 = (Boolean)project.getUserData(a);
        if (bl2 != null) {
            return bl2;
        }
        HashSet hashSet = Sets.newHashSet();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (Module module2 : moduleArray) {
            hashSet.addAll(PyUtil.getSourceRoots(module2));
        }
        Collections.addAll(hashSet, ProjectRootManager.getInstance((Project)project).getContentRoots());
        for (VirtualFile virtualFile : hashSet) {
            if (!virtualFile.getName().equals("web2py")) continue;
            project.putUserData(a, (Object)Boolean.TRUE);
            return true;
        }
        VirtualFile virtualFile = project.getBaseDir();
        VirtualFile virtualFile2 = virtualFile == null ? null : virtualFile.findChild("gluon");
        int n2 = virtualFile2 != null ? 1 : 0;
        project.putUserData(a, (Object)(n2 != 0));
        return n2 != 0;
    }

    public static boolean isWeb2PyApp(Project project) {
        VirtualFile virtualFile = project.getBaseDir();
        if (virtualFile == null) {
            return false;
        }
        return Web2PyUtils.isWeb2PyApp(virtualFile);
    }

    public static boolean isWeb2PyApp(@NotNull VirtualFile baseDir) {
        Boolean bl2;
        long l2 = c ^ 0x6D96850A022CL;
        if (baseDir == null) {
            Web2PyUtils.a(0);
        }
        if ((bl2 = (Boolean)baseDir.getUserData(b)) != null) {
            return bl2;
        }
        VirtualFile virtualFile = baseDir.findChild("controllers");
        VirtualFile virtualFile2 = baseDir.findChild("views");
        VirtualFile virtualFile3 = baseDir.findChild("models");
        bl2 = virtualFile != null && virtualFile2 != null && virtualFile3 != null;
        baseDir.putUserData(b, (Object)bl2);
        return bl2;
    }

    @Nullable
    public static VirtualFile getViewFile(@NotNull PyFunction function, boolean isMobile) {
        String string;
        if (function == null) {
            Web2PyUtils.a(1);
        }
        String string2 = string = isMobile ? null : Web2PyUtils.getViewNameDefinedInFunction(function);
        if (string == null) {
            string = Web2PyUtils.getViewName(function, isMobile);
        }
        if (string == null) {
            return null;
        }
        return Web2PyUtils.getViewFileByFunctionName(function, string);
    }

    public static String getViewName(@NotNull PyFunction function, boolean isMobile) {
        String string;
        long l2 = c ^ 0x182189151488L;
        if (function == null) {
            Web2PyUtils.a(2);
        }
        if ((string = function.getName()) == null) {
            return null;
        }
        PsiFile psiFile = function.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        String string2 = Web2PyUtils.getFileNameWithoutExtension((PsiFileSystemItem)psiFile) + "/" + string;
        if (isMobile) {
            string2 = string2 + ".mobile";
        }
        string2 = string2 + ".html";
        return string2;
    }

    @Nullable
    public static String getViewNameDefinedInFunction(@NotNull PyFunction function) {
        if (function == null) {
            Web2PyUtils.a(3);
        }
        ViewNameVisitor viewNameVisitor = new ViewNameVisitor();
        function.accept(viewNameVisitor);
        return viewNameVisitor.a;
    }

    @Nullable
    public static VirtualFile getViewFileByFunctionName(@NotNull PyFunction function, @Nullable String viewName) {
        String string;
        long l2 = c ^ 0x56F27E136FC0L;
        if (function == null) {
            Web2PyUtils.a(4);
        }
        if ((string = function.getName()) == null) {
            return null;
        }
        PsiFile psiFile = function.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiDirectory psiDirectory = psiFile.getContainingDirectory();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory.getParentDirectory();
        if (psiDirectory2 == null) {
            return null;
        }
        return psiDirectory2.getVirtualFile().findFileByRelativePath("views/" + viewName);
    }

    public static String getFileNameWithoutExtension(@NotNull PsiFileSystemItem file) {
        String string;
        int n2;
        long l2 = c ^ 0x3D885D3EFC6L;
        if (file == null) {
            Web2PyUtils.a(5);
        }
        if ((n2 = (string = file.getName()).lastIndexOf(46)) < 0) {
            return string;
        }
        String string2 = ".mobile";
        if (string.substring(0, n2).endsWith(".mobile")) {
            n2 = string.lastIndexOf(".mobile");
        }
        return string.substring(0, n2);
    }

    @Nullable
    public static VirtualFile findGluon(@NotNull Project project) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x4F0C1327A272L;
        if (project == null) {
            Web2PyUtils.a(6);
        }
        if ((virtualFile = LocalFileSystem.getInstance().findFileByPath(project.getBasePath())) == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("web2py");
        if (virtualFile2 != null) {
            return virtualFile2.findChild("gluon");
        }
        VirtualFile virtualFile3 = virtualFile.findChild("gluon");
        if (virtualFile3 != null) {
            return virtualFile3;
        }
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        if (moduleArray.length > 0) {
            VirtualFile virtualFile4 = virtualFile.getParent().getParent();
            if (virtualFile4.getName().equals("web2py")) {
                return virtualFile4.findChild("gluon");
            }
            Sdk sdk = PythonSdkType.findPythonSdk(moduleArray[0]);
            if (sdk instanceof ProjectJdkImpl) {
                VirtualFile[] virtualFileArray;
                PyPackage pyPackage;
                List<PyPackage> list2 = PyPackageManager.getInstance(sdk).getPackages();
                PyPackage pyPackage2 = pyPackage = list2 != null ? PyPackageUtil.findPackage(list2, "web2py") : null;
                if (pyPackage == null) {
                    return null;
                }
                for (VirtualFile virtualFile5 : virtualFileArray = ((ProjectJdkImpl)sdk).getRoots(OrderRootType.CLASSES)) {
                    VirtualFile virtualFile6 = virtualFile5.findChild("gluon");
                    if (virtualFile6 == null) continue;
                    return virtualFile6;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getApplicationBase(@NotNull PsiFile file) {
        PsiDirectory psiDirectory;
        PsiDirectory psiDirectory2;
        long l2 = c ^ 0x7EB78E79E772L;
        if (file == null) {
            Web2PyUtils.a(7);
        }
        for (psiDirectory2 = file.getContainingDirectory(); !(psiDirectory2 == null || psiDirectory2.getVirtualFile().equals(file.getProject().getBaseDir()) || (psiDirectory = psiDirectory2.getParentDirectory()) != null && "applications".equals(psiDirectory.getName())); psiDirectory2 = psiDirectory2.getParentDirectory()) {
        }
        return psiDirectory2;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-3027165200542255130L, -7137559396115801744L, MethodHandles.lookup().lookupClass()).a(252810958615232L);
        long l2 = c ^ 0x659F9A6AFB73L;
        a = Key.create((String)"WEB2PY_PROJECT");
        b = Key.create((String)"WEB2PY_APP");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x4E2DEC542B20L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/web2py/Web2PyUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWeb2PyApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewNameDefinedInFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewFileByFunctionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findGluon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationBase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ViewNameVisitor
    extends PyRecursiveElementVisitor {
        private String a;
        private static final long b = com.jetbrains.python.psi.c.a(7791967089360478041L, -1896083126273662166L, MethodHandles.lookup().lookupClass()).a(97945673327415L);

        ViewNameVisitor() {
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            PyExpression pyExpression;
            long l2 = b ^ 0x3759F78899CL;
            super.visitPyStringLiteralExpression(node);
            PsiElement psiElement = node.getParent();
            if (psiElement instanceof PyAssignmentStatement && (pyExpression = ((PyAssignmentStatement)psiElement).getLeftHandSideExpression()) instanceof PyTargetExpression && pyExpression.getText().equals("response.view")) {
                this.a = node.getStringValue();
            }
        }
    }
}

