/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.c;
import icons.RubyIcons;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.detector.RubyGemDetector;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceWithPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class GemReference
extends RubyPolyVariantReferenceWithPsiElement {
    private final RPsiElement d;
    @NotNull
    private final AtomicNotNullLazyValue<TextRange> c;
    private static final long e = com.jetbrains.python.psi.c.a(-4987903759597028266L, 7114578291252828045L, MethodHandles.lookup().lookupClass()).a(82920837304022L);

    public GemReference(@NotNull RPossibleCall rCall, RPsiElement gemName) {
        if (rCall == null) {
            GemReference.d(0);
        }
        super((PsiElement)rCall);
        this.c = AtomicNotNullLazyValue.createValue(() -> this.a());
        this.d = gemName;
    }

    private TextRange a() {
        int n2;
        int n3 = n2 = this.d.getTextOffset() - this.myElement.getTextOffset();
        if (this.d instanceof RBaseString) {
            PsiElement psiElement = this.d.getFirstChild();
            if (psiElement != null) {
                n3 += psiElement.getTextLength();
            }
            int n4 = n2 + this.d.getTextLength();
            PsiElement psiElement2 = this.d.getLastChild();
            if (psiElement2 != null && psiElement2.getNode().getElementType() == RubyTokenTypes.tSTRING_END) {
                n4 -= psiElement2.getTextLength();
            }
            return new TextRange(n3, n4);
        }
        return new TextRange(n2, n2 + this.d.getTextLength());
    }

    @NotNull
    public RPossibleCall getElement() {
        RPossibleCall rPossibleCall = (RPossibleCall)this.myElement;
        if (rPossibleCall == null) {
            GemReference.d(1);
        }
        return rPossibleCall;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = (TextRange)this.c.getValue();
        if (textRange == null) {
            GemReference.d(2);
        }
        return textRange;
    }

    public boolean hasDynamicSubstitutions() {
        if (GemReference.a(this.d)) {
            return true;
        }
        for (RPsiElement rPsiElement : this.getElement().getArguments()) {
            if (!GemReference.a(rPsiElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(RPsiElement rPsiElement) {
        return rPsiElement instanceof RStringLiteral && ((RStringLiteral)rPsiElement).hasExpressionSubstitutions();
    }

    @Override
    @NotNull
    protected ResolveResult[] multiResolveInner(boolean incompleteCode) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.d);
        if (module2 == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.d(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GemDependency gemDependency = this.getDependency(false);
        if (gemDependency == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.d(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GemInfo gemInfo = GemSearchUtil.findGem(GemManager.getAllGems(module2), gemDependency);
        VirtualFile virtualFile2 = virtualFile = gemInfo != null ? gemInfo.getLibFolder() : null;
        if (virtualFile == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.d(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String string = gemDependency.getLibScript();
        String string2 = string != null ? string : this.getGemName();
        VirtualFile virtualFile3 = RFileUtil.findFileRelativeTo(virtualFile, string2);
        PsiFile psiFile2 = psiFile = virtualFile3 != null ? this.d.getManager().findFile(virtualFile3) : null;
        if (psiFile == null) {
            psiFile = this.d.getManager().findDirectory(virtualFile);
        }
        ResolveResult[] resolveResultArray = psiFile == null ? ResolveResult.EMPTY_ARRAY : PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{psiFile});
        if (resolveResultArray == null) {
            GemReference.d(6);
        }
        return resolveResultArray;
    }

    public String getGemName() {
        return TextUtil.removeQuoting(this.d.getText());
    }

    @Nullable
    public GemDependency getDependency(boolean ignoreLocker) {
        if (this.getElement().getCommand() == null) {
            return null;
        }
        return RubyGemDetector.buildRequirement(this.getElement(), ignoreLocker, null);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            GemReference.d(7);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        long l2 = e ^ 0x3BB131D13199L;
        if (newElementName == null) {
            GemReference.d(8);
        }
        throw new UnsupportedOperationException("method handleElementRename is not supported in org.jetbrains.plugins.ruby.ruby.codeInsight.references.GemReference");
    }

    @Override
    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GemReference.d(9);
        }
        return null;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GemReference.d(10);
        }
        return false;
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            GemReference.d(11);
        }
        if (result == null) {
            GemReference.d(12);
        }
        this.processCompletions((Consumer<LookupElement>)((Consumer)lookupElement -> result.addElement(lookupElement)));
    }

    public void processCompletions(@NotNull Consumer<LookupElement> elementConsumer) {
        if (elementConsumer == null) {
            GemReference.d(13);
        }
        if (this.d instanceof RBaseString) {
            this.a(elementConsumer, true);
        } else if (this.d instanceof RConstant && RConstantImpl.isDummyIdentifier((PsiElement)this.d)) {
            this.a(elementConsumer, false);
        }
    }

    private void a(@NotNull Consumer<LookupElement> consumer, boolean bl2) {
        if (consumer == null) {
            GemReference.d(14);
        }
        RFile rFile = RubyPsiUtil.getRFile(this.myElement);
        assert (rFile != null);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)rFile);
        if (module2 == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        if (RubySdkUtil.isRubySDK(sdk)) {
            for (GemInfo gemInfo : GemManager.getInstance().getAllGems(sdk, module2)) {
                String string = gemInfo.getName();
                String string2 = bl2 ? string : "'" + string + "'";
                consumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(string2, null, gemInfo.getVersion(), true, RubyIcons.Ruby.Ruby, null), (double)RubyCompletionGrouping.GEM_REF.getValue()));
            }
        }
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        GemReference gemReference = (GemReference)o2;
        return !(this.d != null ? !this.d.equals(gemReference.d) : gemReference.d != null);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        return n2;
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x7D24B5C4FCD9L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processCompletions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addGemNamesVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

