/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigDataService;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class BundleConfig {
    public static final String CONFIG_FILE_NAME = "config";
    private static final String b;
    private static final String d = "BUNDLE_";
    static final String PATH_TO_USER_BUNDLE_FOLDER;
    static final String PATH_TO_USER_BUNDLE_CONFIG;
    private static final String c = "local.";
    private static final String f;
    @NotNull
    private final VirtualFile e;
    @NotNull
    private final VirtualFile a;
    private static final long g;

    private BundleConfig(@NotNull VirtualFile configFile, @NotNull VirtualFile root) {
        if (configFile == null) {
            BundleConfig.a(0);
        }
        if (root == null) {
            BundleConfig.a(1);
        }
        this.e = configFile;
        this.a = root;
    }

    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.e;
        if (virtualFile == null) {
            BundleConfig.a(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.a;
        if (virtualFile == null) {
            BundleConfig.a(3);
        }
        return virtualFile;
    }

    @NotNull
    public Map<String, String> getValues() {
        Map<String, String> map2 = BundleConfigDataService.getInstance().getValues(this.e);
        if (map2 == null) {
            BundleConfig.a(4);
        }
        return map2;
    }

    @Contract(value="null->null")
    @Nullable
    public String getValue(@Nullable String key) {
        return this.getValues().get(key);
    }

    @NotNull
    public Map<String, String> getLocalGemsPathNamesMap() {
        Ref ref = Ref.create();
        this.getValues().forEach((string, string2) -> {
            if (!StringUtil.startsWith((CharSequence)string, (CharSequence)f)) {
                return;
            }
            if (ref.isNull()) {
                ref.set(new HashMap());
            }
            ((Map)ref.get()).put(StringUtil.toLowerCase((String)StringUtil.trimStart((String)string, (String)f)), string2);
        });
        Map map2 = ref.isNull() ? Collections.emptyMap() : (Map)ref.get();
        if (map2 == null) {
            BundleConfig.a(5);
        }
        return map2;
    }

    @Contract(value="null->null")
    @Nullable
    public String getPathValue(@Nullable String key) {
        return (String)ObjectUtils.doIfNotNull((Object)this.getValue(key), FileUtil::expandUserHome);
    }

    @Contract(value="null->null")
    @Nullable
    public VirtualFile getPathValueVirtualFile(@Nullable String key) {
        return (VirtualFile)ReadAction.compute(() -> {
            if (!this.a.isValid() || !this.a.isDirectory() || key == null) {
                return null;
            }
            String string2 = this.getPathValue(key);
            if (StringUtil.isEmpty((String)string2)) {
                return null;
            }
            return FileUtil.isAbsolute((String)string2) ? VfsUtil.findFileByIoFile((File)new File(string2), (boolean)false) : this.a.findFileByRelativePath(string2);
        });
    }

    @Nullable
    public VirtualFile getBundlePathVirtualFile() {
        long l2 = g ^ 0x226466D5844DL;
        return this.getPathValueVirtualFile("BUNDLE_PATH");
    }

    @Nullable
    public List<String> getBundleWithout() {
        long l2 = g ^ 0x1B60630B410DL;
        return (List)ObjectUtils.doIfNotNull((Object)this.getValue("BUNDLE_WITHOUT"), string -> Arrays.asList(string.split(":")));
    }

    @Nullable
    public VirtualFile getBundleGemfileVirtualFile() {
        long l2 = g ^ 0x64F7C2EBB0L;
        return this.getPathValueVirtualFile("BUNDLE_GEMFILE");
    }

    @NotNull
    private static String a(@NotNull String string) {
        long l2 = g ^ 0x6A48C0C695D1L;
        if (string == null) {
            BundleConfig.a(6);
        }
        String string2 = d + StringUtil.replace((String)string, (String)".", (String)"__").toUpperCase(Locale.getDefault());
        if (string2 == null) {
            BundleConfig.a(7);
        }
        return string2;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    @Nullable
    private static BundleConfig a(@Nullable VirtualFile virtualFile, @Nullable VirtualFile virtualFile2) {
        return (BundleConfig)ReadAction.compute(() -> {
            if (!(virtualFile != null && virtualFile2 != null && virtualFile2.isValid() && virtualFile.isValid() && BundleConfig.isConfig(virtualFile))) {
                return null;
            }
            return new BundleConfig(virtualFile, virtualFile2);
        });
    }

    @Contract(value="null -> null")
    @Nullable
    static BundleConfig createConfig(@Nullable Module module2) {
        if (module2 == null) {
            return null;
        }
        Ref ref = Ref.create();
        RModuleUtil.processFilesInModuleRoot(module2, false, false, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(virtualFile, virtualFile2) -> {
            ref.set((Object)BundleConfig.a(virtualFile, virtualFile2));
            return false;
        }), b);
        return (BundleConfig)ref.get();
    }

    @Contract(value="null -> null")
    @Nullable
    static BundleConfig createUserConfig(@Nullable Module module2) {
        if (module2 == null) {
            return null;
        }
        VirtualFile[] virtualFileArray = RModuleUtil.getContentRoots(module2);
        return virtualFileArray.length == 0 ? null : BundleConfig.a(virtualFileArray[0]);
    }

    @Nullable
    private static BundleConfig a(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            BundleConfig.a(8);
        }
        return BundleConfig.a(VfsUtil.findFileByIoFile((File)new File(PATH_TO_USER_BUNDLE_CONFIG), (boolean)false), virtualFile);
    }

    public static boolean isConfig(@Nullable VirtualFile file) {
        long l2 = g ^ 0x3D90D65F4843L;
        return file != null && !file.isDirectory() && CONFIG_FILE_NAME.equals(file.getName()) && BundlerUtil.isBundlerDir(file.getParent());
    }

    static {
        g = com.jetbrains.python.psi.c.a(8172830404091558533L, -2931399976175479979L, MethodHandles.lookup().lookupClass()).a(76491432820537L);
        long l2 = g ^ 0x577E7095405DL;
        b = FileUtil.join((String[])new String[]{".bundle", CONFIG_FILE_NAME});
        PATH_TO_USER_BUNDLE_FOLDER = FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), ".bundle"});
        PATH_TO_USER_BUNDLE_CONFIG = FileUtil.join((String[])new String[]{PATH_TO_USER_BUNDLE_FOLDER, CONFIG_FILE_NAME});
        f = BundleConfig.a(c);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x7C4024859526L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configRoot";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsPathNamesMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEnvKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildEnvKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createUserConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

