/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.gem.CachingGemDescriptionProvider;
import org.jetbrains.plugins.ruby.gem.ui.GemSpeedSearch;
import org.jetbrains.plugins.ruby.gem.ui.GemTableCellRenderer;
import org.jetbrains.plugins.ruby.gem.ui.GemTableModel;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.ui.tabs.EvaluatingComponent;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.support.UIUtil;

public class GemUiUtil {
    private static final Logger b;
    private static final Comparator<String> a;
    private static final long c;

    private GemUiUtil() {
    }

    public static void updateDescription(JBTable table, GemTableModel model, JTextPane text2, @Nullable EvaluatingComponent<Pair<String, String>> descriptionUpdater, @Nullable Sdk sdk, @Nullable Module module2) {
        long l2 = c ^ 0x4BF6E49CF7C9L;
        GemInfo gemInfo = GemUiUtil.a(table, model);
        StringBuilder stringBuilder = new StringBuilder();
        if (gemInfo != null) {
            GemUiUtil.a(gemInfo, stringBuilder);
            String string = gemInfo.getReadme();
            if (string != null) {
                stringBuilder.append(RubyDocumentationMarkupUtil.processGemDocumentation(string));
            } else if (!gemInfo.isRemote()) {
                stringBuilder.append(RBundle.message("gems.ui.common.description.not.available"));
            } else {
                stringBuilder.append(RBundle.message("gems.add.dialog.description.not.available.remote.gem"));
                GemUiUtil.a(descriptionUpdater, text2, sdk, module2, gemInfo, table);
            }
            text2.setText(stringBuilder.toString());
        } else {
            text2.setText("&nbsp;");
        }
        text2.setCaretPosition(0);
    }

    private static void a(@NotNull GemInfo gemInfo, @NotNull StringBuilder stringBuilder) {
        long l2 = c ^ 0x3F9B8E41931FL;
        if (gemInfo == null) {
            GemUiUtil.a(0);
        }
        if (stringBuilder == null) {
            GemUiUtil.a(1);
        }
        GemUiUtil.a(GemUiUtil.b(gemInfo), stringBuilder);
        GemUiUtil.a(GemUiUtil.a(gemInfo), stringBuilder);
        GemUiUtil.a(GemUiUtil.d(gemInfo), stringBuilder);
        String string = GemUiUtil.buildGemRoot(gemInfo);
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("<br>");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("<hr>");
        }
    }

    private static void a(String string, StringBuilder stringBuilder) {
        long l2 = c ^ 0x31DD479C8BE1L;
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("<br>");
        }
    }

    @Nullable
    private static String b(GemInfo gemInfo) {
        long l2 = c ^ 0x420209FB88D5L;
        String string = gemInfo.getAdditionalInfo().getAuthors();
        Pattern pattern = Pattern.compile("\\\\u\\{([^}]*)\\}");
        Matcher matcher = pattern.matcher(string);
        String string2 = string;
        try {
            while (matcher.find()) {
                String string3 = matcher.group(1);
                string2 = matcher.replaceFirst(new String(Character.toChars(Integer.valueOf(string3, 16))));
                matcher = pattern.matcher(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return GemUiUtil.b(RBundle.message("gems.ui.common.authors"), string2);
    }

    @Nullable
    private static String d(GemInfo gemInfo) {
        long l2 = c ^ 0x56F8831B58CBL;
        String string = gemInfo.getAdditionalInfo().getHomepage();
        return !GemUiUtil.a(string) ? GemUiUtil.b(RBundle.message("gems.ui.common.homepage"), "<a href=\"" + string + "\">" + string + "</a>") : null;
    }

    @Nullable
    private static String a(GemInfo gemInfo) {
        long l2 = c ^ 0xD53FAAB34F9L;
        String string = gemInfo.getAdditionalInfo().getEmail();
        return GemUiUtil.b(RBundle.message("gems.ui.common.email"), string);
    }

    private static boolean a(String string) {
        long l2 = c ^ 0x3B51C9A8D316L;
        return RBundle.message("gems.ui.common.not.available").equals(string) || StringUtil.isEmpty((String)string);
    }

    public static void fetchDescription(JTextPane text2, GemInfo gem) {
        long l2 = c ^ 0x211C112EB1DL;
        StringBuilder stringBuilder = new StringBuilder();
        if (gem != null) {
            GemUiUtil.a(gem, stringBuilder);
            String string = gem.getReadme();
            if (string != null) {
                stringBuilder.append(RubyDocumentationMarkupUtil.processGemDocumentation(string));
            } else if (!gem.isRemote()) {
                stringBuilder.append(RBundle.message("gems.ui.common.description.not.available"));
            } else {
                stringBuilder.append(RBundle.message("gems.add.dialog.description.not.available.remote.gem"));
            }
            text2.setText(stringBuilder.toString());
        } else {
            text2.setText("&nbsp;");
        }
        text2.setCaretPosition(0);
    }

    private static void a(EvaluatingComponent<Pair<String, String>> evaluatingComponent, JTextPane jTextPane, Sdk sdk, @Nullable Module module2, GemInfo gemInfo, JBTable jBTable) {
        long l2 = c ^ 0x18EF3B4AF1D5L;
        evaluatingComponent.setHanlders(EmptyRunnable.getInstance(), (Function<Object, Pair<String, String>>)((Function)object -> {
            String string = gemInfo.getName();
            BooleanSupplier booleanSupplier = () -> !jBTable.isVisible() || !GemUiUtil.b(jBTable, string);
            return Pair.create((Object)CachingGemDescriptionProvider.getInstance().getDescription(module2, sdk, gemInfo.getUrl(), booleanSupplier, string), (Object)string);
        }), (Function<Pair<String, String>, Object>)((Function)pair -> {
            long l2 = c ^ 0x71D31C034622L;
            String string = (String)pair.first;
            String string2 = (String)pair.second;
            if (!GemUiUtil.b(jBTable, string2)) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            GemUiUtil.a(gemInfo, stringBuilder);
            String string3 = string != null ? RubyDocumentationMarkupUtil.processGemDocumentation(string) : RBundle.message("gems.ui.common.description.not.available");
            stringBuilder.append(string3);
            if (GemUiUtil.b(jBTable, string2)) {
                jTextPane.setText(stringBuilder.toString());
            }
            return null;
        }), RBundle.message("gems.add.dialog.fetching.description"));
        evaluatingComponent.run();
    }

    private static boolean b(JBTable jBTable, String string) {
        TableModel tableModel = jBTable.getModel();
        if (!(tableModel instanceof GemTableModel)) {
            return false;
        }
        GemTableModel gemTableModel = (GemTableModel)tableModel;
        GemInfo gemInfo = GemUiUtil.getSelectedGem(jBTable, gemTableModel);
        return gemInfo != null && string.equals(gemInfo.getName());
    }

    @Nullable
    private static GemInfo a(JBTable jBTable, GemTableModel gemTableModel) {
        return GemUiUtil.getSelectedGem(jBTable, gemTableModel);
    }

    @Nullable
    public static GemInfo getSelectedGem(JBTable table, GemTableModel model) {
        if (table.getSelectedRowCount() <= 0) {
            return null;
        }
        ListSelectionModel listSelectionModel = table.getSelectionModel();
        int n2 = listSelectionModel.getLeadSelectionIndex();
        return n2 >= 0 ? model.getGem(n2) : null;
    }

    public static GemTableModel customizeGemTable(JBTable table) {
        GemTableModel gemTableModel = new GemTableModel();
        new GemSpeedSearch(table);
        table.setModel((TableModel)gemTableModel);
        GemTableCellRenderer gemTableCellRenderer = new GemTableCellRenderer();
        table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)gemTableCellRenderer));
        table.setDefaultRenderer(Collection.class, (TableCellRenderer)((Object)gemTableCellRenderer));
        return gemTableModel;
    }

    public static String buildInvalidGemsText(Sdk sdk, boolean hasRubyGemsSupport, boolean validSdk) {
        long l2 = c ^ 0x29B640563DACL;
        StringBuilder stringBuilder = new StringBuilder("<html><body><font color=red><left>");
        if (!validSdk) {
            stringBuilder.append(RBundle.message("sdk.error.homepath.doesnt.exists", sdk.getHomePath(), sdk.getName()));
        } else if (!hasRubyGemsSupport) {
            stringBuilder.append(RBundle.message("gems.not.installed.for.sdk", sdk.getName()));
        }
        stringBuilder.append("</left></font></body></html>");
        return stringBuilder.toString();
    }

    @Nullable
    public static String buildGemRoot(@NotNull GemInfo selectedGem) {
        long l2 = c ^ 0x5DA1F3578B14L;
        if (selectedGem == null) {
            GemUiUtil.a(2);
        }
        if (selectedGem.isRemote() || selectedGem.isValid()) {
            if (selectedGem.isRemote()) {
                String string = selectedGem.getUrl();
                return !StringUtil.isEmpty((String)string) ? GemUiUtil.b(RBundle.message("gems.ui.common.gem.root"), string) : null;
            }
            VirtualFile virtualFile = selectedGem.getFile();
            b.assertTrue(virtualFile != null, (Object)("No file for selected gem " + selectedGem));
            return GemUiUtil.b(RBundle.message("gems.ui.common.gem.root"), FileUtil.toSystemDependentName((String)virtualFile.getParent().getPath()));
        }
        return null;
    }

    @Nullable
    private static String b(String string, String string2) {
        long l2 = c ^ 0x2F36C42DF60BL;
        if (GemUiUtil.a(string2)) {
            return null;
        }
        return "<b>" + string + "&nbsp;" + "</b>" + string2;
    }

    public static void showInstallErrors(@Nullable Module module2, Map<GemDependency, String> errors) {
        GemUiUtil.showInstallErrors(module2 == null ? null : module2.getProject(), errors);
    }

    public static void showInstallErrors(@Nullable Project project, Map<GemDependency, String> errors) {
        long l2 = c ^ 0x784926E5D409L;
        String string = GemUiUtil.buildInstallErrorsText(errors);
        if (string != null) {
            Messages.showErrorDialog((Project)project, (String)string, (String)RBundle.message("gems.gem.installing.failed"));
        }
    }

    @Nullable
    public static String buildInstallErrorsText(Map<GemDependency, String> errors) {
        long l2 = c ^ 0x7371CDF434ABL;
        if (!errors.isEmpty()) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RBundle.message("gems.gem.installing.failed.list")).append("\n");
            for (Map.Entry<GemDependency, String> entry : errors.entrySet()) {
                GemDependency gemDependency = entry.getKey();
                String string = entry.getValue();
                stringBuilder.append(gemDependency.getDescription());
                if (string.contains("Failed to build gem native extension") || string.contains("native gem requires installed build tools")) {
                    bl2 = true;
                }
                stringBuilder.append(": ").append(string).append("\n");
            }
            if (SystemInfo.isWindows && bl2) {
                stringBuilder.insert(0, "<html><body>");
                stringBuilder.append("<br>Native compilation failed. Please make sure that you have Ruby <a href=\"https://github.com/oneclick/rubyinstaller/wiki/Development-Kit\">DevKit</a> installed\n");
                stringBuilder.append("</body></html>");
                return stringBuilder.toString().replace("\n", "<br>");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static CollectionComboBoxModel<String> buildGemVersionsModel(@NotNull List<? extends GemInfo> gems, @Nullable String customFirstItem) {
        if (gems == null) {
            GemUiUtil.a(3);
        }
        return GemUiUtil.buildGemVersionsModel(gems, customFirstItem, false, null);
    }

    public static CollectionComboBoxModel<String> buildGemVersionsModel(@NotNull List<? extends GemInfo> gems, @Nullable String customFirstItem, boolean addSeparatorAfterCustomItem, @Nullable String valueToSelect) {
        long l2 = c ^ 0x42401566201BL;
        if (gems == null) {
            GemUiUtil.a(4);
        }
        List list2 = gems.stream().map(gemInfo -> gemInfo.getVersion()).distinct().sorted(a).collect(Collectors.toList());
        if (customFirstItem != null) {
            list2.add(0, customFirstItem);
            if (addSeparatorAfterCustomItem) {
                list2.add(1, "!!!separator!!!");
            }
        }
        if (valueToSelect == null || !list2.contains(valueToSelect)) {
            valueToSelect = list2.size() > 0 ? (String)list2.get(0) : null;
        }
        return new CollectionComboBoxModel(list2, (Object)valueToSelect);
    }

    public static Rectangle getRowBounds(JTable table, int first, int last) {
        Rectangle rectangle = table.getCellRect(first, -1, true);
        rectangle = rectangle.union(table.getCellRect(last, -1, true));
        Insets insets = table.getInsets();
        rectangle.x = insets.left;
        rectangle.width = table.getWidth() - insets.left - insets.right;
        return rectangle;
    }

    public static void showNoRubygemsError(@Nullable Project project, @NotNull Sdk sdk) {
        long l2 = c ^ 0x1805C9F4EADCL;
        if (sdk == null) {
            GemUiUtil.a(5);
        }
        Messages.showErrorDialog((Project)project, (String)UIUtil.wrapToHtmlWithLabelFont(RBundle.message("gems.not.installed.for.sdk", sdk.getName())), (String)RBundle.message("gems.version.not.detected"));
    }

    public static void showNoSdkInstallError(Project project) {
        long l2 = c ^ 0x39A8DF67D6B2L;
        Messages.showErrorDialog((Project)project, (String)RBundle.message("gems.gem.installing.failed.no.sdk"), (String)RBundle.message("gems.gem.installing.failed"));
    }

    static {
        c = com.jetbrains.python.psi.c.a(-1396783207996141397L, 384180264857943565L, MethodHandles.lookup().lookupClass()).a(244397699367742L);
        b = Logger.getInstance(GemUiUtil.class);
        a = Collections.reverseOrder((string, string2) -> VersionComparatorUtil.compare((String)string, (String)string2));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x631C52313B47L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/GemUiUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStaticText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildGemRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildGemVersionsModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showNoRubygemsError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

