/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyModuleSdkGemsConfigurable
extends RubySdkGemsConfigurableBase {
    @NotNull
    protected Module myModule;
    @NotNull
    protected final Consumer<? super Sdk> mySetSdkConsumer;
    @NotNull
    protected final Computable<? extends ModifiableRootModel> myModelComputable;
    @Nullable
    private String E;
    private static final long F = c.a(5479944918879517497L, -2651707170948104296L, MethodHandles.lookup().lookupClass()).a(200706942049388L);

    public RubyModuleSdkGemsConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            RubyModuleSdkGemsConfigurable.c(0);
        }
        this(module2, (Computable<? extends ModifiableRootModel>)((Computable)() -> GemModificationUtil.getModuleModifiableModel(module2)), (Consumer<? super Sdk>)((Consumer)sdk -> RModuleUtil.getInstance().changeModuleSdk((Sdk)sdk, module2)));
    }

    public RubyModuleSdkGemsConfigurable(@NotNull Module module2, @NotNull Computable<? extends ModifiableRootModel> modelComputable, @NotNull Consumer<? super Sdk> setSdkConsumer) {
        if (module2 == null) {
            RubyModuleSdkGemsConfigurable.c(1);
        }
        if (modelComputable == null) {
            RubyModuleSdkGemsConfigurable.c(2);
        }
        if (setSdkConsumer == null) {
            RubyModuleSdkGemsConfigurable.c(3);
        }
        this.mySetSdkConsumer = setSdkConsumer;
        this.myModule = module2;
        this.myModelComputable = modelComputable;
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        this.E = sdk == null ? null : sdk.getName();
        this.init();
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            RubyModuleSdkGemsConfigurable.c(4);
        }
        return project;
    }

    @Override
    protected MultiMap<String, String> getSettingsMap() {
        return RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).copy();
    }

    @Override
    void saveSettingsMap(@NotNull MultiMap<String, String> map2) {
        if (map2 == null) {
            RubyModuleSdkGemsConfigurable.c(5);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, map2);
    }

    @Override
    @Nullable
    protected Sdk getSdk() {
        return ModuleRootManager.getInstance((Module)this.myModule).getSdk();
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        long l2 = F ^ 0x600581C5623DL;
        String string = RBundle.message("ruby.ide.sdk.configurable.no.module.sdk.marked", this.myModule.getName());
        if (string == null) {
            RubyModuleSdkGemsConfigurable.c(6);
        }
        return string;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || !RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).equals((Object)this.mySdkGemsetsMap);
    }

    @Override
    public void disposeUIResources() {
        boolean bl2 = this.E != null && this.isModified();
        super.disposeUIResources();
        if (bl2) {
            this.mySetSdkConsumer.consume((Object)ProjectJdkTable.getInstance().findJdk(this.E));
        }
    }

    @Override
    protected void doApply() throws ConfigurationException {
        long l2 = F ^ 0x6AF6F9D70379L;
        super.doApply();
        this.E = null;
        Sdk sdk = this.getCheckedSdk();
        if (sdk == null) {
            return;
        }
        if (this.myIsDisposed) {
            ModuleRootModificationUtil.updateModel((Module)this.myModule, modifiableRootModel -> modifiableRootModel.setSdk(sdk));
        } else {
            this.mySetSdkConsumer.consume((Object)sdk);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, (MultiMap<String, String>)this.mySdkGemsetsMap.copy());
        Collection collection = this.mySdkGemsetsMap.get((Object)sdk.getHomePath());
        if (RbenvGemsetManager.isRbenvSdk(sdk)) {
            RbenvGemsetManager.applyRbenvGemsetsToConfig(this.myModule, collection);
        }
        Application application = ApplicationManager.getApplication();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GemManager.getInstance().refresh(sdk), RBundle.message("module.settings.refreshing.sdk"), true, this.getProject());
        application.runWriteAction(() -> {
            ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.myModelComputable.compute();
            if (GemManager.updateGemset(modifiableRootModel, sdk)) {
                GemModificationUtil.commitModuleModifiableModel(modifiableRootModel);
            } else {
                GemModificationUtil.disposeModuleModifiableModel(modifiableRootModel);
            }
            GemManager.getInstance().flushLibrariesIfNeeded(this.getProject());
        });
    }

    @Override
    @Nullable
    protected Sdk getPreferableRVMSdk(@Nullable Sdk selectedSdk) {
        if (RVMSupportUtil.isLocalRootRVMSdk(selectedSdk)) {
            return selectedSdk;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        if (RVMSupportUtil.isLocalRootRVMSdk(sdk)) {
            return sdk;
        }
        return super.getPreferableRVMSdk(selectedSdk);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = F ^ 0x69BE4839E44CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelComputable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSdkConsumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveSettingsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

