/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.locales.I18nRubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;

public class I18nRubyAdapter {
    private final RFile a;
    private static final long b = c.a(2392324759315276192L, 8316241697351793101L, MethodHandles.lookup().lookupClass()).a(75169221540032L);

    public I18nRubyAdapter(RFile file) {
        this.a = file;
    }

    @NotNull
    public PsiFile getPsiFile() {
        RFile rFile = this.a;
        if (rFile == null) {
            I18nRubyAdapter.a(0);
        }
        return rFile;
    }

    @Nullable
    public String getLocale() {
        RAssoc rAssoc = this.a();
        if (rAssoc == null) {
            return null;
        }
        return rAssoc.getKeyText();
    }

    public static boolean isTranslationElement(PsiElement element) {
        return (Boolean)ReadAction.compute(() -> {
            if (!(element.isValid() && element instanceof RAssoc && I18nProvider.isLocaleFile(element.getContainingFile()))) {
                return false;
            }
            RPsiElement rPsiElement = ((RAssoc)element).getValue();
            return rPsiElement == null || rPsiElement instanceof RStringLiteral;
        });
    }

    @Nullable
    private RAssoc a() {
        for (RPsiElement rPsiElement : this.a.getCompoundStatement().getStatements()) {
            if (!(rPsiElement instanceof RAssocList)) continue;
            List<RPsiElement> list2 = ((RAssocList)rPsiElement).getElements();
            if (list2.isEmpty()) {
                return null;
            }
            RPsiElement rPsiElement2 = list2.get(0);
            return rPsiElement2 instanceof RAssoc ? (RAssoc)rPsiElement2 : null;
        }
        return null;
    }

    @Nullable
    public String getValue(String key) {
        RPsiElement rPsiElement;
        RAssoc rAssoc = this.getRecord(key);
        if (rAssoc != null && (rPsiElement = rAssoc.getValue()) instanceof RStringLiteral) {
            return ((RStringLiteral)rPsiElement).getContent();
        }
        return null;
    }

    @Nullable
    public RAssoc getRecord(String k10) {
        long l2 = b ^ 0x1878DA62538DL;
        String[] stringArray = k10.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : k10.split("\\.");
        RAssoc rAssoc = this.a();
        block0: for (String string : stringArray) {
            if (rAssoc == null) {
                return null;
            }
            RPsiElement rPsiElement = rAssoc.getValue();
            rAssoc = null;
            if (!(rPsiElement instanceof RAssocList)) continue;
            for (RPsiElement rPsiElement2 : ((RAssocList)rPsiElement).getElements()) {
                if (!(rPsiElement2 instanceof RAssoc) || !string.equals(((RAssoc)rPsiElement2).getKeyText())) continue;
                rAssoc = (RAssoc)rPsiElement2;
                continue block0;
            }
        }
        return rAssoc;
    }

    public RAssoc createI18nRecord(String k10, String value) {
        long l2 = b ^ 0x14686D4168CAL;
        RAssoc rAssoc = this.getRecord(k10);
        if (rAssoc != null) {
            return rAssoc;
        }
        String[] stringArray = k10.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : k10.split("\\.");
        String string = StringUtil.wrapWithDoubleQuote((String)value.trim().replaceAll("\\s+", " "));
        return I18nRubyUtil.createI18nRecord(this.a(), stringArray, string);
    }

    @NotNull
    public static String getFullKey(RAssoc keyValue) {
        RAssoc rAssoc;
        StringBuilder stringBuilder = new StringBuilder();
        RAssoc rAssoc2 = keyValue;
        while (rAssoc2 != null && (rAssoc = (RAssoc)PsiTreeUtil.getParentOfType((PsiElement)rAssoc2, RAssoc.class)) != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, rAssoc2.getKeyText());
            rAssoc2 = rAssoc;
        }
        String string = stringBuilder.toString();
        if (string == null) {
            I18nRubyAdapter.a(1);
        }
        return string;
    }

    public List<String> getAllKeys(String prefix) {
        RAssoc rAssoc = this.getRecord(prefix);
        if (rAssoc == null) {
            return Collections.emptyList();
        }
        RPsiElement rPsiElement = rAssoc.getValue();
        ArrayList<String> arrayList = new ArrayList<String>();
        I18nRubyAdapter.a(prefix, (PsiElement)rPsiElement, arrayList);
        return arrayList;
    }

    private static void a(String string, PsiElement psiElement, List<String> list2) {
        if (psiElement instanceof RAssocList) {
            for (RPsiElement rPsiElement : ((RAssocList)psiElement).getElements()) {
                I18nRubyAdapter.a(string, (PsiElement)rPsiElement, list2);
            }
        }
        if (psiElement instanceof RAssoc) {
            RPsiElement rPsiElement;
            RAssoc rAssoc = (RAssoc)psiElement;
            rPsiElement = rAssoc.getValue();
            String string2 = rAssoc.getKeyText();
            if (!string.isEmpty()) {
                string2 = string + "." + string2;
            }
            if (rPsiElement instanceof RStringLiteral) {
                list2.add(string2);
            } else {
                I18nRubyAdapter.a(string2, (PsiElement)rPsiElement, list2);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = b ^ 0x2A9513CAFB0CL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/locales/I18nRubyAdapter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

