/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.StringOrSymbolReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;

public class I18nTranslateReference
extends StringOrSymbolReference {
    @NotNull
    public static final String KEY_SEPARATOR = ".";
    @NotNull
    public static final List<String> OPTIONS;
    private static final InsertHandler<RubyLookupElement> f;
    @NotNull
    private final Module d;
    @NotNull
    private final AtomicNullableLazyValue<String> e;
    private static final long h;

    I18nTranslateReference(@NotNull RPossibleCall possibleCall, @NotNull PsiElement element, @NotNull Module module2) {
        if (possibleCall == null) {
            I18nTranslateReference.e(0);
        }
        if (element == null) {
            I18nTranslateReference.e(1);
        }
        if (module2 == null) {
            I18nTranslateReference.e(2);
        }
        super(possibleCall, element);
        this.e = AtomicNullableLazyValue.createValue(() -> this.a());
        this.d = module2;
    }

    @Override
    @NotNull
    public RPossibleCall getElement() {
        RPossibleCall rPossibleCall = (RPossibleCall)this.myElement;
        if (rPossibleCall == null) {
            I18nTranslateReference.e(3);
        }
        return rPossibleCall;
    }

    @NotNull
    public String getCanonicalText() {
        long l2 = h ^ 0x28CF7C6880CDL;
        String string = StringUtil.notNullize((String)RubyPsiUtil.getElementText(this.getStringOrSymbol()), (String)"*INVALID*");
        if (string == null) {
            I18nTranslateReference.e(4);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String string;
        if (newElementName == null) {
            I18nTranslateReference.e(5);
        }
        String string2 = (string = this.getCanonicalText()).contains(KEY_SEPARATOR) ? string.substring(0, string.lastIndexOf(KEY_SEPARATOR) + 1) : "";
        return I18nTranslateReference.rename(this.getStringOrSymbol(), string2 + newElementName);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            I18nTranslateReference.e(6);
        }
        return super.isReferenceTo(element) && I18nProvider.forElement(element).canBeTranslationReferenceTarget(element);
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            I18nTranslateReference.e(7);
        }
        if (result == null) {
            I18nTranslateReference.e(8);
        }
        I18nDictionary i18nDictionary = this.getDictionary();
        String string = this.isScoped() ? this.getScope() + KEY_SEPARATOR : null;
        String string2 = RubyI18nFoldingLocaleSettings.getInstance(this.getProject()).getLocale();
        for (String string3 : i18nDictionary.getAllKeys()) {
            String string4 = I18nTranslateReference.getLookupTypeFromLocales(string2, i18nDictionary.getLocalesByKey(string3));
            if (string == null) {
                result.addElement(I18nTranslateReference.createLookupElement(string3, string4));
                continue;
            }
            if (!string3.startsWith(string)) continue;
            result.addElement(I18nTranslateReference.createLookupElement(string3.substring(string.length()), string4));
        }
    }

    @Override
    @NotNull
    protected ResolveResult[] multiResolveInner(boolean incompleteCode) {
        I18nDictionary i18nDictionary = this.getDictionary();
        List<String> list2 = this.getFullKeys();
        ArrayList<I18nResolveResult> arrayList = new ArrayList<I18nResolveResult>();
        for (String string : list2) {
            for (LocaleEntry localeEntry : i18nDictionary.getLocaleEntriesByKey(string)) {
                PsiElement psiElement = localeEntry.getRecord(string);
                if (psiElement == null) continue;
                arrayList.add(new I18nResolveResult(psiElement, localeEntry));
            }
        }
        ResolveResult[] resolveResultArray = arrayList.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            I18nTranslateReference.e(9);
        }
        return resolveResultArray;
    }

    @NotNull
    public List<String> getFullKeys() {
        String string = StringUtil.trimStart((String)this.getCanonicalText(), (String)KEY_SEPARATOR);
        List<String> list2 = Collections.singletonList(this.isScoped() ? this.getScope() + KEY_SEPARATOR + string : string);
        if (list2 == null) {
            I18nTranslateReference.e(10);
        }
        return list2;
    }

    @NotNull
    public I18nDictionary getDictionary() {
        I18nDictionary i18nDictionary = I18nProvider.getDictionary(this.d);
        if (i18nDictionary == null) {
            I18nTranslateReference.e(11);
        }
        return i18nDictionary;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        I18nTranslateReference i18nTranslateReference = (I18nTranslateReference)o2;
        return this.d.equals(i18nTranslateReference.d);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.d.hashCode();
        return n2;
    }

    @Nullable
    protected String getScope() {
        return (String)this.e.getValue();
    }

    protected boolean isScoped() {
        String string = this.getScope();
        return string != null && !string.isEmpty();
    }

    @Nullable
    private String a() {
        return StringUtil.nullize((String)String.join((CharSequence)KEY_SEPARATOR, I18nTranslateCallType.getScopeOption(this.getElement())));
    }

    @NotNull
    protected static LookupElement createLookupElement(@NotNull String key, @NotNull String type) {
        if (key == null) {
            I18nTranslateReference.e(12);
        }
        if (type == null) {
            I18nTranslateReference.e(13);
        }
        RubyLookupElement rubyLookupElement = new RubyLookupElement(key, null, type, false, PlatformIcons.PROPERTY_ICON, RailsIcons.RAILS_I18N_LOCALE_ICON, f);
        if (rubyLookupElement == null) {
            I18nTranslateReference.e(14);
        }
        return rubyLookupElement;
    }

    @NotNull
    protected static String getLookupTypeFromLocales(@NotNull String defaultLocale, @NotNull Collection<String> locales) {
        long l2 = h ^ 0x8B9DE5A8CC3L;
        if (defaultLocale == null) {
            I18nTranslateReference.e(15);
        }
        if (locales == null) {
            I18nTranslateReference.e(16);
        }
        List list2 = ContainerUtil.sorted(locales, Comparator.comparing(defaultLocale::equals).reversed().thenComparing(Comparator.naturalOrder()));
        if (list2.size() <= 2) {
            String string = String.join((CharSequence)" and ", list2);
            if (string == null) {
                I18nTranslateReference.e(17);
            }
            return string;
        }
        String string = (String)list2.get(0) + " and " + (list2.size() - 1) + " others";
        if (string == null) {
            I18nTranslateReference.e(18);
        }
        return string;
    }

    static {
        h = c.a(-5338387633966265869L, -5016738712792600003L, MethodHandles.lookup().lookupClass()).a(251336571955029L);
        long l2 = h ^ 0x1EB29507E87AL;
        OPTIONS = ContainerUtil.immutableList((Object[])new String[]{"cascade", "count", "deep_interpolation", "default", "exception_handler", "fallback", "fallback_in_progress", "format", "locale", "object", "raise", "resolve", "scope", "separator", "throw"});
        f = new InsertHandler<RubyLookupElement>(){
            private static final long a = c.a(-3792678289076722535L, 9145342427496599977L, MethodHandles.lookup().lookupClass()).a(184934919482574L);

            public void handleInsert(@NotNull InsertionContext context, @NotNull RubyLookupElement item) {
                if (context == null) {
                    1.a(0);
                }
                if (item == null) {
                    1.a(1);
                }
                Document document = context.getDocument();
                int n2 = context.getStartOffset();
                if (n2 <= 0 || document.getCharsSequence().charAt(n2 - 1) != ':') {
                    return;
                }
                RSymbol rSymbol = RubyElementFactory.createSymbol((PsiElement)context.getFile(), item.getLookupString());
                String string = rSymbol.getContent().getText();
                if (string.startsWith("'")) {
                    document.replaceString(n2, context.getTailOffset(), (CharSequence)string);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x56BF8BBD0C71L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void e(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x1C791AC6CD7EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocale";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeys";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionary";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupTypeFromLocales";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLookupTypeFromLocales";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

