/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.helpers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerConfigProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblemEnum;

public class WarblerValidatorHelper {
    private static final long a = c.a(-2887907031625776097L, -6658048126161519485L, MethodHandles.lookup().lookupClass()).a(161555228188321L);

    private WarblerValidatorHelper() {
    }

    @Nullable
    public static WarblerEnvironmentProblem checkEnvironment(@NotNull Module module2) {
        Sdk sdk;
        long l2 = a ^ 0x6E555741DA71L;
        if (module2 == null) {
            WarblerValidatorHelper.a(0);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module2).getSdk()) == null || !StringUtil.toLowerCase((String)sdk.getName()).contains("jruby")) {
            return new WarblerEnvironmentProblem(RBundle.message("warbler.validation.error.jruby.sdk.not.found"), RBundle.message("warbler.validation.error.jruby.sdk.not.found.fix.title"), WarblerEnvironmentProblemEnum.WRONG_SDK);
        }
        GemInfo gemInfo = GemSearchUtil.findGem(module2, sdk, "rails");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message("warbler.validation.error.rails.not.found"), RBundle.message("warbler.validation.error.rails.not.found.fix.title"), WarblerEnvironmentProblemEnum.RAILS_NOT_FOUND);
        }
        gemInfo = GemSearchUtil.findGem(module2, sdk, "warbler");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message("warbler.validation.error.warbler.not.found"), RBundle.message("warbler.validation.error.warbler.not.found.fix.title"), WarblerEnvironmentProblemEnum.WARBLER_NOT_FOUND);
        }
        return null;
    }

    @Nullable
    public static WarblerConfigProblem checkConfig(@NotNull WarblerConfigModel config) {
        long l2 = a ^ 0x1DEFBE2F3651L;
        if (config == null) {
            WarblerValidatorHelper.a(1);
        }
        if (!StandardFileSystems.local().isValidName(config.getFileName())) {
            return new WarblerConfigProblem(RBundle.message("warbler.validation.error.fileName"));
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x445B4E6DFCF8L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerValidatorHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

