/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class BundlerGemsRefresher
implements ProjectComponent {
    @NotNull
    private final Project c;
    @NotNull
    private final Map<String, LocalFileSystem.WatchRequest> b;
    private final VirtualFileListener a;
    private static final long d = com.jetbrains.python.psi.c.a(-3688819591321000372L, 1366639700448082502L, MethodHandles.lookup().lookupClass()).a(128913978267022L);

    public BundlerGemsRefresher(@NotNull Project project) {
        if (project == null) {
            BundlerGemsRefresher.a(0);
        }
        this.b = Maps.newHashMap();
        this.a = new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-894066390181697649L, -5498005452640023451L, MethodHandles.lookup().lookupClass()).a(245154772339913L);

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(0);
                }
                BundlerGemsRefresher.this.c(event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                long l2 = a ^ 0xA404B2C8994L;
                if (event == null) {
                    1.a(1);
                }
                Object object = (virtualFile2 = event.getFile()).isDirectory() ? ("vendor".equals(virtualFile2.getName()) ? virtualFile2.findChild("cache") : ("cache".equals(virtualFile2.getName()) ? virtualFile2 : null)) : (virtualFile = null);
                if (virtualFile != null) {
                    Module module2 = BundlerGemsRefresher.this.a(virtualFile);
                    if (!RModuleUtil.getInstance().hasRubySupport(module2)) {
                        return;
                    }
                    BundlerGemsRefresher.this.c(module2, null, virtualFile);
                } else if (BundlerUtil.isBundlerDir(virtualFile2)) {
                    VirtualFile virtualFile3 = virtualFile2.findChild("config");
                    if (virtualFile3 != null) {
                        BundlerGemsRefresher.this.c(virtualFile3);
                    }
                } else {
                    BundlerGemsRefresher.this.c(virtualFile2);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(2);
                }
                BundlerGemsRefresher.this.b(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.a(3);
                }
                BundlerGemsRefresher.this.c(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    1.a(4);
                }
                BundlerGemsRefresher.this.c(event.getFile());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6883157EDB51L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsRefresher$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.c = project;
    }

    public void projectOpened() {
        if (this.c.isDefault()) {
            return;
        }
        for (Module module2 : ModuleManager.getInstance((Project)this.c).getModules()) {
            BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance().getConfig(module2);
            if (bundleConfig == null) continue;
            this.a(bundleConfig.getConfigFile().getPath());
        }
        LocalFileSystem.getInstance().addVirtualFileListener(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(@NotNull String string) {
        if (string == null) {
            BundlerGemsRefresher.a(1);
        }
        Map<String, LocalFileSystem.WatchRequest> map2 = this.b;
        synchronized (map2) {
            if (this.b.containsKey(string)) {
                return;
            }
            LocalFileSystem.WatchRequest watchRequest = LocalFileSystem.getInstance().addRootToWatch(string, false);
            if (watchRequest != null) {
                this.b.put(string, watchRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        ArrayList arrayList;
        if (this.c.isDefault()) {
            return;
        }
        Map<String, LocalFileSystem.WatchRequest> map2 = this.b;
        synchronized (map2) {
            arrayList = Lists.newArrayList(this.b.values());
            this.b.clear();
        }
        LocalFileSystem.getInstance().removeWatchedRoots((Collection)arrayList);
        LocalFileSystem.getInstance().removeVirtualFileListener(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(@Nullable VirtualFile virtualFile) {
        String string;
        long l2 = d ^ 0xF87170669FAL;
        if (BundlerUtil.isBundlerDir(virtualFile)) {
            string = virtualFile.getPath() + "/" + "config";
        } else if (BundleConfig.isConfig(virtualFile)) {
            string = virtualFile.getPath();
        } else {
            return;
        }
        Module module2 = this.a(virtualFile);
        if (module2 == null || !RModuleUtil.getInstance().hasRubySupport(module2)) {
            return;
        }
        Map<String, LocalFileSystem.WatchRequest> map2 = this.b;
        synchronized (map2) {
            LocalFileSystem.WatchRequest watchRequest = this.b.remove(string);
            if (watchRequest != null) {
                LocalFileSystem.getInstance().removeWatchedRoot(watchRequest);
            }
        }
        GemManager.updateGemset(module2);
    }

    @Nullable
    private Module a(@NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        if (virtualFile == null) {
            BundlerGemsRefresher.a(2);
        }
        if ((virtualFile2 = virtualFile.getParent()) == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.c).getFileIndex().getModuleForFile(virtualFile3);
    }

    private void c(@Nullable VirtualFile virtualFile) {
        long l2 = d ^ 0xF7F949DF933L;
        if (BundlerUtil.isBundlerDir(virtualFile)) {
            virtualFile = virtualFile.findChild("config");
        }
        if (!BundleConfig.isConfig(virtualFile)) {
            return;
        }
        Module module2 = this.a(virtualFile);
        if (module2 == null || !RModuleUtil.getInstance().hasRubySupport(module2)) {
            return;
        }
        BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance().getConfig(module2);
        if (bundleConfig == null) {
            return;
        }
        this.c(module2, virtualFile, bundleConfig.getBundlePathVirtualFile());
        GemManager.updateGemset(module2);
    }

    private void c(@NotNull Module module2, @Nullable VirtualFile virtualFile, @Nullable VirtualFile virtualFile2) {
        long l2 = d ^ 0x7FE726CBB7C8L;
        if (module2 == null) {
            BundlerGemsRefresher.a(3);
        }
        if (virtualFile2 == null) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        if (projectFileIndex.isExcluded(virtualFile2)) {
            return;
        }
        VirtualFile virtualFile3 = projectFileIndex.getContentRootForFile(virtualFile2);
        if (virtualFile3 == null) {
            return;
        }
        if (!BundlerGemsRefresher.b(module2, virtualFile2, virtualFile3)) {
            return;
        }
        if (virtualFile != null && projectFileIndex.isExcluded(virtualFile)) {
            this.a(virtualFile.getPath());
        }
        new Notification("Gem Manager", RBundle.message("gems.directory.excluded.title"), RBundle.message("gems.directory.excluded.message", virtualFile2.getPath()), NotificationType.INFORMATION).notify(module2.getProject());
    }

    private static boolean b(@NotNull Module module2, @NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
        if (module2 == null) {
            BundlerGemsRefresher.a(4);
        }
        if (virtualFile == null) {
            BundlerGemsRefresher.a(5);
        }
        if (virtualFile2 == null) {
            BundlerGemsRefresher.a(6);
        }
        return (Boolean)WriteAction.compute(() -> {
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            for (ContentEntry contentEntry : modifiableRootModel.getContentEntries()) {
                if (!contentEntry.getUrl().equals(virtualFile2.getUrl())) continue;
                contentEntry.addExcludeFolder(virtualFile);
                modifiableRootModel.commit();
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x6D1E8731B7CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theRoot";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsRefresher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWatchRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeBundleDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "markFolderAsExcluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

