/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsTableNameCallType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.StringValueAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodBase;

public class ModelsTableMappingUtil {
    private static final String a = "table_name_prefix";
    private static final long b = c.a(1635373465665502919L, -7324417112017747698L, MethodHandles.lookup().lookupClass()).a(21949997771116L);

    private ModelsTableMappingUtil() {
    }

    @Nullable
    public static String getTableNameIgnoringInheritance(RClass railsModelClass, Module module2) {
        String string = ModelsTableMappingUtil.getExplicitTableName(railsModelClass);
        return string != null ? string : ModelsTableMappingUtil.getImplicitTableName(railsModelClass.getFQNWithNesting(), module2);
    }

    @Nullable
    static String getExplicitTableName(RClass model) {
        RPossibleCall rPossibleCall = model.findCall(RailsTableNameCallType.class::isInstance);
        if (rPossibleCall != null) {
            RailsTableNameCallType railsTableNameCallType = (RailsTableNameCallType)rPossibleCall.getCallType();
            List list2 = (List)rPossibleCall.getData(railsTableNameCallType);
            if (list2.size() == 1) {
                return (String)list2.get(0);
            }
        }
        return null;
    }

    @Nullable
    static String getExplicitTableNamePrefix(RClass model) {
        long l2 = b ^ 0x77E4350EC9L;
        for (FQN fQN = model.getFQNWithNesting().getCallerFQN(); fQN != FQN.INVALID; fQN = fQN.getCallerFQN()) {
            Symbol symbol;
            Symbol symbol2 = SymbolUtil.findConstantByFQN(model.getProject(), Type.MODULE.asSet(), fQN, (PsiElement)model);
            if (symbol2 == null || (symbol = SymbolUtil.lookupMethod(symbol2, FQN.of(a), Type.CLASS_METHOD.asSet(), Context.CLASS, (PsiElement)model)) == null) continue;
            return Optional.ofNullable(symbol.getPsiElement()).map(psiElement -> (RMethodBase)ObjectUtils.tryCast((Object)psiElement, RMethodBase.class)).map(RMethodBase::getSummary).map(Summary::getReturnValue).map(symbolicExpression -> symbolicExpression.getAttributeValue(StringValueAttribute.INSTANCE)).orElse(null);
        }
        return null;
    }

    @Nullable
    static String getImplicitTableName(FQN modelFqn, Module module2) {
        return Optional.of(InflectorService.getInstance(module2)).filter(inflectorService -> inflectorService.isInflectorAvailable()).map(inflectorService -> inflectorService.tableize(modelFqn.getFullPath())).map(string -> string.replace('/', '_')).orElse(null);
    }

    static boolean isAbstract(RClass model) {
        List list2;
        long l2 = b ^ 0x1829270DFE95L;
        RPossibleCall rPossibleCall = model.findCall(RailsCallTypeProvider.ABSTRACT_CLASS_CALL::equals);
        if (rPossibleCall != null && (list2 = (List)rPossibleCall.getData(RailsCallTypeProvider.ABSTRACT_CLASS_CALL)).size() == 1) {
            return ((String)list2.get(0)).equals("true");
        }
        return false;
    }
}

