/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.a;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleTypeBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public final class RModuleUtil {
    private static final Logger a;
    private static final long b;

    @Contract(value="null,_,_,_ -> null")
    @Nullable
    public static VirtualFile findFileInModuleRoot(@Nullable Module module2, boolean doRefresh, boolean honorExclusion, String ... relativePaths) {
        if (relativePaths == null) {
            RModuleUtil.a(0);
        }
        Ref ref = Ref.create();
        RModuleUtil.processFilesInModuleRoot(module2, doRefresh, honorExclusion, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(virtualFile, virtualFile2) -> {
            ref.set(virtualFile);
            return false;
        }), relativePaths);
        return (VirtualFile)ref.get();
    }

    public static void processFilesInModuleRoot(@Nullable Module module2, boolean doRefresh, boolean honorExclusion, PairProcessor<? super VirtualFile, ? super VirtualFile> processor2, String ... relativePaths) {
        if (relativePaths == null) {
            RModuleUtil.a(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (module2 == null || module2.isDisposed()) {
            return;
        }
        for (VirtualFile virtualFile : RModuleUtil.getContentRoots(module2)) {
            if (doRefresh) {
                virtualFile.refresh(false, false);
            }
            for (String string : relativePaths) {
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(FileUtil.toSystemIndependentName((String)string));
                if (virtualFile2 == null || !virtualFile2.isValid() || honorExclusion && ProjectFileIndex.getInstance((Project)module2.getProject()).isExcluded(virtualFile2) || processor2.process((Object)virtualFile2, (Object)virtualFile)) continue;
                return;
            }
        }
    }

    public static VirtualFile[] getContentRoots(@NotNull Module module2) {
        if (module2 == null) {
            RModuleUtil.a(2);
        }
        Object[] objectArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        VirtualFile virtualFile = module2.getModuleFile();
        if (objectArray.length > 1 && virtualFile != null) {
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                VirtualFile virtualFile2 = objectArray[i10];
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                ArrayUtil.swap((Object[])objectArray, (int)0, (int)i10);
                break;
            }
        }
        return objectArray;
    }

    public static RModuleUtil getInstance() {
        return SingletonHolder.a;
    }

    private RModuleUtil() {
    }

    public Module[] getAllModulesWithRubySupport(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.a(3);
        }
        SmartList smartList = new SmartList();
        ApplicationManager.getApplication().runReadAction(() -> this.a(project, (List)smartList));
        return smartList.toArray(Module.EMPTY_ARRAY);
    }

    @Contract(value="null -> false")
    public boolean hasRubySupport(@Nullable Module module2) {
        if (module2 == null || module2.isDisposed()) {
            return false;
        }
        if (this.isRubyModule(module2)) {
            return true;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.hasRubySupport(module2)) continue;
            return true;
        }
        return false;
    }

    public boolean isRubyModule(@Nullable Module module2) {
        return module2 != null && this.isRubyModuleType(ModuleType.get((Module)module2));
    }

    public boolean isRubyModuleType(@Nullable ModuleType moduleType) {
        return moduleType instanceof RubyModuleTypeBase;
    }

    @Contract(value="null -> null")
    @Nullable
    public VirtualFile getFirstContentRoot(@Nullable Module module2) {
        return module2 == null || module2.isDisposed() ? null : (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            RModuleUtil.a(4);
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
    }

    public void refreshRubyModuleTypeContent(Module module2) {
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                VirtualFile virtualFile = this.getFirstContentRoot(module2);
                if (virtualFile != null) {
                    virtualFile.refresh(false, true);
                }
            });
        }
        catch (Exception exception) {
            a.error((Throwable)exception);
        }
    }

    public RSupportPerModuleSettings getRubyModuleSettings(@NotNull Module module2) {
        if (module2 == null) {
            RModuleUtil.a(5);
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            RSupportPerModuleSettings rSupportPerModuleSettings = rubySupportProvider.findRubySettings(module2);
            if (rSupportPerModuleSettings == null) continue;
            return rSupportPerModuleSettings;
        }
        return RubyModuleSettings.getInstance(module2);
    }

    @Nullable
    public Module getModule(@NotNull DataContext dataContext) {
        Module module2;
        if (dataContext == null) {
            RModuleUtil.a(6);
        }
        if ((module2 = (Module)dataContext.getData(LangDataKeys.MODULE.getName())) != null) {
            return module2;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT.getName());
        if (project != null) {
            return this.getModuleWithRubySupport(project);
        }
        return null;
    }

    @Nullable
    public Module getModuleWithRubySupport(@NotNull Project project) {
        Module[] moduleArray;
        if (project == null) {
            RModuleUtil.a(7);
        }
        if ((moduleArray = this.getAllModulesWithRubySupport(project)).length == 1) {
            return moduleArray[0];
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return (Module)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return null;
                }
                Module module2 = ModuleAttachProcessor.getPrimaryModule((Project)project);
                if (this.isRubyModule(module2)) {
                    return module2;
                }
                return null;
            });
        }
        return null;
    }

    public boolean changeModuleSdk(@Nullable Sdk sdk, @NotNull Module module2) {
        if (module2 == null) {
            RModuleUtil.a(8);
        }
        if (this.isRubyModule(module2)) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Sdk sdk2 = moduleRootManager.getSdk();
            if (sdk2 != sdk) {
                ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
                return true;
            }
            return false;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.updateFacetSdk(module2, sdk)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevelByModule(Module module2) {
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getEffectiveLanguageLevel(this.findRubySdkForModule(module2));
        if (languageLevel == null) {
            RModuleUtil.a(9);
        }
        return languageLevel;
    }

    public boolean isMultiProject(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.a(10);
        }
        return PlatformUtils.isRubyMine() && this.getAllModulesWithRubySupport(project).length > 1;
    }

    @Contract(value="null -> false")
    public boolean isInMultiProject(@Nullable Module module2) {
        return module2 != null && this.isMultiProject(module2.getProject());
    }

    @Nullable
    public Project getProject(@Nullable Module module2) {
        return module2 != null ? module2.getProject() : null;
    }

    @Nullable
    public Sdk findRubySdkForVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null || project == null) {
            return null;
        }
        return this.findRubySdkForModule(ScratchUtil.isScratch((VirtualFile)virtualFile) ? (Module)ContainerUtil.getFirstItem(Arrays.asList(this.getAllModulesWithRubySupport(project))) : ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project));
    }

    @Nullable
    public Sdk findRubySdkForModule(@Nullable Module module2) {
        Object object;
        if (module2 == null || module2.isDisposed()) {
            return null;
        }
        if (this.isRubyModule(module2) && (object = ModuleRootManager.getInstance((Module)module2).getSdk()) != null && object.getSdkType() instanceof RubySdkType) {
            return object;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            Sdk sdk = rubySupportProvider.findRubySdk(module2);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    private /* synthetic */ void a(Project project, List list2) {
        if (project.isDisposed()) {
            return;
        }
        Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(this::hasRubySupport).forEach(list2::add);
    }

    /* synthetic */ RModuleUtil(a x0) {
        this();
    }

    static {
        b = c.a(-2425394761809875561L, -8014960774766762061L, MethodHandles.lookup().lookupClass()).a(144480885009064L);
        a = Logger.getInstance(RModuleUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x6D3DDDD0B614L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelByModule";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileInModuleRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInModuleRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesWithRubySupport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstContentRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRubyModuleSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleWithRubySupport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeModuleSdk";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMultiProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingletonHolder {
        private static final RModuleUtil a = new RModuleUtil(null);

        private SingletonHolder() {
        }
    }
}

