/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FQNCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RubyQualifiedNameProvider
implements QualifiedNameProvider {
    private static final long a = c.a(-3887159288911094933L, 4570249008570526280L, MethodHandles.lookup().lookupClass()).a(107680125760333L);

    public PsiElement adjustElementToCopy(PsiElement element) {
        if (element instanceof RClass || element instanceof RModule || element instanceof RMethod || element instanceof RConstant) {
            return element;
        }
        return null;
    }

    @Nullable
    public String getQualifiedName(PsiElement element) {
        long l2 = a ^ 0x55DA162AD43EL;
        if (element instanceof RColonReference && !(((RColonReference)element).getValue() instanceof RConstant)) {
            return null;
        }
        if (element instanceof RConstant || element instanceof RColonReference) {
            while (RReferenceNavigator.getReferenceByRightPart(element) instanceof RColonReference) {
                element = (PsiElement)Objects.requireNonNull(RReferenceNavigator.getReferenceByRightPart(element));
            }
            FQN fQN = FQN.of(element.getText());
            Symbol symbol = SymbolUtil.getScopeContextWithCaching(element);
            FQN fQN2 = symbol != null && !(symbol instanceof TopLevelSymbol) ? symbol.getFQNWithNesting() : FQN.INVALID;
            return FQN.Builder.concat(fQN2, fQN).getFullPath();
        }
        if (!(element instanceof RElementWithFQN)) {
            return null;
        }
        FQN fQN = ((RElementWithFQN)element).getFQNWithNesting();
        if (element instanceof RClass || element instanceof RModule) {
            return RContainerPresentationUtil.getHumanizedFQN(fQN, null, element);
        }
        if (element instanceof RMethod) {
            String string;
            FQN fQN3 = fQN.getCallerFQN();
            if ("$$SINGLETON$$".equals(fQN3.getShortName())) {
                fQN3 = fQN3.getCallerFQN();
                string = "::";
            } else {
                string = "#";
            }
            return (fQN3 != FQN.INVALID ? fQN3.getFullPath() + string : "") + fQN.getShortName();
        }
        return null;
    }

    @Nullable
    public PsiElement qualifiedNameToElement(String fqnString, Project project) {
        int n2;
        boolean bl2;
        long l2 = a ^ 0x257E755C07FFL;
        if (fqnString.startsWith("singleton class of ")) {
            fqnString = fqnString.substring("singleton class of ".length()) + "::" + "$$SINGLETON$$";
        }
        boolean bl3 = bl2 = (n2 = StringUtil.lastIndexOfAny((CharSequence)(fqnString = StringUtil.replace((String)fqnString, (String)"<singleton class>", (String)"$$SINGLETON$$")), (String)"#:")) + 1 < fqnString.length() && !Character.isLowerCase(fqnString.charAt(n2 + 1));
        if (bl2) {
            FQN fQN = FQN.of(fqnString);
            Symbol symbol = SymbolUtil.findConstantByFQN(project, fQN, null);
            if (symbol != null) {
                return symbol.getPsiElement();
            }
            return FQNCache.getInstance(project).getAnyConstant(project, fQN, null);
        }
        boolean bl4 = false;
        if (n2 != -1) {
            bl4 = fqnString.charAt(n2) == ':';
            fqnString = bl4 ? TextRange.create((int)Math.max(0, n2 - 1), (int)(n2 + 1)).replace(fqnString, ".") : StringUtil.replace((String)fqnString, (String)"#", (String)".");
        }
        FQN fQN = FQN.of(fqnString);
        if (bl4) {
            fQN = FQN.Builder.concat(RObjectClass.makeSingletonClassFQN(fQN.getCallerFQN()), fQN.getShortName());
        }
        return RubyFQNUtil.findContainerByFQN(project, Types.METHODS_LIKE, fQN, null);
    }
}

