/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.google.common.collect.Lists;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocLanguage;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorOptions;
import org.jetbrains.plugins.ruby.ruby.actions.intention.bracestodo.BraceConverter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.HeredocsManager;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class RubyEnterHandler
extends EnterHandlerDelegateAdapter
implements RubyTokenTypes {
    private static final TokenSet c;
    private static final IElementType[] b;
    private static final TokenSet f;
    private static final TokenSet e;
    private static final String a = "\n";
    private static final String d = "\n\n";
    private static final long g;

    private static int a(@NotNull Project project, @NotNull Document document, int n2) {
        if (project == null) {
            RubyEnterHandler.a(0);
        }
        if (document == null) {
            RubyEnterHandler.a(1);
        }
        if (0 > n2 || n2 >= document.getLineCount()) {
            return -1;
        }
        return CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(n2));
    }

    private static void a(@NotNull Project project, @NotNull Editor editor2, @NotNull Document document, int n2) {
        int n3;
        if (project == null) {
            RubyEnterHandler.a(2);
        }
        if (editor2 == null) {
            RubyEnterHandler.a(3);
        }
        if (document == null) {
            RubyEnterHandler.a(4);
        }
        if ((n3 = RubyEnterHandler.a(project, document, n2)) != -1) {
            editor2.getCaretModel().moveToOffset(n3);
        }
    }

    private static boolean a(@NotNull Editor editor2, int n2) {
        if (editor2 == null) {
            RubyEnterHandler.a(5);
        }
        if (n2 == 0) {
            return false;
        }
        Document document = editor2.getDocument();
        int n3 = document.getLineNumber(n2);
        int n4 = document.getLineStartOffset(n3);
        EditorHighlighter editorHighlighter = ((EditorEx)editor2).getHighlighter();
        HighlighterIterator highlighterIterator = editorHighlighter.createIterator(n4);
        boolean bl2 = false;
        while (!bl2 && !highlighterIterator.atEnd() && highlighterIterator.getEnd() <= n2) {
            if (c.contains(!highlighterIterator.atEnd() ? highlighterIterator.getTokenType() : null)) {
                bl2 = true;
            }
            highlighterIterator.advance();
        }
        if (!bl2) {
            return false;
        }
        highlighterIterator = editorHighlighter.createIterator(0);
        int n5 = 0;
        while (!highlighterIterator.atEnd()) {
            IElementType iElementType = highlighterIterator.getTokenType();
            if (c.contains(iElementType)) {
                ++n5;
            }
            if (iElementType == kEND) {
                --n5;
            }
            highlighterIterator.advance();
        }
        return n5 > 0;
    }

    @NotNull
    private static List<String> b(@NotNull Editor editor2, int n2) {
        if (editor2 == null) {
            RubyEnterHandler.a(6);
        }
        if (n2 == 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyEnterHandler.a(7);
            }
            return list2;
        }
        Document document = editor2.getDocument();
        int n3 = document.getLineNumber(n2);
        int n4 = document.getLineStartOffset(n3);
        EditorHighlighter editorHighlighter = ((EditorEx)editor2).getHighlighter();
        HighlighterIterator highlighterIterator = editorHighlighter.createIterator(n4);
        ArrayList arrayList = Lists.newArrayList();
        while (!highlighterIterator.atEnd() && highlighterIterator.getEnd() <= n2) {
            if (highlighterIterator.getTokenType() == tHEREDOC_ID) {
                arrayList.add(document.getText().substring(highlighterIterator.getStart(), highlighterIterator.getEnd()));
            }
            highlighterIterator.advance();
        }
        if (arrayList.isEmpty()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                RubyEnterHandler.a(8);
            }
            return list3;
        }
        highlighterIterator = editorHighlighter.createIterator(0);
        int n5 = 0;
        while (!highlighterIterator.atEnd()) {
            IElementType iElementType = highlighterIterator.getTokenType();
            if (iElementType == tHEREDOC_ID) {
                ++n5;
            }
            if (TokenBNF.tHEREDOC_ENDS.contains(iElementType)) {
                --n5;
            }
            highlighterIterator.advance();
        }
        List<Object> list4 = n5 > 0 ? arrayList : Collections.emptyList();
        if (list4 == null) {
            RubyEnterHandler.a(9);
        }
        return list4;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int n2;
        CharSequence charSequence;
        List<String> list2;
        Project project;
        long l2 = g ^ 0x3330FDF325EL;
        if (file == null) {
            RubyEnterHandler.a(10);
        }
        if (editor2 == null) {
            RubyEnterHandler.a(11);
        }
        if (caretOffset == null) {
            RubyEnterHandler.a(12);
        }
        if (caretAdvance == null) {
            RubyEnterHandler.a(13);
        }
        if (dataContext == null) {
            RubyEnterHandler.a(14);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!RubyEnterHandler.a(editor2, dataContext)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        int n3 = editor2.getCaretModel().getOffset();
        if (n3 == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        int n4 = document.getLineNumber(n3);
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        PsiElement psiElement = file.findElementAt(n3 - 1);
        if (psiElement == null) {
            return EnterHandlerDelegate.Result.Default;
        }
        ASTNode aSTNode = psiElement.getNode();
        IElementType iElementType = aSTNode.getElementType();
        if (iElementType != TokenType.WHITE_SPACE && iElementType.getLanguage() != RubyLanguage.INSTANCE && iElementType.getLanguage() != RDocLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Default;
        }
        if (RubyEnterHandler.a(dataContext, editor2, file)) {
            return EnterHandlerDelegate.Result.Stop;
        }
        if (iElementType == TLINE_COMMENT || RDocTokenTypes.ALL_TYPES.contains(iElementType)) {
            CharSequence iElementTypeArray;
            int n5;
            list2 = editor2.getDocument().getCharsSequence();
            charSequence = list2.subSequence(n3, document.getLineEndOffset(n4));
            n2 = 0;
            if (RubyEditorOptions.getInstance().isProlongComments() && (n5 = StringUtil.indexOf((CharSequence)(iElementTypeArray = list2.subSequence(document.getLineStartOffset(n4), n3)), (char)'#')) > -1) {
                n2 = StringUtil.trimLeading((CharSequence)iElementTypeArray.subSequence(0, n5)).length() == 0 ? 1 : 0;
            }
            if ((n2 |= StringUtil.trimLeading((CharSequence)charSequence).length() != 0 ? 1 : 0) != 0) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)("\n #" + (!StringUtil.startsWith((CharSequence)charSequence, (CharSequence)" ") ? " " : "")));
                RubyEnterHandler.a(project, editor2, document, n4 + 1);
                editor2.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        if (e.contains(iElementType)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)a);
            return EnterHandlerDelegate.Result.Stop;
        }
        if (!TemplateIntegrationUtils.getInstance().isTemplateFile(file) && codeInsightSettings.SMART_END_ACTION && !TokenBNF.tSTRING_LIKE_CONTENTS.contains(iElementType) && !TokenBNF.tDOT_OR_COLON.contains(iElementType) && RubyEnterHandler.a(editor2, n3)) {
            int n6 = document.getLineEndOffset(n4);
            if (n6 != (n2 = (charSequence = editor2.getCaretModel()).getOffset())) {
                charSequence.moveToOffset(n6);
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)(a + RubyTokenTypes.kEND.toString()));
            RubyEnterHandler.a(project, document, n4 + 1);
            if (n6 != n2) {
                charSequence.moveToOffset(n2);
            }
            return EnterHandlerDelegate.Result.Continue;
        }
        list2 = RubyEnterHandler.b(editor2, n3);
        if (!list2.isEmpty()) {
            int n7 = n4;
            for (String string : list2) {
                n7 += 2;
                String string2 = d + HeredocsManager.getName(string);
                EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)string2);
                if (!HeredocsManager.isIndented(string) && !HeredocsManager.isSquiggly(string)) continue;
                RubyEnterHandler.a(project, document, n7);
            }
            editor2.getCaretModel().moveToOffset(document.getLineStartOffset(n4 + 1));
            return EnterHandlerDelegate.Result.Stop;
        }
        int n8 = document.getLineStartOffset(n4);
        String string = document.getText().substring(n8, n3).trim();
        for (IElementType iElementType2 : b) {
            if (!string.startsWith(iElementType2.toString())) continue;
            int n6 = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine((Document)document, (int)n4);
            RubyEnterHandler.a(project, document, n4);
            int n7 = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine((Document)document, (int)n4);
            int n9 = (Integer)caretOffset.get() - n6 + n7;
            caretOffset.set((Object)n9);
            break;
        }
        if (iElementType == TokenType.WHITE_SPACE && string.endsWith("\\")) {
            int n10 = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine((Document)document, (int)n4);
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)(a + document.getText(new TextRange(n8, n10))));
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean a(Editor editor2, DataContext dataContext) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null || psiFile.getFileType() != RubyFileType.RUBY) {
            return false;
        }
        if (editor2.isViewer()) {
            return false;
        }
        Document document = editor2.getDocument();
        return document.isWritable();
    }

    private static RCodeBlock a(@NotNull PsiFile psiFile, int n2) {
        if (psiFile == null) {
            RubyEnterHandler.a(15);
        }
        PsiElement psiElement = psiFile.findElementAt(n2);
        return (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RCodeBlock.class);
    }

    private static boolean a(@NotNull DataContext dataContext, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        boolean bl2;
        if (dataContext == null) {
            RubyEnterHandler.a(16);
        }
        if (editor2 == null) {
            RubyEnterHandler.a(17);
        }
        if (psiFile == null) {
            RubyEnterHandler.a(18);
        }
        Project project = psiFile.getProject();
        RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)psiFile, RubyCodeStyleSettings.class);
        if (!rubyCodeStyleSettings.CONVERT_BRACE_BLOCK_BY_ENTER) {
            return false;
        }
        boolean bl3 = bl2 = DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
        if (bl2) {
            return false;
        }
        Document document = editor2.getDocument();
        int n2 = editor2.getCaretModel().getOffset();
        int n3 = document.getLineNumber(n2);
        RCodeBlock rCodeBlock = RubyEnterHandler.a(psiFile, n2);
        if (!(rCodeBlock instanceof RBraceCodeBlock) || rCodeBlock.getText().contains(a)) {
            return false;
        }
        PsiElement psiElement = rCodeBlock.getParent();
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{RPossibleCall.class, RContainer.class});
        if (psiElement2 instanceof RPossibleCall) {
            return false;
        }
        document.insertString(rCodeBlock.getLastChild().getTextOffset(), (CharSequence)a);
        document.insertString(n2, (CharSequence)a);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        BraceConverter.replaceBlock(project, editor2, psiFile, RBraceCodeBlock.class);
        rCodeBlock = RubyEnterHandler.a(psiFile, n2);
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(rCodeBlock.getNode().getTreeParent(), rCodeBlock.getNode());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        RubyEnterHandler.a(project, editor2, document, n3 + 1);
        return true;
    }

    static {
        g = com.jetbrains.python.psi.c.a(-4214105518298180938L, 2351966773288136357L, MethodHandles.lookup().lookupClass()).a(151673205448792L);
        c = TokenSet.create((IElementType[])new IElementType[]{kDEF, kCLASS, kMODULE, kBEGIN, kIF, kUNLESS, kWHILE, kUNTIL, kCASE, kFOR, kDO});
        b = new IElementType[]{kEND, kELSE, kELSIF, kENSURE, kRESCUE, kWHEN};
        f = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tSTRING_LIKE_CONTENTS, TokenBNF.tEXPR_SUBT_TOKENS, TokenBNF.tESCAPE_SEQUENCES});
        e = TokenSet.orSet((TokenSet[])new TokenSet[]{f, TokenSet.create((IElementType[])new IElementType[]{tBLOCK_COMMENT})});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x2947C186E4BAL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandler";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeredocsToClose";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indentLineAndMoveCaret";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEndNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHeredocsToClose";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBlock";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleEnterInBraceBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

